/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.content.ContentResolver;
import android.database.ContentObserver;
import android.database.Cursor;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import android.os.StrictMode;
import android.util.Log;
import androidx.annotation.GuardedBy;
import androidx.collection.ArrayMap;
import com.google.android.gms.internal.measurement.zzbz;
import com.google.android.gms.internal.measurement.zzca;
import com.google.android.gms.internal.measurement.zzcb;
import com.google.android.gms.internal.measurement.zzcc;
import com.google.android.gms.internal.measurement.zzce;
import com.google.android.gms.internal.measurement.zzcl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class zzbx
implements zzcb {
    @GuardedBy(value="ConfigurationContentLoader.class")
    private static final Map<Uri, zzbx> zza = new ArrayMap();
    private final ContentResolver zzb;
    private final Uri zzc;
    private final ContentObserver zzd = new zzbz(this, null);
    private final Object zze = new Object();
    private volatile Map<String, String> zzf;
    @GuardedBy(value="this")
    private final List<zzcc> zzg = new ArrayList<zzcc>();
    private static final String[] zzh = new String[]{"key", "value"};

    private zzbx(ContentResolver contentResolver, Uri uri) {
        this.zzb = contentResolver;
        this.zzc = uri;
        contentResolver.registerContentObserver(uri, false, this.zzd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzbx zza(ContentResolver contentResolver, Uri uri) {
        Class<zzbx> clazz = zzbx.class;
        synchronized (zzbx.class) {
            zzbx zzbx2 = zza.get(uri);
            if (zzbx2 == null) {
                try {
                    zzbx2 = new zzbx(contentResolver, uri);
                    zza.put(uri, zzbx2);
                }
                catch (SecurityException securityException) {}
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return zzbx2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Map<String, String> zza() {
        Map<String, String> map = this.zzf;
        if (map == null) {
            Object object = this.zze;
            synchronized (object) {
                map = this.zzf;
                if (map == null) {
                    this.zzf = map = this.zze();
                }
            }
        }
        if (map != null) {
            return map;
        }
        return Collections.emptyMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzb() {
        zzbx zzbx2;
        Object object = this.zze;
        synchronized (object) {
            this.zzf = null;
            zzcl.zza();
        }
        zzbx zzbx3 = zzbx2 = this;
        synchronized (zzbx2) {
            Iterator<zzcc> iterator = zzbx2.zzg.iterator();
            while (iterator.hasNext()) {
                iterator.next().zza();
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    private final Map<String, String> zze() {
        StrictMode.ThreadPolicy threadPolicy = StrictMode.allowThreadDiskReads();
        try {
            Map map = (Map)zzce.zza(new zzca(this));
            return map;
        }
        catch (SQLiteException | IllegalStateException | SecurityException throwable) {
            Log.e((String)"ConfigurationContentLoader", (String)"PhenotypeFlag unable to load ContentProvider, using default values");
            return null;
        }
        finally {
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)threadPolicy);
        }
    }

    static synchronized void zzc() {
        for (zzbx zzbx2 : zza.values()) {
            zzbx2.zzb.unregisterContentObserver(zzbx2.zzd);
        }
        zza.clear();
    }

    @Override
    public final /* synthetic */ Object zza(String string) {
        String string2 = string;
        return this.zza().get(string2);
    }

    final /* synthetic */ Map zzd() {
        Cursor cursor = this.zzb.query(this.zzc, zzh, null, null, null);
        if (cursor == null) {
            return Collections.emptyMap();
        }
        try {
            Object object;
            int n = cursor.getCount();
            if (n == 0) {
                Map map = Collections.emptyMap();
                return map;
            }
            Object object2 = object = n <= 256 ? new ArrayMap(n) : new HashMap(n, 1.0f);
            while (cursor.moveToNext()) {
                object.put(cursor.getString(0), cursor.getString(1));
            }
            Object object3 = object;
            return object3;
        }
        finally {
            cursor.close();
        }
    }
}

