/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Pair;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.api.internal.GoogleServices;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzcl;
import com.google.android.gms.internal.measurement.zzkb;
import com.google.android.gms.internal.measurement.zzv;
import com.google.android.gms.measurement.internal.zzah;
import com.google.android.gms.measurement.internal.zzap;
import com.google.android.gms.measurement.internal.zzb;
import com.google.android.gms.measurement.internal.zze;
import com.google.android.gms.measurement.internal.zzem;
import com.google.android.gms.measurement.internal.zzep;
import com.google.android.gms.measurement.internal.zzes;
import com.google.android.gms.measurement.internal.zzeu;
import com.google.android.gms.measurement.internal.zzew;
import com.google.android.gms.measurement.internal.zzey;
import com.google.android.gms.measurement.internal.zzff;
import com.google.android.gms.measurement.internal.zzfl;
import com.google.android.gms.measurement.internal.zzfq;
import com.google.android.gms.measurement.internal.zzft;
import com.google.android.gms.measurement.internal.zzfz;
import com.google.android.gms.measurement.internal.zzgc;
import com.google.android.gms.measurement.internal.zzgr;
import com.google.android.gms.measurement.internal.zzgt;
import com.google.android.gms.measurement.internal.zzgu;
import com.google.android.gms.measurement.internal.zzhb;
import com.google.android.gms.measurement.internal.zzhc;
import com.google.android.gms.measurement.internal.zzhy;
import com.google.android.gms.measurement.internal.zzhz;
import com.google.android.gms.measurement.internal.zzib;
import com.google.android.gms.measurement.internal.zzii;
import com.google.android.gms.measurement.internal.zzij;
import com.google.android.gms.measurement.internal.zzjo;
import com.google.android.gms.measurement.internal.zzkm;
import com.google.android.gms.measurement.internal.zzw;
import com.google.android.gms.measurement.internal.zzx;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.json.JSONException;
import org.json.JSONObject;

public class zzga
implements zzgt {
    private static volatile zzga zza;
    private final Context zzb;
    private final String zzc;
    private final String zzd;
    private final String zze;
    private final boolean zzf;
    private final zzw zzg;
    private final zzx zzh;
    private final zzff zzi;
    private final zzew zzj;
    private final zzft zzk;
    private final zzjo zzl;
    private final zzkm zzm;
    private final zzeu zzn;
    private final Clock zzo;
    private final zzii zzp;
    private final zzhb zzq;
    private final zzb zzr;
    private final zzhz zzs;
    private zzes zzt;
    private zzij zzu;
    private zzah zzv;
    private zzep zzw;
    private zzfl zzx;
    private boolean zzy = false;
    private Boolean zzz;
    private long zzaa;
    private volatile Boolean zzab;
    @VisibleForTesting
    private Boolean zzac;
    @VisibleForTesting
    private Boolean zzad;
    private int zzae;
    private AtomicInteger zzaf = new AtomicInteger(0);
    private final long zzag;

    private zzga(zzhc zzhc2) {
        Object object;
        Preconditions.checkNotNull((Object)zzhc2);
        Object object2 = zzhc2.zza;
        zzem.zza = this.zzg = new zzw((Context)object2);
        this.zzb = zzhc2.zza;
        this.zzc = zzhc2.zzb;
        this.zzd = zzhc2.zzc;
        this.zze = zzhc2.zzd;
        this.zzf = zzhc2.zzh;
        this.zzab = zzhc2.zze;
        zzv zzv2 = zzhc2.zzg;
        if (zzv2 != null && zzv2.zzg != null) {
            object = zzv2.zzg.get("measurementEnabled");
            if (object instanceof Boolean) {
                this.zzac = (Boolean)object;
            }
            if ((object = zzv2.zzg.get("measurementDeactivated")) instanceof Boolean) {
                this.zzad = (Boolean)object;
            }
        }
        zzcl.zza(this.zzb);
        this.zzo = DefaultClock.getInstance();
        this.zzag = this.zzo.currentTimeMillis();
        object2 = this;
        this.zzh = new zzx((zzga)object2);
        object2 = this;
        object = new zzff((zzga)object2);
        ((zzgu)object).zzab();
        this.zzi = object;
        object2 = this;
        zzew zzew2 = new zzew((zzga)object2);
        zzew2.zzab();
        this.zzj = zzew2;
        object2 = this;
        zzkm zzkm2 = new zzkm((zzga)object2);
        zzkm2.zzab();
        this.zzm = zzkm2;
        object2 = this;
        zzeu zzeu2 = new zzeu((zzga)object2);
        zzeu2.zzab();
        this.zzn = zzeu2;
        object2 = this;
        this.zzr = new zzb((zzga)object2);
        object2 = this;
        zzii zzii2 = new zzii((zzga)object2);
        zzii2.zzx();
        this.zzp = zzii2;
        object2 = this;
        zzhb zzhb2 = new zzhb((zzga)object2);
        zzhb2.zzx();
        this.zzq = zzhb2;
        object2 = this;
        zzjo zzjo2 = new zzjo((zzga)object2);
        zzjo2.zzx();
        this.zzl = zzjo2;
        object2 = this;
        zzhz zzhz2 = new zzhz((zzga)object2);
        zzhz2.zzab();
        this.zzs = zzhz2;
        object2 = this;
        zzft zzft2 = new zzft((zzga)object2);
        zzft2.zzab();
        this.zzk = zzft2;
        boolean bl = zzhc2.zzg != null && zzhc2.zzg.zzb != 0L;
        boolean bl2 = !bl;
        object2 = this;
        zzw zzw2 = ((zzga)object2).zzg;
        if (((zzga)object2).zzb.getApplicationContext() instanceof Application) {
            boolean bl3 = bl2;
            zzhb zzhb3 = ((zzga)object2).zzh();
            if (((zzgr)zzhb3).zzn().getApplicationContext() instanceof Application) {
                Application application = (Application)((zzgr)zzhb3).zzn().getApplicationContext();
                if (zzhb3.zza == null) {
                    zzhb3.zza = new zzhy(zzhb3, null);
                }
                if (bl3) {
                    zzhy zzhy2 = zzhb3.zza;
                    application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)zzhy2);
                    zzhy2 = zzhb3.zza;
                    application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)zzhy2);
                    ((zzgr)zzhb3).zzr().zzx().zza("Registered activity lifecycle callback");
                }
            }
        } else {
            ((zzga)object2).zzr().zzi().zza("Application context is not an Application");
        }
        this.zzk.zza(new zzgc(this, zzhc2));
    }

    @WorkerThread
    private final void zza(zzhc zzhc2) {
        ((zzgr)this.zzq()).zzd();
        Object object = this;
        zzah zzah2 = new zzah((zzga)object);
        zzah2.zzab();
        this.zzv = zzah2;
        zzga zzga2 = this;
        object = zzhc2;
        zzep zzep2 = new zzep(zzga2, ((zzhc)object).zzf);
        zzep2.zzx();
        this.zzw = zzep2;
        object = this;
        zzes zzes2 = new zzes((zzga)object);
        zzes2.zzx();
        this.zzt = zzes2;
        object = this;
        zzij zzij2 = new zzij((zzga)object);
        zzij2.zzx();
        this.zzu = zzij2;
        this.zzm.zzac();
        this.zzi.zzac();
        object = this;
        this.zzx = new zzfl((zzga)object);
        this.zzw.zzy();
        this.zzr().zzv().zza("App measurement is starting up, version", this.zzh.zze());
        zzw zzw2 = this.zzg;
        this.zzr().zzv().zza("To enable debug logging run: adb shell setprop log.tag.FA VERBOSE");
        zzw2 = this.zzg;
        String string = zzep2.zzab();
        if (TextUtils.isEmpty((CharSequence)this.zzc)) {
            String string2;
            zzey zzey2;
            if (this.zzi().zzf(string)) {
                zzey2 = this.zzr().zzv();
                string2 = "Faster debug mode event logging enabled. To disable, run:\n  adb shell setprop debug.firebase.analytics.app .none.";
            } else {
                zzey2 = this.zzr().zzv();
                String string3 = String.valueOf(string);
                string2 = string3.length() != 0 ? "To enable faster debug mode event logging run:\n  adb shell setprop debug.firebase.analytics.app ".concat(string3) : new String("To enable faster debug mode event logging run:\n  adb shell setprop debug.firebase.analytics.app ");
            }
            zzey2.zza(string2);
        }
        this.zzr().zzw().zza("Debug-level message logging enabled");
        if (this.zzae != this.zzaf.get()) {
            this.zzr().zzf().zza("Not all components initialized", this.zzae, this.zzaf.get());
        }
        this.zzy = true;
    }

    @WorkerThread
    protected final void zza() {
        ((zzgr)this.zzq()).zzd();
        if (this.zzc().zzc.zza() == 0L) {
            this.zzc().zzc.zza(this.zzo.currentTimeMillis());
        }
        if (Long.valueOf(this.zzc().zzh.zza()) == 0L) {
            this.zzr().zzx().zza("Persisting first open", this.zzag);
            this.zzc().zzh.zza(this.zzag);
        }
        if (!this.zzag()) {
            if (this.zzab()) {
                if (!this.zzi().zzd("android.permission.INTERNET")) {
                    this.zzr().zzf().zza("App is missing INTERNET permission");
                }
                if (!this.zzi().zzd("android.permission.ACCESS_NETWORK_STATE")) {
                    this.zzr().zzf().zza("App is missing ACCESS_NETWORK_STATE permission");
                }
                zzw zzw2 = this.zzg;
                if (!Wrappers.packageManager((Context)this.zzb).isCallerInstantApp() && !this.zzh.zzx()) {
                    if (!zzfq.zza(this.zzb)) {
                        this.zzr().zzf().zza("AppMeasurementReceiver not registered/enabled");
                    }
                    if (!zzkm.zza(this.zzb, false)) {
                        this.zzr().zzf().zza("AppMeasurementService not registered/enabled");
                    }
                }
                this.zzr().zzf().zza("Uploading is not possible. App measurement disabled");
            }
        } else {
            zzw zzw3 = this.zzg;
            if (!TextUtils.isEmpty((CharSequence)this.zzy().zzac()) || !TextUtils.isEmpty((CharSequence)this.zzy().zzad())) {
                this.zzi();
                if (zzkm.zza(this.zzy().zzac(), this.zzc().zzh(), this.zzy().zzad(), this.zzc().zzi())) {
                    this.zzr().zzv().zza("Rechecking which service to use due to a GMP App Id change");
                    this.zzc().zzk();
                    this.zzk().zzab();
                    this.zzu.zzah();
                    this.zzu.zzaf();
                    this.zzc().zzh.zza(this.zzag);
                    this.zzc().zzj.zza(null);
                }
                this.zzc().zzc(this.zzy().zzac());
                this.zzc().zzd(this.zzy().zzad());
            }
            this.zzh().zza(this.zzc().zzj.zza());
            zzw3 = this.zzg;
            if (zzkb.zzb() && this.zzh.zza(zzap.zzcl) && !this.zzi().zzv() && !TextUtils.isEmpty((CharSequence)this.zzc().zzw.zza())) {
                this.zzr().zzi().zza("Remote config removed with active feature rollouts");
                this.zzc().zzw.zza(null);
            }
            if (!TextUtils.isEmpty((CharSequence)this.zzy().zzac()) || !TextUtils.isEmpty((CharSequence)this.zzy().zzad())) {
                boolean bl = this.zzab();
                if (!this.zzc().zzx() && !this.zzh.zzg()) {
                    this.zzc().zzc(!bl);
                }
                if (bl) {
                    this.zzh().zzai();
                }
                this.zze().zza.zza();
                this.zzw().zza(new AtomicReference<String>());
            }
        }
        this.zzc().zzo.zza(this.zzh.zza(zzap.zzbh));
        this.zzc().zzp.zza(this.zzh.zza(zzap.zzbi));
    }

    @Override
    public final zzw zzu() {
        return this.zzg;
    }

    public final zzx zzb() {
        return this.zzh;
    }

    public final zzff zzc() {
        zzga.zza(this.zzi);
        return this.zzi;
    }

    @Override
    public final zzew zzr() {
        zzga.zzb(this.zzj);
        return this.zzj;
    }

    public final zzew zzd() {
        if (this.zzj != null && this.zzj.zzz()) {
            return this.zzj;
        }
        return null;
    }

    @Override
    public final zzft zzq() {
        zzga.zzb(this.zzk);
        return this.zzk;
    }

    public final zzjo zze() {
        zzga.zzb(this.zzl);
        return this.zzl;
    }

    public final zzfl zzf() {
        return this.zzx;
    }

    final zzft zzg() {
        return this.zzk;
    }

    public final zzhb zzh() {
        zzga.zzb(this.zzq);
        return this.zzq;
    }

    public final zzkm zzi() {
        zzga.zza(this.zzm);
        return this.zzm;
    }

    public final zzeu zzj() {
        zzga.zza(this.zzn);
        return this.zzn;
    }

    public final zzes zzk() {
        zzga.zzb(this.zzt);
        return this.zzt;
    }

    private final zzhz zzai() {
        zzga.zzb(this.zzs);
        return this.zzs;
    }

    @Override
    public final Context zzn() {
        return this.zzb;
    }

    public final boolean zzl() {
        return TextUtils.isEmpty((CharSequence)this.zzc);
    }

    public final String zzo() {
        return this.zzc;
    }

    public final String zzp() {
        return this.zzd;
    }

    public final String zzs() {
        return this.zze;
    }

    public final boolean zzt() {
        return this.zzf;
    }

    @Override
    public final Clock zzm() {
        return this.zzo;
    }

    public final zzii zzv() {
        zzga.zzb(this.zzp);
        return this.zzp;
    }

    public final zzij zzw() {
        zzga.zzb(this.zzu);
        return this.zzu;
    }

    public final zzah zzx() {
        zzga.zzb(this.zzv);
        return this.zzv;
    }

    public final zzep zzy() {
        zzga.zzb(this.zzw);
        return this.zzw;
    }

    public final zzb zzz() {
        if (this.zzr == null) {
            throw new IllegalStateException("Component not created");
        }
        return this.zzr;
    }

    @VisibleForTesting
    public static zzga zza(Context context, String string, String string2, Bundle bundle) {
        return zzga.zza(context, new zzv(0L, 0L, true, null, null, null, bundle));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzga zza(Context context, zzv zzv2) {
        if (zzv2 != null && (zzv2.zze == null || zzv2.zzf == null)) {
            zzv2 = new zzv(zzv2.zza, zzv2.zzb, zzv2.zzc, zzv2.zzd, null, null, zzv2.zzg);
        }
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)context.getApplicationContext());
        if (zza == null) {
            Class<zzga> clazz = zzga.class;
            synchronized (zzga.class) {
                if (zza == null) {
                    zzhc zzhc2 = new zzhc(context, zzv2);
                    zza = new zzga(zzhc2);
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
        } else if (zzv2 != null && zzv2.zzg != null && zzv2.zzg.containsKey("dataCollectionDefaultEnabled")) {
            zza.zza(zzv2.zzg.getBoolean("dataCollectionDefaultEnabled"));
        }
        return zza;
    }

    private final void zzaj() {
        if (!this.zzy) {
            throw new IllegalStateException("AppMeasurement is not initialized");
        }
    }

    private static void zzb(zzgu zzgu2) {
        if (zzgu2 == null) {
            throw new IllegalStateException("Component not created");
        }
        if (!zzgu2.zzz()) {
            String string = String.valueOf(zzgu2.getClass());
            throw new IllegalStateException(new StringBuilder(27 + String.valueOf(string).length()).append("Component not initialized: ").append(string).toString());
        }
    }

    private static void zzb(zze zze2) {
        if (zze2 == null) {
            throw new IllegalStateException("Component not created");
        }
        if (!zze2.zzv()) {
            String string = String.valueOf(zze2.getClass());
            throw new IllegalStateException(new StringBuilder(27 + String.valueOf(string).length()).append("Component not initialized: ").append(string).toString());
        }
    }

    private static void zza(zzgr zzgr2) {
        if (zzgr2 == null) {
            throw new IllegalStateException("Component not created");
        }
    }

    @WorkerThread
    final void zza(boolean bl) {
        this.zzab = bl;
    }

    @WorkerThread
    public final boolean zzaa() {
        return this.zzab != null && this.zzab != false;
    }

    @WorkerThread
    public final boolean zzab() {
        ((zzgr)this.zzq()).zzd();
        this.zzaj();
        if (this.zzh.zzg()) {
            return false;
        }
        if (this.zzad != null && this.zzad.booleanValue()) {
            return false;
        }
        Boolean bl = this.zzc().zzv();
        if (bl != null) {
            return bl;
        }
        Boolean bl2 = this.zzh.zzh();
        if (bl2 != null) {
            return bl2;
        }
        if (this.zzac != null) {
            return this.zzac;
        }
        if (GoogleServices.isMeasurementExplicitlyDisabled()) {
            return false;
        }
        if (this.zzh.zza(zzap.zzax) && this.zzab != null) {
            return this.zzab;
        }
        return true;
    }

    final long zzac() {
        Long l = this.zzc().zzh.zza();
        if (l == 0L) {
            return this.zzag;
        }
        return Math.min(this.zzag, l);
    }

    final void zzad() {
        zzw zzw2 = this.zzg;
    }

    final void zzae() {
        zzw zzw2 = this.zzg;
        throw new IllegalStateException("Unexpected call on client side");
    }

    final void zza(zzgu zzgu2) {
        ++this.zzae;
    }

    final void zza(zze zze2) {
        ++this.zzae;
    }

    final void zzaf() {
        this.zzaf.incrementAndGet();
    }

    @WorkerThread
    protected final boolean zzag() {
        this.zzaj();
        ((zzgr)this.zzq()).zzd();
        if (this.zzz == null || this.zzaa == 0L || this.zzz != null && !this.zzz.booleanValue() && Math.abs(this.zzo.elapsedRealtime() - this.zzaa) > 1000L) {
            this.zzaa = this.zzo.elapsedRealtime();
            zzw zzw2 = this.zzg;
            this.zzz = this.zzi().zzd("android.permission.INTERNET") && this.zzi().zzd("android.permission.ACCESS_NETWORK_STATE") && (Wrappers.packageManager((Context)this.zzb).isCallerInstantApp() || this.zzh.zzx() || zzfq.zza(this.zzb) && zzkm.zza(this.zzb, false));
            if (this.zzz.booleanValue()) {
                this.zzz = this.zzi().zza(this.zzy().zzac(), this.zzy().zzad(), this.zzy().zzae()) || !TextUtils.isEmpty((CharSequence)this.zzy().zzad());
            }
        }
        return this.zzz;
    }

    @WorkerThread
    public final void zzah() {
        ((zzgr)this.zzq()).zzd();
        zzga.zzb(this.zzai());
        String string = this.zzy().zzab();
        Pair<String, Boolean> pair = this.zzc().zza(string);
        if (!this.zzh.zzi().booleanValue() || ((Boolean)pair.second).booleanValue() || TextUtils.isEmpty((CharSequence)((CharSequence)pair.first))) {
            this.zzr().zzw().zza("ADID unavailable to retrieve Deferred Deep Link. Skipping");
            return;
        }
        if (!this.zzai().zzg()) {
            this.zzr().zzi().zza("Network is not available for Deferred Deep Link request. Skipping");
            return;
        }
        URL uRL = this.zzi().zza(((zzgr)this.zzy()).zzt().zze(), string, (String)pair.first, this.zzc().zzv.zza() - 1L);
        zzfz zzfz2 = new zzfz(this);
        URL uRL2 = uRL;
        String string2 = string;
        zzhz zzhz2 = this.zzai();
        ((zzgr)zzhz2).zzd();
        zzhz2.zzaa();
        Preconditions.checkNotNull((Object)uRL2);
        Preconditions.checkNotNull((Object)zzfz2);
        ((zzgr)zzhz2).zzq().zzb(new zzib(zzhz2, string2, uRL2, null, null, zzfz2));
    }

    final /* synthetic */ void zza(String string, int n, Throwable throwable, byte[] byArray, Map map) {
        Throwable throwable2 = throwable;
        byte[] byArray2 = byArray;
        int n2 = n;
        zzga zzga2 = this;
        if (!((n2 == 200 || n2 == 204 || n2 == 304) && throwable2 == null)) {
            zzga2.zzr().zzi().zza("Network Request for Deferred Deep Link failed. response, exception", n2, throwable2);
            return;
        }
        zzga2.zzc().zzu.zza(true);
        if (byArray2.length == 0) {
            zzga2.zzr().zzw().zza("Deferred Deep Link response empty.");
            return;
        }
        String string2 = new String(byArray2);
        try {
            List list;
            JSONObject jSONObject = new JSONObject(string2);
            String string3 = jSONObject.optString("deeplink", "");
            String string4 = jSONObject.optString("gclid", "");
            double d = jSONObject.optDouble("timestamp", 0.0);
            if (TextUtils.isEmpty((CharSequence)string3)) {
                zzga2.zzr().zzw().zza("Deferred Deep Link is empty.");
                return;
            }
            String string5 = string3;
            zzkm zzkm2 = zzga2.zzi();
            ((zzgr)zzkm2).zzb();
            if (!(!TextUtils.isEmpty((CharSequence)string5) && (list = ((zzgr)zzkm2).zzn().getPackageManager().queryIntentActivities(new Intent("android.intent.action.VIEW", Uri.parse((String)string5)), 0)) != null && !list.isEmpty())) {
                zzga2.zzr().zzi().zza("Deferred Deep Link validation failed. gclid, deep link", string4, string3);
                return;
            }
            Bundle bundle = new Bundle();
            bundle.putString("gclid", string4);
            bundle.putString("_cis", "ddp");
            zzga2.zzq.zza("auto", "_cmp", bundle);
            string5 = string3;
            zzkm2 = zzga2.zzi();
            if (!TextUtils.isEmpty((CharSequence)string5) && zzkm2.zza(string5, d)) {
                Intent intent = new Intent("android.google.analytics.action.DEEPLINK_ACTION");
                ((zzgr)zzkm2).zzn().sendBroadcast(intent);
            }
            return;
        }
        catch (JSONException jSONException) {
            zzga2.zzr().zzf().zza("Failed to parse the Deferred Deep Link response. exception", (Object)jSONException);
            return;
        }
    }

    static /* synthetic */ void zza(zzga zzga2, zzhc zzhc2) {
        zzga2.zza(zzhc2);
    }
}

