/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.text.TextUtils;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zzap;
import com.google.android.gms.measurement.internal.zzfx;
import com.google.android.gms.measurement.internal.zzfz;
import com.google.android.gms.measurement.internal.zzga;
import com.google.android.gms.measurement.internal.zzgc;
import com.google.android.gms.measurement.internal.zzgq;
import com.google.android.gms.measurement.internal.zzhk;
import com.google.android.gms.measurement.internal.zzla;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Locale;

final class zzfv
extends zzhk {
    @VisibleForTesting
    static final Pair<String, Long> zza = new Pair((Object)"", (Object)0L);
    private SharedPreferences zzy;
    public zzfz zzb;
    public final zzga zzc = new zzga(this, "last_upload", 0L);
    public final zzga zzd = new zzga(this, "last_upload_attempt", 0L);
    public final zzga zze = new zzga(this, "backoff", 0L);
    public final zzga zzf = new zzga(this, "last_delete_stale", 0L);
    public final zzga zzg;
    public final zzga zzh;
    public final zzga zzi;
    public final zzgc zzj;
    private String zzz;
    private boolean zzaa;
    private long zzab;
    public final zzga zzk = new zzga(this, "time_before_start", 10000L);
    public final zzga zzl = new zzga(this, "session_timeout", 1800000L);
    public final zzfx zzm = new zzfx(this, "start_new_session", true);
    public final zzgc zzn;
    public final zzfx zzo;
    public final zzfx zzp;
    public final zzga zzq = new zzga(this, "last_pause_time", 0L);
    public final zzga zzr = new zzga(this, "time_active", 0L);
    public boolean zzs;
    public zzfx zzt;
    public zzfx zzu;
    public zzga zzv;
    public final zzgc zzw;

    @WorkerThread
    @NonNull
    final Pair<String, Boolean> zza(String string) {
        this.zzd();
        long l = this.zzm().elapsedRealtime();
        if (this.zzz != null && l < this.zzab) {
            return new Pair((Object)this.zzz, (Object)this.zzaa);
        }
        String string2 = string;
        this.zzab = l + this.zzt().zza(string2, zzap.zza);
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)true);
        try {
            AdvertisingIdClient.Info info = AdvertisingIdClient.getAdvertisingIdInfo((Context)this.zzn());
            if (info != null) {
                this.zzz = info.getId();
                this.zzaa = info.isLimitAdTrackingEnabled();
            }
            if (this.zzz == null) {
                this.zzz = "";
            }
        }
        catch (Exception exception) {
            this.zzr().zzw().zza("Unable to get advertising id", exception);
            this.zzz = "";
        }
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)false);
        return new Pair((Object)this.zzz, (Object)this.zzaa);
    }

    @WorkerThread
    final String zzb(String string) {
        this.zzd();
        String string2 = (String)this.zza((String)string).first;
        MessageDigest messageDigest = zzla.zzi();
        if (messageDigest == null) {
            return null;
        }
        return String.format(Locale.US, "%032X", new BigInteger(1, messageDigest.digest(string2.getBytes())));
    }

    zzfv(zzgq zzgq2) {
        super(zzgq2);
        this.zzn = new zzgc(this, "non_personalized_ads", null);
        this.zzo = new zzfx(this, "use_dynamite_api", false);
        this.zzp = new zzfx(this, "allow_remote_dynamite", false);
        this.zzg = new zzga(this, "midnight_offset", 0L);
        this.zzh = new zzga(this, "first_open_time", 0L);
        this.zzi = new zzga(this, "app_install_time", 0L);
        this.zzj = new zzgc(this, "app_instance_id", null);
        this.zzt = new zzfx(this, "app_backgrounded", false);
        this.zzu = new zzfx(this, "deep_link_retrieval_complete", false);
        this.zzv = new zzga(this, "deep_link_retrieval_attempts", 0L);
        this.zzw = new zzgc(this, "firebase_feature_rollouts", null);
    }

    @Override
    protected final boolean zze() {
        return true;
    }

    @Override
    @WorkerThread
    protected final void f_() {
        this.zzy = this.zzn().getSharedPreferences("com.google.android.gms.measurement.prefs", 0);
        this.zzs = this.zzy.getBoolean("has_been_opened", false);
        if (!this.zzs) {
            SharedPreferences.Editor editor = this.zzy.edit();
            editor.putBoolean("has_been_opened", true);
            editor.apply();
        }
        this.zzb = new zzfz(this, "health_monitor", Math.max(0L, (Long)zzap.zzb.zza(null)), null);
    }

    @WorkerThread
    @VisibleForTesting
    protected final SharedPreferences zzg() {
        this.zzd();
        this.zzaa();
        return this.zzy;
    }

    @WorkerThread
    final void zzc(String string) {
        this.zzd();
        SharedPreferences.Editor editor = this.zzg().edit();
        editor.putString("gmp_app_id", string);
        editor.apply();
    }

    @WorkerThread
    final String zzh() {
        this.zzd();
        return this.zzg().getString("gmp_app_id", null);
    }

    @WorkerThread
    final void zzd(String string) {
        this.zzd();
        SharedPreferences.Editor editor = this.zzg().edit();
        editor.putString("admob_app_id", string);
        editor.apply();
    }

    @WorkerThread
    final String zzi() {
        this.zzd();
        return this.zzg().getString("admob_app_id", null);
    }

    @WorkerThread
    final Boolean zzj() {
        this.zzd();
        if (!this.zzg().contains("use_service")) {
            return null;
        }
        return this.zzg().getBoolean("use_service", false);
    }

    @WorkerThread
    final void zza(boolean bl) {
        this.zzd();
        SharedPreferences.Editor editor = this.zzg().edit();
        editor.putBoolean("use_service", bl);
        editor.apply();
    }

    @WorkerThread
    final void zzk() {
        this.zzd();
        Boolean bl = this.zzv();
        SharedPreferences.Editor editor = this.zzg().edit();
        editor.clear();
        editor.apply();
        if (bl != null) {
            this.zzb(bl);
        }
    }

    @WorkerThread
    final void zzb(boolean bl) {
        this.zzd();
        SharedPreferences.Editor editor = this.zzg().edit();
        editor.putBoolean("measurement_enabled", bl);
        editor.apply();
    }

    @WorkerThread
    final Boolean zzv() {
        this.zzd();
        if (this.zzg().contains("measurement_enabled")) {
            return this.zzg().getBoolean("measurement_enabled", true);
        }
        return null;
    }

    @WorkerThread
    protected final String zzw() {
        this.zzd();
        String string = this.zzg().getString("previous_os_version", null);
        this.zzl().zzaa();
        String string2 = Build.VERSION.RELEASE;
        if (!TextUtils.isEmpty((CharSequence)string2) && !string2.equals(string)) {
            SharedPreferences.Editor editor = this.zzg().edit();
            editor.putString("previous_os_version", string2);
            editor.apply();
        }
        return string;
    }

    @WorkerThread
    final void zzc(boolean bl) {
        this.zzd();
        this.zzr().zzx().zza("App measurement setting deferred collection", bl);
        SharedPreferences.Editor editor = this.zzg().edit();
        editor.putBoolean("deferred_analytics_collection", bl);
        editor.apply();
    }

    @WorkerThread
    final boolean zzx() {
        return this.zzy.contains("deferred_analytics_collection");
    }

    final boolean zza(long l) {
        return l - this.zzl.zza() > this.zzq.zza();
    }
}

