/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.annotation.SuppressLint;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.content.pm.Signature;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.CollectionUtils;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzju;
import com.google.android.gms.internal.measurement.zzll;
import com.google.android.gms.internal.measurement.zzn;
import com.google.android.gms.measurement.internal.zzam;
import com.google.android.gms.measurement.internal.zzan;
import com.google.android.gms.measurement.internal.zzap;
import com.google.android.gms.measurement.internal.zzfj;
import com.google.android.gms.measurement.internal.zzgq;
import com.google.android.gms.measurement.internal.zzhh;
import com.google.android.gms.measurement.internal.zzhk;
import com.google.android.gms.measurement.internal.zzhl;
import com.google.android.gms.measurement.internal.zzhm;
import com.google.android.gms.measurement.internal.zzhn;
import com.google.android.gms.measurement.internal.zzho;
import com.google.android.gms.measurement.internal.zzkz;
import com.google.android.gms.measurement.internal.zzv;
import com.google.android.gms.measurement.internal.zzw;
import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import javax.security.auth.x500.X500Principal;

public final class zzla
extends zzhk {
    private static final String[] zza = new String[]{"firebase_", "google_", "ga_"};
    private SecureRandom zzb;
    private final AtomicLong zzc = new AtomicLong(0L);
    private int zzd;
    private Integer zze = null;

    zzla(zzgq zzgq2) {
        super(zzgq2);
    }

    @Override
    protected final boolean zze() {
        return true;
    }

    @Override
    @WorkerThread
    protected final void f_() {
        ((zzhh)this).zzd();
        SecureRandom secureRandom = new SecureRandom();
        long l = secureRandom.nextLong();
        if (l == 0L && (l = secureRandom.nextLong()) == 0L) {
            ((zzhh)this).zzr().zzi().zza("Utils falling back to Random for random id");
        }
        this.zzc.set(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long zzg() {
        if (this.zzc.get() == 0L) {
            AtomicLong atomicLong = this.zzc;
            synchronized (atomicLong) {
                return new Random(System.nanoTime() ^ ((zzhh)this).zzm().currentTimeMillis()).nextLong() + (long)(++this.zzd);
            }
        }
        AtomicLong atomicLong = this.zzc;
        synchronized (atomicLong) {
            this.zzc.compareAndSet(-1L, 1L);
            return this.zzc.getAndIncrement();
        }
    }

    @WorkerThread
    final SecureRandom zzh() {
        ((zzhh)this).zzd();
        if (this.zzb == null) {
            this.zzb = new SecureRandom();
        }
        return this.zzb;
    }

    static boolean zza(String string) {
        Preconditions.checkNotEmpty((String)string);
        return string.charAt(0) != '_' || string.equals("_ep");
    }

    final Bundle zza(@NonNull Uri uri) {
        if (uri == null) {
            return null;
        }
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        try {
            if (uri.isHierarchical()) {
                string = uri.getQueryParameter("utm_campaign");
                string2 = uri.getQueryParameter("utm_source");
                string3 = uri.getQueryParameter("utm_medium");
                string4 = uri.getQueryParameter("gclid");
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            ((zzhh)this).zzr().zzi().zza("Install referrer url isn't a hierarchical URI", unsupportedOperationException);
            return null;
        }
        if (!(TextUtils.isEmpty(string) && TextUtils.isEmpty(string2) && TextUtils.isEmpty(string3) && TextUtils.isEmpty(string4))) {
            String string5;
            String string6;
            String string7;
            String string8;
            String string9;
            Bundle bundle = new Bundle();
            if (!TextUtils.isEmpty((CharSequence)string)) {
                bundle.putString("campaign", string);
            }
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                bundle.putString("source", string2);
            }
            if (!TextUtils.isEmpty((CharSequence)string3)) {
                bundle.putString("medium", string3);
            }
            if (!TextUtils.isEmpty((CharSequence)string4)) {
                bundle.putString("gclid", string4);
            }
            if (!TextUtils.isEmpty((CharSequence)(string9 = uri.getQueryParameter("utm_term")))) {
                bundle.putString("term", string9);
            }
            if (!TextUtils.isEmpty((CharSequence)(string8 = uri.getQueryParameter("utm_content")))) {
                bundle.putString("content", string8);
            }
            if (!TextUtils.isEmpty((CharSequence)(string7 = uri.getQueryParameter("aclid")))) {
                bundle.putString("aclid", string7);
            }
            if (!TextUtils.isEmpty((CharSequence)(string6 = uri.getQueryParameter("cp1")))) {
                bundle.putString("cp1", string6);
            }
            if (!TextUtils.isEmpty((CharSequence)(string5 = uri.getQueryParameter("anid")))) {
                bundle.putString("anid", string5);
            }
            return bundle;
        }
        return null;
    }

    static boolean zza(Intent intent) {
        String string = intent.getStringExtra("android.intent.extra.REFERRER_NAME");
        return "android-app://com.google.android.googlequicksearchbox/https/www.google.com".equals(string) || "https://www.google.com".equals(string) || "android-app://com.google.appcrawler".equals(string);
    }

    final boolean zza(String string, String string2) {
        int n;
        if (string2 == null) {
            ((zzhh)this).zzr().zzh().zza("Name is required and can't be null. Type", string);
            return false;
        }
        if (string2.length() == 0) {
            ((zzhh)this).zzr().zzh().zza("Name is required and can't be empty. Type", string);
            return false;
        }
        int n2 = string2.codePointAt(0);
        if (!Character.isLetter(n2)) {
            ((zzhh)this).zzr().zzh().zza("Name must start with a letter. Type, name", string, string2);
            return false;
        }
        int n3 = string2.length();
        for (int i = Character.charCount(n2); i < n3; i += Character.charCount(n)) {
            n = string2.codePointAt(i);
            if (n == 95 || Character.isLetterOrDigit(n)) continue;
            ((zzhh)this).zzr().zzh().zza("Name must consist of letters, digits or _ (underscores). Type, name", string, string2);
            return false;
        }
        return true;
    }

    final boolean zzb(String string, String string2) {
        int n;
        if (string2 == null) {
            ((zzhh)this).zzr().zzh().zza("Name is required and can't be null. Type", string);
            return false;
        }
        if (string2.length() == 0) {
            ((zzhh)this).zzr().zzh().zza("Name is required and can't be empty. Type", string);
            return false;
        }
        int n2 = string2.codePointAt(0);
        if (!Character.isLetter(n2) && n2 != 95) {
            ((zzhh)this).zzr().zzh().zza("Name must start with a letter or _ (underscore). Type, name", string, string2);
            return false;
        }
        int n3 = string2.length();
        for (int i = Character.charCount(n2); i < n3; i += Character.charCount(n)) {
            n = string2.codePointAt(i);
            if (n == 95 || Character.isLetterOrDigit(n)) continue;
            ((zzhh)this).zzr().zzh().zza("Name must consist of letters, digits or _ (underscores). Type, name", string, string2);
            return false;
        }
        return true;
    }

    final boolean zza(String string, String[] stringArray, String string2) {
        boolean bl;
        block4: {
            if (string2 == null) {
                ((zzhh)this).zzr().zzh().zza("Name is required and can't be null. Type", string);
                return false;
            }
            String string3 = string2;
            Preconditions.checkNotNull((Object)string3);
            String[] stringArray2 = zza;
            int n = zza.length;
            for (int i = 0; i < n; ++i) {
                String string4 = stringArray2[i];
                if (!string3.startsWith(string4)) continue;
                bl = true;
                break block4;
            }
            bl = false;
        }
        if (bl) {
            ((zzhh)this).zzr().zzh().zza("Name starts with reserved prefix. Type, name", string, string2);
            return false;
        }
        if (stringArray != null && zzla.zza(string2, stringArray)) {
            ((zzhh)this).zzr().zzh().zza("Name is reserved. Type, name", string, string2);
            return false;
        }
        return true;
    }

    final boolean zza(String string, int n, String string2) {
        if (string2 == null) {
            ((zzhh)this).zzr().zzh().zza("Name is required and can't be null. Type", string);
            return false;
        }
        if (string2.codePointCount(0, string2.length()) > n) {
            ((zzhh)this).zzr().zzh().zza("Name is too long. Type, maximum supported length, name", string, n, string2);
            return false;
        }
        return true;
    }

    final int zzb(String string) {
        if (!this.zzb("event", string)) {
            return 2;
        }
        if (!this.zza("event", zzhl.zza, string)) {
            return 13;
        }
        if (!this.zza("event", 40, string)) {
            return 2;
        }
        return 0;
    }

    final int zzc(String string) {
        if (!this.zzb("user property", string)) {
            return 6;
        }
        if (!this.zza("user property", zzhn.zza, string)) {
            return 15;
        }
        if (!this.zza("user property", 24, string)) {
            return 6;
        }
        return 0;
    }

    private final int zzg(String string) {
        if (!this.zza("event param", string)) {
            return 3;
        }
        if (!this.zza("event param", (String[])null, string)) {
            return 14;
        }
        if (!this.zza("event param", 40, string)) {
            return 3;
        }
        return 0;
    }

    private final int zzh(String string) {
        if (!this.zzb("event param", string)) {
            return 3;
        }
        if (!this.zza("event param", (String[])null, string)) {
            return 14;
        }
        if (!this.zza("event param", 40, string)) {
            return 3;
        }
        return 0;
    }

    private static boolean zzb(Object object) {
        return object instanceof Parcelable[] || object instanceof ArrayList || object instanceof Bundle;
    }

    private final boolean zza(String string, String string2, int n, Object object) {
        int n2;
        if (object instanceof Parcelable[]) {
            n2 = ((Parcelable[])object).length;
        } else if (object instanceof ArrayList) {
            n2 = ((ArrayList)object).size();
        } else {
            return true;
        }
        if (n2 > n) {
            ((zzhh)this).zzr().zzk().zza("Parameter array is too long; discarded. Value kind, name, array length", string, string2, n2);
            return false;
        }
        return true;
    }

    private final boolean zzb(String string, String string2, int n, Object object) {
        if (object == null) {
            return true;
        }
        if (object instanceof Long || object instanceof Float || object instanceof Integer || object instanceof Byte || object instanceof Short || object instanceof Boolean || object instanceof Double) {
            return true;
        }
        if (object instanceof String || object instanceof Character || object instanceof CharSequence) {
            String string3 = String.valueOf(object);
            if (string3.codePointCount(0, string3.length()) > n) {
                ((zzhh)this).zzr().zzk().zza("Value is too long; discarded. Value kind, name, value length", string, string2, string3.length());
                return false;
            }
            return true;
        }
        return false;
    }

    private final void zza(String string, String string2, String string3, Bundle bundle, @Nullable List<String> list, boolean bl) {
        if (bundle == null) {
            return;
        }
        boolean bl2 = ((zzhh)this).zzt().zza(zzap.zzdd);
        int n = 0;
        int n2 = bl2 ? 0 : ((zzhh)this).zzt().zze();
        for (String string4 : new TreeSet(bundle.keySet())) {
            int n3 = 0;
            if (list == null || !list.contains(string4)) {
                if (bl) {
                    n3 = this.zzg(string4);
                }
                if (n3 == 0) {
                    n3 = this.zzh(string4);
                }
            }
            if (n3 != 0) {
                zzla.zza(bundle, n3, string4, string4, n3 == 3 ? string4 : null);
                bundle.remove(string4);
                continue;
            }
            if (zzla.zzb(bundle.get(string4))) {
                ((zzhh)this).zzr().zzk().zza("Nested Bundle parameters are not allowed; discarded. event name, param name, child param name", string2, string3, string4);
                n3 = 22;
            } else {
                n3 = this.zza(string, string2, string4, bundle.get(string4), bundle, list, bl, false);
            }
            if (n3 != 0 && !"_ev".equals(string4)) {
                zzla.zza(bundle, n3, string4, string4, bundle.get(string4));
                bundle.remove(string4);
                continue;
            }
            if (!zzla.zza(string4) || bl2 && zzla.zza(string4, zzho.zzd) || ++n <= n2) continue;
            String string5 = bl2 ? "Item cannot contain custom parameters" : new StringBuilder(63).append("Child bundles can't contain more than ").append(n2).append(" custom params").toString();
            ((zzhh)this).zzr().zzh().zza(string5, ((zzhh)this).zzo().zza(string2), ((zzhh)this).zzo().zza(bundle));
            zzla.zza(bundle, bl2 ? 23 : 5);
            bundle.remove(string4);
        }
    }

    final boolean zza(String string, String string2, String string3) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            if (!zzla.zzi(string)) {
                if (this.zzx.zzl()) {
                    ((zzhh)this).zzr().zzh().zza("Invalid google_app_id. Firebase Analytics disabled. See https://goo.gl/NAOOOI. provided id", zzfj.zza(string));
                }
                return false;
            }
        } else if (!zzll.zzb() || !((zzhh)this).zzt().zza(zzap.zzch) || TextUtils.isEmpty((CharSequence)string3)) {
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                if (!zzla.zzi(string2)) {
                    ((zzhh)this).zzr().zzh().zza("Invalid admob_app_id. Analytics disabled.", zzfj.zza(string2));
                    return false;
                }
            } else {
                if (this.zzx.zzl()) {
                    ((zzhh)this).zzr().zzh().zza("Missing google_app_id. Firebase Analytics disabled. See https://goo.gl/NAOOOI");
                }
                return false;
            }
        }
        return true;
    }

    static boolean zza(String string, String string2, String string3, String string4) {
        boolean bl = TextUtils.isEmpty((CharSequence)string);
        boolean bl2 = TextUtils.isEmpty((CharSequence)string2);
        if (!bl && !bl2) {
            return !string.equals(string2);
        }
        if (bl && bl2) {
            if (!TextUtils.isEmpty((CharSequence)string3) && !TextUtils.isEmpty((CharSequence)string4)) {
                return !string3.equals(string4);
            }
            return !TextUtils.isEmpty((CharSequence)string4);
        }
        if (!bl && bl2) {
            if (TextUtils.isEmpty((CharSequence)string4)) {
                return false;
            }
            return TextUtils.isEmpty((CharSequence)string3) || !string3.equals(string4);
        }
        return TextUtils.isEmpty((CharSequence)string3) || !string3.equals(string4);
    }

    @VisibleForTesting
    private static boolean zzi(String string) {
        Preconditions.checkNotNull((Object)string);
        String string2 = "^(1:\\d+:android:[a-f0-9]+|ca-app-pub-.*)$";
        return string.matches(string2);
    }

    private final Object zza(int n, Object object, boolean bl, boolean bl2) {
        if (object == null) {
            return null;
        }
        if (object instanceof Long || object instanceof Double) {
            return object;
        }
        if (object instanceof Integer) {
            return (long)((Integer)object).intValue();
        }
        if (object instanceof Byte) {
            return (long)((Byte)object).byteValue();
        }
        if (object instanceof Short) {
            return (long)((Short)object).shortValue();
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1L : 0L;
        }
        if (object instanceof Float) {
            return ((Float)object).doubleValue();
        }
        if (object instanceof String || object instanceof Character || object instanceof CharSequence) {
            return zzla.zza(String.valueOf(object), n, bl);
        }
        if (zzju.zzb() && ((zzhh)this).zzt().zza(zzap.zzdc) && ((zzhh)this).zzt().zza(zzap.zzdb) && bl2 && (object instanceof Bundle[] || object instanceof Parcelable[])) {
            ArrayList<Bundle> arrayList = new ArrayList<Bundle>();
            for (Parcelable parcelable : (Parcelable[])object) {
                Bundle bundle;
                if (!(parcelable instanceof Bundle) || (bundle = this.zza((Bundle)parcelable)) == null || bundle.isEmpty()) continue;
                arrayList.add(bundle);
            }
            return arrayList.toArray(new Bundle[arrayList.size()]);
        }
        return null;
    }

    public static String zza(String string, int n, boolean bl) {
        if (string == null) {
            return null;
        }
        if (string.codePointCount(0, string.length()) > n) {
            if (bl) {
                return String.valueOf(string.substring(0, string.offsetByCodePoints(0, n))).concat("...");
            }
            return null;
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @WorkerThread
    private final int zza(String string, String string2, String string3, Object object, Bundle bundle, @Nullable List<String> arrayList, boolean bl, boolean bl2) {
        boolean bl3;
        boolean bl4;
        int n;
        ArrayList arrayList2;
        Object object2;
        String string4;
        Object object3;
        ((zzhh)this).zzd();
        int n2 = 0;
        if (zzju.zzb() && ((zzhh)this).zzt().zza(zzap.zzdd)) {
            if (zzla.zzb(object)) {
                if (!bl2) return 21;
                if (!zzla.zza(string3, zzho.zzc)) {
                    return 20;
                }
                if (!this.zzx.zzw().zzai()) {
                    return 25;
                }
                if (!this.zza("param", string3, 200, object)) {
                    n2 = 17;
                    object3 = object;
                    string4 = string3;
                    object2 = bundle;
                    if (object3 instanceof Parcelable[]) {
                        if (((Parcelable[])object3).length > 200) {
                            object2.putParcelableArray(string4, Arrays.copyOf((Parcelable[])object3, 200));
                        }
                    } else if (object3 instanceof ArrayList && (arrayList2 = (ArrayList)object3).size() > 200) {
                        object2.putParcelableArrayList(string4, new ArrayList(arrayList2.subList(0, 200)));
                    }
                }
            }
        } else if (bl2 && !this.zza("param", string3, 1000, object)) {
            return 17;
        }
        if (this.zzb("param", string3, n = ((zzhh)this).zzt().zze(string, zzap.zzaq) && zzla.zze(string2) || zzla.zze(string3) ? 256 : 100, object)) {
            return n2;
        }
        if (!bl2) return 4;
        boolean bl5 = bl;
        arrayList2 = arrayList;
        Object object4 = object;
        object3 = string3;
        String string5 = string2;
        string4 = string;
        object2 = this;
        boolean bl6 = bl4 = zzju.zzb() && ((zzhh)object2).zzt().zza(zzap.zzdc);
        if (object4 instanceof Bundle) {
            if (bl4) {
                super.zza(string4, string5, (String)object3, (Bundle)object4, arrayList2, bl5);
            }
            bl3 = true;
        } else if (object4 instanceof Parcelable[]) {
            for (Parcelable parcelable : (Parcelable[])object4) {
                if (!(parcelable instanceof Bundle)) {
                    ((zzhh)object2).zzr().zzk().zza("All Parcelable[] elements must be of type Bundle. Value type, name", parcelable.getClass(), object3);
                    return 4;
                }
                if (!bl4) continue;
                super.zza(string4, string5, (String)object3, (Bundle)parcelable, arrayList2, bl5);
            }
            bl3 = true;
        } else {
            if (!(object4 instanceof ArrayList)) return 4;
            ArrayList arrayList3 = (ArrayList)object4;
            int n3 = arrayList3.size();
            for (int i = 0; i < n3; ++i) {
                Object e = arrayList3.get(i);
                Object e2 = e;
                if (e instanceof Bundle) continue;
                ((zzhh)object2).zzr().zzk().zza("All ArrayList elements must be of type Bundle. Value type, name", e2.getClass(), object3);
                return 4;
            }
            bl3 = true;
        }
        if (!bl3) return 4;
        return n2;
    }

    final Object zza(String string, Object object) {
        if ("_ev".equals(string)) {
            return this.zza(256, object, true, true);
        }
        return this.zza(zzla.zze(string) ? 256 : 100, object, false, true);
    }

    static Bundle[] zza(Object object) {
        if (object instanceof Bundle) {
            return new Bundle[]{(Bundle)object};
        }
        if (object instanceof Parcelable[]) {
            return (Bundle[])Arrays.copyOf((Parcelable[])object, ((Parcelable[])object).length, Bundle[].class);
        }
        if (object instanceof ArrayList) {
            ArrayList arrayList = (ArrayList)object;
            return arrayList.toArray(new Bundle[arrayList.size()]);
        }
        return null;
    }

    final Bundle zza(String string, String string2, Bundle bundle, @Nullable List<String> list, boolean bl, boolean bl2) {
        boolean bl3 = zzju.zzb() && ((zzhh)this).zzt().zza(zzap.zzdd);
        boolean bl4 = bl3 ? zzla.zza(string2, zzhl.zzc) : bl2;
        Bundle bundle2 = null;
        if (bundle != null) {
            bundle2 = new Bundle(bundle);
            int n = 0;
            int n2 = ((zzhh)this).zzt().zze();
            TreeSet treeSet = ((zzhh)this).zzt().zze(string, zzap.zzbk) ? new TreeSet(bundle.keySet()) : bundle.keySet();
            for (String string3 : treeSet) {
                String string4;
                int n3 = 0;
                if (list == null || !list.contains(string3)) {
                    if (bl) {
                        n3 = this.zzg(string3);
                    }
                    if (n3 == 0) {
                        n3 = this.zzh(string3);
                    }
                }
                if (n3 != 0) {
                    zzla.zza(bundle2, n3, string3, string3, n3 == 3 ? string3 : null);
                    bundle2.remove(string3);
                    continue;
                }
                n3 = this.zza(string, string2, string3, bundle.get(string3), bundle2, list, bl, bl4);
                if (bl3 && n3 == 17) {
                    zzla.zza(bundle2, n3, string3, string3, false);
                } else if (n3 != 0 && !"_ev".equals(string3)) {
                    string4 = n3 == 21 ? string2 : string3;
                    zzla.zza(bundle2, n3, string4, string3, bundle.get(string3));
                    bundle2.remove(string3);
                    continue;
                }
                if (!zzla.zza(string3) || ++n <= n2) continue;
                string4 = new StringBuilder(48).append("Event can't contain more than ").append(n2).append(" params").toString();
                ((zzhh)this).zzr().zzh().zza(string4, ((zzhh)this).zzo().zza(string2), ((zzhh)this).zzo().zza(bundle));
                zzla.zza(bundle2, 5);
                bundle2.remove(string3);
            }
        }
        return bundle2;
    }

    private static void zza(Bundle bundle, int n, String string, String string2, Object object) {
        if (zzla.zza(bundle, n)) {
            String string3 = zzla.zza(string, 40, true);
            bundle.putString("_ev", string3);
            if (object != null) {
                Object object2 = object;
                Bundle bundle2 = bundle;
                Preconditions.checkNotNull((Object)bundle2);
                if (object2 != null && (object2 instanceof String || object2 instanceof CharSequence)) {
                    String string4 = String.valueOf(object2);
                    bundle2.putLong("_el", (long)string4.length());
                }
            }
        }
    }

    static boolean zza(Bundle bundle, int n) {
        if (bundle == null) {
            return false;
        }
        if (bundle.getLong("_err") == 0L) {
            bundle.putLong("_err", (long)n);
            return true;
        }
        return false;
    }

    private final int zzj(String string) {
        if ("_ldl".equals(string)) {
            return 2048;
        }
        if ("_id".equals(string)) {
            return 256;
        }
        if (((zzhh)this).zzt().zza(zzap.zzce) && "_lgclid".equals(string)) {
            return 100;
        }
        return 36;
    }

    final int zzb(String string, Object object) {
        boolean bl = "_ldl".equals(string) ? this.zzb("user property referrer", string, this.zzj(string), object) : this.zzb("user property", string, this.zzj(string), object);
        if (bl) {
            return 0;
        }
        return 7;
    }

    final Object zzc(String string, Object object) {
        if ("_ldl".equals(string)) {
            return this.zza(this.zzj(string), object, true, false);
        }
        return this.zza(this.zzj(string), object, false, false);
    }

    final void zza(Bundle bundle, String string, Object object) {
        if (bundle == null) {
            return;
        }
        if (object instanceof Long) {
            bundle.putLong(string, ((Long)object).longValue());
            return;
        }
        if (object instanceof String) {
            String string2 = String.valueOf(object);
            bundle.putString(string, string2);
            return;
        }
        if (object instanceof Double) {
            bundle.putDouble(string, ((Double)object).doubleValue());
            return;
        }
        if (zzju.zzb() && ((zzhh)this).zzt().zza(zzap.zzdc) && ((zzhh)this).zzt().zza(zzap.zzdb) && object instanceof Bundle[]) {
            bundle.putParcelableArray(string, (Parcelable[])((Bundle[])object));
            return;
        }
        if (string != null) {
            String string3 = object != null ? object.getClass().getSimpleName() : null;
            ((zzhh)this).zzr().zzk().zza("Not putting event parameter. Invalid value type. name, type", ((zzhh)this).zzo().zzb(string), string3);
        }
    }

    public final void zza(int n, String string, String string2, int n2) {
        this.zza(null, n, string, string2, n2);
    }

    final void zza(String string, int n, String string2, String string3, int n2) {
        Bundle bundle = new Bundle();
        zzla.zza(bundle, n);
        if (!TextUtils.isEmpty((CharSequence)string2) && !TextUtils.isEmpty((CharSequence)string3)) {
            bundle.putString(string2, string3);
        }
        if (n == 6 || n == 7 || n == 2) {
            bundle.putLong("_el", (long)n2);
        }
        zzw zzw2 = this.zzx.zzu();
        this.zzx.zzh().zza("auto", "_err", bundle);
    }

    static MessageDigest zzi() {
        for (int i = 0; i < 2; ++i) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                if (messageDigest == null) continue;
                return messageDigest;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
        }
        return null;
    }

    @VisibleForTesting
    static long zza(byte[] byArray) {
        Preconditions.checkNotNull((Object)byArray);
        Preconditions.checkState((byArray.length > 0 ? 1 : 0) != 0);
        long l = 0L;
        int n = 0;
        for (int i = byArray.length - 1; i >= 0 && i >= byArray.length - 8; --i) {
            l += ((long)byArray[i] & 0xFFL) << n;
            n += 8;
        }
        return l;
    }

    static boolean zza(Context context, boolean bl) {
        Preconditions.checkNotNull((Object)context);
        if (Build.VERSION.SDK_INT >= 24) {
            return zzla.zzb(context, "com.google.android.gms.measurement.AppMeasurementJobService");
        }
        return zzla.zzb(context, "com.google.android.gms.measurement.AppMeasurementService");
    }

    private static boolean zzb(Context context, String string) {
        try {
            PackageManager packageManager = context.getPackageManager();
            if (packageManager == null) {
                return false;
            }
            ServiceInfo serviceInfo = packageManager.getServiceInfo(new ComponentName(context, string), 0);
            if (serviceInfo != null && serviceInfo.enabled) {
                return true;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        return false;
    }

    @WorkerThread
    final boolean zzd(String string) {
        ((zzhh)this).zzd();
        if (Wrappers.packageManager((Context)((zzhh)this).zzn()).checkCallingOrSelfPermission(string) == 0) {
            return true;
        }
        ((zzhh)this).zzr().zzw().zza("Permission not granted", string);
        return false;
    }

    static boolean zze(String string) {
        return !TextUtils.isEmpty((CharSequence)string) && string.startsWith("_");
    }

    static boolean zzc(String string, String string2) {
        if (string == null && string2 == null) {
            return true;
        }
        if (string == null) {
            return false;
        }
        return string.equals(string2);
    }

    static boolean zza(Boolean bl, Boolean bl2) {
        if (bl == null && bl2 == null) {
            return true;
        }
        if (bl == null) {
            return false;
        }
        return bl.equals(bl2);
    }

    static boolean zza(@Nullable List<String> list, @Nullable List<String> list2) {
        if (list == null && list2 == null) {
            return true;
        }
        if (list == null) {
            return false;
        }
        return list.equals(list2);
    }

    final boolean zzf(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        String string2 = ((zzhh)this).zzt().zzw();
        zzw zzw2 = ((zzhh)this).zzu();
        return string2.equals(string);
    }

    final Bundle zza(Bundle bundle) {
        Bundle bundle2 = new Bundle();
        if (bundle != null) {
            for (String string : bundle.keySet()) {
                Object object = this.zza(string, bundle.get(string));
                if (object == null) {
                    ((zzhh)this).zzr().zzk().zza("Param value can't be null", ((zzhh)this).zzo().zzb(string));
                    continue;
                }
                this.zza(bundle2, string, object);
            }
        }
        return bundle2;
    }

    final zzan zza(String string, String string2, Bundle bundle, String string3, long l, boolean bl, boolean bl2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        if (this.zzb(string2) != 0) {
            ((zzhh)this).zzr().zzf().zza("Invalid conditional property event name", ((zzhh)this).zzo().zzc(string2));
            throw new IllegalArgumentException();
        }
        bundle = bundle != null ? new Bundle(bundle) : new Bundle();
        bundle.putString("_o", string3);
        List list = CollectionUtils.listOf((Object)"_o");
        Bundle bundle2 = this.zza(string, string2, bundle, list, false, false);
        Bundle bundle3 = this.zza(bundle2);
        return new zzan(string2, new zzam(bundle3), string3, l);
    }

    @WorkerThread
    final long zza(Context context, String string) {
        ((zzhh)this).zzd();
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotEmpty((String)string);
        long l = 0L;
        PackageManager packageManager = context.getPackageManager();
        MessageDigest messageDigest = zzla.zzi();
        if (messageDigest == null) {
            ((zzhh)this).zzr().zzf().zza("Could not get MD5 instance");
            l = -1L;
        } else if (packageManager != null) {
            try {
                if (!this.zzc(context, string)) {
                    PackageInfo packageInfo = Wrappers.packageManager((Context)context).getPackageInfo(((zzhh)this).zzn().getPackageName(), 64);
                    if (packageInfo.signatures != null && packageInfo.signatures.length > 0) {
                        l = zzla.zza(messageDigest.digest(packageInfo.signatures[0].toByteArray()));
                    } else {
                        ((zzhh)this).zzr().zzi().zza("Could not get signatures");
                        l = -1L;
                    }
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                ((zzhh)this).zzr().zzf().zza("Package name not found", (Object)nameNotFoundException);
            }
        }
        return l;
    }

    @VisibleForTesting
    private final boolean zzc(Context context, String string) {
        X500Principal x500Principal = new X500Principal("CN=Android Debug,O=Android,C=US");
        try {
            PackageInfo packageInfo = Wrappers.packageManager((Context)context).getPackageInfo(string, 64);
            if (packageInfo != null && packageInfo.signatures != null && packageInfo.signatures.length > 0) {
                Signature signature = packageInfo.signatures[0];
                return ((X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(signature.toByteArray()))).getSubjectX500Principal().equals(x500Principal);
            }
        }
        catch (CertificateException certificateException) {
            ((zzhh)this).zzr().zzf().zza("Error obtaining certificate", certificateException);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            ((zzhh)this).zzr().zzf().zza("Package name not found", (Object)nameNotFoundException);
        }
        return true;
    }

    static byte[] zza(Parcelable parcelable) {
        if (parcelable == null) {
            return null;
        }
        Parcel parcel = Parcel.obtain();
        try {
            parcelable.writeToParcel(parcel, 0);
            byte[] byArray = parcel.marshall();
            return byArray;
        }
        finally {
            parcel.recycle();
        }
    }

    public static Bundle zzb(Bundle bundle) {
        if (bundle == null) {
            return new Bundle();
        }
        Bundle bundle2 = new Bundle(bundle);
        for (String string : bundle2.keySet()) {
            int n;
            Object object;
            Object object2 = bundle2.get(string);
            if (object2 instanceof Bundle) {
                bundle2.putBundle(string, new Bundle((Bundle)object2));
                continue;
            }
            if (object2 instanceof Parcelable[]) {
                object = (Parcelable[])object2;
                for (n = 0; n < ((Parcelable[])object).length; ++n) {
                    if (!(object[n] instanceof Bundle)) continue;
                    object[n] = new Bundle((Bundle)object[n]);
                }
                continue;
            }
            if (!(object2 instanceof List)) continue;
            object = (List)object2;
            for (n = 0; n < object.size(); ++n) {
                Object e = object.get(n);
                if (!(e instanceof Bundle)) continue;
                object.set(n, new Bundle((Bundle)e));
            }
        }
        return bundle2;
    }

    private static boolean zza(String string, String[] stringArray) {
        Preconditions.checkNotNull((Object)stringArray);
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string2 = stringArray2[i];
            if (!zzla.zzc(string, string2)) continue;
            return true;
        }
        return false;
    }

    public final int zzj() {
        if (this.zze == null) {
            this.zze = GoogleApiAvailabilityLight.getInstance().getApkVersion(((zzhh)this).zzn()) / 1000;
        }
        return this.zze;
    }

    public final int zza(int n) {
        return GoogleApiAvailabilityLight.getInstance().isGooglePlayServicesAvailable(((zzhh)this).zzn(), 12451000);
    }

    public static long zza(long l, long l2) {
        return (l + l2 * 60000L) / 86400000L;
    }

    @WorkerThread
    final String zzk() {
        byte[] byArray = new byte[16];
        this.zzh().nextBytes(byArray);
        return String.format(Locale.US, "%032x", new BigInteger(1, byArray));
    }

    @WorkerThread
    final void zza(Bundle bundle, long l) {
        long l2 = bundle.getLong("_et");
        if (l2 != 0L) {
            ((zzhh)this).zzr().zzi().zza("Params already contained engagement", l2);
        }
        bundle.putLong("_et", l + l2);
    }

    public final void zza(zzn zzn2, String string) {
        Bundle bundle = new Bundle();
        bundle.putString("r", string);
        try {
            zzn2.zza(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzx.zzr().zzi().zza("Error returning string value to wrapper", (Object)remoteException);
            return;
        }
    }

    public final void zza(zzn zzn2, long l) {
        Bundle bundle = new Bundle();
        bundle.putLong("r", l);
        try {
            zzn2.zza(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzx.zzr().zzi().zza("Error returning long value to wrapper", (Object)remoteException);
            return;
        }
    }

    public final void zza(zzn zzn2, int n) {
        Bundle bundle = new Bundle();
        bundle.putInt("r", n);
        try {
            zzn2.zza(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzx.zzr().zzi().zza("Error returning int value to wrapper", (Object)remoteException);
            return;
        }
    }

    public final void zza(zzn zzn2, byte[] byArray) {
        Bundle bundle = new Bundle();
        bundle.putByteArray("r", byArray);
        try {
            zzn2.zza(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzx.zzr().zzi().zza("Error returning byte array to wrapper", (Object)remoteException);
            return;
        }
    }

    public final void zza(zzn zzn2, boolean bl) {
        Bundle bundle = new Bundle();
        bundle.putBoolean("r", bl);
        try {
            zzn2.zza(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzx.zzr().zzi().zza("Error returning boolean value to wrapper", (Object)remoteException);
            return;
        }
    }

    public final void zza(zzn zzn2, Bundle bundle) {
        try {
            zzn2.zza(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzx.zzr().zzi().zza("Error returning bundle value to wrapper", (Object)remoteException);
            return;
        }
    }

    public static Bundle zza(List<zzkz> list) {
        Bundle bundle = new Bundle();
        if (list == null) {
            return bundle;
        }
        for (zzkz zzkz2 : list) {
            if (zzkz2.zzd != null) {
                bundle.putString(zzkz2.zza, zzkz2.zzd);
                continue;
            }
            if (zzkz2.zzc != null) {
                bundle.putLong(zzkz2.zza, zzkz2.zzc.longValue());
                continue;
            }
            if (zzkz2.zzf == null) continue;
            bundle.putDouble(zzkz2.zza, zzkz2.zzf.doubleValue());
        }
        return bundle;
    }

    public final void zza(zzn zzn2, ArrayList<Bundle> arrayList) {
        Bundle bundle = new Bundle();
        bundle.putParcelableArrayList("r", arrayList);
        try {
            zzn2.zza(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzx.zzr().zzi().zza("Error returning bundle list to wrapper", (Object)remoteException);
            return;
        }
    }

    public static ArrayList<Bundle> zzb(List<zzv> list) {
        if (list == null) {
            return new ArrayList<Bundle>(0);
        }
        ArrayList<Bundle> arrayList = new ArrayList<Bundle>(list.size());
        for (zzv zzv2 : list) {
            Bundle bundle = new Bundle();
            bundle.putString("app_id", zzv2.zza);
            bundle.putString("origin", zzv2.zzb);
            bundle.putLong("creation_timestamp", zzv2.zzd);
            bundle.putString("name", zzv2.zzc.zza);
            zzhm.zza((Bundle)bundle, (Object)zzv2.zzc.zza());
            bundle.putBoolean("active", zzv2.zze);
            if (zzv2.zzf != null) {
                bundle.putString("trigger_event_name", zzv2.zzf);
            }
            if (zzv2.zzg != null) {
                bundle.putString("timed_out_event_name", zzv2.zzg.zza);
                if (zzv2.zzg.zzb != null) {
                    bundle.putBundle("timed_out_event_params", zzv2.zzg.zzb.zzb());
                }
            }
            bundle.putLong("trigger_timeout", zzv2.zzh);
            if (zzv2.zzi != null) {
                bundle.putString("triggered_event_name", zzv2.zzi.zza);
                if (zzv2.zzi.zzb != null) {
                    bundle.putBundle("triggered_event_params", zzv2.zzi.zzb.zzb());
                }
            }
            bundle.putLong("triggered_timestamp", zzv2.zzc.zzb);
            bundle.putLong("time_to_live", zzv2.zzj);
            if (zzv2.zzk != null) {
                bundle.putString("expired_event_name", zzv2.zzk.zza);
                if (zzv2.zzk.zzb != null) {
                    bundle.putBundle("expired_event_params", zzv2.zzk.zzb.zzb());
                }
            }
            arrayList.add(bundle);
        }
        return arrayList;
    }

    public final URL zza(long l, @NonNull String string, @NonNull String string2, long l2) {
        try {
            Preconditions.checkNotEmpty((String)string2);
            Preconditions.checkNotEmpty((String)string);
            String string3 = String.format("https://www.googleadservices.com/pagead/conversion/app/deeplink?id_type=adid&sdk_version=%s&rdid=%s&bundleid=%s&retry=%s", String.format("v%s.%s", l, this.zzj()), string2, string, l2);
            if (string.equals(((zzhh)this).zzt().zzx())) {
                string3 = string3.concat("&ddl_test=1");
            }
            return new URL(string3);
        }
        catch (IllegalArgumentException | MalformedURLException exception) {
            ((zzhh)this).zzr().zzf().zza("Failed to create BOW URL for Deferred Deep Link. exception", exception.getMessage());
            return null;
        }
    }

    @SuppressLint(value={"ApplySharedPref"})
    final boolean zza(String string, double d) {
        try {
            SharedPreferences.Editor editor = ((zzhh)this).zzn().getSharedPreferences("google.analytics.deferred.deeplink.prefs", 0).edit();
            editor.putString("deeplink", string);
            editor.putLong("timestamp", Double.doubleToRawLongBits(d));
            return editor.commit();
        }
        catch (Exception exception) {
            ((zzhh)this).zzr().zzf().zza("Failed to persist Deferred Deep Link. exception", exception);
            return false;
        }
    }

    public final boolean zzv() {
        try {
            ((zzhh)this).zzn().getClassLoader().loadClass("com.google.firebase.remoteconfig.FirebaseRemoteConfig");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public static long zza(zzam zzam2) {
        if (zzam2 == null) {
            return 0L;
        }
        long l = 0L;
        for (String string : zzam2) {
            Object object = zzam2.zza(string);
            if (!(object instanceof Parcelable[])) continue;
            l += (long)((Parcelable[])object).length;
        }
        return l;
    }
}

