/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Size;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.ProcessUtils;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzjj;
import com.google.android.gms.internal.measurement.zzll;
import com.google.android.gms.measurement.internal.zzaa;
import com.google.android.gms.measurement.internal.zzap;
import com.google.android.gms.measurement.internal.zzfc;
import com.google.android.gms.measurement.internal.zzg;
import com.google.android.gms.measurement.internal.zzgq;
import com.google.android.gms.measurement.internal.zzhh;
import com.google.android.gms.measurement.internal.zzw;
import com.google.android.gms.measurement.internal.zzz;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;

public final class zzx
extends zzhh {
    private Boolean zza;
    @NonNull
    private zzz zzb = zzaa.zza;
    private Boolean zzc;

    zzx(zzgq zzgq2) {
        super(zzgq2);
    }

    final void zza(@NonNull zzz zzz2) {
        this.zzb = zzz2;
    }

    public final int zze() {
        if (zzjj.zzb()) {
            zzfc<Boolean> zzfc2;
            zzfc<Boolean> zzfc3 = zzfc2 = zzap.zzdg;
            if (((zzhh)this).zzt().zzd(null, zzfc3)) {
                if (((zzhh)this).zzp().zzj() >= 2147483) {
                    return 100;
                }
                return 25;
            }
        }
        return 25;
    }

    final int zza(@Size(min=1L) String string) {
        zzfc<Boolean> zzfc2;
        zzfc<Boolean> zzfc3;
        if (zzjj.zzb() && this.zzd(null, zzfc3 = (zzfc2 = zzap.zzdf))) {
            return this.zza(string, zzap.zzag, 500, 2000);
        }
        return 500;
    }

    @WorkerThread
    public final int zzb(@Size(min=1L) String string) {
        return this.zzb(string, zzap.zzn);
    }

    final int zzc(@Size(min=1L) String string) {
        zzfc<Boolean> zzfc2;
        zzfc<Boolean> zzfc3;
        if (zzjj.zzb() && this.zzd(null, zzfc3 = (zzfc2 = zzap.zzdf))) {
            return this.zza(string, zzap.zzaf, 25, 100);
        }
        return 25;
    }

    public final long zzf() {
        zzw zzw2 = ((zzhh)this).zzu();
        return 25001L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zzg() {
        if (this.zzc == null) {
            zzx zzx2 = this;
            synchronized (zzx2) {
                if (this.zzc == null) {
                    ApplicationInfo applicationInfo = ((zzhh)this).zzn().getApplicationInfo();
                    String string = ProcessUtils.getMyProcessName();
                    if (applicationInfo != null) {
                        String string2 = applicationInfo.processName;
                        this.zzc = string2 != null && string2.equals(string);
                    }
                    if (this.zzc == null) {
                        this.zzc = Boolean.TRUE;
                        ((zzhh)this).zzr().zzf().zza("My process not in the list of running processes");
                    }
                }
            }
        }
        return this.zzc;
    }

    @WorkerThread
    public final long zza(String string, @NonNull zzfc<Long> zzfc2) {
        if (string == null) {
            return zzfc2.zza(null);
        }
        String string2 = this.zzb.zza(string, zzfc2.zza());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zzfc2.zza(null);
        }
        try {
            long l = Long.parseLong(string2);
            return zzfc2.zza(l);
        }
        catch (NumberFormatException numberFormatException) {
            return zzfc2.zza(null);
        }
    }

    @WorkerThread
    public final int zzb(String string, @NonNull zzfc<Integer> zzfc2) {
        if (string == null) {
            return zzfc2.zza(null);
        }
        String string2 = this.zzb.zza(string, zzfc2.zza());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zzfc2.zza(null);
        }
        try {
            int n = Integer.parseInt(string2);
            return zzfc2.zza(n);
        }
        catch (NumberFormatException numberFormatException) {
            return zzfc2.zza(null);
        }
    }

    @WorkerThread
    public final int zza(String string, @NonNull zzfc<Integer> zzfc2, int n, int n2) {
        return Math.max(Math.min(this.zzb(string, zzfc2), n2), n);
    }

    @WorkerThread
    public final double zzc(String string, @NonNull zzfc<Double> zzfc2) {
        if (string == null) {
            return zzfc2.zza(null);
        }
        String string2 = this.zzb.zza(string, zzfc2.zza());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zzfc2.zza(null);
        }
        try {
            double d = Double.parseDouble(string2);
            return zzfc2.zza(d);
        }
        catch (NumberFormatException numberFormatException) {
            return zzfc2.zza(null);
        }
    }

    @WorkerThread
    public final boolean zzd(String string, @NonNull zzfc<Boolean> zzfc2) {
        if (string == null) {
            return zzfc2.zza(null);
        }
        String string2 = this.zzb.zza(string, zzfc2.zza());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zzfc2.zza(null);
        }
        boolean bl = Boolean.parseBoolean(string2);
        return zzfc2.zza(bl);
    }

    public final boolean zze(String string, zzfc<Boolean> zzfc2) {
        return this.zzd(string, zzfc2);
    }

    public final boolean zza(zzfc<Boolean> zzfc2) {
        zzfc<Boolean> zzfc3 = zzfc2;
        return this.zzd(null, zzfc3);
    }

    @Nullable
    @VisibleForTesting
    private final Bundle zzz() {
        try {
            if (((zzhh)this).zzn().getPackageManager() == null) {
                ((zzhh)this).zzr().zzf().zza("Failed to load metadata: PackageManager is null");
                return null;
            }
            ApplicationInfo applicationInfo = Wrappers.packageManager((Context)((zzhh)this).zzn()).getApplicationInfo(((zzhh)this).zzn().getPackageName(), 128);
            if (applicationInfo == null) {
                ((zzhh)this).zzr().zzf().zza("Failed to load metadata: ApplicationInfo is null");
                return null;
            }
            return applicationInfo.metaData;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            ((zzhh)this).zzr().zzf().zza("Failed to load metadata: Package name not found", (Object)nameNotFoundException);
            return null;
        }
    }

    @Nullable
    @VisibleForTesting
    final Boolean zzd(@Size(min=1L) String string) {
        Preconditions.checkNotEmpty((String)string);
        Bundle bundle = this.zzz();
        if (bundle == null) {
            ((zzhh)this).zzr().zzf().zza("Failed to load metadata: Metadata bundle is null");
            return null;
        }
        if (!bundle.containsKey(string)) {
            return null;
        }
        return bundle.getBoolean(string);
    }

    @Nullable
    @VisibleForTesting
    final List<String> zze(@Size(min=1L) String string) {
        Integer n;
        Integer n2;
        String string2 = string;
        zzx zzx2 = this;
        Preconditions.checkNotEmpty((String)string2);
        Bundle bundle = zzx2.zzz();
        if (bundle == null) {
            ((zzhh)zzx2).zzr().zzf().zza("Failed to load metadata: Metadata bundle is null");
            n2 = null;
        } else {
            n2 = n = !bundle.containsKey(string2) ? null : Integer.valueOf(bundle.getInt(string2));
        }
        if (n2 == null) {
            return null;
        }
        try {
            String[] stringArray = ((zzhh)this).zzn().getResources().getStringArray(n.intValue());
            if (stringArray == null) {
                return null;
            }
            return Arrays.asList(stringArray);
        }
        catch (Resources.NotFoundException notFoundException) {
            ((zzhh)this).zzr().zzf().zza("Failed to load string array from metadata: resource not found", (Object)notFoundException);
            return null;
        }
    }

    public final boolean zzh() {
        zzw zzw2 = ((zzhh)this).zzu();
        Boolean bl = this.zzd("firebase_analytics_collection_deactivated");
        return bl != null && bl != false;
    }

    public final Boolean zzi() {
        zzw zzw2 = ((zzhh)this).zzu();
        return this.zzd("firebase_analytics_collection_enabled");
    }

    public final Boolean zzj() {
        ((zzhh)this).zzb();
        Boolean bl = this.zzd("google_analytics_adid_collection_enabled");
        return bl == null || bl != false;
    }

    public static long zzk() {
        return zzap.zzac.zza(null);
    }

    public final String zza(zzg zzg2) {
        String string;
        Uri.Builder builder;
        block2: {
            block3: {
                builder = new Uri.Builder();
                string = zzg2.zze();
                if (!TextUtils.isEmpty((CharSequence)string)) break block2;
                if (!zzll.zzb()) break block3;
                zzfc<Boolean> zzfc2 = zzap.zzch;
                String string2 = zzg2.zzc();
                if (((zzhh)this).zzt().zzd(string2, zzfc2) && !TextUtils.isEmpty((CharSequence)(string = zzg2.zzg()))) break block2;
            }
            string = zzg2.zzf();
        }
        String string3 = String.valueOf(string);
        builder.scheme((String)zzap.zzd.zza(null)).encodedAuthority((String)zzap.zze.zza(null)).path(string3.length() != 0 ? "config/app/".concat(string3) : new String("config/app/")).appendQueryParameter("app_instance_id", zzg2.zzd()).appendQueryParameter("platform", "android").appendQueryParameter("gmp_version", String.valueOf(this.zzf()));
        return builder.build().toString();
    }

    public static long zzv() {
        return zzap.zzc.zza(null);
    }

    public final String zzw() {
        return this.zza("debug.firebase.analytics.app", "");
    }

    public final String zzx() {
        return this.zza("debug.deferred.deeplink", "");
    }

    private final String zza(String string, String string2) {
        try {
            return (String)Class.forName("android.os.SystemProperties").getMethod("get", String.class, String.class).invoke(null, string, string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            ((zzhh)this).zzr().zzf().zza("Could not find SystemProperties class", classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            ((zzhh)this).zzr().zzf().zza("Could not find SystemProperties.get() method", noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            ((zzhh)this).zzr().zzf().zza("Could not access SystemProperties.get()", illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            ((zzhh)this).zzr().zzf().zza("SystemProperties.get() threw an exception", invocationTargetException);
        }
        return string2;
    }

    public final boolean zzf(String string) {
        return "1".equals(this.zzb.zza(string, "gaia_collection_enabled"));
    }

    public final boolean zzg(String string) {
        return "1".equals(this.zzb.zza(string, "measurement.event_sampling_enabled"));
    }

    @WorkerThread
    final boolean zzh(String string) {
        return this.zzd(string, zzap.zzaj);
    }

    @WorkerThread
    final String zzi(String string) {
        zzfc<String> zzfc2 = zzap.zzak;
        String string2 = string;
        zzx zzx2 = this;
        if (string2 == null) {
            return zzfc2.zza(null);
        }
        return zzfc2.zza(zzx2.zzb.zza(string2, zzfc2.zza()));
    }

    @WorkerThread
    final boolean zzy() {
        if (this.zza == null) {
            this.zza = this.zzd("app_measurement_lite");
            if (this.zza == null) {
                this.zza = false;
            }
        }
        return this.zza != false || !this.zzx.zzt();
    }
}

