/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.os.RemoteException;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzp;
import com.google.android.gms.measurement.internal.zzag;
import com.google.android.gms.measurement.internal.zzao;
import com.google.android.gms.measurement.internal.zzaq;
import com.google.android.gms.measurement.internal.zzd;
import com.google.android.gms.measurement.internal.zzek;
import com.google.android.gms.measurement.internal.zzfw;
import com.google.android.gms.measurement.internal.zzg;
import com.google.android.gms.measurement.internal.zzgr;
import com.google.android.gms.measurement.internal.zzih;
import com.google.android.gms.measurement.internal.zzik;
import com.google.android.gms.measurement.internal.zzim;
import com.google.android.gms.measurement.internal.zzin;
import com.google.android.gms.measurement.internal.zzio;
import com.google.android.gms.measurement.internal.zzip;
import com.google.android.gms.measurement.internal.zziq;
import com.google.android.gms.measurement.internal.zzir;
import com.google.android.gms.measurement.internal.zzis;
import com.google.android.gms.measurement.internal.zzit;
import com.google.android.gms.measurement.internal.zziu;
import com.google.android.gms.measurement.internal.zziv;
import com.google.android.gms.measurement.internal.zziw;
import com.google.android.gms.measurement.internal.zzix;
import com.google.android.gms.measurement.internal.zziy;
import com.google.android.gms.measurement.internal.zziz;
import com.google.android.gms.measurement.internal.zzja;
import com.google.android.gms.measurement.internal.zzjb;
import com.google.android.gms.measurement.internal.zzjd;
import com.google.android.gms.measurement.internal.zzjx;
import com.google.android.gms.measurement.internal.zzkh;
import com.google.android.gms.measurement.internal.zzn;
import com.google.android.gms.measurement.internal.zzw;
import com.google.android.gms.measurement.internal.zzx;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

@VisibleForTesting
public final class zzil
extends zzg {
    private final zzjd zza;
    private zzek zzb;
    private volatile Boolean zzc;
    private final zzag zzd;
    private final zzjx zze;
    private final List<Runnable> zzf = new ArrayList<Runnable>();
    private final zzag zzg;

    protected zzil(zzfw zzfw2) {
        super(zzfw2);
        this.zze = new zzjx(zzfw2.zzm());
        this.zza = new zzjd(this);
        this.zzd = new zzik(this, zzfw2);
        this.zzg = new zziv(this, zzfw2);
    }

    @Override
    protected final boolean zzz() {
        return false;
    }

    @WorkerThread
    public final boolean zzab() {
        ((zzgr)this).zzd();
        this.zzw();
        return this.zzb != null;
    }

    @WorkerThread
    protected final void zzac() {
        ((zzgr)this).zzd();
        this.zzw();
        zzn zzn2 = this.zza(true);
        this.zza(new zziu(this, zzn2));
    }

    @WorkerThread
    @VisibleForTesting
    final void zza(zzek zzek2, AbstractSafeParcelable abstractSafeParcelable, zzn zzn2) {
        ((zzgr)this).zzd();
        ((zzgr)this).zzb();
        this.zzw();
        boolean bl = this.zzaj();
        int n = 100;
        for (int i = 0; i < 1001 && n == 100; ++i) {
            List<AbstractSafeParcelable> list;
            ArrayList<AbstractSafeParcelable> arrayList = new ArrayList<AbstractSafeParcelable>();
            n = 0;
            if (bl && (list = ((zzd)this).zzj().zza(100)) != null) {
                arrayList.addAll(list);
                n = list.size();
            }
            if (abstractSafeParcelable != null && n < 100) {
                arrayList.add(abstractSafeParcelable);
            }
            ArrayList<AbstractSafeParcelable> arrayList2 = arrayList;
            int n2 = arrayList2.size();
            int n3 = 0;
            while (n3 < n2) {
                Object e = arrayList2.get(n3);
                ++n3;
                AbstractSafeParcelable abstractSafeParcelable2 = (AbstractSafeParcelable)e;
                if (abstractSafeParcelable2 instanceof zzao) {
                    try {
                        zzek2.zza((zzao)abstractSafeParcelable2, zzn2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzgr)this).zzr().zzf().zza("Failed to send event to the service", (Object)remoteException);
                    }
                    continue;
                }
                if (abstractSafeParcelable2 instanceof zzkh) {
                    try {
                        zzek2.zza((zzkh)abstractSafeParcelable2, zzn2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzgr)this).zzr().zzf().zza("Failed to send user property to the service", (Object)remoteException);
                    }
                    continue;
                }
                if (abstractSafeParcelable2 instanceof zzw) {
                    try {
                        zzek2.zza((zzw)abstractSafeParcelable2, zzn2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzgr)this).zzr().zzf().zza("Failed to send conditional user property to the service", (Object)remoteException);
                    }
                    continue;
                }
                ((zzgr)this).zzr().zzf().zza("Discarding data. Unrecognized parcel type.");
            }
        }
    }

    @WorkerThread
    protected final void zza(zzao zzao2, String string) {
        Preconditions.checkNotNull((Object)((Object)zzao2));
        ((zzgr)this).zzd();
        this.zzw();
        boolean bl = this.zzaj();
        boolean bl2 = bl && ((zzd)this).zzj().zza(zzao2);
        zzn zzn2 = this.zza(true);
        this.zza(new zzix(this, bl, bl2, zzao2, zzn2, string));
    }

    @WorkerThread
    protected final void zza(zzw zzw2) {
        Preconditions.checkNotNull((Object)((Object)zzw2));
        ((zzgr)this).zzd();
        this.zzw();
        zzx zzx2 = ((zzgr)this).zzu();
        boolean bl = true;
        boolean bl2 = true && ((zzd)this).zzj().zza(zzw2);
        zzw zzw3 = new zzw(zzw2);
        zzn zzn2 = this.zza(true);
        this.zza(new zziw(this, bl, bl2, zzw3, zzn2, zzw2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzw>> atomicReference, String string, String string2, String string3) {
        ((zzgr)this).zzd();
        this.zzw();
        zzn zzn2 = this.zza(false);
        this.zza(new zziz(this, atomicReference, string, string2, string3, zzn2));
    }

    @WorkerThread
    protected final void zza(zzp zzp2, String string, String string2) {
        ((zzgr)this).zzd();
        this.zzw();
        zzn zzn2 = this.zza(false);
        this.zza(new zziy(this, string, string2, zzn2, zzp2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzkh>> atomicReference, String string, String string2, String string3, boolean bl) {
        ((zzgr)this).zzd();
        this.zzw();
        zzn zzn2 = this.zza(false);
        this.zza(new zzjb(this, atomicReference, string, string2, string3, bl, zzn2));
    }

    @WorkerThread
    protected final void zza(zzp zzp2, String string, String string2, boolean bl) {
        ((zzgr)this).zzd();
        this.zzw();
        zzn zzn2 = this.zza(false);
        this.zza(new zzja(this, string, string2, bl, zzn2, zzp2));
    }

    @WorkerThread
    protected final void zza(zzkh zzkh2) {
        ((zzgr)this).zzd();
        this.zzw();
        boolean bl = this.zzaj() && ((zzd)this).zzj().zza(zzkh2);
        zzn zzn2 = this.zza(true);
        this.zza(new zzin(this, bl, zzkh2, zzn2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzkh>> atomicReference, boolean bl) {
        ((zzgr)this).zzd();
        this.zzw();
        zzn zzn2 = this.zza(false);
        this.zza(new zzim(this, atomicReference, zzn2, bl));
    }

    @WorkerThread
    protected final void zzad() {
        ((zzgr)this).zzd();
        ((zzgr)this).zzb();
        this.zzw();
        zzn zzn2 = this.zza(false);
        if (this.zzaj()) {
            ((zzd)this).zzj().zzab();
        }
        this.zza(new zzip(this, zzn2));
    }

    private final boolean zzaj() {
        zzx zzx2 = ((zzgr)this).zzu();
        return true;
    }

    @WorkerThread
    public final void zza(AtomicReference<String> atomicReference) {
        ((zzgr)this).zzd();
        this.zzw();
        zzn zzn2 = this.zza(false);
        this.zza(new zzio(this, atomicReference, zzn2));
    }

    @WorkerThread
    public final void zza(zzp zzp2) {
        ((zzgr)this).zzd();
        this.zzw();
        zzn zzn2 = this.zza(false);
        this.zza(new zzir(this, zzn2, zzp2));
    }

    @WorkerThread
    protected final void zzae() {
        ((zzgr)this).zzd();
        this.zzw();
        zzn zzn2 = this.zza(true);
        ((zzd)this).zzj().zzac();
        this.zza(new zziq(this, zzn2));
    }

    @WorkerThread
    protected final void zza(zzih zzih2) {
        ((zzgr)this).zzd();
        this.zzw();
        this.zza(new zzit(this, zzih2));
    }

    @WorkerThread
    private final void zzak() {
        ((zzgr)this).zzd();
        this.zze.zza();
        this.zzd.zza((Long)zzaq.zzai.zza(null));
    }

    @WorkerThread
    final void zzaf() {
        ((zzgr)this).zzd();
        this.zzw();
        if (this.zzab()) {
            return;
        }
        if (this.zzal()) {
            this.zza.zzb();
            return;
        }
        if (!((zzgr)this).zzt().zzy()) {
            Intent intent;
            zzil zzil2 = this;
            zzx zzx2 = ((zzgr)zzil2).zzu();
            PackageManager packageManager = ((zzgr)zzil2).zzn().getPackageManager();
            List list = packageManager.queryIntentServices(intent = new Intent().setClassName(((zzgr)zzil2).zzn(), "com.google.android.gms.measurement.AppMeasurementService"), 65536);
            if (list != null && list.size() > 0) {
                Intent intent2 = new Intent("com.google.android.gms.measurement.START");
                zzx2 = ((zzgr)this).zzu();
                intent2.setComponent(new ComponentName(((zzgr)this).zzn(), "com.google.android.gms.measurement.AppMeasurementService"));
                this.zza.zza(intent2);
                return;
            }
            ((zzgr)this).zzr().zzf().zza("Unable to use remote or local measurement implementation. Please register the AppMeasurementService service in the app manifest");
        }
    }

    final Boolean zzag() {
        return this.zzc;
    }

    @WorkerThread
    private final boolean zzal() {
        ((zzgr)this).zzd();
        this.zzw();
        if (this.zzc == null) {
            boolean bl;
            zzil zzil2 = this;
            ((zzgr)zzil2).zzd();
            zzil2.zzw();
            Boolean bl2 = ((zzgr)zzil2).zzs().zzj();
            if (bl2 != null && bl2.booleanValue()) {
                bl = true;
            } else {
                boolean bl3;
                boolean bl4;
                zzx zzx2 = ((zzgr)zzil2).zzu();
                if (((zzd)zzil2).zzg().zzag() == 1) {
                    bl4 = true;
                    bl3 = true;
                } else {
                    ((zzgr)zzil2).zzr().zzx().zza("Checking service availability");
                    int n = ((zzgr)zzil2).zzp().zza(12451000);
                    switch (n) {
                        case 0: {
                            ((zzgr)zzil2).zzr().zzx().zza("Service available");
                            bl4 = true;
                            bl3 = true;
                            break;
                        }
                        case 1: {
                            ((zzgr)zzil2).zzr().zzx().zza("Service missing");
                            bl4 = false;
                            bl3 = true;
                            break;
                        }
                        case 18: {
                            ((zzgr)zzil2).zzr().zzi().zza("Service updating");
                            bl4 = true;
                            bl3 = true;
                            break;
                        }
                        case 2: {
                            ((zzgr)zzil2).zzr().zzw().zza("Service container out of date");
                            if (((zzgr)zzil2).zzp().zzj() < 17443) {
                                bl4 = false;
                                bl3 = true;
                                break;
                            }
                            bl4 = bl2 == null;
                            bl3 = false;
                            break;
                        }
                        case 3: {
                            ((zzgr)zzil2).zzr().zzi().zza("Service disabled");
                            bl4 = false;
                            bl3 = false;
                            break;
                        }
                        case 9: {
                            ((zzgr)zzil2).zzr().zzi().zza("Service invalid");
                            bl4 = false;
                            bl3 = false;
                            break;
                        }
                        default: {
                            ((zzgr)zzil2).zzr().zzi().zza("Unexpected service status", n);
                            bl4 = false;
                            bl3 = false;
                        }
                    }
                }
                if (!bl4 && ((zzgr)zzil2).zzt().zzy()) {
                    ((zzgr)zzil2).zzr().zzf().zza("No way to upload. Consider using the full version of Analytics");
                    bl3 = false;
                }
                if (bl3) {
                    ((zzgr)zzil2).zzs().zza(bl4);
                }
                bl = bl4;
            }
            this.zzc = bl;
        }
        return this.zzc;
    }

    @WorkerThread
    @VisibleForTesting
    protected final void zza(zzek zzek2) {
        ((zzgr)this).zzd();
        Preconditions.checkNotNull((Object)zzek2);
        this.zzb = zzek2;
        this.zzak();
        this.zzan();
    }

    @WorkerThread
    public final void zzah() {
        ((zzgr)this).zzd();
        this.zzw();
        this.zza.zza();
        try {
            ConnectionTracker.getInstance().unbindService(((zzgr)this).zzn(), (ServiceConnection)this.zza);
        }
        catch (IllegalArgumentException | IllegalStateException runtimeException) {}
        this.zzb = null;
    }

    @WorkerThread
    private final void zza(ComponentName componentName) {
        ((zzgr)this).zzd();
        if (this.zzb != null) {
            this.zzb = null;
            ((zzgr)this).zzr().zzx().zza("Disconnected from device MeasurementService", componentName);
            zzil zzil2 = this;
            ((zzgr)zzil2).zzd();
            zzil2.zzaf();
        }
    }

    @WorkerThread
    private final void zzam() {
        ((zzgr)this).zzd();
        if (!this.zzab()) {
            return;
        }
        ((zzgr)this).zzr().zzx().zza("Inactivity, disconnecting from the service");
        this.zzah();
    }

    @WorkerThread
    private final void zza(Runnable runnable) throws IllegalStateException {
        ((zzgr)this).zzd();
        if (this.zzab()) {
            runnable.run();
            return;
        }
        if ((long)this.zzf.size() >= 1000L) {
            ((zzgr)this).zzr().zzf().zza("Discarding data. Max runnable queue size reached");
            return;
        }
        this.zzf.add(runnable);
        this.zzg.zza(60000L);
        this.zzaf();
    }

    @WorkerThread
    private final void zzan() {
        ((zzgr)this).zzd();
        ((zzgr)this).zzr().zzx().zza("Processing queued up service tasks", this.zzf.size());
        for (Runnable runnable : this.zzf) {
            try {
                runnable.run();
            }
            catch (Exception exception) {
                ((zzgr)this).zzr().zzf().zza("Task exception while flushing queue", exception);
            }
        }
        this.zzf.clear();
        this.zzg.zzc();
    }

    @WorkerThread
    @Nullable
    private final zzn zza(boolean bl) {
        zzx zzx2 = ((zzgr)this).zzu();
        return ((zzd)this).zzg().zza(bl ? ((zzgr)this).zzr().zzy() : null);
    }

    @WorkerThread
    public final void zza(zzp zzp2, zzao zzao2, String string) {
        ((zzgr)this).zzd();
        this.zzw();
        int n = ((zzgr)this).zzp().zza(12451000);
        if (n != 0) {
            ((zzgr)this).zzr().zzi().zza("Not bundling data. Service unavailable or out of date");
            ((zzgr)this).zzp().zza(zzp2, new byte[0]);
            return;
        }
        this.zza(new zzis(this, zzao2, string, zzp2));
    }

    @WorkerThread
    final boolean zzai() {
        ((zzgr)this).zzd();
        this.zzw();
        if (!this.zzal()) {
            return true;
        }
        return ((zzgr)this).zzp().zzj() >= 200900;
    }

    static /* synthetic */ zzjd zza(zzil zzil2) {
        return zzil2.zza;
    }

    static /* synthetic */ void zza(zzil zzil2, ComponentName componentName) {
        zzil2.zza(componentName);
    }

    static /* synthetic */ zzek zza(zzil zzil2, zzek zzek2) {
        zzil2.zzb = null;
        return null;
    }

    static /* synthetic */ void zzb(zzil zzil2) {
        zzil2.zzan();
    }

    static /* synthetic */ void zzc(zzil zzil2) {
        zzil2.zzam();
    }

    static /* synthetic */ zzek zzd(zzil zzil2) {
        return zzil2.zzb;
    }

    static /* synthetic */ void zze(zzil zzil2) {
        zzil2.zzak();
    }
}

