/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Size;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.ProcessUtils;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzjg;
import com.google.android.gms.internal.measurement.zzlb;
import com.google.android.gms.internal.measurement.zzlo;
import com.google.android.gms.measurement.internal.zzaa;
import com.google.android.gms.measurement.internal.zzab;
import com.google.android.gms.measurement.internal.zzaq;
import com.google.android.gms.measurement.internal.zzel;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzfw;
import com.google.android.gms.measurement.internal.zzgr;
import com.google.android.gms.measurement.internal.zzx;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;

public final class zzy
extends zzgr {
    private Boolean zza;
    @NonNull
    private zzaa zzb = zzab.zza;
    private Boolean zzc;

    zzy(zzfw zzfw2) {
        super(zzfw2);
    }

    final void zza(@NonNull zzaa zzaa2) {
        this.zzb = zzaa2;
    }

    public final int zze() {
        if (zzjg.zzb()) {
            zzel<Boolean> zzel2;
            zzel<Boolean> zzel3 = zzel2 = zzaq.zzcl;
            if (((zzgr)this).zzt().zzd(null, zzel3)) {
                if (((zzgr)this).zzp().zzj() >= 2147483) {
                    return 100;
                }
                return 25;
            }
        }
        return 25;
    }

    final int zza(@Size(min=1L) String string) {
        zzel<Boolean> zzel2;
        zzel<Boolean> zzel3;
        if (zzjg.zzb() && this.zzd(null, zzel3 = (zzel2 = zzaq.zzck))) {
            return this.zza(string, zzaq.zzag, 500, 2000);
        }
        return 500;
    }

    @WorkerThread
    public final int zzb(@Size(min=1L) String string) {
        return this.zzb(string, zzaq.zzn);
    }

    final int zzc(@Size(min=1L) String string) {
        zzel<Boolean> zzel2;
        zzel<Boolean> zzel3;
        if (zzjg.zzb() && this.zzd(null, zzel3 = (zzel2 = zzaq.zzck))) {
            return this.zza(string, zzaq.zzaf, 25, 100);
        }
        return 25;
    }

    public final long zzf() {
        zzx zzx2 = ((zzgr)this).zzu();
        return 26001L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zzg() {
        if (this.zzc == null) {
            zzy zzy2 = this;
            synchronized (zzy2) {
                if (this.zzc == null) {
                    ApplicationInfo applicationInfo = ((zzgr)this).zzn().getApplicationInfo();
                    String string = ProcessUtils.getMyProcessName();
                    if (applicationInfo != null) {
                        String string2 = applicationInfo.processName;
                        this.zzc = string2 != null && string2.equals(string);
                    }
                    if (this.zzc == null) {
                        this.zzc = Boolean.TRUE;
                        ((zzgr)this).zzr().zzf().zza("My process not in the list of running processes");
                    }
                }
            }
        }
        return this.zzc;
    }

    @WorkerThread
    public final long zza(String string, @NonNull zzel<Long> zzel2) {
        if (string == null) {
            return zzel2.zza(null);
        }
        String string2 = this.zzb.zza(string, zzel2.zza());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zzel2.zza(null);
        }
        try {
            long l = Long.parseLong(string2);
            return zzel2.zza(l);
        }
        catch (NumberFormatException numberFormatException) {
            return zzel2.zza(null);
        }
    }

    @WorkerThread
    public final int zzb(String string, @NonNull zzel<Integer> zzel2) {
        if (string == null) {
            return zzel2.zza(null);
        }
        String string2 = this.zzb.zza(string, zzel2.zza());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zzel2.zza(null);
        }
        try {
            int n = Integer.parseInt(string2);
            return zzel2.zza(n);
        }
        catch (NumberFormatException numberFormatException) {
            return zzel2.zza(null);
        }
    }

    @WorkerThread
    public final int zza(String string, @NonNull zzel<Integer> zzel2, int n, int n2) {
        return Math.max(Math.min(this.zzb(string, zzel2), n2), n);
    }

    @WorkerThread
    public final double zzc(String string, @NonNull zzel<Double> zzel2) {
        if (string == null) {
            return zzel2.zza(null);
        }
        String string2 = this.zzb.zza(string, zzel2.zza());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zzel2.zza(null);
        }
        try {
            double d = Double.parseDouble(string2);
            return zzel2.zza(d);
        }
        catch (NumberFormatException numberFormatException) {
            return zzel2.zza(null);
        }
    }

    @WorkerThread
    public final boolean zzd(String string, @NonNull zzel<Boolean> zzel2) {
        if (string == null) {
            return zzel2.zza(null);
        }
        String string2 = this.zzb.zza(string, zzel2.zza());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zzel2.zza(null);
        }
        boolean bl = Boolean.parseBoolean(string2);
        return zzel2.zza(bl);
    }

    public final boolean zze(String string, zzel<Boolean> zzel2) {
        return this.zzd(string, zzel2);
    }

    public final boolean zza(zzel<Boolean> zzel2) {
        zzel<Boolean> zzel3 = zzel2;
        return this.zzd(null, zzel3);
    }

    @Nullable
    @VisibleForTesting
    private final Bundle zzz() {
        try {
            if (((zzgr)this).zzn().getPackageManager() == null) {
                ((zzgr)this).zzr().zzf().zza("Failed to load metadata: PackageManager is null");
                return null;
            }
            ApplicationInfo applicationInfo = Wrappers.packageManager((Context)((zzgr)this).zzn()).getApplicationInfo(((zzgr)this).zzn().getPackageName(), 128);
            if (applicationInfo == null) {
                ((zzgr)this).zzr().zzf().zza("Failed to load metadata: ApplicationInfo is null");
                return null;
            }
            return applicationInfo.metaData;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            ((zzgr)this).zzr().zzf().zza("Failed to load metadata: Package name not found", (Object)nameNotFoundException);
            return null;
        }
    }

    @Nullable
    @VisibleForTesting
    final Boolean zzd(@Size(min=1L) String string) {
        Preconditions.checkNotEmpty((String)string);
        Bundle bundle = this.zzz();
        if (bundle == null) {
            ((zzgr)this).zzr().zzf().zza("Failed to load metadata: Metadata bundle is null");
            return null;
        }
        if (!bundle.containsKey(string)) {
            return null;
        }
        return bundle.getBoolean(string);
    }

    @Nullable
    @VisibleForTesting
    final List<String> zze(@Size(min=1L) String string) {
        Integer n;
        Integer n2;
        String string2 = string;
        zzy zzy2 = this;
        Preconditions.checkNotEmpty((String)string2);
        Bundle bundle = zzy2.zzz();
        if (bundle == null) {
            ((zzgr)zzy2).zzr().zzf().zza("Failed to load metadata: Metadata bundle is null");
            n2 = null;
        } else {
            n2 = n = !bundle.containsKey(string2) ? null : Integer.valueOf(bundle.getInt(string2));
        }
        if (n2 == null) {
            return null;
        }
        try {
            String[] stringArray = ((zzgr)this).zzn().getResources().getStringArray(n.intValue());
            if (stringArray == null) {
                return null;
            }
            return Arrays.asList(stringArray);
        }
        catch (Resources.NotFoundException notFoundException) {
            ((zzgr)this).zzr().zzf().zza("Failed to load string array from metadata: resource not found", (Object)notFoundException);
            return null;
        }
    }

    public final boolean zzh() {
        zzx zzx2 = ((zzgr)this).zzu();
        Boolean bl = this.zzd("firebase_analytics_collection_deactivated");
        return bl != null && bl != false;
    }

    public final Boolean zzi() {
        ((zzgr)this).zzb();
        Boolean bl = this.zzd("google_analytics_adid_collection_enabled");
        return bl == null || bl != false;
    }

    public final Boolean zzj() {
        ((zzgr)this).zzb();
        if (!zzlo.zzb() || !this.zza(zzaq.zzcc)) {
            return true;
        }
        Boolean bl = this.zzd("google_analytics_automatic_screen_reporting_enabled");
        return bl == null || bl != false;
    }

    public static long zzk() {
        return zzaq.zzac.zza(null);
    }

    public final String zza(zzf zzf2) {
        String string;
        Uri.Builder builder;
        block2: {
            block3: {
                builder = new Uri.Builder();
                string = zzf2.zze();
                if (!TextUtils.isEmpty((CharSequence)string)) break block2;
                if (!zzlb.zzb()) break block3;
                zzel<Boolean> zzel2 = zzaq.zzbo;
                String string2 = zzf2.zzc();
                if (((zzgr)this).zzt().zzd(string2, zzel2) && !TextUtils.isEmpty((CharSequence)(string = zzf2.zzg()))) break block2;
            }
            string = zzf2.zzf();
        }
        String string3 = String.valueOf(string);
        builder.scheme((String)zzaq.zzd.zza(null)).encodedAuthority((String)zzaq.zze.zza(null)).path(string3.length() != 0 ? "config/app/".concat(string3) : new String("config/app/")).appendQueryParameter("app_instance_id", zzf2.zzd()).appendQueryParameter("platform", "android").appendQueryParameter("gmp_version", String.valueOf(this.zzf()));
        return builder.build().toString();
    }

    public static long zzv() {
        return zzaq.zzc.zza(null);
    }

    public final String zzw() {
        return this.zza("debug.firebase.analytics.app", "");
    }

    public final String zzx() {
        return this.zza("debug.deferred.deeplink", "");
    }

    private final String zza(String string, String string2) {
        try {
            return (String)Class.forName("android.os.SystemProperties").getMethod("get", String.class, String.class).invoke(null, string, string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            ((zzgr)this).zzr().zzf().zza("Could not find SystemProperties class", classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            ((zzgr)this).zzr().zzf().zza("Could not find SystemProperties.get() method", noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            ((zzgr)this).zzr().zzf().zza("Could not access SystemProperties.get()", illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            ((zzgr)this).zzr().zzf().zza("SystemProperties.get() threw an exception", invocationTargetException);
        }
        return string2;
    }

    public final boolean zzf(String string) {
        return "1".equals(this.zzb.zza(string, "gaia_collection_enabled"));
    }

    public final boolean zzg(String string) {
        return "1".equals(this.zzb.zza(string, "measurement.event_sampling_enabled"));
    }

    @WorkerThread
    final boolean zzh(String string) {
        return this.zzd(string, zzaq.zzaj);
    }

    @WorkerThread
    final String zzi(String string) {
        zzel<String> zzel2 = zzaq.zzak;
        String string2 = string;
        zzy zzy2 = this;
        if (string2 == null) {
            return zzel2.zza(null);
        }
        return zzel2.zza(zzy2.zzb.zza(string2, zzel2.zza()));
    }

    @WorkerThread
    final boolean zzy() {
        if (this.zza == null) {
            this.zza = this.zzd("app_measurement_lite");
            if (this.zza == null) {
                this.zza = false;
            }
        }
        return this.zza != false || !this.zzz.zzt();
    }
}

