/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.text.TextUtils;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zzas;
import com.google.android.gms.measurement.internal.zzfh;
import com.google.android.gms.measurement.internal.zzfj;
import com.google.android.gms.measurement.internal.zzfk;
import com.google.android.gms.measurement.internal.zzfl;
import com.google.android.gms.measurement.internal.zzfm;
import com.google.android.gms.measurement.internal.zzfx;
import com.google.android.gms.measurement.internal.zzgr;
import com.google.android.gms.measurement.internal.zzko;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Locale;

final class zzff
extends zzgr {
    @VisibleForTesting
    static final Pair<String, Long> zza = new Pair((Object)"", (Object)0L);
    private SharedPreferences zzaa;
    public zzfm zzb;
    public final zzfj zzc = new zzfj(this, "last_upload", 0L);
    public final zzfj zzd = new zzfj(this, "last_upload_attempt", 0L);
    public final zzfj zze = new zzfj(this, "backoff", 0L);
    public final zzfj zzf = new zzfj(this, "last_delete_stale", 0L);
    public final zzfj zzg;
    public final zzfj zzh;
    public final zzfj zzi;
    public final zzfl zzj;
    private String zzab;
    private boolean zzac;
    private long zzad;
    public final zzfj zzk = new zzfj(this, "time_before_start", 10000L);
    public final zzfj zzl = new zzfj(this, "session_timeout", 1800000L);
    public final zzfh zzm = new zzfh(this, "start_new_session", true);
    public final zzfl zzn;
    public final zzfh zzo;
    public final zzfh zzp;
    public final zzfj zzq = new zzfj(this, "last_pause_time", 0L);
    public boolean zzr;
    public zzfh zzs;
    public zzfh zzt;
    public zzfj zzu;
    public final zzfl zzv;
    public final zzfl zzw;
    public final zzfj zzx;
    public final zzfk zzy;

    @WorkerThread
    @NonNull
    final Pair<String, Boolean> zza(String string) {
        this.zzd();
        long l = this.zzm().elapsedRealtime();
        if (this.zzab != null && l < this.zzad) {
            return new Pair((Object)this.zzab, (Object)this.zzac);
        }
        String string2 = string;
        this.zzad = l + this.zzt().zza(string2, zzas.zza);
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)true);
        try {
            AdvertisingIdClient.Info info = AdvertisingIdClient.getAdvertisingIdInfo((Context)this.zzn());
            if (info != null) {
                this.zzab = info.getId();
                this.zzac = info.isLimitAdTrackingEnabled();
            }
            if (this.zzab == null) {
                this.zzab = "";
            }
        }
        catch (Exception exception) {
            this.zzr().zzw().zza("Unable to get advertising id", exception);
            this.zzab = "";
        }
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)false);
        return new Pair((Object)this.zzab, (Object)this.zzac);
    }

    @WorkerThread
    final String zzb(String string) {
        this.zzd();
        String string2 = (String)this.zza((String)string).first;
        MessageDigest messageDigest = zzko.zzi();
        if (messageDigest == null) {
            return null;
        }
        return String.format(Locale.US, "%032X", new BigInteger(1, messageDigest.digest(string2.getBytes())));
    }

    zzff(zzfx zzfx2) {
        super(zzfx2);
        this.zzn = new zzfl(this, "non_personalized_ads", null);
        this.zzo = new zzfh(this, "use_dynamite_api", false);
        this.zzp = new zzfh(this, "allow_remote_dynamite", false);
        this.zzg = new zzfj(this, "midnight_offset", 0L);
        this.zzh = new zzfj(this, "first_open_time", 0L);
        this.zzi = new zzfj(this, "app_install_time", 0L);
        this.zzj = new zzfl(this, "app_instance_id", null);
        this.zzs = new zzfh(this, "app_backgrounded", false);
        this.zzt = new zzfh(this, "deep_link_retrieval_complete", false);
        this.zzu = new zzfj(this, "deep_link_retrieval_attempts", 0L);
        this.zzv = new zzfl(this, "firebase_feature_rollouts", null);
        this.zzw = new zzfl(this, "deferred_attribution_cache", null);
        this.zzx = new zzfj(this, "deferred_attribution_cache_timestamp", 0L);
        this.zzy = new zzfk(this, "default_event_parameters", null);
    }

    @Override
    protected final boolean zze() {
        return true;
    }

    @Override
    @WorkerThread
    protected final void f_() {
        this.zzaa = this.zzn().getSharedPreferences("com.google.android.gms.measurement.prefs", 0);
        this.zzr = this.zzaa.getBoolean("has_been_opened", false);
        if (!this.zzr) {
            SharedPreferences.Editor editor = this.zzaa.edit();
            editor.putBoolean("has_been_opened", true);
            editor.apply();
        }
        this.zzb = new zzfm(this, "health_monitor", Math.max(0L, (Long)zzas.zzb.zza(null)), null);
    }

    @WorkerThread
    @VisibleForTesting
    protected final SharedPreferences zzg() {
        this.zzd();
        this.zzaa();
        return this.zzaa;
    }

    @WorkerThread
    final void zzc(String string) {
        this.zzd();
        SharedPreferences.Editor editor = this.zzg().edit();
        editor.putString("gmp_app_id", string);
        editor.apply();
    }

    @WorkerThread
    final String zzh() {
        this.zzd();
        return this.zzg().getString("gmp_app_id", null);
    }

    @WorkerThread
    final void zzd(String string) {
        this.zzd();
        SharedPreferences.Editor editor = this.zzg().edit();
        editor.putString("admob_app_id", string);
        editor.apply();
    }

    @WorkerThread
    final String zzi() {
        this.zzd();
        return this.zzg().getString("admob_app_id", null);
    }

    @WorkerThread
    final Boolean zzj() {
        this.zzd();
        if (!this.zzg().contains("use_service")) {
            return null;
        }
        return this.zzg().getBoolean("use_service", false);
    }

    @WorkerThread
    final void zza(boolean bl) {
        this.zzd();
        SharedPreferences.Editor editor = this.zzg().edit();
        editor.putBoolean("use_service", bl);
        editor.apply();
    }

    @WorkerThread
    final void zzk() {
        this.zzd();
        Boolean bl = this.zzv();
        SharedPreferences.Editor editor = this.zzg().edit();
        editor.clear();
        editor.apply();
        if (bl != null) {
            this.zzb(bl);
        }
    }

    @WorkerThread
    final void zzb(boolean bl) {
        this.zzd();
        SharedPreferences.Editor editor = this.zzg().edit();
        editor.putBoolean("measurement_enabled", bl);
        editor.apply();
    }

    @WorkerThread
    final Boolean zzv() {
        this.zzd();
        if (this.zzg().contains("measurement_enabled")) {
            return this.zzg().getBoolean("measurement_enabled", true);
        }
        return null;
    }

    @WorkerThread
    protected final String zzw() {
        this.zzd();
        String string = this.zzg().getString("previous_os_version", null);
        this.zzl().zzaa();
        String string2 = Build.VERSION.RELEASE;
        if (!TextUtils.isEmpty((CharSequence)string2) && !string2.equals(string)) {
            SharedPreferences.Editor editor = this.zzg().edit();
            editor.putString("previous_os_version", string2);
            editor.apply();
        }
        return string;
    }

    @WorkerThread
    final void zzc(boolean bl) {
        this.zzd();
        this.zzr().zzx().zza("App measurement setting deferred collection", bl);
        SharedPreferences.Editor editor = this.zzg().edit();
        editor.putBoolean("deferred_analytics_collection", bl);
        editor.apply();
    }

    @WorkerThread
    final boolean zzx() {
        return this.zzaa.contains("deferred_analytics_collection");
    }

    final boolean zza(long l) {
        return l - this.zzl.zza() > this.zzq.zza();
    }
}

