/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.measurement.internal.zzfv;
import com.google.android.gms.measurement.internal.zzfw;
import com.google.android.gms.measurement.internal.zzfx;
import com.google.android.gms.measurement.internal.zzfy;
import com.google.android.gms.measurement.internal.zzgr;
import com.google.android.gms.measurement.internal.zzgs;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public final class zzfu
extends zzgr {
    private zzfy zza;
    private zzfy zzb;
    private final PriorityBlockingQueue<zzfv<?>> zzc;
    private final BlockingQueue<zzfv<?>> zzd;
    private final Thread.UncaughtExceptionHandler zze;
    private final Thread.UncaughtExceptionHandler zzf;
    private final Object zzg = new Object();
    private final Semaphore zzh = new Semaphore(2);
    private volatile boolean zzi;
    private static final AtomicLong zzj = new AtomicLong(Long.MIN_VALUE);

    zzfu(zzfx zzfx2) {
        super(zzfx2);
        this.zzc = new PriorityBlockingQueue();
        this.zzd = new LinkedBlockingQueue();
        this.zze = new zzfw(this, "Thread death: Uncaught exception on worker thread");
        this.zzf = new zzfw(this, "Thread death: Uncaught exception on network thread");
    }

    @Override
    protected final boolean zze() {
        return false;
    }

    @Override
    public final void zzd() {
        if (Thread.currentThread() != this.zza) {
            throw new IllegalStateException("Call expected from worker thread");
        }
    }

    @Override
    public final void zzc() {
        if (Thread.currentThread() != this.zzb) {
            throw new IllegalStateException("Call expected from network thread");
        }
    }

    public final boolean zzg() {
        return Thread.currentThread() == this.zza;
    }

    public final <V> Future<V> zza(Callable<V> callable) throws IllegalStateException {
        this.zzaa();
        Preconditions.checkNotNull(callable);
        zzfv zzfv2 = new zzfv(this, callable, false, "Task exception on worker thread");
        if (Thread.currentThread() == this.zza) {
            if (!this.zzc.isEmpty()) {
                ((zzgs)this).zzr().zzi().zza("Callable skipped the worker queue.");
            }
            zzfv2.run();
        } else {
            this.zza(zzfv2);
        }
        return zzfv2;
    }

    public final <V> Future<V> zzb(Callable<V> callable) throws IllegalStateException {
        this.zzaa();
        Preconditions.checkNotNull(callable);
        zzfv zzfv2 = new zzfv(this, callable, true, "Task exception on worker thread");
        if (Thread.currentThread() == this.zza) {
            zzfv2.run();
        } else {
            this.zza(zzfv2);
        }
        return zzfv2;
    }

    public final void zza(Runnable runnable) throws IllegalStateException {
        this.zzaa();
        Preconditions.checkNotNull((Object)runnable);
        this.zza(new zzfv(this, runnable, false, "Task exception on worker thread"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final <T> T zza(AtomicReference<T> atomicReference, long l, String string, Runnable runnable) {
        AtomicReference<T> atomicReference2 = atomicReference;
        synchronized (atomicReference2) {
            ((zzgs)this).zzq().zza(runnable);
            try {
                atomicReference.wait(l);
            }
            catch (InterruptedException interruptedException) {
                String string2 = String.valueOf(string);
                ((zzgs)this).zzr().zzi().zza(string2.length() != 0 ? "Interrupted waiting for ".concat(string2) : new String("Interrupted waiting for "));
                return null;
            }
        }
        atomicReference2 = atomicReference.get();
        if (atomicReference2 == null) {
            String string3 = String.valueOf(string);
            ((zzgs)this).zzr().zzi().zza(string3.length() != 0 ? "Timed out waiting for ".concat(string3) : new String("Timed out waiting for "));
        }
        return (T)atomicReference2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zza(zzfv<?> zzfv2) {
        Object object = this.zzg;
        synchronized (object) {
            this.zzc.add(zzfv2);
            if (this.zza == null) {
                this.zza = new zzfy(this, "Measurement Worker", this.zzc);
                this.zza.setUncaughtExceptionHandler(this.zze);
                this.zza.start();
            } else {
                this.zza.zza();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzb(Runnable runnable) throws IllegalStateException {
        this.zzaa();
        Preconditions.checkNotNull((Object)runnable);
        zzfv zzfv2 = new zzfv(this, runnable, false, "Task exception on network thread");
        zzfu zzfu2 = this;
        Object object = zzfu2.zzg;
        synchronized (object) {
            zzfu2.zzd.add(zzfv2);
            if (zzfu2.zzb == null) {
                zzfu2.zzb = new zzfy(zzfu2, "Measurement Network", zzfu2.zzd);
                zzfu2.zzb.setUncaughtExceptionHandler(zzfu2.zzf);
                zzfu2.zzb.start();
            } else {
                zzfu2.zzb.zza();
            }
            return;
        }
    }

    static /* synthetic */ Semaphore zza(zzfu zzfu2) {
        return zzfu2.zzh;
    }

    static /* synthetic */ boolean zzb(zzfu zzfu2) {
        return zzfu2.zzi;
    }

    static /* synthetic */ Object zzc(zzfu zzfu2) {
        return zzfu2.zzg;
    }

    static /* synthetic */ zzfy zzd(zzfu zzfu2) {
        return zzfu2.zza;
    }

    static /* synthetic */ zzfy zza(zzfu zzfu2, zzfy zzfy2) {
        zzfu2.zza = null;
        return null;
    }

    static /* synthetic */ zzfy zze(zzfu zzfu2) {
        return zzfu2.zzb;
    }

    static /* synthetic */ zzfy zzb(zzfu zzfu2, zzfy zzfy2) {
        zzfu2.zzb = null;
        return null;
    }

    static /* synthetic */ AtomicLong zzh() {
        return zzj;
    }
}

