/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.RemoteException;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zzag;
import com.google.android.gms.measurement.internal.zzao;
import com.google.android.gms.measurement.internal.zzaq;
import com.google.android.gms.measurement.internal.zzd;
import com.google.android.gms.measurement.internal.zzem;
import com.google.android.gms.measurement.internal.zzfy;
import com.google.android.gms.measurement.internal.zzg;
import com.google.android.gms.measurement.internal.zzgs;
import com.google.android.gms.measurement.internal.zzij;
import com.google.android.gms.measurement.internal.zziq;
import com.google.android.gms.measurement.internal.zzis;
import com.google.android.gms.measurement.internal.zzit;
import com.google.android.gms.measurement.internal.zziu;
import com.google.android.gms.measurement.internal.zziv;
import com.google.android.gms.measurement.internal.zziw;
import com.google.android.gms.measurement.internal.zzix;
import com.google.android.gms.measurement.internal.zziy;
import com.google.android.gms.measurement.internal.zziz;
import com.google.android.gms.measurement.internal.zzja;
import com.google.android.gms.measurement.internal.zzjb;
import com.google.android.gms.measurement.internal.zzjc;
import com.google.android.gms.measurement.internal.zzjd;
import com.google.android.gms.measurement.internal.zzje;
import com.google.android.gms.measurement.internal.zzjf;
import com.google.android.gms.measurement.internal.zzjg;
import com.google.android.gms.measurement.internal.zzjh;
import com.google.android.gms.measurement.internal.zzji;
import com.google.android.gms.measurement.internal.zzjj;
import com.google.android.gms.measurement.internal.zzkc;
import com.google.android.gms.measurement.internal.zzkq;
import com.google.android.gms.measurement.internal.zzn;
import com.google.android.gms.measurement.internal.zzw;
import com.google.android.gms.measurement.internal.zzx;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

@VisibleForTesting
public final class zzir
extends zzg {
    private final zzji zza;
    private zzem zzb;
    private volatile Boolean zzc;
    private final zzag zzd;
    private final zzkc zze;
    private final List<Runnable> zzf = new ArrayList<Runnable>();
    private final zzag zzg;

    protected zzir(zzfy zzfy2) {
        super(zzfy2);
        this.zze = new zzkc(zzfy2.zzm());
        this.zza = new zzji(this);
        this.zzd = new zziq(this, zzfy2);
        this.zzg = new zzja(this, zzfy2);
    }

    @Override
    protected final boolean zzz() {
        return false;
    }

    @WorkerThread
    public final boolean zzab() {
        ((zzgs)this).zzd();
        this.zzw();
        return this.zzb != null;
    }

    @WorkerThread
    protected final void zzac() {
        ((zzgs)this).zzd();
        this.zzw();
        zzn zzn2 = this.zza(true);
        this.zza(new zzjd(this, zzn2));
    }

    @WorkerThread
    @VisibleForTesting
    final void zza(zzem zzem2, AbstractSafeParcelable abstractSafeParcelable, zzn zzn2) {
        ((zzgs)this).zzd();
        ((zzgs)this).zzb();
        this.zzw();
        boolean bl = this.zzaj();
        int n = 100;
        for (int i = 0; i < 1001 && n == 100; ++i) {
            List<AbstractSafeParcelable> list;
            ArrayList<AbstractSafeParcelable> arrayList = new ArrayList<AbstractSafeParcelable>();
            n = 0;
            if (bl && (list = ((zzd)this).zzj().zza(100)) != null) {
                arrayList.addAll(list);
                n = list.size();
            }
            if (abstractSafeParcelable != null && n < 100) {
                arrayList.add(abstractSafeParcelable);
            }
            ArrayList<AbstractSafeParcelable> arrayList2 = arrayList;
            int n2 = arrayList2.size();
            int n3 = 0;
            while (n3 < n2) {
                Object e = arrayList2.get(n3);
                ++n3;
                AbstractSafeParcelable abstractSafeParcelable2 = (AbstractSafeParcelable)e;
                if (abstractSafeParcelable2 instanceof zzao) {
                    try {
                        zzem2.zza((zzao)abstractSafeParcelable2, zzn2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzgs)this).zzr().zzf().zza("Failed to send event to the service", (Object)remoteException);
                    }
                    continue;
                }
                if (abstractSafeParcelable2 instanceof zzkq) {
                    try {
                        zzem2.zza((zzkq)abstractSafeParcelable2, zzn2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzgs)this).zzr().zzf().zza("Failed to send user property to the service", (Object)remoteException);
                    }
                    continue;
                }
                if (abstractSafeParcelable2 instanceof zzw) {
                    try {
                        zzem2.zza((zzw)abstractSafeParcelable2, zzn2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzgs)this).zzr().zzf().zza("Failed to send conditional user property to the service", (Object)remoteException);
                    }
                    continue;
                }
                ((zzgs)this).zzr().zzf().zza("Discarding data. Unrecognized parcel type.");
            }
        }
    }

    @WorkerThread
    protected final void zza(zzao zzao2, String string) {
        Preconditions.checkNotNull((Object)((Object)zzao2));
        ((zzgs)this).zzd();
        this.zzw();
        boolean bl = this.zzaj();
        boolean bl2 = bl && ((zzd)this).zzj().zza(zzao2);
        zzn zzn2 = this.zza(true);
        this.zza(new zzjc(this, bl, bl2, zzao2, zzn2, string));
    }

    @WorkerThread
    protected final void zza(zzw zzw2) {
        Preconditions.checkNotNull((Object)((Object)zzw2));
        ((zzgs)this).zzd();
        this.zzw();
        zzx zzx2 = ((zzgs)this).zzu();
        boolean bl = true;
        boolean bl2 = true && ((zzd)this).zzj().zza(zzw2);
        zzw zzw3 = new zzw(zzw2);
        zzn zzn2 = this.zza(true);
        this.zza(new zzjf(this, bl, bl2, zzw3, zzn2, zzw2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzw>> atomicReference, String string, String string2, String string3) {
        ((zzgs)this).zzd();
        this.zzw();
        zzn zzn2 = this.zza(false);
        this.zza(new zzje(this, atomicReference, string, string2, string3, zzn2));
    }

    @WorkerThread
    protected final void zza(com.google.android.gms.internal.measurement.zzw zzw2, String string, String string2) {
        ((zzgs)this).zzd();
        this.zzw();
        zzn zzn2 = this.zza(false);
        this.zza(new zzjh(this, string, string2, zzn2, zzw2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzkq>> atomicReference, String string, String string2, String string3, boolean bl) {
        ((zzgs)this).zzd();
        this.zzw();
        zzn zzn2 = this.zza(false);
        this.zza(new zzjg(this, atomicReference, string, string2, string3, bl, zzn2));
    }

    @WorkerThread
    protected final void zza(com.google.android.gms.internal.measurement.zzw zzw2, String string, String string2, boolean bl) {
        ((zzgs)this).zzd();
        this.zzw();
        zzn zzn2 = this.zza(false);
        this.zza(new zzjj(this, string, string2, bl, zzn2, zzw2));
    }

    @WorkerThread
    protected final void zza(zzkq zzkq2) {
        ((zzgs)this).zzd();
        this.zzw();
        boolean bl = this.zzaj() && ((zzd)this).zzj().zza(zzkq2);
        zzn zzn2 = this.zza(true);
        this.zza(new zzit(this, bl, zzkq2, zzn2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzkq>> atomicReference, boolean bl) {
        ((zzgs)this).zzd();
        this.zzw();
        zzn zzn2 = this.zza(false);
        this.zza(new zzis(this, atomicReference, zzn2, bl));
    }

    @WorkerThread
    protected final void zzad() {
        ((zzgs)this).zzd();
        ((zzgs)this).zzb();
        this.zzw();
        zzn zzn2 = this.zza(false);
        if (this.zzaj()) {
            ((zzd)this).zzj().zzab();
        }
        this.zza(new zziv(this, zzn2));
    }

    private final boolean zzaj() {
        zzx zzx2 = ((zzgs)this).zzu();
        return true;
    }

    @WorkerThread
    public final void zza(AtomicReference<String> atomicReference) {
        ((zzgs)this).zzd();
        this.zzw();
        zzn zzn2 = this.zza(false);
        this.zza(new zziu(this, atomicReference, zzn2));
    }

    @WorkerThread
    public final void zza(com.google.android.gms.internal.measurement.zzw zzw2) {
        ((zzgs)this).zzd();
        this.zzw();
        zzn zzn2 = this.zza(false);
        this.zza(new zzix(this, zzn2, zzw2));
    }

    @WorkerThread
    protected final void zzae() {
        ((zzgs)this).zzd();
        this.zzw();
        zzn zzn2 = this.zza(true);
        ((zzd)this).zzj().zzac();
        this.zza(new zziw(this, zzn2));
    }

    @WorkerThread
    protected final void zza(zzij zzij2) {
        ((zzgs)this).zzd();
        this.zzw();
        this.zza(new zziz(this, zzij2));
    }

    @WorkerThread
    public final void zza(Bundle bundle) {
        ((zzgs)this).zzd();
        this.zzw();
        zzn zzn2 = this.zza(false);
        this.zza(new zziy(this, bundle, zzn2));
    }

    @WorkerThread
    private final void zzak() {
        ((zzgs)this).zzd();
        this.zze.zza();
        this.zzd.zza((Long)zzaq.zzai.zza(null));
    }

    @WorkerThread
    final void zzaf() {
        ((zzgs)this).zzd();
        this.zzw();
        if (this.zzab()) {
            return;
        }
        if (this.zzal()) {
            this.zza.zzb();
            return;
        }
        if (!((zzgs)this).zzt().zzy()) {
            Intent intent;
            zzir zzir2 = this;
            zzx zzx2 = ((zzgs)zzir2).zzu();
            PackageManager packageManager = ((zzgs)zzir2).zzn().getPackageManager();
            List list = packageManager.queryIntentServices(intent = new Intent().setClassName(((zzgs)zzir2).zzn(), "com.google.android.gms.measurement.AppMeasurementService"), 65536);
            if (list != null && list.size() > 0) {
                Intent intent2 = new Intent("com.google.android.gms.measurement.START");
                zzx2 = ((zzgs)this).zzu();
                intent2.setComponent(new ComponentName(((zzgs)this).zzn(), "com.google.android.gms.measurement.AppMeasurementService"));
                this.zza.zza(intent2);
                return;
            }
            ((zzgs)this).zzr().zzf().zza("Unable to use remote or local measurement implementation. Please register the AppMeasurementService service in the app manifest");
        }
    }

    final Boolean zzag() {
        return this.zzc;
    }

    @WorkerThread
    private final boolean zzal() {
        ((zzgs)this).zzd();
        this.zzw();
        if (this.zzc == null) {
            boolean bl;
            zzir zzir2 = this;
            ((zzgs)zzir2).zzd();
            zzir2.zzw();
            Boolean bl2 = ((zzgs)zzir2).zzs().zzj();
            if (bl2 != null && bl2.booleanValue()) {
                bl = true;
            } else {
                boolean bl3;
                boolean bl4;
                zzx zzx2 = ((zzgs)zzir2).zzu();
                if (((zzd)zzir2).zzg().zzag() == 1) {
                    bl4 = true;
                    bl3 = true;
                } else {
                    ((zzgs)zzir2).zzr().zzx().zza("Checking service availability");
                    int n = ((zzgs)zzir2).zzp().zza(12451000);
                    switch (n) {
                        case 0: {
                            ((zzgs)zzir2).zzr().zzx().zza("Service available");
                            bl4 = true;
                            bl3 = true;
                            break;
                        }
                        case 1: {
                            ((zzgs)zzir2).zzr().zzx().zza("Service missing");
                            bl4 = false;
                            bl3 = true;
                            break;
                        }
                        case 18: {
                            ((zzgs)zzir2).zzr().zzi().zza("Service updating");
                            bl4 = true;
                            bl3 = true;
                            break;
                        }
                        case 2: {
                            ((zzgs)zzir2).zzr().zzw().zza("Service container out of date");
                            if (((zzgs)zzir2).zzp().zzj() < 17443) {
                                bl4 = false;
                                bl3 = true;
                                break;
                            }
                            bl4 = bl2 == null;
                            bl3 = false;
                            break;
                        }
                        case 3: {
                            ((zzgs)zzir2).zzr().zzi().zza("Service disabled");
                            bl4 = false;
                            bl3 = false;
                            break;
                        }
                        case 9: {
                            ((zzgs)zzir2).zzr().zzi().zza("Service invalid");
                            bl4 = false;
                            bl3 = false;
                            break;
                        }
                        default: {
                            ((zzgs)zzir2).zzr().zzi().zza("Unexpected service status", n);
                            bl4 = false;
                            bl3 = false;
                        }
                    }
                }
                if (!bl4 && ((zzgs)zzir2).zzt().zzy()) {
                    ((zzgs)zzir2).zzr().zzf().zza("No way to upload. Consider using the full version of Analytics");
                    bl3 = false;
                }
                if (bl3) {
                    ((zzgs)zzir2).zzs().zza(bl4);
                }
                bl = bl4;
            }
            this.zzc = bl;
        }
        return this.zzc;
    }

    @WorkerThread
    @VisibleForTesting
    protected final void zza(zzem zzem2) {
        ((zzgs)this).zzd();
        Preconditions.checkNotNull((Object)zzem2);
        this.zzb = zzem2;
        this.zzak();
        this.zzan();
    }

    @WorkerThread
    public final void zzah() {
        ((zzgs)this).zzd();
        this.zzw();
        this.zza.zza();
        try {
            ConnectionTracker.getInstance().unbindService(((zzgs)this).zzn(), (ServiceConnection)this.zza);
        }
        catch (IllegalArgumentException | IllegalStateException runtimeException) {}
        this.zzb = null;
    }

    @WorkerThread
    private final void zza(ComponentName componentName) {
        ((zzgs)this).zzd();
        if (this.zzb != null) {
            this.zzb = null;
            ((zzgs)this).zzr().zzx().zza("Disconnected from device MeasurementService", componentName);
            zzir zzir2 = this;
            ((zzgs)zzir2).zzd();
            zzir2.zzaf();
        }
    }

    @WorkerThread
    private final void zzam() {
        ((zzgs)this).zzd();
        if (!this.zzab()) {
            return;
        }
        ((zzgs)this).zzr().zzx().zza("Inactivity, disconnecting from the service");
        this.zzah();
    }

    @WorkerThread
    private final void zza(Runnable runnable) throws IllegalStateException {
        ((zzgs)this).zzd();
        if (this.zzab()) {
            runnable.run();
            return;
        }
        if ((long)this.zzf.size() >= 1000L) {
            ((zzgs)this).zzr().zzf().zza("Discarding data. Max runnable queue size reached");
            return;
        }
        this.zzf.add(runnable);
        this.zzg.zza(60000L);
        this.zzaf();
    }

    @WorkerThread
    private final void zzan() {
        ((zzgs)this).zzd();
        ((zzgs)this).zzr().zzx().zza("Processing queued up service tasks", this.zzf.size());
        for (Runnable runnable : this.zzf) {
            try {
                runnable.run();
            }
            catch (Exception exception) {
                ((zzgs)this).zzr().zzf().zza("Task exception while flushing queue", exception);
            }
        }
        this.zzf.clear();
        this.zzg.zzc();
    }

    @WorkerThread
    @Nullable
    private final zzn zza(boolean bl) {
        zzx zzx2 = ((zzgs)this).zzu();
        return ((zzd)this).zzg().zza(bl ? ((zzgs)this).zzr().zzy() : null);
    }

    @WorkerThread
    public final void zza(com.google.android.gms.internal.measurement.zzw zzw2, zzao zzao2, String string) {
        ((zzgs)this).zzd();
        this.zzw();
        int n = ((zzgs)this).zzp().zza(12451000);
        if (n != 0) {
            ((zzgs)this).zzr().zzi().zza("Not bundling data. Service unavailable or out of date");
            ((zzgs)this).zzp().zza(zzw2, new byte[0]);
            return;
        }
        this.zza(new zzjb(this, zzao2, string, zzw2));
    }

    @WorkerThread
    final boolean zzai() {
        ((zzgs)this).zzd();
        this.zzw();
        if (!this.zzal()) {
            return true;
        }
        return ((zzgs)this).zzp().zzj() >= 200900;
    }

    static /* synthetic */ zzji zza(zzir zzir2) {
        return zzir2.zza;
    }

    static /* synthetic */ void zza(zzir zzir2, ComponentName componentName) {
        zzir2.zza(componentName);
    }

    static /* synthetic */ zzem zza(zzir zzir2, zzem zzem2) {
        zzir2.zzb = null;
        return null;
    }

    static /* synthetic */ void zzb(zzir zzir2) {
        zzir2.zzan();
    }

    static /* synthetic */ void zzc(zzir zzir2) {
        zzir2.zzam();
    }

    static /* synthetic */ zzem zzd(zzir zzir2) {
        return zzir2.zzb;
    }

    static /* synthetic */ void zze(zzir zzir2) {
        zzir2.zzak();
    }
}

