/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Activity;
import android.os.Bundle;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Size;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zznh;
import com.google.android.gms.internal.measurement.zznt;
import com.google.android.gms.measurement.internal.zza;
import com.google.android.gms.measurement.internal.zzaq;
import com.google.android.gms.measurement.internal.zzd;
import com.google.android.gms.measurement.internal.zze;
import com.google.android.gms.measurement.internal.zzg;
import com.google.android.gms.measurement.internal.zzgd;
import com.google.android.gms.measurement.internal.zzgx;
import com.google.android.gms.measurement.internal.zzik;
import com.google.android.gms.measurement.internal.zzim;
import com.google.android.gms.measurement.internal.zzio;
import com.google.android.gms.measurement.internal.zzip;
import com.google.android.gms.measurement.internal.zziq;
import com.google.android.gms.measurement.internal.zzir;
import com.google.android.gms.measurement.internal.zzit;
import com.google.android.gms.measurement.internal.zzkw;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class zzin
extends zzg {
    private volatile zzik zzb;
    private zzik zzc;
    @VisibleForTesting
    protected zzik zza;
    private final Map<Activity, zzik> zzd;
    private Activity zze;
    private volatile boolean zzf;
    private volatile zzik zzg;
    private zzik zzh;
    private boolean zzi;
    private final Object zzj = new Object();
    private zzik zzk;
    private String zzl;

    public zzin(zzgd zzgd2) {
        super(zzgd2);
        this.zzd = new ConcurrentHashMap<Activity, zzik>();
    }

    @Override
    protected final boolean zzz() {
        return false;
    }

    @WorkerThread
    public final zzik zza(boolean bl) {
        this.zzw();
        ((zzgx)this).zzd();
        if (!((zzgx)this).zzt().zza(zzaq.zzcc) || !bl) {
            return this.zza;
        }
        if (this.zza != null) {
            return this.zza;
        }
        return this.zzh;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(Bundle bundle, long l) {
        zzik zzik2;
        if (!((zzgx)this).zzt().zza(zzaq.zzcc)) {
            ((zzgx)this).zzr().zzk().zza("Manual screen reporting is disabled.");
            return;
        }
        String string = null;
        String string2 = null;
        Object object = this.zzj;
        synchronized (object) {
            if (!this.zzi) {
                ((zzgx)this).zzr().zzk().zza("Cannot log screen view event when the app is in the background.");
                return;
            }
            if (bundle != null) {
                string = bundle.getString("screen_name");
                if (string != null && (string.length() <= 0 || string.length() > 100)) {
                    ((zzgx)this).zzr().zzk().zza("Invalid screen name length for screen view. Length", string.length());
                    return;
                }
                string2 = bundle.getString("screen_class");
                if (string2 != null && (string2.length() <= 0 || string2.length() > 100)) {
                    ((zzgx)this).zzr().zzk().zza("Invalid screen class length for screen view. Length", string2.length());
                    return;
                }
            }
            if (string2 == null) {
                String string3 = string2 = this.zze != null ? zzin.zza(this.zze.getClass().getCanonicalName()) : "Activity";
            }
            if (this.zzf && this.zzb != null) {
                this.zzf = false;
                boolean bl = zzkw.zzc(this.zzb.zzb, string2);
                boolean bl2 = zzkw.zzc(this.zzb.zza, string);
                if (bl && bl2) {
                    ((zzgx)this).zzr().zzk().zza("Ignoring call to log screen view event with duplicate parameters.");
                    return;
                }
            }
        }
        ((zzgx)this).zzr().zzx().zza("Logging screen view with name, class", string == null ? "null" : string, string2 == null ? "null" : string2);
        object = this.zzb == null ? this.zzc : this.zzb;
        this.zzb = zzik2 = new zzik(string, string2, ((zzgx)this).zzp().zzg(), true, l);
        this.zzc = object;
        this.zzg = zzik2;
        long l2 = ((zzgx)this).zzm().elapsedRealtime();
        ((zzgx)this).zzq().zza(new zzim(this, bundle, zzik2, (zzik)object, l2));
    }

    @WorkerThread
    private final void zza(Bundle bundle, @NonNull zzik zzik2, zzik zzik3, long l) {
        if (bundle != null) {
            bundle.remove("screen_name");
            bundle.remove("screen_class");
        }
        Bundle bundle2 = ((zzgx)this).zzp().zza(null, "screen_view", bundle, null, true, true);
        this.zza(zzik2, zzik3, l, true, bundle2);
    }

    @MainThread
    public final void zza(@NonNull Activity activity, @Size(min=1L, max=36L) @Nullable String string, @Size(min=1L, max=36L) @Nullable String string2) {
        if (!((zzgx)this).zzt().zzj().booleanValue()) {
            ((zzgx)this).zzr().zzk().zza("setCurrentScreen cannot be called while screen reporting is disabled.");
            return;
        }
        if (this.zzb == null) {
            ((zzgx)this).zzr().zzk().zza("setCurrentScreen cannot be called while no activity active");
            return;
        }
        if (this.zzd.get(activity) == null) {
            ((zzgx)this).zzr().zzk().zza("setCurrentScreen must be called with an activity in the activity lifecycle");
            return;
        }
        if (string2 == null) {
            string2 = zzin.zza(activity.getClass().getCanonicalName());
        }
        boolean bl = zzkw.zzc(this.zzb.zzb, string2);
        boolean bl2 = zzkw.zzc(this.zzb.zza, string);
        if (bl && bl2) {
            ((zzgx)this).zzr().zzk().zza("setCurrentScreen cannot be called with the same class and name");
            return;
        }
        if (string != null && (string.length() <= 0 || string.length() > 100)) {
            ((zzgx)this).zzr().zzk().zza("Invalid screen name length in setCurrentScreen. Length", string.length());
            return;
        }
        if (string2 != null && (string2.length() <= 0 || string2.length() > 100)) {
            ((zzgx)this).zzr().zzk().zza("Invalid class name length in setCurrentScreen. Length", string2.length());
            return;
        }
        ((zzgx)this).zzr().zzx().zza("Setting current screen to name, class", string == null ? "null" : string, string2);
        zzik zzik2 = new zzik(string, string2, ((zzgx)this).zzp().zzg());
        this.zzd.put(activity, zzik2);
        this.zza(activity, zzik2, true);
    }

    public final zzik zzab() {
        ((zzgx)this).zzb();
        return this.zzb;
    }

    @MainThread
    private final void zza(Activity activity, zzik zzik2, boolean bl) {
        zzik zzik3;
        zzik zzik4;
        zzik zzik5 = zzik4 = this.zzb == null ? this.zzc : this.zzb;
        if (zzik2.zzb == null) {
            zzik3 = activity != null ? zzin.zza(activity.getClass().getCanonicalName()) : null;
            zzik2 = new zzik(zzik2.zza, (String)((Object)zzik3), zzik2.zzc, zzik2.zze, zzik2.zzf);
        }
        zzik3 = zzik2;
        this.zzc = this.zzb;
        this.zzb = zzik3;
        long l = ((zzgx)this).zzm().elapsedRealtime();
        ((zzgx)this).zzq().zza(new zzip(this, zzik3, zzik4, l, bl));
    }

    @WorkerThread
    private final void zza(zzik zzik2, zzik zzik3, long l, boolean bl, Bundle bundle) {
        ((zzgx)this).zzd();
        boolean bl2 = false;
        if (((zzgx)this).zzt().zza(zzaq.zzat)) {
            bl2 = bl && this.zza != null;
            if (bl2) {
                this.zza(this.zza, true, l);
            }
        } else if (bl && this.zza != null) {
            this.zza(this.zza, true, l);
        }
        if (zzik3 == null || zzik3.zzc != zzik2.zzc || !zzkw.zzc(zzik3.zzb, zzik2.zzb) || !zzkw.zzc(zzik3.zza, zzik2.zza)) {
            long l2;
            Bundle bundle2 = new Bundle();
            if (((zzgx)this).zzt().zza(zzaq.zzcc)) {
                bundle2 = bundle != null ? new Bundle(bundle) : new Bundle();
            }
            zzin.zza(zzik2, bundle2, true);
            if (zzik3 != null) {
                if (zzik3.zza != null) {
                    bundle2.putString("_pn", zzik3.zza);
                }
                if (zzik3.zzb != null) {
                    bundle2.putString("_pc", zzik3.zzb);
                }
                bundle2.putLong("_pi", zzik3.zzc);
            }
            if (((zzgx)this).zzt().zza(zzaq.zzat) && bl2 && (l2 = zznt.zzb() && ((zzgx)this).zzt().zza(zzaq.zzav) && zznh.zzb() && ((zzgx)this).zzt().zza(zzaq.zzbz) ? ((zzd)this).zzk().zza(l) : ((zzd)this).zzk().zzb.zzb()) > 0L) {
                ((zzgx)this).zzp().zza(bundle2, l2);
            }
            String string = "auto";
            if (((zzgx)this).zzt().zza(zzaq.zzcc)) {
                if (!((zzgx)this).zzt().zzj().booleanValue()) {
                    bundle2.putLong("_mt", 1L);
                }
                String string2 = string = zzik2.zze ? "app" : "auto";
            }
            if (((zzgx)this).zzt().zza(zzaq.zzcc)) {
                long l3 = ((zzgx)this).zzm().currentTimeMillis();
                if (zzik2.zze && zzik2.zzf != 0L) {
                    l3 = zzik2.zzf;
                }
                ((zzd)this).zzf().zza(string, "_vs", l3, bundle2);
            } else {
                ((zzd)this).zzf().zzb(string, "_vs", bundle2);
            }
        }
        this.zza = zzik2;
        if (((zzgx)this).zzt().zza(zzaq.zzcc) && zzik2.zze) {
            this.zzh = zzik2;
        }
        ((zzd)this).zzh().zza(zzik2);
    }

    @WorkerThread
    private final void zza(zzik zzik2, boolean bl, long l) {
        boolean bl2;
        ((zzd)this).zze().zza(((zzgx)this).zzm().elapsedRealtime());
        boolean bl3 = bl2 = zzik2 != null && zzik2.zzd;
        if (((zzd)this).zzk().zza(bl2, bl, l) && zzik2 != null) {
            zzik2.zzd = false;
        }
    }

    public static void zza(zzik zzik2, Bundle bundle, boolean bl) {
        if (bundle != null && zzik2 != null && (!bundle.containsKey("_sc") || bl)) {
            if (zzik2.zza != null) {
                bundle.putString("_sn", zzik2.zza);
            } else {
                bundle.remove("_sn");
            }
            if (zzik2.zzb != null) {
                bundle.putString("_sc", zzik2.zzb);
            } else {
                bundle.remove("_sc");
            }
            bundle.putLong("_si", zzik2.zzc);
            return;
        }
        if (bundle != null && zzik2 == null && bl) {
            bundle.remove("_sn");
            bundle.remove("_sc");
            bundle.remove("_si");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zza(String string, zzik zzik2) {
        ((zzgx)this).zzd();
        zzin zzin2 = this;
        synchronized (zzin2) {
            if (this.zzl == null || this.zzl.equals(string) || zzik2 != null) {
                this.zzl = string;
                this.zzk = zzik2;
            }
            return;
        }
    }

    @VisibleForTesting
    private static String zza(String string) {
        String[] stringArray = string.split("\\.");
        String string2 = stringArray.length > 0 ? stringArray[stringArray.length - 1] : "";
        if (string2.length() > 100) {
            return string2.substring(0, 100);
        }
        return string2;
    }

    @MainThread
    private final zzik zzd(@NonNull Activity activity) {
        Preconditions.checkNotNull((Object)activity);
        zzik zzik2 = this.zzd.get(activity);
        if (zzik2 == null) {
            String string = zzin.zza(activity.getClass().getCanonicalName());
            zzik2 = new zzik(null, string, ((zzgx)this).zzp().zzg());
            this.zzd.put(activity, zzik2);
        }
        if (!((zzgx)this).zzt().zza(zzaq.zzcc)) {
            return zzik2;
        }
        if (this.zzg != null) {
            return this.zzg;
        }
        return zzik2;
    }

    @MainThread
    public final void zza(Activity activity, Bundle bundle) {
        if (!((zzgx)this).zzt().zzj().booleanValue()) {
            return;
        }
        if (bundle == null) {
            return;
        }
        Bundle bundle2 = bundle.getBundle("com.google.app_measurement.screen_service");
        if (bundle2 == null) {
            return;
        }
        zzik zzik2 = new zzik(bundle2.getString("name"), bundle2.getString("referrer_name"), bundle2.getLong("id"));
        this.zzd.put(activity, zzik2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void zza(Activity activity) {
        zzd zzd2;
        Object object;
        if (((zzgx)this).zzt().zza(zzaq.zzcc)) {
            object = this.zzj;
            synchronized (object) {
                this.zzi = true;
                if (activity != this.zze) {
                    Activity activity2 = activity;
                    zzd2 = this;
                    Object object2 = ((zzin)zzd2).zzj;
                    synchronized (object2) {
                        ((zzin)zzd2).zze = activity2;
                        ((zzin)zzd2).zzf = false;
                    }
                    if (zzd2.zzt().zza(zzaq.zzcb) && zzd2.zzt().zzj().booleanValue()) {
                        ((zzin)zzd2).zzg = null;
                        zzd2.zzq().zza(new zzit((zzin)zzd2));
                    }
                }
            }
        }
        if (((zzgx)this).zzt().zza(zzaq.zzcb) && !((zzgx)this).zzt().zzj().booleanValue()) {
            this.zzb = this.zzg;
            ((zzgx)this).zzq().zza(new zzio(this));
            return;
        }
        object = this.zzd(activity);
        this.zza(activity, (zzik)object, false);
        zzd2 = ((zzd)this).zze();
        long l = zzd2.zzm().elapsedRealtime();
        zzd2.zzq().zza(new zze((zza)zzd2, l));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void zzb(Activity activity) {
        if (((zzgx)this).zzt().zza(zzaq.zzcc)) {
            Object object = this.zzj;
            synchronized (object) {
                this.zzi = false;
                this.zzf = true;
            }
        }
        long l = ((zzgx)this).zzm().elapsedRealtime();
        if (((zzgx)this).zzt().zza(zzaq.zzcb) && !((zzgx)this).zzt().zzj().booleanValue()) {
            this.zzb = null;
            ((zzgx)this).zzq().zza(new zzir(this, l));
            return;
        }
        zzik zzik2 = this.zzd(activity);
        this.zzc = this.zzb;
        this.zzb = null;
        ((zzgx)this).zzq().zza(new zziq(this, zzik2, l));
    }

    @MainThread
    public final void zzb(Activity activity, Bundle bundle) {
        if (!((zzgx)this).zzt().zzj().booleanValue()) {
            return;
        }
        if (bundle == null) {
            return;
        }
        zzik zzik2 = this.zzd.get(activity);
        if (zzik2 == null) {
            return;
        }
        Bundle bundle2 = new Bundle();
        bundle2.putLong("id", zzik2.zzc);
        bundle2.putString("name", zzik2.zza);
        bundle2.putString("referrer_name", zzik2.zzb);
        bundle.putBundle("com.google.app_measurement.screen_service", bundle2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void zzc(Activity activity) {
        Object object = this.zzj;
        synchronized (object) {
            if (activity == this.zze) {
                this.zze = null;
            }
        }
        if (!((zzgx)this).zzt().zzj().booleanValue()) {
            return;
        }
        this.zzd.remove(activity);
    }

    static /* synthetic */ void zza(zzin zzin2, Bundle bundle, zzik zzik2, zzik zzik3, long l) {
        zzin2.zza(bundle, zzik2, zzik3, l);
    }

    static /* synthetic */ void zza(zzin zzin2, zzik zzik2, zzik zzik3, long l, boolean bl, Bundle bundle) {
        zzin2.zza(zzik2, zzik3, l, bl, null);
    }

    static /* synthetic */ zzik zza(zzin zzin2) {
        return zzin2.zzh;
    }

    static /* synthetic */ void zza(zzin zzin2, zzik zzik2, boolean bl, long l) {
        zzin2.zza(zzik2, false, l);
    }

    static /* synthetic */ zzik zza(zzin zzin2, zzik zzik2) {
        zzin2.zzh = null;
        return null;
    }
}

