/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.RemoteException;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zzag;
import com.google.android.gms.measurement.internal.zzao;
import com.google.android.gms.measurement.internal.zzaq;
import com.google.android.gms.measurement.internal.zzd;
import com.google.android.gms.measurement.internal.zzer;
import com.google.android.gms.measurement.internal.zzg;
import com.google.android.gms.measurement.internal.zzgd;
import com.google.android.gms.measurement.internal.zzgx;
import com.google.android.gms.measurement.internal.zzik;
import com.google.android.gms.measurement.internal.zziu;
import com.google.android.gms.measurement.internal.zziv;
import com.google.android.gms.measurement.internal.zziw;
import com.google.android.gms.measurement.internal.zzix;
import com.google.android.gms.measurement.internal.zziy;
import com.google.android.gms.measurement.internal.zziz;
import com.google.android.gms.measurement.internal.zzja;
import com.google.android.gms.measurement.internal.zzjb;
import com.google.android.gms.measurement.internal.zzjc;
import com.google.android.gms.measurement.internal.zzjd;
import com.google.android.gms.measurement.internal.zzje;
import com.google.android.gms.measurement.internal.zzjf;
import com.google.android.gms.measurement.internal.zzjg;
import com.google.android.gms.measurement.internal.zzjh;
import com.google.android.gms.measurement.internal.zzji;
import com.google.android.gms.measurement.internal.zzjj;
import com.google.android.gms.measurement.internal.zzjk;
import com.google.android.gms.measurement.internal.zzjl;
import com.google.android.gms.measurement.internal.zzjn;
import com.google.android.gms.measurement.internal.zzkh;
import com.google.android.gms.measurement.internal.zzkr;
import com.google.android.gms.measurement.internal.zzn;
import com.google.android.gms.measurement.internal.zzw;
import com.google.android.gms.measurement.internal.zzx;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

@VisibleForTesting
public final class zzis
extends zzg {
    private final zzjn zza;
    private zzer zzb;
    private volatile Boolean zzc;
    private final zzag zzd;
    private final zzkh zze;
    private final List<Runnable> zzf = new ArrayList<Runnable>();
    private final zzag zzg;

    protected zzis(zzgd zzgd2) {
        super(zzgd2);
        this.zze = new zzkh(zzgd2.zzm());
        this.zza = new zzjn(this);
        this.zzd = new zziv(this, zzgd2);
        this.zzg = new zzjf(this, zzgd2);
    }

    @Override
    protected final boolean zzz() {
        return false;
    }

    @WorkerThread
    public final boolean zzab() {
        ((zzgx)this).zzd();
        this.zzw();
        return this.zzb != null;
    }

    @WorkerThread
    protected final void zzac() {
        ((zzgx)this).zzd();
        this.zzw();
        zzn zzn2 = this.zza(true);
        this.zza(new zzje(this, zzn2));
    }

    @WorkerThread
    @VisibleForTesting
    final void zza(zzer zzer2, AbstractSafeParcelable abstractSafeParcelable, zzn zzn2) {
        ((zzgx)this).zzd();
        ((zzgx)this).zzb();
        this.zzw();
        boolean bl = this.zzaj();
        int n = 100;
        for (int i = 0; i < 1001 && n == 100; ++i) {
            List<AbstractSafeParcelable> list;
            ArrayList<AbstractSafeParcelable> arrayList = new ArrayList<AbstractSafeParcelable>();
            n = 0;
            if (bl && (list = ((zzd)this).zzj().zza(100)) != null) {
                arrayList.addAll(list);
                n = list.size();
            }
            if (abstractSafeParcelable != null && n < 100) {
                arrayList.add(abstractSafeParcelable);
            }
            ArrayList<AbstractSafeParcelable> arrayList2 = arrayList;
            int n2 = arrayList2.size();
            int n3 = 0;
            while (n3 < n2) {
                Object e = arrayList2.get(n3);
                ++n3;
                AbstractSafeParcelable abstractSafeParcelable2 = (AbstractSafeParcelable)e;
                if (abstractSafeParcelable2 instanceof zzao) {
                    try {
                        zzer2.zza((zzao)abstractSafeParcelable2, zzn2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzgx)this).zzr().zzf().zza("Failed to send event to the service", (Object)remoteException);
                    }
                    continue;
                }
                if (abstractSafeParcelable2 instanceof zzkr) {
                    try {
                        zzer2.zza((zzkr)abstractSafeParcelable2, zzn2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzgx)this).zzr().zzf().zza("Failed to send user property to the service", (Object)remoteException);
                    }
                    continue;
                }
                if (abstractSafeParcelable2 instanceof zzw) {
                    try {
                        zzer2.zza((zzw)abstractSafeParcelable2, zzn2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzgx)this).zzr().zzf().zza("Failed to send conditional user property to the service", (Object)remoteException);
                    }
                    continue;
                }
                ((zzgx)this).zzr().zzf().zza("Discarding data. Unrecognized parcel type.");
            }
        }
    }

    @WorkerThread
    protected final void zza(zzao zzao2, String string) {
        Preconditions.checkNotNull((Object)((Object)zzao2));
        ((zzgx)this).zzd();
        this.zzw();
        boolean bl = this.zzaj();
        boolean bl2 = bl && ((zzd)this).zzj().zza(zzao2);
        zzn zzn2 = this.zza(true);
        this.zza(new zzjh(this, bl, bl2, zzao2, zzn2, string));
    }

    @WorkerThread
    protected final void zza(zzw zzw2) {
        Preconditions.checkNotNull((Object)((Object)zzw2));
        ((zzgx)this).zzd();
        this.zzw();
        zzx zzx2 = ((zzgx)this).zzu();
        boolean bl = true;
        boolean bl2 = true && ((zzd)this).zzj().zza(zzw2);
        zzw zzw3 = new zzw(zzw2);
        zzn zzn2 = this.zza(true);
        this.zza(new zzjg(this, bl, bl2, zzw3, zzn2, zzw2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzw>> atomicReference, String string, String string2, String string3) {
        ((zzgx)this).zzd();
        this.zzw();
        zzn zzn2 = this.zza(false);
        this.zza(new zzjj(this, atomicReference, string, string2, string3, zzn2));
    }

    @WorkerThread
    protected final void zza(com.google.android.gms.internal.measurement.zzw zzw2, String string, String string2) {
        ((zzgx)this).zzd();
        this.zzw();
        zzn zzn2 = this.zza(false);
        this.zza(new zzji(this, string, string2, zzn2, zzw2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzkr>> atomicReference, String string, String string2, String string3, boolean bl) {
        ((zzgx)this).zzd();
        this.zzw();
        zzn zzn2 = this.zza(false);
        this.zza(new zzjl(this, atomicReference, string, string2, string3, bl, zzn2));
    }

    @WorkerThread
    protected final void zza(com.google.android.gms.internal.measurement.zzw zzw2, String string, String string2, boolean bl) {
        ((zzgx)this).zzd();
        this.zzw();
        zzn zzn2 = this.zza(false);
        this.zza(new zzjk(this, string, string2, bl, zzn2, zzw2));
    }

    @WorkerThread
    protected final void zza(zzkr zzkr2) {
        ((zzgx)this).zzd();
        this.zzw();
        boolean bl = this.zzaj() && ((zzd)this).zzj().zza(zzkr2);
        zzn zzn2 = this.zza(true);
        this.zza(new zziu(this, bl, zzkr2, zzn2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzkr>> atomicReference, boolean bl) {
        ((zzgx)this).zzd();
        this.zzw();
        zzn zzn2 = this.zza(false);
        this.zza(new zzix(this, atomicReference, zzn2, bl));
    }

    @WorkerThread
    protected final void zzad() {
        ((zzgx)this).zzd();
        ((zzgx)this).zzb();
        this.zzw();
        zzn zzn2 = this.zza(false);
        if (this.zzaj()) {
            ((zzd)this).zzj().zzab();
        }
        this.zza(new zziw(this, zzn2));
    }

    private final boolean zzaj() {
        zzx zzx2 = ((zzgx)this).zzu();
        return true;
    }

    @WorkerThread
    public final void zza(AtomicReference<String> atomicReference) {
        ((zzgx)this).zzd();
        this.zzw();
        zzn zzn2 = this.zza(false);
        this.zza(new zziz(this, atomicReference, zzn2));
    }

    @WorkerThread
    public final void zza(com.google.android.gms.internal.measurement.zzw zzw2) {
        ((zzgx)this).zzd();
        this.zzw();
        zzn zzn2 = this.zza(false);
        this.zza(new zziy(this, zzn2, zzw2));
    }

    @WorkerThread
    protected final void zzae() {
        ((zzgx)this).zzd();
        this.zzw();
        zzn zzn2 = this.zza(true);
        ((zzd)this).zzj().zzac();
        this.zza(new zzjb(this, zzn2));
    }

    @WorkerThread
    protected final void zza(zzik zzik2) {
        ((zzgx)this).zzd();
        this.zzw();
        this.zza(new zzja(this, zzik2));
    }

    @WorkerThread
    public final void zza(Bundle bundle) {
        ((zzgx)this).zzd();
        this.zzw();
        zzn zzn2 = this.zza(false);
        this.zza(new zzjd(this, bundle, zzn2));
    }

    @WorkerThread
    private final void zzak() {
        ((zzgx)this).zzd();
        this.zze.zza();
        this.zzd.zza((Long)zzaq.zzai.zza(null));
    }

    @WorkerThread
    final void zzaf() {
        ((zzgx)this).zzd();
        this.zzw();
        if (this.zzab()) {
            return;
        }
        if (this.zzal()) {
            this.zza.zzb();
            return;
        }
        if (!((zzgx)this).zzt().zzy()) {
            Intent intent;
            zzis zzis2 = this;
            zzx zzx2 = ((zzgx)zzis2).zzu();
            PackageManager packageManager = ((zzgx)zzis2).zzn().getPackageManager();
            List list = packageManager.queryIntentServices(intent = new Intent().setClassName(((zzgx)zzis2).zzn(), "com.google.android.gms.measurement.AppMeasurementService"), 65536);
            if (list != null && list.size() > 0) {
                Intent intent2 = new Intent("com.google.android.gms.measurement.START");
                zzx2 = ((zzgx)this).zzu();
                intent2.setComponent(new ComponentName(((zzgx)this).zzn(), "com.google.android.gms.measurement.AppMeasurementService"));
                this.zza.zza(intent2);
                return;
            }
            ((zzgx)this).zzr().zzf().zza("Unable to use remote or local measurement implementation. Please register the AppMeasurementService service in the app manifest");
        }
    }

    final Boolean zzag() {
        return this.zzc;
    }

    @WorkerThread
    private final boolean zzal() {
        ((zzgx)this).zzd();
        this.zzw();
        if (this.zzc == null) {
            boolean bl;
            zzis zzis2 = this;
            ((zzgx)zzis2).zzd();
            zzis2.zzw();
            Boolean bl2 = ((zzgx)zzis2).zzs().zzj();
            if (bl2 != null && bl2.booleanValue()) {
                bl = true;
            } else {
                boolean bl3;
                boolean bl4;
                zzx zzx2 = ((zzgx)zzis2).zzu();
                if (((zzd)zzis2).zzg().zzag() == 1) {
                    bl4 = true;
                    bl3 = true;
                } else {
                    ((zzgx)zzis2).zzr().zzx().zza("Checking service availability");
                    int n = ((zzgx)zzis2).zzp().zza(12451000);
                    switch (n) {
                        case 0: {
                            ((zzgx)zzis2).zzr().zzx().zza("Service available");
                            bl4 = true;
                            bl3 = true;
                            break;
                        }
                        case 1: {
                            ((zzgx)zzis2).zzr().zzx().zza("Service missing");
                            bl4 = false;
                            bl3 = true;
                            break;
                        }
                        case 18: {
                            ((zzgx)zzis2).zzr().zzi().zza("Service updating");
                            bl4 = true;
                            bl3 = true;
                            break;
                        }
                        case 2: {
                            ((zzgx)zzis2).zzr().zzw().zza("Service container out of date");
                            if (((zzgx)zzis2).zzp().zzj() < 17443) {
                                bl4 = false;
                                bl3 = true;
                                break;
                            }
                            bl4 = bl2 == null;
                            bl3 = false;
                            break;
                        }
                        case 3: {
                            ((zzgx)zzis2).zzr().zzi().zza("Service disabled");
                            bl4 = false;
                            bl3 = false;
                            break;
                        }
                        case 9: {
                            ((zzgx)zzis2).zzr().zzi().zza("Service invalid");
                            bl4 = false;
                            bl3 = false;
                            break;
                        }
                        default: {
                            ((zzgx)zzis2).zzr().zzi().zza("Unexpected service status", n);
                            bl4 = false;
                            bl3 = false;
                        }
                    }
                }
                if (!bl4 && ((zzgx)zzis2).zzt().zzy()) {
                    ((zzgx)zzis2).zzr().zzf().zza("No way to upload. Consider using the full version of Analytics");
                    bl3 = false;
                }
                if (bl3) {
                    ((zzgx)zzis2).zzs().zza(bl4);
                }
                bl = bl4;
            }
            this.zzc = bl;
        }
        return this.zzc;
    }

    @WorkerThread
    @VisibleForTesting
    protected final void zza(zzer zzer2) {
        ((zzgx)this).zzd();
        Preconditions.checkNotNull((Object)zzer2);
        this.zzb = zzer2;
        this.zzak();
        this.zzan();
    }

    @WorkerThread
    public final void zzah() {
        ((zzgx)this).zzd();
        this.zzw();
        this.zza.zza();
        try {
            ConnectionTracker.getInstance().unbindService(((zzgx)this).zzn(), (ServiceConnection)this.zza);
        }
        catch (IllegalArgumentException | IllegalStateException runtimeException) {}
        this.zzb = null;
    }

    @WorkerThread
    private final void zza(ComponentName componentName) {
        ((zzgx)this).zzd();
        if (this.zzb != null) {
            this.zzb = null;
            ((zzgx)this).zzr().zzx().zza("Disconnected from device MeasurementService", componentName);
            zzis zzis2 = this;
            ((zzgx)zzis2).zzd();
            zzis2.zzaf();
        }
    }

    @WorkerThread
    private final void zzam() {
        ((zzgx)this).zzd();
        if (!this.zzab()) {
            return;
        }
        ((zzgx)this).zzr().zzx().zza("Inactivity, disconnecting from the service");
        this.zzah();
    }

    @WorkerThread
    private final void zza(Runnable runnable) throws IllegalStateException {
        ((zzgx)this).zzd();
        if (this.zzab()) {
            runnable.run();
            return;
        }
        if ((long)this.zzf.size() >= 1000L) {
            ((zzgx)this).zzr().zzf().zza("Discarding data. Max runnable queue size reached");
            return;
        }
        this.zzf.add(runnable);
        this.zzg.zza(60000L);
        this.zzaf();
    }

    @WorkerThread
    private final void zzan() {
        ((zzgx)this).zzd();
        ((zzgx)this).zzr().zzx().zza("Processing queued up service tasks", this.zzf.size());
        for (Runnable runnable : this.zzf) {
            try {
                runnable.run();
            }
            catch (Exception exception) {
                ((zzgx)this).zzr().zzf().zza("Task exception while flushing queue", exception);
            }
        }
        this.zzf.clear();
        this.zzg.zzc();
    }

    @WorkerThread
    @Nullable
    private final zzn zza(boolean bl) {
        zzx zzx2 = ((zzgx)this).zzu();
        return ((zzd)this).zzg().zza(bl ? ((zzgx)this).zzr().zzy() : null);
    }

    @WorkerThread
    public final void zza(com.google.android.gms.internal.measurement.zzw zzw2, zzao zzao2, String string) {
        ((zzgx)this).zzd();
        this.zzw();
        int n = ((zzgx)this).zzp().zza(12451000);
        if (n != 0) {
            ((zzgx)this).zzr().zzi().zza("Not bundling data. Service unavailable or out of date");
            ((zzgx)this).zzp().zza(zzw2, new byte[0]);
            return;
        }
        this.zza(new zzjc(this, zzao2, string, zzw2));
    }

    @WorkerThread
    final boolean zzai() {
        ((zzgx)this).zzd();
        this.zzw();
        if (!this.zzal()) {
            return true;
        }
        return ((zzgx)this).zzp().zzj() >= 200900;
    }

    static /* synthetic */ zzjn zza(zzis zzis2) {
        return zzis2.zza;
    }

    static /* synthetic */ void zza(zzis zzis2, ComponentName componentName) {
        zzis2.zza(componentName);
    }

    static /* synthetic */ zzer zza(zzis zzis2, zzer zzer2) {
        zzis2.zzb = null;
        return null;
    }

    static /* synthetic */ void zzb(zzis zzis2) {
        zzis2.zzan();
    }

    static /* synthetic */ void zzc(zzis zzis2) {
        zzis2.zzam();
    }

    static /* synthetic */ zzer zzd(zzis zzis2) {
        return zzis2.zzb;
    }

    static /* synthetic */ void zze(zzis zzis2) {
        zzis2.zzak();
    }
}

