/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.RemoteException;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.internal.BaseGmsClient;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zzer;
import com.google.android.gms.measurement.internal.zzet;
import com.google.android.gms.measurement.internal.zzew;
import com.google.android.gms.measurement.internal.zzez;
import com.google.android.gms.measurement.internal.zzgx;
import com.google.android.gms.measurement.internal.zzis;
import com.google.android.gms.measurement.internal.zzjm;
import com.google.android.gms.measurement.internal.zzjo;
import com.google.android.gms.measurement.internal.zzjp;
import com.google.android.gms.measurement.internal.zzjq;
import com.google.android.gms.measurement.internal.zzjr;

@VisibleForTesting
public final class zzjn
implements ServiceConnection,
BaseGmsClient.BaseConnectionCallbacks,
BaseGmsClient.BaseOnConnectionFailedListener {
    private volatile boolean zzb;
    private volatile zzew zzc;
    final /* synthetic */ zzis zza;

    protected zzjn(zzis zzis2) {
        this.zza = zzis2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zza(Intent intent) {
        ((zzgx)this.zza).zzd();
        Context context = ((zzgx)this.zza).zzn();
        ConnectionTracker connectionTracker = ConnectionTracker.getInstance();
        zzjn zzjn2 = this;
        synchronized (zzjn2) {
            if (this.zzb) {
                ((zzgx)this.zza).zzr().zzx().zza("Connection attempt already in progress");
                return;
            }
            ((zzgx)this.zza).zzr().zzx().zza("Using local app measurement service");
            this.zzb = true;
            connectionTracker.bindService(context, intent, (ServiceConnection)zzis.zza(this.zza), 129);
            return;
        }
    }

    @WorkerThread
    public final void zza() {
        if (this.zzc != null && (this.zzc.isConnected() || this.zzc.isConnecting())) {
            this.zzc.disconnect();
        }
        this.zzc = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onServiceConnected");
        zzjn zzjn2 = this;
        synchronized (zzjn2) {
            String string;
            if (iBinder == null) {
                this.zzb = false;
                ((zzgx)this.zza).zzr().zzf().zza("Service connected with null binder");
                return;
            }
            zzer zzer2 = null;
            try {
                string = iBinder.getInterfaceDescriptor();
                if ("com.google.android.gms.measurement.internal.IMeasurementService".equals(string)) {
                    IInterface iInterface;
                    IBinder iBinder2 = iBinder;
                    zzer2 = iBinder2 == null ? null : ((iInterface = iBinder2.queryLocalInterface("com.google.android.gms.measurement.internal.IMeasurementService")) instanceof zzer ? (zzer)iInterface : new zzet(iBinder2));
                    ((zzgx)this.zza).zzr().zzx().zza("Bound to IMeasurementService interface");
                } else {
                    ((zzgx)this.zza).zzr().zzf().zza("Got binder with a wrong descriptor", string);
                }
            }
            catch (RemoteException remoteException) {
                ((zzgx)this.zza).zzr().zzf().zza("Service connect failed to get IMeasurementService");
            }
            if (zzer2 == null) {
                this.zzb = false;
                try {
                    ConnectionTracker.getInstance().unbindService(((zzgx)this.zza).zzn(), (ServiceConnection)zzis.zza(this.zza));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            } else {
                string = zzer2;
                ((zzgx)this.zza).zzq().zza(new zzjm(this, (zzer)((Object)string)));
            }
            return;
        }
    }

    @MainThread
    public final void onServiceDisconnected(ComponentName componentName) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onServiceDisconnected");
        ((zzgx)this.zza).zzr().zzw().zza("Service disconnected");
        ((zzgx)this.zza).zzq().zza(new zzjp(this, componentName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zzb() {
        ((zzgx)this.zza).zzd();
        Context context = ((zzgx)this.zza).zzn();
        zzjn zzjn2 = this;
        synchronized (zzjn2) {
            if (this.zzb) {
                ((zzgx)this.zza).zzr().zzx().zza("Connection attempt already in progress");
                return;
            }
            if (this.zzc != null && (this.zzc.isConnecting() || this.zzc.isConnected())) {
                ((zzgx)this.zza).zzr().zzx().zza("Already awaiting connection attempt");
                return;
            }
            this.zzc = new zzew(context, Looper.getMainLooper(), this, this);
            ((zzgx)this.zza).zzr().zzx().zza("Connecting to remote service");
            this.zzb = true;
            this.zzc.checkAvailabilityAndConnect();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onConnected(@Nullable Bundle bundle) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnected");
        zzjn zzjn2 = this;
        synchronized (zzjn2) {
            try {
                zzer zzer2 = (zzer)this.zzc.getService();
                ((zzgx)this.zza).zzq().zza(new zzjo(this, zzer2));
            }
            catch (DeadObjectException | IllegalStateException throwable) {
                this.zzc = null;
                this.zzb = false;
            }
            return;
        }
    }

    @MainThread
    public final void onConnectionSuspended(int n) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnectionSuspended");
        ((zzgx)this.zza).zzr().zzw().zza("Service connection suspended");
        ((zzgx)this.zza).zzq().zza(new zzjr(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnectionFailed");
        zzez zzez2 = this.zza.zzy.zzd();
        if (zzez2 != null) {
            zzez2.zzi().zza("Service connection failed", connectionResult);
        }
        zzjn zzjn2 = this;
        synchronized (zzjn2) {
            this.zzb = false;
            this.zzc = null;
        }
        ((zzgx)this.zza).zzq().zza(new zzjq(this));
    }

    static /* synthetic */ boolean zza(zzjn zzjn2, boolean bl) {
        zzjn2.zzb = false;
        return false;
    }
}

