/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Size;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.ProcessUtils;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzmd;
import com.google.android.gms.internal.measurement.zzoe;
import com.google.android.gms.internal.measurement.zzor;
import com.google.android.gms.measurement.internal.zzaa;
import com.google.android.gms.measurement.internal.zzab;
import com.google.android.gms.measurement.internal.zzaq;
import com.google.android.gms.measurement.internal.zzeo;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzgd;
import com.google.android.gms.measurement.internal.zzgx;
import com.google.android.gms.measurement.internal.zzx;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;

public final class zzy
extends zzgx {
    private Boolean zza;
    @NonNull
    private zzaa zzb = zzab.zza;
    private Boolean zzc;

    zzy(zzgd zzgd2) {
        super(zzgd2);
    }

    final void zza(@NonNull zzaa zzaa2) {
        this.zzb = zzaa2;
    }

    public final int zze() {
        if (zzmd.zzb()) {
            zzeo<Boolean> zzeo2;
            zzeo<Boolean> zzeo3 = zzeo2 = zzaq.zzck;
            if (((zzgx)this).zzt().zzd(null, zzeo3)) {
                if (((zzgx)this).zzp().zzj() >= 201500) {
                    return 100;
                }
                return 25;
            }
        }
        return 25;
    }

    public final int zza(@Size(min=1L) String string) {
        return this.zza(string, zzaq.zzah, 25, 100);
    }

    final int zzb(@Size(min=1L) String string) {
        zzeo<Boolean> zzeo2;
        zzeo<Boolean> zzeo3;
        if (zzmd.zzb() && this.zzd(null, zzeo3 = (zzeo2 = zzaq.zzcj))) {
            return this.zza(string, zzaq.zzag, 500, 2000);
        }
        return 500;
    }

    @WorkerThread
    public final int zzc(@Size(min=1L) String string) {
        return this.zzb(string, zzaq.zzn);
    }

    final int zzd(@Size(min=1L) String string) {
        zzeo<Boolean> zzeo2;
        zzeo<Boolean> zzeo3;
        if (zzmd.zzb() && this.zzd(null, zzeo3 = (zzeo2 = zzaq.zzcj))) {
            return this.zza(string, zzaq.zzaf, 25, 100);
        }
        return 25;
    }

    public final long zzf() {
        zzx zzx2 = ((zzgx)this).zzu();
        return 31000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zzg() {
        if (this.zzc == null) {
            zzy zzy2 = this;
            synchronized (zzy2) {
                if (this.zzc == null) {
                    ApplicationInfo applicationInfo = ((zzgx)this).zzn().getApplicationInfo();
                    String string = ProcessUtils.getMyProcessName();
                    if (applicationInfo != null) {
                        String string2 = applicationInfo.processName;
                        this.zzc = string2 != null && string2.equals(string);
                    }
                    if (this.zzc == null) {
                        this.zzc = Boolean.TRUE;
                        ((zzgx)this).zzr().zzf().zza("My process not in the list of running processes");
                    }
                }
            }
        }
        return this.zzc;
    }

    @WorkerThread
    public final long zza(String string, @NonNull zzeo<Long> zzeo2) {
        if (string == null) {
            return zzeo2.zza(null);
        }
        String string2 = this.zzb.zza(string, zzeo2.zza());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zzeo2.zza(null);
        }
        try {
            long l = Long.parseLong(string2);
            return zzeo2.zza(l);
        }
        catch (NumberFormatException numberFormatException) {
            return zzeo2.zza(null);
        }
    }

    @WorkerThread
    public final int zzb(String string, @NonNull zzeo<Integer> zzeo2) {
        if (string == null) {
            return zzeo2.zza(null);
        }
        String string2 = this.zzb.zza(string, zzeo2.zza());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zzeo2.zza(null);
        }
        try {
            int n = Integer.parseInt(string2);
            return zzeo2.zza(n);
        }
        catch (NumberFormatException numberFormatException) {
            return zzeo2.zza(null);
        }
    }

    @WorkerThread
    private final int zza(String string, @NonNull zzeo<Integer> zzeo2, int n, int n2) {
        return Math.max(Math.min(this.zzb(string, zzeo2), n2), n);
    }

    @WorkerThread
    public final double zzc(String string, @NonNull zzeo<Double> zzeo2) {
        if (string == null) {
            return zzeo2.zza(null);
        }
        String string2 = this.zzb.zza(string, zzeo2.zza());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zzeo2.zza(null);
        }
        try {
            double d = Double.parseDouble(string2);
            return zzeo2.zza(d);
        }
        catch (NumberFormatException numberFormatException) {
            return zzeo2.zza(null);
        }
    }

    @WorkerThread
    public final boolean zzd(String string, @NonNull zzeo<Boolean> zzeo2) {
        if (string == null) {
            return zzeo2.zza(null);
        }
        String string2 = this.zzb.zza(string, zzeo2.zza());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zzeo2.zza(null);
        }
        boolean bl = Boolean.parseBoolean(string2);
        return zzeo2.zza(bl);
    }

    public final boolean zze(String string, zzeo<Boolean> zzeo2) {
        return this.zzd(string, zzeo2);
    }

    public final boolean zza(zzeo<Boolean> zzeo2) {
        zzeo<Boolean> zzeo3 = zzeo2;
        return this.zzd(null, zzeo3);
    }

    @Nullable
    @VisibleForTesting
    private final Bundle zzz() {
        try {
            if (((zzgx)this).zzn().getPackageManager() == null) {
                ((zzgx)this).zzr().zzf().zza("Failed to load metadata: PackageManager is null");
                return null;
            }
            ApplicationInfo applicationInfo = Wrappers.packageManager((Context)((zzgx)this).zzn()).getApplicationInfo(((zzgx)this).zzn().getPackageName(), 128);
            if (applicationInfo == null) {
                ((zzgx)this).zzr().zzf().zza("Failed to load metadata: ApplicationInfo is null");
                return null;
            }
            return applicationInfo.metaData;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            ((zzgx)this).zzr().zzf().zza("Failed to load metadata: Package name not found", (Object)nameNotFoundException);
            return null;
        }
    }

    @Nullable
    @VisibleForTesting
    final Boolean zze(@Size(min=1L) String string) {
        Preconditions.checkNotEmpty((String)string);
        Bundle bundle = this.zzz();
        if (bundle == null) {
            ((zzgx)this).zzr().zzf().zza("Failed to load metadata: Metadata bundle is null");
            return null;
        }
        if (!bundle.containsKey(string)) {
            return null;
        }
        return bundle.getBoolean(string);
    }

    @Nullable
    @VisibleForTesting
    final List<String> zzf(@Size(min=1L) String string) {
        Integer n;
        Integer n2;
        String string2 = string;
        zzy zzy2 = this;
        Preconditions.checkNotEmpty((String)string2);
        Bundle bundle = zzy2.zzz();
        if (bundle == null) {
            ((zzgx)zzy2).zzr().zzf().zza("Failed to load metadata: Metadata bundle is null");
            n2 = null;
        } else {
            n2 = n = !bundle.containsKey(string2) ? null : Integer.valueOf(bundle.getInt(string2));
        }
        if (n2 == null) {
            return null;
        }
        try {
            String[] stringArray = ((zzgx)this).zzn().getResources().getStringArray(n.intValue());
            if (stringArray == null) {
                return null;
            }
            return Arrays.asList(stringArray);
        }
        catch (Resources.NotFoundException notFoundException) {
            ((zzgx)this).zzr().zzf().zza("Failed to load string array from metadata: resource not found", (Object)notFoundException);
            return null;
        }
    }

    public final boolean zzh() {
        zzx zzx2 = ((zzgx)this).zzu();
        Boolean bl = this.zze("firebase_analytics_collection_deactivated");
        return bl != null && bl != false;
    }

    public final Boolean zzi() {
        ((zzgx)this).zzb();
        Boolean bl = this.zze("google_analytics_adid_collection_enabled");
        return bl == null || bl != false;
    }

    public final Boolean zzj() {
        ((zzgx)this).zzb();
        if (!zzor.zzb() || !this.zza(zzaq.zzcb)) {
            return true;
        }
        Boolean bl = this.zze("google_analytics_automatic_screen_reporting_enabled");
        return bl == null || bl != false;
    }

    public static long zzk() {
        return zzaq.zzac.zza(null);
    }

    public final String zza(zzf zzf2) {
        String string;
        Uri.Builder builder;
        block2: {
            block3: {
                builder = new Uri.Builder();
                string = zzf2.zze();
                if (!TextUtils.isEmpty((CharSequence)string)) break block2;
                if (!zzoe.zzb()) break block3;
                zzeo<Boolean> zzeo2 = zzaq.zzbn;
                String string2 = zzf2.zzc();
                if (((zzgx)this).zzt().zzd(string2, zzeo2) && !TextUtils.isEmpty((CharSequence)(string = zzf2.zzg()))) break block2;
            }
            string = zzf2.zzf();
        }
        String string3 = String.valueOf(string);
        builder.scheme((String)zzaq.zzd.zza(null)).encodedAuthority((String)zzaq.zze.zza(null)).path(string3.length() != 0 ? "config/app/".concat(string3) : new String("config/app/")).appendQueryParameter("app_instance_id", zzf2.zzd()).appendQueryParameter("platform", "android").appendQueryParameter("gmp_version", String.valueOf(this.zzf()));
        return builder.build().toString();
    }

    public static long zzv() {
        return zzaq.zzc.zza(null);
    }

    public final String zzw() {
        return this.zza("debug.firebase.analytics.app", "");
    }

    public final String zzx() {
        return this.zza("debug.deferred.deeplink", "");
    }

    private final String zza(String string, String string2) {
        try {
            return (String)Class.forName("android.os.SystemProperties").getMethod("get", String.class, String.class).invoke(null, string, string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            ((zzgx)this).zzr().zzf().zza("Could not find SystemProperties class", classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            ((zzgx)this).zzr().zzf().zza("Could not find SystemProperties.get() method", noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            ((zzgx)this).zzr().zzf().zza("Could not access SystemProperties.get()", illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            ((zzgx)this).zzr().zzf().zza("SystemProperties.get() threw an exception", invocationTargetException);
        }
        return string2;
    }

    public final boolean zzg(String string) {
        return "1".equals(this.zzb.zza(string, "gaia_collection_enabled"));
    }

    public final boolean zzh(String string) {
        return "1".equals(this.zzb.zza(string, "measurement.event_sampling_enabled"));
    }

    @WorkerThread
    final boolean zzi(String string) {
        return this.zzd(string, zzaq.zzaj);
    }

    @WorkerThread
    final String zzj(String string) {
        zzeo<String> zzeo2 = zzaq.zzak;
        String string2 = string;
        zzy zzy2 = this;
        if (string2 == null) {
            return zzeo2.zza(null);
        }
        return zzeo2.zza(zzy2.zzb.zza(string2, zzeo2.zza()));
    }

    @WorkerThread
    final boolean zzy() {
        if (this.zza == null) {
            this.zza = this.zze("app_measurement_lite");
            if (this.zza == null) {
                this.zza = false;
            }
        }
        return this.zza != false || !this.zzy.zzt();
    }
}

