/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.text.TextUtils;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zzaq;
import com.google.android.gms.measurement.internal.zzfm;
import com.google.android.gms.measurement.internal.zzfn;
import com.google.android.gms.measurement.internal.zzfo;
import com.google.android.gms.measurement.internal.zzfp;
import com.google.android.gms.measurement.internal.zzfr;
import com.google.android.gms.measurement.internal.zzgd;
import com.google.android.gms.measurement.internal.zzgw;
import com.google.android.gms.measurement.internal.zzkw;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Locale;

final class zzfl
extends zzgw {
    @VisibleForTesting
    static final Pair<String, Long> zza = new Pair((Object)"", (Object)0L);
    private SharedPreferences zzz;
    public zzfo zzb;
    public final zzfp zzc = new zzfp(this, "last_upload", 0L);
    public final zzfp zzd = new zzfp(this, "last_upload_attempt", 0L);
    public final zzfp zze = new zzfp(this, "backoff", 0L);
    public final zzfp zzf = new zzfp(this, "last_delete_stale", 0L);
    public final zzfp zzg;
    public final zzfp zzh;
    public final zzfp zzi;
    public final zzfr zzj;
    private String zzaa;
    private boolean zzab;
    private long zzac;
    public final zzfp zzk = new zzfp(this, "time_before_start", 10000L);
    public final zzfp zzl = new zzfp(this, "session_timeout", 1800000L);
    public final zzfn zzm = new zzfn(this, "start_new_session", true);
    public final zzfr zzn;
    public final zzfn zzo;
    public final zzfp zzp = new zzfp(this, "last_pause_time", 0L);
    public boolean zzq;
    public zzfn zzr;
    public zzfn zzs;
    public zzfp zzt;
    public final zzfr zzu;
    public final zzfr zzv;
    public final zzfp zzw;
    public final zzfm zzx;

    @WorkerThread
    @NonNull
    final Pair<String, Boolean> zza(String string) {
        this.zzd();
        long l = this.zzm().elapsedRealtime();
        if (this.zzaa != null && l < this.zzac) {
            return new Pair((Object)this.zzaa, (Object)this.zzab);
        }
        String string2 = string;
        this.zzac = l + this.zzt().zza(string2, zzaq.zza);
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)true);
        try {
            AdvertisingIdClient.Info info = AdvertisingIdClient.getAdvertisingIdInfo((Context)this.zzn());
            if (info != null) {
                this.zzaa = info.getId();
                this.zzab = info.isLimitAdTrackingEnabled();
            }
            if (this.zzaa == null) {
                this.zzaa = "";
            }
        }
        catch (Exception exception) {
            this.zzr().zzw().zza("Unable to get advertising id", exception);
            this.zzaa = "";
        }
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)false);
        return new Pair((Object)this.zzaa, (Object)this.zzab);
    }

    @WorkerThread
    final String zzb(String string) {
        this.zzd();
        String string2 = (String)this.zza((String)string).first;
        MessageDigest messageDigest = zzkw.zzi();
        if (messageDigest == null) {
            return null;
        }
        return String.format(Locale.US, "%032X", new BigInteger(1, messageDigest.digest(string2.getBytes())));
    }

    zzfl(zzgd zzgd2) {
        super(zzgd2);
        this.zzn = new zzfr(this, "non_personalized_ads", null);
        this.zzo = new zzfn(this, "allow_remote_dynamite", false);
        this.zzg = new zzfp(this, "midnight_offset", 0L);
        this.zzh = new zzfp(this, "first_open_time", 0L);
        this.zzi = new zzfp(this, "app_install_time", 0L);
        this.zzj = new zzfr(this, "app_instance_id", null);
        this.zzr = new zzfn(this, "app_backgrounded", false);
        this.zzs = new zzfn(this, "deep_link_retrieval_complete", false);
        this.zzt = new zzfp(this, "deep_link_retrieval_attempts", 0L);
        this.zzu = new zzfr(this, "firebase_feature_rollouts", null);
        this.zzv = new zzfr(this, "deferred_attribution_cache", null);
        this.zzw = new zzfp(this, "deferred_attribution_cache_timestamp", 0L);
        this.zzx = new zzfm(this, "default_event_parameters", null);
    }

    @Override
    protected final boolean zze() {
        return true;
    }

    @Override
    @WorkerThread
    protected final void f_() {
        this.zzz = this.zzn().getSharedPreferences("com.google.android.gms.measurement.prefs", 0);
        this.zzq = this.zzz.getBoolean("has_been_opened", false);
        if (!this.zzq) {
            SharedPreferences.Editor editor = this.zzz.edit();
            editor.putBoolean("has_been_opened", true);
            editor.apply();
        }
        this.zzb = new zzfo(this, "health_monitor", Math.max(0L, (Long)zzaq.zzb.zza(null)), null);
    }

    @WorkerThread
    @VisibleForTesting
    protected final SharedPreferences zzg() {
        this.zzd();
        this.zzaa();
        return this.zzz;
    }

    @WorkerThread
    final void zzc(String string) {
        this.zzd();
        SharedPreferences.Editor editor = this.zzg().edit();
        editor.putString("gmp_app_id", string);
        editor.apply();
    }

    @WorkerThread
    final String zzh() {
        this.zzd();
        return this.zzg().getString("gmp_app_id", null);
    }

    @WorkerThread
    final void zzd(String string) {
        this.zzd();
        SharedPreferences.Editor editor = this.zzg().edit();
        editor.putString("admob_app_id", string);
        editor.apply();
    }

    @WorkerThread
    final String zzi() {
        this.zzd();
        return this.zzg().getString("admob_app_id", null);
    }

    @WorkerThread
    final Boolean zzj() {
        this.zzd();
        if (!this.zzg().contains("use_service")) {
            return null;
        }
        return this.zzg().getBoolean("use_service", false);
    }

    @WorkerThread
    final void zza(boolean bl) {
        this.zzd();
        SharedPreferences.Editor editor = this.zzg().edit();
        editor.putBoolean("use_service", bl);
        editor.apply();
    }

    @WorkerThread
    final void zzk() {
        this.zzd();
        Boolean bl = this.zzv();
        SharedPreferences.Editor editor = this.zzg().edit();
        editor.clear();
        editor.apply();
        if (bl != null) {
            this.zzb(bl);
        }
    }

    @WorkerThread
    final void zzb(boolean bl) {
        this.zzd();
        SharedPreferences.Editor editor = this.zzg().edit();
        editor.putBoolean("measurement_enabled", bl);
        editor.apply();
    }

    @WorkerThread
    final Boolean zzv() {
        this.zzd();
        if (this.zzg().contains("measurement_enabled")) {
            return this.zzg().getBoolean("measurement_enabled", true);
        }
        return null;
    }

    @WorkerThread
    protected final String zzw() {
        this.zzd();
        String string = this.zzg().getString("previous_os_version", null);
        this.zzl().zzaa();
        String string2 = Build.VERSION.RELEASE;
        if (!TextUtils.isEmpty((CharSequence)string2) && !string2.equals(string)) {
            SharedPreferences.Editor editor = this.zzg().edit();
            editor.putString("previous_os_version", string2);
            editor.apply();
        }
        return string;
    }

    @WorkerThread
    final void zzc(boolean bl) {
        this.zzd();
        this.zzr().zzx().zza("App measurement setting deferred collection", bl);
        SharedPreferences.Editor editor = this.zzg().edit();
        editor.putBoolean("deferred_analytics_collection", bl);
        editor.apply();
    }

    @WorkerThread
    final boolean zzx() {
        return this.zzz.contains("deferred_analytics_collection");
    }

    final boolean zza(long l) {
        return l - this.zzl.zza() > this.zzp.zza();
    }
}

