/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.RemoteException;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.internal.BaseGmsClient;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zzep;
import com.google.android.gms.measurement.internal.zzer;
import com.google.android.gms.measurement.internal.zzeu;
import com.google.android.gms.measurement.internal.zzex;
import com.google.android.gms.measurement.internal.zzgu;
import com.google.android.gms.measurement.internal.zziv;
import com.google.android.gms.measurement.internal.zzjo;
import com.google.android.gms.measurement.internal.zzjq;
import com.google.android.gms.measurement.internal.zzjr;
import com.google.android.gms.measurement.internal.zzjs;
import com.google.android.gms.measurement.internal.zzjt;

@VisibleForTesting
public final class zzjp
implements ServiceConnection,
BaseGmsClient.BaseConnectionCallbacks,
BaseGmsClient.BaseOnConnectionFailedListener {
    private volatile boolean zzb;
    private volatile zzeu zzc;
    final /* synthetic */ zziv zza;

    protected zzjp(zziv zziv2) {
        this.zza = zziv2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zza(Intent intent) {
        ((zzgu)this.zza).zzc();
        Context context = ((zzgu)this.zza).zzm();
        ConnectionTracker connectionTracker = ConnectionTracker.getInstance();
        zzjp zzjp2 = this;
        synchronized (zzjp2) {
            if (this.zzb) {
                ((zzgu)this.zza).zzq().zzw().zza("Connection attempt already in progress");
                return;
            }
            ((zzgu)this.zza).zzq().zzw().zza("Using local app measurement service");
            this.zzb = true;
            connectionTracker.bindService(context, intent, (ServiceConnection)zziv.zza(this.zza), 129);
            return;
        }
    }

    @WorkerThread
    public final void zza() {
        if (this.zzc != null && (this.zzc.isConnected() || this.zzc.isConnecting())) {
            this.zzc.disconnect();
        }
        this.zzc = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onServiceConnected");
        zzjp zzjp2 = this;
        synchronized (zzjp2) {
            String string;
            if (iBinder == null) {
                this.zzb = false;
                ((zzgu)this.zza).zzq().zze().zza("Service connected with null binder");
                return;
            }
            zzep zzep2 = null;
            try {
                string = iBinder.getInterfaceDescriptor();
                if ("com.google.android.gms.measurement.internal.IMeasurementService".equals(string)) {
                    IInterface iInterface;
                    IBinder iBinder2 = iBinder;
                    zzep2 = iBinder2 == null ? null : ((iInterface = iBinder2.queryLocalInterface("com.google.android.gms.measurement.internal.IMeasurementService")) instanceof zzep ? (zzep)iInterface : new zzer(iBinder2));
                    ((zzgu)this.zza).zzq().zzw().zza("Bound to IMeasurementService interface");
                } else {
                    ((zzgu)this.zza).zzq().zze().zza("Got binder with a wrong descriptor", string);
                }
            }
            catch (RemoteException remoteException) {
                ((zzgu)this.zza).zzq().zze().zza("Service connect failed to get IMeasurementService");
            }
            if (zzep2 == null) {
                this.zzb = false;
                try {
                    ConnectionTracker.getInstance().unbindService(((zzgu)this.zza).zzm(), (ServiceConnection)zziv.zza(this.zza));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            } else {
                string = zzep2;
                ((zzgu)this.zza).zzp().zza(new zzjo(this, (zzep)((Object)string)));
            }
            return;
        }
    }

    @MainThread
    public final void onServiceDisconnected(ComponentName componentName) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onServiceDisconnected");
        ((zzgu)this.zza).zzq().zzv().zza("Service disconnected");
        ((zzgu)this.zza).zzp().zza(new zzjr(this, componentName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zzb() {
        ((zzgu)this.zza).zzc();
        Context context = ((zzgu)this.zza).zzm();
        zzjp zzjp2 = this;
        synchronized (zzjp2) {
            if (this.zzb) {
                ((zzgu)this.zza).zzq().zzw().zza("Connection attempt already in progress");
                return;
            }
            if (this.zzc != null && (this.zzc.isConnecting() || this.zzc.isConnected())) {
                ((zzgu)this.zza).zzq().zzw().zza("Already awaiting connection attempt");
                return;
            }
            this.zzc = new zzeu(context, Looper.getMainLooper(), this, this);
            ((zzgu)this.zza).zzq().zzw().zza("Connecting to remote service");
            this.zzb = true;
            this.zzc.checkAvailabilityAndConnect();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onConnected(@Nullable Bundle bundle) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnected");
        zzjp zzjp2 = this;
        synchronized (zzjp2) {
            try {
                zzep zzep2 = (zzep)this.zzc.getService();
                ((zzgu)this.zza).zzp().zza(new zzjq(this, zzep2));
            }
            catch (DeadObjectException | IllegalStateException throwable) {
                this.zzc = null;
                this.zzb = false;
            }
            return;
        }
    }

    @MainThread
    public final void onConnectionSuspended(int n) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnectionSuspended");
        ((zzgu)this.zza).zzq().zzv().zza("Service connection suspended");
        ((zzgu)this.zza).zzp().zza(new zzjt(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnectionFailed");
        zzex zzex2 = this.zza.zzy.zzc();
        if (zzex2 != null) {
            zzex2.zzh().zza("Service connection failed", connectionResult);
        }
        zzjp zzjp2 = this;
        synchronized (zzjp2) {
            this.zzb = false;
            this.zzc = null;
        }
        ((zzgu)this.zza).zzp().zza(new zzjs(this));
    }

    static /* synthetic */ boolean zza(zzjp zzjp2, boolean bl) {
        zzjp2.zzb = false;
        return false;
    }
}

