/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement;

import android.content.Context;
import android.os.Bundle;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresPermission;
import androidx.annotation.Size;
import androidx.annotation.WorkerThread;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzae;
import com.google.android.gms.measurement.internal.zzfu;
import com.google.android.gms.measurement.internal.zzgs;
import com.google.android.gms.measurement.internal.zzgw;
import com.google.android.gms.measurement.internal.zzgz;
import com.google.android.gms.measurement.internal.zzia;
import com.google.android.gms.measurement.internal.zzig;
import com.google.android.gms.measurement.internal.zzku;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Deprecated
@ShowFirstParty
@KeepForSdk
public class AppMeasurement {
    @ShowFirstParty
    @KeepForSdk
    public static final String CRASH_ORIGIN = "crash";
    @ShowFirstParty
    @KeepForSdk
    public static final String FCM_ORIGIN = "fcm";
    @ShowFirstParty
    @KeepForSdk
    public static final String FIAM_ORIGIN = "fiam";
    private static volatile AppMeasurement zza;
    private final zzfu zzb;
    private final zzia zzc;
    private final boolean zzd;

    @Deprecated
    @ShowFirstParty
    @Keep
    @KeepForSdk
    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE", "android.permission.WAKE_LOCK"})
    public static AppMeasurement getInstance(Context context) {
        return AppMeasurement.zza(context, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    private static AppMeasurement zza(Context context, String string, String string2) {
        if (zza != null) return zza;
        Class<AppMeasurement> clazz = AppMeasurement.class;
        synchronized (AppMeasurement.class) {
            if (zza != null) return zza;
            zzia zzia2 = AppMeasurement.zza(context, null);
            if (zzia2 != null) {
                zza = new AppMeasurement(zzia2);
            } else {
                zzfu zzfu2 = zzfu.zza(context, new zzae(0L, 0L, true, null, null, null, null), null);
                zza = new AppMeasurement(zzfu2);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return zza;
        }
    }

    private static zzia zza(Context context, Bundle bundle) {
        Class<?> clazz;
        try {
            clazz = Class.forName("com.google.firebase.analytics.FirebaseAnalytics");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        try {
            return (zzia)clazz.getDeclaredMethod("getScionFrontendApiImplementation", Context.class, Bundle.class).invoke(null, context, null);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private AppMeasurement(zzfu zzfu2) {
        Preconditions.checkNotNull((Object)zzfu2);
        this.zzb = zzfu2;
        this.zzc = null;
        this.zzd = false;
    }

    private AppMeasurement(zzia zzia2) {
        Preconditions.checkNotNull((Object)zzia2);
        this.zzc = zzia2;
        this.zzb = null;
        this.zzd = true;
    }

    @ShowFirstParty
    @Keep
    public void logEventInternal(String string, String string2, Bundle bundle) {
        if (this.zzd) {
            this.zzc.zza(string, string2, bundle);
            return;
        }
        this.zzb.zzg().zza(string, string2, bundle);
    }

    @ShowFirstParty
    @KeepForSdk
    public void logEventInternalNoInterceptor(String string, String string2, Bundle bundle, long l) {
        if (this.zzd) {
            this.zzc.zza(string, string2, bundle, l);
            return;
        }
        Bundle bundle2 = bundle;
        String string3 = string2;
        this.zzb.zzg().zza(string, string3, bundle2, true, false, l);
    }

    @WorkerThread
    @ShowFirstParty
    @KeepForSdk
    public Map<String, Object> getUserProperties(boolean bl) {
        if (this.zzd) {
            return this.zzc.zza(null, null, bl);
        }
        List<zzku> list = this.zzb.zzg().zza(bl);
        ArrayMap arrayMap = new ArrayMap(list.size());
        for (zzku zzku2 : list) {
            arrayMap.put(zzku2.zza, zzku2.zza());
        }
        return arrayMap;
    }

    @WorkerThread
    @ShowFirstParty
    @KeepForSdk
    public void setEventInterceptor(EventInterceptor eventInterceptor) {
        if (this.zzd) {
            this.zzc.zza((zzgw)eventInterceptor);
            return;
        }
        this.zzb.zzg().zza(eventInterceptor);
    }

    @ShowFirstParty
    @KeepForSdk
    public void registerOnMeasurementEventListener(OnEventListener onEventListener) {
        if (this.zzd) {
            this.zzc.zza((zzgz)onEventListener);
            return;
        }
        this.zzb.zzg().zza(onEventListener);
    }

    @ShowFirstParty
    @KeepForSdk
    public void unregisterOnMeasurementEventListener(OnEventListener onEventListener) {
        if (this.zzd) {
            this.zzc.zzb((zzgz)onEventListener);
            return;
        }
        this.zzb.zzg().zzb(onEventListener);
    }

    @Nullable
    @Keep
    public String getCurrentScreenName() {
        if (this.zzd) {
            return this.zzc.zza();
        }
        return this.zzb.zzg().zzai();
    }

    @Nullable
    @Keep
    public String getCurrentScreenClass() {
        if (this.zzd) {
            return this.zzc.zzb();
        }
        return this.zzb.zzg().zzaj();
    }

    @Nullable
    @Keep
    public String getAppInstanceId() {
        if (this.zzd) {
            return this.zzc.zzc();
        }
        return this.zzb.zzg().zzag();
    }

    @Nullable
    @Keep
    public String getGmpAppId() {
        if (this.zzd) {
            return this.zzc.zzd();
        }
        return this.zzb.zzg().zzak();
    }

    @Keep
    public long generateEventId() {
        if (this.zzd) {
            return this.zzc.zze();
        }
        return this.zzb.zzh().zzf();
    }

    @Keep
    public void beginAdUnitExposure(@NonNull @Size(min=1L) String string) {
        if (this.zzd) {
            this.zzc.zza(string);
            return;
        }
        this.zzb.zzy().zza(string, this.zzb.zzl().elapsedRealtime());
    }

    @Keep
    public void endAdUnitExposure(@NonNull @Size(min=1L) String string) {
        if (this.zzd) {
            this.zzc.zzb(string);
            return;
        }
        this.zzb.zzy().zzb(string, this.zzb.zzl().elapsedRealtime());
    }

    @Keep
    @ShowFirstParty
    @KeepForSdk
    public void setConditionalUserProperty(@NonNull ConditionalUserProperty conditionalUserProperty) {
        Preconditions.checkNotNull((Object)conditionalUserProperty);
        if (this.zzd) {
            this.zzc.zza(conditionalUserProperty.zza());
            return;
        }
        this.zzb.zzg().zza(conditionalUserProperty.zza());
    }

    @Keep
    @ShowFirstParty
    @KeepForSdk
    public void clearConditionalUserProperty(@NonNull @Size(min=1L, max=24L) String string, @Nullable String string2, @Nullable Bundle bundle) {
        if (this.zzd) {
            this.zzc.zzb(string, string2, bundle);
            return;
        }
        this.zzb.zzg().zzc(string, string2, bundle);
    }

    @WorkerThread
    @Keep
    @VisibleForTesting
    protected Map<String, Object> getUserProperties(@Nullable String string, @Nullable @Size(min=1L, max=24L) String string2, boolean bl) {
        if (this.zzd) {
            return this.zzc.zza(string, string2, bl);
        }
        return this.zzb.zzg().zza(string, string2, bl);
    }

    @WorkerThread
    @Keep
    @ShowFirstParty
    @KeepForSdk
    public List<ConditionalUserProperty> getConditionalUserProperties(@Nullable String string, @Nullable @Size(min=1L, max=23L) String string2) {
        ArrayList<Bundle> arrayList = this.zzd ? this.zzc.zza(string, string2) : this.zzb.zzg().zza(string, string2);
        ArrayList<ConditionalUserProperty> arrayList2 = new ArrayList<ConditionalUserProperty>(arrayList == null ? 0 : arrayList.size());
        for (Bundle bundle : arrayList) {
            arrayList2.add(new ConditionalUserProperty(bundle));
        }
        return arrayList2;
    }

    @WorkerThread
    @Keep
    @ShowFirstParty
    @KeepForSdk
    public int getMaxUserProperties(@NonNull @Size(min=1L) String string) {
        if (this.zzd) {
            return this.zzc.zzc(string);
        }
        this.zzb.zzg();
        Preconditions.checkNotEmpty((String)string);
        return 25;
    }

    @KeepForSdk
    public Boolean getBoolean() {
        if (this.zzd) {
            return (Boolean)this.zzc.zza(4);
        }
        return this.zzb.zzg().zzab();
    }

    @KeepForSdk
    public String getString() {
        if (this.zzd) {
            return (String)this.zzc.zza(0);
        }
        return this.zzb.zzg().zzac();
    }

    @KeepForSdk
    public Long getLong() {
        if (this.zzd) {
            return (Long)this.zzc.zza(1);
        }
        return this.zzb.zzg().zzad();
    }

    @KeepForSdk
    public Integer getInteger() {
        if (this.zzd) {
            return (Integer)this.zzc.zza(3);
        }
        return this.zzb.zzg().zzae();
    }

    @KeepForSdk
    public Double getDouble() {
        if (this.zzd) {
            return (Double)this.zzc.zza(2);
        }
        return this.zzb.zzg().zzaf();
    }

    @ShowFirstParty
    @KeepForSdk
    public static class ConditionalUserProperty {
        @Keep
        @ShowFirstParty
        @KeepForSdk
        public String mAppId;
        @Keep
        @ShowFirstParty
        @KeepForSdk
        public String mOrigin;
        @Keep
        @ShowFirstParty
        @KeepForSdk
        public String mName;
        @Keep
        @ShowFirstParty
        @KeepForSdk
        public Object mValue;
        @Keep
        @ShowFirstParty
        @KeepForSdk
        public String mTriggerEventName;
        @Keep
        @ShowFirstParty
        @KeepForSdk
        public long mTriggerTimeout;
        @Keep
        public String mTimedOutEventName;
        @Keep
        public Bundle mTimedOutEventParams;
        @Keep
        public String mTriggeredEventName;
        @Keep
        public Bundle mTriggeredEventParams;
        @Keep
        @ShowFirstParty
        @KeepForSdk
        public long mTimeToLive;
        @Keep
        public String mExpiredEventName;
        @Keep
        public Bundle mExpiredEventParams;
        @Keep
        @ShowFirstParty
        @KeepForSdk
        public long mCreationTimestamp;
        @Keep
        @ShowFirstParty
        @KeepForSdk
        public boolean mActive;
        @Keep
        @ShowFirstParty
        @KeepForSdk
        public long mTriggeredTimestamp;

        @KeepForSdk
        public ConditionalUserProperty() {
        }

        @KeepForSdk
        public ConditionalUserProperty(ConditionalUserProperty conditionalUserProperty) {
            Preconditions.checkNotNull((Object)conditionalUserProperty);
            this.mAppId = conditionalUserProperty.mAppId;
            this.mOrigin = conditionalUserProperty.mOrigin;
            this.mCreationTimestamp = conditionalUserProperty.mCreationTimestamp;
            this.mName = conditionalUserProperty.mName;
            if (conditionalUserProperty.mValue != null) {
                this.mValue = zzig.zza((Object)conditionalUserProperty.mValue);
                if (this.mValue == null) {
                    this.mValue = conditionalUserProperty.mValue;
                }
            }
            this.mActive = conditionalUserProperty.mActive;
            this.mTriggerEventName = conditionalUserProperty.mTriggerEventName;
            this.mTriggerTimeout = conditionalUserProperty.mTriggerTimeout;
            this.mTimedOutEventName = conditionalUserProperty.mTimedOutEventName;
            if (conditionalUserProperty.mTimedOutEventParams != null) {
                this.mTimedOutEventParams = new Bundle(conditionalUserProperty.mTimedOutEventParams);
            }
            this.mTriggeredEventName = conditionalUserProperty.mTriggeredEventName;
            if (conditionalUserProperty.mTriggeredEventParams != null) {
                this.mTriggeredEventParams = new Bundle(conditionalUserProperty.mTriggeredEventParams);
            }
            this.mTriggeredTimestamp = conditionalUserProperty.mTriggeredTimestamp;
            this.mTimeToLive = conditionalUserProperty.mTimeToLive;
            this.mExpiredEventName = conditionalUserProperty.mExpiredEventName;
            if (conditionalUserProperty.mExpiredEventParams != null) {
                this.mExpiredEventParams = new Bundle(conditionalUserProperty.mExpiredEventParams);
            }
        }

        @VisibleForTesting
        ConditionalUserProperty(@NonNull Bundle bundle) {
            Preconditions.checkNotNull((Object)bundle);
            this.mAppId = (String)zzgs.zza((Bundle)bundle, (String)"app_id", String.class, null);
            this.mOrigin = (String)zzgs.zza((Bundle)bundle, (String)"origin", String.class, null);
            this.mName = (String)zzgs.zza((Bundle)bundle, (String)"name", String.class, null);
            this.mValue = zzgs.zza((Bundle)bundle, (String)"value", Object.class, null);
            this.mTriggerEventName = (String)zzgs.zza((Bundle)bundle, (String)"trigger_event_name", String.class, null);
            this.mTriggerTimeout = (Long)zzgs.zza((Bundle)bundle, (String)"trigger_timeout", Long.class, (Object)0L);
            this.mTimedOutEventName = (String)zzgs.zza((Bundle)bundle, (String)"timed_out_event_name", String.class, null);
            this.mTimedOutEventParams = (Bundle)zzgs.zza((Bundle)bundle, (String)"timed_out_event_params", Bundle.class, null);
            this.mTriggeredEventName = (String)zzgs.zza((Bundle)bundle, (String)"triggered_event_name", String.class, null);
            this.mTriggeredEventParams = (Bundle)zzgs.zza((Bundle)bundle, (String)"triggered_event_params", Bundle.class, null);
            this.mTimeToLive = (Long)zzgs.zza((Bundle)bundle, (String)"time_to_live", Long.class, (Object)0L);
            this.mExpiredEventName = (String)zzgs.zza((Bundle)bundle, (String)"expired_event_name", String.class, null);
            this.mExpiredEventParams = (Bundle)zzgs.zza((Bundle)bundle, (String)"expired_event_params", Bundle.class, null);
            this.mActive = (Boolean)zzgs.zza((Bundle)bundle, (String)"active", Boolean.class, (Object)false);
            this.mCreationTimestamp = (Long)zzgs.zza((Bundle)bundle, (String)"creation_timestamp", Long.class, (Object)0L);
            this.mTriggeredTimestamp = (Long)zzgs.zza((Bundle)bundle, (String)"triggered_timestamp", Long.class, (Object)0L);
        }

        @VisibleForTesting
        final Bundle zza() {
            Bundle bundle = new Bundle();
            if (this.mAppId != null) {
                bundle.putString("app_id", this.mAppId);
            }
            if (this.mOrigin != null) {
                bundle.putString("origin", this.mOrigin);
            }
            if (this.mName != null) {
                bundle.putString("name", this.mName);
            }
            if (this.mValue != null) {
                zzgs.zza((Bundle)bundle, (Object)this.mValue);
            }
            if (this.mTriggerEventName != null) {
                bundle.putString("trigger_event_name", this.mTriggerEventName);
            }
            bundle.putLong("trigger_timeout", this.mTriggerTimeout);
            if (this.mTimedOutEventName != null) {
                bundle.putString("timed_out_event_name", this.mTimedOutEventName);
            }
            if (this.mTimedOutEventParams != null) {
                bundle.putBundle("timed_out_event_params", this.mTimedOutEventParams);
            }
            if (this.mTriggeredEventName != null) {
                bundle.putString("triggered_event_name", this.mTriggeredEventName);
            }
            if (this.mTriggeredEventParams != null) {
                bundle.putBundle("triggered_event_params", this.mTriggeredEventParams);
            }
            bundle.putLong("time_to_live", this.mTimeToLive);
            if (this.mExpiredEventName != null) {
                bundle.putString("expired_event_name", this.mExpiredEventName);
            }
            if (this.mExpiredEventParams != null) {
                bundle.putBundle("expired_event_params", this.mExpiredEventParams);
            }
            bundle.putLong("creation_timestamp", this.mCreationTimestamp);
            bundle.putBoolean("active", this.mActive);
            bundle.putLong("triggered_timestamp", this.mTriggeredTimestamp);
            return bundle;
        }
    }

    @ShowFirstParty
    @KeepForSdk
    public static interface OnEventListener
    extends zzgz {
        @WorkerThread
        @ShowFirstParty
        @KeepForSdk
        public void onEvent(String var1, String var2, Bundle var3, long var4);
    }

    @ShowFirstParty
    @KeepForSdk
    public static interface EventInterceptor
    extends zzgw {
        @WorkerThread
        @ShowFirstParty
        @KeepForSdk
        public void interceptEvent(String var1, String var2, Bundle var3, long var4);
    }
}

