/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.os.Bundle;
import androidx.annotation.WorkerThread;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.measurement.internal.zzb;
import com.google.android.gms.measurement.internal.zzc;
import com.google.android.gms.measurement.internal.zzd;
import com.google.android.gms.measurement.internal.zzfu;
import com.google.android.gms.measurement.internal.zzgr;
import com.google.android.gms.measurement.internal.zzii;
import com.google.android.gms.measurement.internal.zzij;
import java.util.Map;

public final class zza
extends zzd {
    private final Map<String, Long> zza;
    private final Map<String, Integer> zzb = new ArrayMap();
    private long zzc;

    public zza(zzfu zzfu2) {
        super(zzfu2);
        this.zza = new ArrayMap();
    }

    public final void zza(String string, long l) {
        if (string == null || string.length() == 0) {
            ((zzgr)this).zzq().zze().zza("Ad unit id must be a non-empty string");
            return;
        }
        ((zzgr)this).zzp().zza(new zzc(this, string, l));
    }

    @WorkerThread
    private final void zzc(String string, long l) {
        Integer n;
        ((zzgr)this).zzc();
        Preconditions.checkNotEmpty((String)string);
        if (this.zzb.isEmpty()) {
            this.zzc = l;
        }
        if ((n = this.zzb.get(string)) != null) {
            this.zzb.put(string, n + 1);
            return;
        }
        if (this.zzb.size() >= 100) {
            ((zzgr)this).zzq().zzh().zza("Too many ads visible");
            return;
        }
        this.zzb.put(string, 1);
        this.zza.put(string, l);
    }

    public final void zzb(String string, long l) {
        if (string == null || string.length() == 0) {
            ((zzgr)this).zzq().zze().zza("Ad unit id must be a non-empty string");
            return;
        }
        ((zzgr)this).zzp().zza(new zzb(this, string, l));
    }

    @WorkerThread
    private final void zzd(String string, long l) {
        ((zzgr)this).zzc();
        Preconditions.checkNotEmpty((String)string);
        Integer n = this.zzb.get(string);
        if (n != null) {
            zzij zzij2 = ((zzd)this).zzh().zza(false);
            int n2 = n - 1;
            if (n2 == 0) {
                this.zzb.remove(string);
                Long l2 = this.zza.get(string);
                if (l2 == null) {
                    ((zzgr)this).zzq().zze().zza("First ad unit exposure time was never set");
                } else {
                    long l3 = l - l2;
                    this.zza.remove(string);
                    this.zza(string, l3, zzij2);
                }
                if (this.zzb.isEmpty()) {
                    if (this.zzc == 0L) {
                        ((zzgr)this).zzq().zze().zza("First ad exposure time was never set");
                        return;
                    }
                    this.zza(l - this.zzc, zzij2);
                    this.zzc = 0L;
                }
                return;
            }
            this.zzb.put(string, n2);
            return;
        }
        ((zzgr)this).zzq().zze().zza("Call to endAdUnitExposure for unknown ad unit id", string);
    }

    @WorkerThread
    private final void zza(long l, zzij zzij2) {
        if (zzij2 == null) {
            ((zzgr)this).zzq().zzw().zza("Not logging ad exposure. No active activity");
            return;
        }
        if (l < 1000L) {
            ((zzgr)this).zzq().zzw().zza("Not logging ad exposure. Less than 1000 ms. exposure", l);
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putLong("_xt", l);
        zzii.zza(zzij2, bundle, true);
        ((zzd)this).zze().zza("am", "_xa", bundle);
    }

    @WorkerThread
    private final void zza(String string, long l, zzij zzij2) {
        if (zzij2 == null) {
            ((zzgr)this).zzq().zzw().zza("Not logging ad unit exposure. No active activity");
            return;
        }
        if (l < 1000L) {
            ((zzgr)this).zzq().zzw().zza("Not logging ad unit exposure. Less than 1000 ms. exposure", l);
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putString("_ai", string);
        bundle.putLong("_xt", l);
        zzii.zza(zzij2, bundle, true);
        ((zzd)this).zze().zza("am", "_xu", bundle);
    }

    @WorkerThread
    public final void zza(long l) {
        zzij zzij2 = ((zzd)this).zzh().zza(false);
        for (String string : this.zza.keySet()) {
            long l2 = this.zza.get(string);
            this.zza(string, l - l2, zzij2);
        }
        if (!this.zza.isEmpty()) {
            this.zza(l - this.zzc, zzij2);
        }
        this.zzb(l);
    }

    @WorkerThread
    private final void zzb(long l) {
        for (String string : this.zza.keySet()) {
            this.zza.put(string, l);
        }
        if (!this.zza.isEmpty()) {
            this.zzc = l;
        }
    }

    static /* synthetic */ void zza(zza zza2, String string, long l) {
        zza2.zzc(string, l);
    }

    static /* synthetic */ void zzb(zza zza2, String string, long l) {
        zza2.zzd(string, l);
    }

    static /* synthetic */ void zza(zza zza2, long l) {
        zza2.zzb(l);
    }
}

