/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.measurement.internal.zzfs;
import com.google.android.gms.measurement.internal.zzft;
import com.google.android.gms.measurement.internal.zzfu;
import com.google.android.gms.measurement.internal.zzfv;
import com.google.android.gms.measurement.internal.zzgq;
import com.google.android.gms.measurement.internal.zzgr;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public final class zzfr
extends zzgq {
    private zzfv zza;
    private zzfv zzb;
    private final PriorityBlockingQueue<zzfs<?>> zzc;
    private final BlockingQueue<zzfs<?>> zzd;
    private final Thread.UncaughtExceptionHandler zze;
    private final Thread.UncaughtExceptionHandler zzf;
    private final Object zzg = new Object();
    private final Semaphore zzh = new Semaphore(2);
    private volatile boolean zzi;
    private static final AtomicLong zzj = new AtomicLong(Long.MIN_VALUE);

    zzfr(zzfu zzfu2) {
        super(zzfu2);
        this.zzc = new PriorityBlockingQueue();
        this.zzd = new LinkedBlockingQueue();
        this.zze = new zzft(this, "Thread death: Uncaught exception on worker thread");
        this.zzf = new zzft(this, "Thread death: Uncaught exception on network thread");
    }

    @Override
    protected final boolean zzd() {
        return false;
    }

    @Override
    public final void zzc() {
        if (Thread.currentThread() != this.zza) {
            throw new IllegalStateException("Call expected from worker thread");
        }
    }

    @Override
    public final void zzb() {
        if (Thread.currentThread() != this.zzb) {
            throw new IllegalStateException("Call expected from network thread");
        }
    }

    public final boolean zzf() {
        return Thread.currentThread() == this.zza;
    }

    public final <V> Future<V> zza(Callable<V> callable) throws IllegalStateException {
        this.zzab();
        Preconditions.checkNotNull(callable);
        zzfs zzfs2 = new zzfs(this, callable, false, "Task exception on worker thread");
        if (Thread.currentThread() == this.zza) {
            if (!this.zzc.isEmpty()) {
                ((zzgr)this).zzq().zzh().zza("Callable skipped the worker queue.");
            }
            zzfs2.run();
        } else {
            this.zza(zzfs2);
        }
        return zzfs2;
    }

    public final <V> Future<V> zzb(Callable<V> callable) throws IllegalStateException {
        this.zzab();
        Preconditions.checkNotNull(callable);
        zzfs zzfs2 = new zzfs(this, callable, true, "Task exception on worker thread");
        if (Thread.currentThread() == this.zza) {
            zzfs2.run();
        } else {
            this.zza(zzfs2);
        }
        return zzfs2;
    }

    public final void zza(Runnable runnable) throws IllegalStateException {
        this.zzab();
        Preconditions.checkNotNull((Object)runnable);
        this.zza(new zzfs(this, runnable, false, "Task exception on worker thread"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final <T> T zza(AtomicReference<T> atomicReference, long l, String string, Runnable runnable) {
        AtomicReference<T> atomicReference2 = atomicReference;
        synchronized (atomicReference2) {
            ((zzgr)this).zzp().zza(runnable);
            try {
                atomicReference.wait(l);
            }
            catch (InterruptedException interruptedException) {
                String string2 = String.valueOf(string);
                ((zzgr)this).zzq().zzh().zza(string2.length() != 0 ? "Interrupted waiting for ".concat(string2) : new String("Interrupted waiting for "));
                return null;
            }
        }
        atomicReference2 = atomicReference.get();
        if (atomicReference2 == null) {
            String string3 = String.valueOf(string);
            ((zzgr)this).zzq().zzh().zza(string3.length() != 0 ? "Timed out waiting for ".concat(string3) : new String("Timed out waiting for "));
        }
        return (T)atomicReference2;
    }

    public final void zzb(Runnable runnable) throws IllegalStateException {
        this.zzab();
        Preconditions.checkNotNull((Object)runnable);
        this.zza(new zzfs(this, runnable, true, "Task exception on worker thread"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zza(zzfs<?> zzfs2) {
        Object object = this.zzg;
        synchronized (object) {
            this.zzc.add(zzfs2);
            if (this.zza == null) {
                this.zza = new zzfv(this, "Measurement Worker", this.zzc);
                this.zza.setUncaughtExceptionHandler(this.zze);
                this.zza.start();
            } else {
                this.zza.zza();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzc(Runnable runnable) throws IllegalStateException {
        this.zzab();
        Preconditions.checkNotNull((Object)runnable);
        zzfs zzfs2 = new zzfs(this, runnable, false, "Task exception on network thread");
        zzfr zzfr2 = this;
        Object object = zzfr2.zzg;
        synchronized (object) {
            zzfr2.zzd.add(zzfs2);
            if (zzfr2.zzb == null) {
                zzfr2.zzb = new zzfv(zzfr2, "Measurement Network", zzfr2.zzd);
                zzfr2.zzb.setUncaughtExceptionHandler(zzfr2.zzf);
                zzfr2.zzb.start();
            } else {
                zzfr2.zzb.zza();
            }
            return;
        }
    }

    static /* synthetic */ Semaphore zza(zzfr zzfr2) {
        return zzfr2.zzh;
    }

    static /* synthetic */ boolean zzb(zzfr zzfr2) {
        return zzfr2.zzi;
    }

    static /* synthetic */ Object zzc(zzfr zzfr2) {
        return zzfr2.zzg;
    }

    static /* synthetic */ zzfv zzd(zzfr zzfr2) {
        return zzfr2.zza;
    }

    static /* synthetic */ zzfv zza(zzfr zzfr2, zzfv zzfv2) {
        zzfr2.zza = null;
        return null;
    }

    static /* synthetic */ zzfv zze(zzfr zzfr2) {
        return zzfr2.zzb;
    }

    static /* synthetic */ zzfv zzb(zzfr zzfr2, zzfv zzfv2) {
        zzfr2.zzb = null;
        return null;
    }

    static /* synthetic */ AtomicLong zzg() {
        return zzj;
    }
}

