/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Activity;
import android.os.Bundle;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Size;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zznk;
import com.google.android.gms.measurement.internal.zza;
import com.google.android.gms.measurement.internal.zzas;
import com.google.android.gms.measurement.internal.zzd;
import com.google.android.gms.measurement.internal.zze;
import com.google.android.gms.measurement.internal.zzfu;
import com.google.android.gms.measurement.internal.zzg;
import com.google.android.gms.measurement.internal.zzgr;
import com.google.android.gms.measurement.internal.zzij;
import com.google.android.gms.measurement.internal.zzik;
import com.google.android.gms.measurement.internal.zzil;
import com.google.android.gms.measurement.internal.zzim;
import com.google.android.gms.measurement.internal.zzin;
import com.google.android.gms.measurement.internal.zzio;
import com.google.android.gms.measurement.internal.zzip;
import com.google.android.gms.measurement.internal.zzkv;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class zzii
extends zzg {
    private volatile zzij zzb;
    private zzij zzc;
    @VisibleForTesting
    protected zzij zza;
    private final Map<Activity, zzij> zzd;
    private Activity zze;
    private volatile boolean zzf;
    private volatile zzij zzg;
    private zzij zzh;
    private boolean zzi;
    private final Object zzj = new Object();
    private zzij zzk;
    private String zzl;

    public zzii(zzfu zzfu2) {
        super(zzfu2);
        this.zzd = new ConcurrentHashMap<Activity, zzij>();
    }

    @Override
    protected final boolean zzy() {
        return false;
    }

    @WorkerThread
    public final zzij zza(boolean bl) {
        this.zzv();
        ((zzgr)this).zzc();
        if (!((zzgr)this).zzs().zza(zzas.zzbu) || !bl) {
            return this.zza;
        }
        if (this.zza != null) {
            return this.zza;
        }
        return this.zzh;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(Bundle bundle, long l) {
        zzij zzij2;
        if (!((zzgr)this).zzs().zza(zzas.zzbu)) {
            ((zzgr)this).zzq().zzj().zza("Manual screen reporting is disabled.");
            return;
        }
        String string = null;
        String string2 = null;
        Object object = this.zzj;
        synchronized (object) {
            if (!this.zzi) {
                ((zzgr)this).zzq().zzj().zza("Cannot log screen view event when the app is in the background.");
                return;
            }
            if (bundle != null) {
                string = bundle.getString("screen_name");
                if (string != null && (string.length() <= 0 || string.length() > 100)) {
                    ((zzgr)this).zzq().zzj().zza("Invalid screen name length for screen view. Length", string.length());
                    return;
                }
                string2 = bundle.getString("screen_class");
                if (string2 != null && (string2.length() <= 0 || string2.length() > 100)) {
                    ((zzgr)this).zzq().zzj().zza("Invalid screen class length for screen view. Length", string2.length());
                    return;
                }
            }
            if (string2 == null) {
                String string3 = string2 = this.zze != null ? zzii.zza(this.zze.getClass().getCanonicalName()) : "Activity";
            }
            if (this.zzf && this.zzb != null) {
                this.zzf = false;
                boolean bl = zzkv.zzc(this.zzb.zzb, string2);
                boolean bl2 = zzkv.zzc(this.zzb.zza, string);
                if (bl && bl2) {
                    ((zzgr)this).zzq().zzj().zza("Ignoring call to log screen view event with duplicate parameters.");
                    return;
                }
            }
        }
        ((zzgr)this).zzq().zzw().zza("Logging screen view with name, class", string == null ? "null" : string, string2 == null ? "null" : string2);
        object = this.zzb == null ? this.zzc : this.zzb;
        this.zzb = zzij2 = new zzij(string, string2, ((zzgr)this).zzo().zzf(), true, l);
        this.zzc = object;
        this.zzg = zzij2;
        long l2 = ((zzgr)this).zzl().elapsedRealtime();
        ((zzgr)this).zzp().zza(new zzil(this, bundle, zzij2, (zzij)object, l2));
    }

    @WorkerThread
    private final void zza(Bundle bundle, @NonNull zzij zzij2, zzij zzij3, long l) {
        if (bundle != null) {
            bundle.remove("screen_name");
            bundle.remove("screen_class");
        }
        Bundle bundle2 = ((zzgr)this).zzo().zza(null, "screen_view", bundle, null, true, true);
        this.zza(zzij2, zzij3, l, true, bundle2);
    }

    @Deprecated
    @MainThread
    public final void zza(@NonNull Activity activity, @Size(min=1L, max=36L) @Nullable String string, @Size(min=1L, max=36L) @Nullable String string2) {
        if (!((zzgr)this).zzs().zzh().booleanValue()) {
            ((zzgr)this).zzq().zzj().zza("setCurrentScreen cannot be called while screen reporting is disabled.");
            return;
        }
        if (this.zzb == null) {
            ((zzgr)this).zzq().zzj().zza("setCurrentScreen cannot be called while no activity active");
            return;
        }
        if (this.zzd.get(activity) == null) {
            ((zzgr)this).zzq().zzj().zza("setCurrentScreen must be called with an activity in the activity lifecycle");
            return;
        }
        if (string2 == null) {
            string2 = zzii.zza(activity.getClass().getCanonicalName());
        }
        boolean bl = zzkv.zzc(this.zzb.zzb, string2);
        boolean bl2 = zzkv.zzc(this.zzb.zza, string);
        if (bl && bl2) {
            ((zzgr)this).zzq().zzj().zza("setCurrentScreen cannot be called with the same class and name");
            return;
        }
        if (string != null && (string.length() <= 0 || string.length() > 100)) {
            ((zzgr)this).zzq().zzj().zza("Invalid screen name length in setCurrentScreen. Length", string.length());
            return;
        }
        if (string2 != null && (string2.length() <= 0 || string2.length() > 100)) {
            ((zzgr)this).zzq().zzj().zza("Invalid class name length in setCurrentScreen. Length", string2.length());
            return;
        }
        ((zzgr)this).zzq().zzw().zza("Setting current screen to name, class", string == null ? "null" : string, string2);
        zzij zzij2 = new zzij(string, string2, ((zzgr)this).zzo().zzf());
        this.zzd.put(activity, zzij2);
        this.zza(activity, zzij2, true);
    }

    public final zzij zzaa() {
        return this.zzb;
    }

    @MainThread
    private final void zza(Activity activity, zzij zzij2, boolean bl) {
        zzij zzij3;
        zzij zzij4;
        zzij zzij5 = zzij4 = this.zzb == null ? this.zzc : this.zzb;
        if (zzij2.zzb == null) {
            zzij3 = activity != null ? zzii.zza(activity.getClass().getCanonicalName()) : null;
            zzij2 = new zzij(zzij2.zza, (String)((Object)zzij3), zzij2.zzc, zzij2.zze, zzij2.zzf);
        }
        zzij3 = zzij2;
        this.zzc = this.zzb;
        this.zzb = zzij3;
        long l = ((zzgr)this).zzl().elapsedRealtime();
        ((zzgr)this).zzp().zza(new zzik(this, zzij3, zzij4, l, bl));
    }

    @WorkerThread
    private final void zza(zzij zzij2, zzij zzij3, long l, boolean bl, Bundle bundle) {
        ((zzgr)this).zzc();
        boolean bl2 = false;
        if (((zzgr)this).zzs().zza(zzas.zzas)) {
            bl2 = bl && this.zza != null;
            if (bl2) {
                this.zza(this.zza, true, l);
            }
        } else if (bl && this.zza != null) {
            this.zza(this.zza, true, l);
        }
        if (zzij3 == null || zzij3.zzc != zzij2.zzc || !zzkv.zzc(zzij3.zzb, zzij2.zzb) || !zzkv.zzc(zzij3.zza, zzij2.zza)) {
            long l2;
            Bundle bundle2 = new Bundle();
            if (((zzgr)this).zzs().zza(zzas.zzbu)) {
                bundle2 = bundle != null ? new Bundle(bundle) : new Bundle();
            }
            zzii.zza(zzij2, bundle2, true);
            if (zzij3 != null) {
                if (zzij3.zza != null) {
                    bundle2.putString("_pn", zzij3.zza);
                }
                if (zzij3.zzb != null) {
                    bundle2.putString("_pc", zzij3.zzb);
                }
                bundle2.putLong("_pi", zzij3.zzc);
            }
            if (((zzgr)this).zzs().zza(zzas.zzas) && bl2 && (l2 = zznk.zzb() && ((zzgr)this).zzs().zza(zzas.zzau) ? ((zzd)this).zzj().zza(l) : ((zzd)this).zzj().zzb.zzb()) > 0L) {
                ((zzgr)this).zzo().zza(bundle2, l2);
            }
            String string = "auto";
            if (((zzgr)this).zzs().zza(zzas.zzbu)) {
                if (!((zzgr)this).zzs().zzh().booleanValue()) {
                    bundle2.putLong("_mst", 1L);
                }
                String string2 = string = zzij2.zze ? "app" : "auto";
            }
            if (((zzgr)this).zzs().zza(zzas.zzbu)) {
                long l3 = ((zzgr)this).zzl().currentTimeMillis();
                if (zzij2.zze && zzij2.zzf != 0L) {
                    l3 = zzij2.zzf;
                }
                ((zzd)this).zze().zza(string, "_vs", l3, bundle2);
            } else {
                ((zzd)this).zze().zzb(string, "_vs", bundle2);
            }
        }
        this.zza = zzij2;
        if (((zzgr)this).zzs().zza(zzas.zzbu) && zzij2.zze) {
            this.zzh = zzij2;
        }
        ((zzd)this).zzg().zza(zzij2);
    }

    @WorkerThread
    private final void zza(zzij zzij2, boolean bl, long l) {
        boolean bl2;
        ((zzd)this).zzd().zza(((zzgr)this).zzl().elapsedRealtime());
        boolean bl3 = bl2 = zzij2 != null && zzij2.zzd;
        if (((zzd)this).zzj().zza(bl2, bl, l) && zzij2 != null) {
            zzij2.zzd = false;
        }
    }

    public static void zza(zzij zzij2, Bundle bundle, boolean bl) {
        if (bundle != null && zzij2 != null && (!bundle.containsKey("_sc") || bl)) {
            if (zzij2.zza != null) {
                bundle.putString("_sn", zzij2.zza);
            } else {
                bundle.remove("_sn");
            }
            if (zzij2.zzb != null) {
                bundle.putString("_sc", zzij2.zzb);
            } else {
                bundle.remove("_sc");
            }
            bundle.putLong("_si", zzij2.zzc);
            return;
        }
        if (bundle != null && zzij2 == null && bl) {
            bundle.remove("_sn");
            bundle.remove("_sc");
            bundle.remove("_si");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zza(String string, zzij zzij2) {
        ((zzgr)this).zzc();
        zzii zzii2 = this;
        synchronized (zzii2) {
            if (this.zzl == null || this.zzl.equals(string) || zzij2 != null) {
                this.zzl = string;
                this.zzk = zzij2;
            }
            return;
        }
    }

    @VisibleForTesting
    private static String zza(String string) {
        String[] stringArray = string.split("\\.");
        String string2 = stringArray.length > 0 ? stringArray[stringArray.length - 1] : "";
        if (string2.length() > 100) {
            return string2.substring(0, 100);
        }
        return string2;
    }

    @MainThread
    private final zzij zzd(@NonNull Activity activity) {
        Preconditions.checkNotNull((Object)activity);
        zzij zzij2 = this.zzd.get(activity);
        if (zzij2 == null) {
            String string = zzii.zza(activity.getClass().getCanonicalName());
            zzij2 = new zzij(null, string, ((zzgr)this).zzo().zzf());
            this.zzd.put(activity, zzij2);
        }
        if (!((zzgr)this).zzs().zza(zzas.zzbu)) {
            return zzij2;
        }
        if (this.zzg != null) {
            return this.zzg;
        }
        return zzij2;
    }

    @MainThread
    public final void zza(Activity activity, Bundle bundle) {
        if (!((zzgr)this).zzs().zzh().booleanValue()) {
            return;
        }
        if (bundle == null) {
            return;
        }
        Bundle bundle2 = bundle.getBundle("com.google.app_measurement.screen_service");
        if (bundle2 == null) {
            return;
        }
        zzij zzij2 = new zzij(bundle2.getString("name"), bundle2.getString("referrer_name"), bundle2.getLong("id"));
        this.zzd.put(activity, zzij2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void zza(Activity activity) {
        zzd zzd2;
        Object object;
        if (((zzgr)this).zzs().zza(zzas.zzbu)) {
            object = this.zzj;
            synchronized (object) {
                this.zzi = true;
                if (activity != this.zze) {
                    Activity activity2 = activity;
                    zzd2 = this;
                    Object object2 = ((zzii)zzd2).zzj;
                    synchronized (object2) {
                        ((zzii)zzd2).zze = activity2;
                        ((zzii)zzd2).zzf = false;
                    }
                    if (zzd2.zzs().zza(zzas.zzbt) && zzd2.zzs().zzh().booleanValue()) {
                        ((zzii)zzd2).zzg = null;
                        zzd2.zzp().zza(new zzio((zzii)zzd2));
                    }
                }
            }
        }
        if (((zzgr)this).zzs().zza(zzas.zzbt) && !((zzgr)this).zzs().zzh().booleanValue()) {
            this.zzb = this.zzg;
            ((zzgr)this).zzp().zza(new zzin(this));
            return;
        }
        object = this.zzd(activity);
        this.zza(activity, (zzij)object, false);
        zzd2 = ((zzd)this).zzd();
        long l = zzd2.zzl().elapsedRealtime();
        zzd2.zzp().zza(new zze((zza)zzd2, l));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void zzb(Activity activity) {
        if (((zzgr)this).zzs().zza(zzas.zzbu)) {
            Object object = this.zzj;
            synchronized (object) {
                this.zzi = false;
                this.zzf = true;
            }
        }
        long l = ((zzgr)this).zzl().elapsedRealtime();
        if (((zzgr)this).zzs().zza(zzas.zzbt) && !((zzgr)this).zzs().zzh().booleanValue()) {
            this.zzb = null;
            ((zzgr)this).zzp().zza(new zzim(this, l));
            return;
        }
        zzij zzij2 = this.zzd(activity);
        this.zzc = this.zzb;
        this.zzb = null;
        ((zzgr)this).zzp().zza(new zzip(this, zzij2, l));
    }

    @MainThread
    public final void zzb(Activity activity, Bundle bundle) {
        if (!((zzgr)this).zzs().zzh().booleanValue()) {
            return;
        }
        if (bundle == null) {
            return;
        }
        zzij zzij2 = this.zzd.get(activity);
        if (zzij2 == null) {
            return;
        }
        Bundle bundle2 = new Bundle();
        bundle2.putLong("id", zzij2.zzc);
        bundle2.putString("name", zzij2.zza);
        bundle2.putString("referrer_name", zzij2.zzb);
        bundle.putBundle("com.google.app_measurement.screen_service", bundle2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void zzc(Activity activity) {
        Object object = this.zzj;
        synchronized (object) {
            if (activity == this.zze) {
                this.zze = null;
            }
        }
        if (!((zzgr)this).zzs().zzh().booleanValue()) {
            return;
        }
        this.zzd.remove(activity);
    }

    static /* synthetic */ void zza(zzii zzii2, Bundle bundle, zzij zzij2, zzij zzij3, long l) {
        zzii2.zza(bundle, zzij2, zzij3, l);
    }

    static /* synthetic */ void zza(zzii zzii2, zzij zzij2, zzij zzij3, long l, boolean bl, Bundle bundle) {
        zzii2.zza(zzij2, zzij3, l, bl, null);
    }

    static /* synthetic */ zzij zza(zzii zzii2) {
        return zzii2.zzh;
    }

    static /* synthetic */ void zza(zzii zzii2, zzij zzij2, boolean bl, long l) {
        zzii2.zza(zzij2, false, l);
    }

    static /* synthetic */ zzij zza(zzii zzii2, zzij zzij2) {
        zzii2.zzh = null;
        return null;
    }
}

