/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.RemoteException;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.internal.BaseGmsClient;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zzei;
import com.google.android.gms.measurement.internal.zzek;
import com.google.android.gms.measurement.internal.zzeq;
import com.google.android.gms.measurement.internal.zzer;
import com.google.android.gms.measurement.internal.zzgr;
import com.google.android.gms.measurement.internal.zzir;
import com.google.android.gms.measurement.internal.zzjk;
import com.google.android.gms.measurement.internal.zzjm;
import com.google.android.gms.measurement.internal.zzjn;
import com.google.android.gms.measurement.internal.zzjo;
import com.google.android.gms.measurement.internal.zzjp;

@VisibleForTesting
public final class zzjl
implements ServiceConnection,
BaseGmsClient.BaseConnectionCallbacks,
BaseGmsClient.BaseOnConnectionFailedListener {
    private volatile boolean zzb;
    private volatile zzer zzc;
    final /* synthetic */ zzir zza;

    protected zzjl(zzir zzir2) {
        this.zza = zzir2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zza(Intent intent) {
        ((zzgr)this.zza).zzc();
        Context context = ((zzgr)this.zza).zzm();
        ConnectionTracker connectionTracker = ConnectionTracker.getInstance();
        zzjl zzjl2 = this;
        synchronized (zzjl2) {
            if (this.zzb) {
                ((zzgr)this.zza).zzq().zzw().zza("Connection attempt already in progress");
                return;
            }
            ((zzgr)this.zza).zzq().zzw().zza("Using local app measurement service");
            this.zzb = true;
            connectionTracker.bindService(context, intent, (ServiceConnection)zzir.zza(this.zza), 129);
            return;
        }
    }

    @WorkerThread
    public final void zza() {
        if (this.zzc != null && (this.zzc.isConnected() || this.zzc.isConnecting())) {
            this.zzc.disconnect();
        }
        this.zzc = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onServiceConnected");
        zzjl zzjl2 = this;
        synchronized (zzjl2) {
            String string;
            if (iBinder == null) {
                this.zzb = false;
                ((zzgr)this.zza).zzq().zze().zza("Service connected with null binder");
                return;
            }
            zzei zzei2 = null;
            try {
                string = iBinder.getInterfaceDescriptor();
                if ("com.google.android.gms.measurement.internal.IMeasurementService".equals(string)) {
                    IInterface iInterface;
                    IBinder iBinder2 = iBinder;
                    zzei2 = iBinder2 == null ? null : ((iInterface = iBinder2.queryLocalInterface("com.google.android.gms.measurement.internal.IMeasurementService")) instanceof zzei ? (zzei)iInterface : new zzek(iBinder2));
                    ((zzgr)this.zza).zzq().zzw().zza("Bound to IMeasurementService interface");
                } else {
                    ((zzgr)this.zza).zzq().zze().zza("Got binder with a wrong descriptor", string);
                }
            }
            catch (RemoteException remoteException) {
                ((zzgr)this.zza).zzq().zze().zza("Service connect failed to get IMeasurementService");
            }
            if (zzei2 == null) {
                this.zzb = false;
                try {
                    ConnectionTracker.getInstance().unbindService(((zzgr)this.zza).zzm(), (ServiceConnection)zzir.zza(this.zza));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            } else {
                string = zzei2;
                ((zzgr)this.zza).zzp().zza(new zzjk(this, (zzei)((Object)string)));
            }
            return;
        }
    }

    @MainThread
    public final void onServiceDisconnected(ComponentName componentName) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onServiceDisconnected");
        ((zzgr)this.zza).zzq().zzv().zza("Service disconnected");
        ((zzgr)this.zza).zzp().zza(new zzjn(this, componentName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zzb() {
        ((zzgr)this.zza).zzc();
        Context context = ((zzgr)this.zza).zzm();
        zzjl zzjl2 = this;
        synchronized (zzjl2) {
            if (this.zzb) {
                ((zzgr)this.zza).zzq().zzw().zza("Connection attempt already in progress");
                return;
            }
            if (this.zzc != null && (this.zzc.isConnecting() || this.zzc.isConnected())) {
                ((zzgr)this.zza).zzq().zzw().zza("Already awaiting connection attempt");
                return;
            }
            this.zzc = new zzer(context, Looper.getMainLooper(), this, this);
            ((zzgr)this.zza).zzq().zzw().zza("Connecting to remote service");
            this.zzb = true;
            this.zzc.checkAvailabilityAndConnect();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onConnected(@Nullable Bundle bundle) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnected");
        zzjl zzjl2 = this;
        synchronized (zzjl2) {
            try {
                zzei zzei2 = (zzei)this.zzc.getService();
                ((zzgr)this.zza).zzp().zza(new zzjm(this, zzei2));
            }
            catch (DeadObjectException | IllegalStateException throwable) {
                this.zzc = null;
                this.zzb = false;
            }
            return;
        }
    }

    @MainThread
    public final void onConnectionSuspended(int n) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnectionSuspended");
        ((zzgr)this.zza).zzq().zzv().zza("Service connection suspended");
        ((zzgr)this.zza).zzp().zza(new zzjp(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnectionFailed");
        zzeq zzeq2 = this.zza.zzy.zzc();
        if (zzeq2 != null) {
            zzeq2.zzh().zza("Service connection failed", connectionResult);
        }
        zzjl zzjl2 = this;
        synchronized (zzjl2) {
            this.zzb = false;
            this.zzc = null;
        }
        ((zzgr)this.zza).zzp().zza(new zzjo(this));
    }

    static /* synthetic */ boolean zza(zzjl zzjl2, boolean bl) {
        zzjl2.zzb = false;
        return false;
    }
}

