/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.GuardedBy;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zzae;
import com.google.android.gms.measurement.internal.zzeq;
import com.google.android.gms.measurement.internal.zzer;
import com.google.android.gms.measurement.internal.zzes;
import com.google.android.gms.measurement.internal.zzft;
import com.google.android.gms.measurement.internal.zzfw;
import com.google.android.gms.measurement.internal.zzgq;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;

public final class zzet
extends zzgq {
    private char zza = '\u0000';
    private long zzb = -1L;
    @GuardedBy(value="this")
    private String zzc;
    private final zzer zzd;
    private final zzer zze;
    private final zzer zzf;
    private final zzer zzg;
    private final zzer zzh;
    private final zzer zzi;
    private final zzer zzj;
    private final zzer zzk;
    private final zzer zzl;

    zzet(zzfw object) {
        super((zzfw)object);
        this.zzd = object = new zzer(this, 6, false, false);
        this.zze = object = new zzer(this, 6, true, false);
        this.zzf = object = new zzer(this, 6, false, true);
        this.zzg = object = new zzer(this, 5, false, false);
        this.zzh = object = new zzer(this, 5, true, false);
        this.zzi = object = new zzer(this, 5, false, true);
        this.zzj = object = new zzer(this, 4, false, false);
        this.zzk = object = new zzer(this, 3, false, false);
        this.zzl = object = new zzer(this, 2, false, false);
    }

    public final zzer zzb() {
        return this.zzd;
    }

    public final zzer zzc() {
        return this.zze;
    }

    public final zzer zzd() {
        return this.zzf;
    }

    public final zzer zze() {
        return this.zzg;
    }

    public final zzer zzf() {
        return this.zzh;
    }

    public final zzer zzh() {
        return this.zzi;
    }

    public final zzer zzi() {
        return this.zzj;
    }

    public final zzer zzj() {
        return this.zzk;
    }

    public final zzer zzk() {
        return this.zzl;
    }

    @Override
    protected final boolean zza() {
        return false;
    }

    protected static Object zzl(String string) {
        if (string == null) {
            return null;
        }
        zzes zzes2 = new zzes(string);
        return zzes2;
    }

    protected final void zzm(int n, boolean bl, boolean bl2, String string, Object object, Object object2, Object object3) {
        if (!bl && Log.isLoggable((String)this.zzn(), (int)n)) {
            String string2 = zzet.zzo(false, string, object, object2, object3);
            Log.println((int)n, (String)this.zzn(), (String)string2);
        }
        if (!bl2 && n >= 5) {
            Preconditions.checkNotNull((Object)string);
            zzft zzft2 = this.zzx.zzj();
            if (zzft2 == null) {
                Log.println((int)6, (String)this.zzn(), (String)"Scheduler not set. Not logging error/warn");
                return;
            }
            if (!zzft2.zzu()) {
                Log.println((int)6, (String)this.zzn(), (String)"Scheduler not initialized. Not logging error/warn");
                return;
            }
            if (n >= 9) {
                n = 8;
            }
            zzeq zzeq2 = new zzeq(this, n, string, object, object2, object3);
            zzft2.zzh(zzeq2);
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @EnsuresNonNull(value={"logTagDoNotUseDirectly"})
    @VisibleForTesting
    protected final String zzn() {
        synchronized (this) {
            Object object = this.zzc;
            if (object == null) {
                object = this.zzx.zzt();
                if (object != null) {
                    this.zzc = this.zzx.zzt();
                } else {
                    object = this.zzx.zzc();
                    this.zzc = ((zzae)object).zzb();
                }
            }
            object = this.zzc;
            Preconditions.checkNotNull((Object)object);
            return this.zzc;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    static String zzo(boolean bl, String string, Object object, Object object2, Object object3) {
        String string2;
        if (string == null) {
            string = "";
        }
        object = zzet.zzp(bl, object);
        object2 = zzet.zzp(bl, object2);
        object3 = zzet.zzp(bl, object3);
        StringBuilder stringBuilder = new StringBuilder();
        if (!TextUtils.isEmpty((CharSequence)string)) {
            stringBuilder.append(string);
            string2 = ": ";
        } else {
            string2 = "";
        }
        if (!TextUtils.isEmpty((CharSequence)object)) {
            stringBuilder.append(string2);
            stringBuilder.append((String)object);
            string2 = ", ";
        }
        if (!TextUtils.isEmpty((CharSequence)object2)) {
            stringBuilder.append(string2);
            stringBuilder.append((String)object2);
            string2 = ", ";
        }
        if (!TextUtils.isEmpty((CharSequence)object3)) {
            stringBuilder.append(string2);
            stringBuilder.append((String)object3);
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    @VisibleForTesting
    static String zzp(boolean bl, Object object) {
        int n;
        String string;
        StringBuilder stringBuilder;
        if (object == null) {
            return "";
        }
        if (object instanceof Integer) {
            object = (long)((Integer)object).intValue();
        }
        if (object instanceof Long) {
            if (!bl) {
                return String.valueOf(object);
            }
            Long l = (Long)object;
            if (Math.abs(l) < 100L) {
                return String.valueOf(object);
            }
            String string2 = String.valueOf(object).charAt(0) == '-' ? "-" : "";
            object = String.valueOf(Math.abs(l));
            int n2 = ((String)object).length();
            double d = Math.pow(10.0, n2 + -1);
            long l2 = Math.round(d);
            int n3 = ((String)object).length();
            double d2 = Math.pow(10.0, n3);
            long l3 = Math.round(d2 + -1.0);
            n3 = string2.length();
            n2 = string2.length();
            StringBuilder stringBuilder2 = new StringBuilder(n3 + 43 + n2);
            stringBuilder2.append(string2);
            stringBuilder2.append(l2);
            stringBuilder2.append("...");
            stringBuilder2.append(string2);
            stringBuilder2.append(l3);
            return stringBuilder2.toString();
        }
        if (object instanceof Boolean) {
            return String.valueOf(object);
        }
        if (object instanceof Throwable) {
            object = (Throwable)object;
            String string3 = bl ? object.getClass().getName() : ((Throwable)object).toString();
            stringBuilder = new StringBuilder(string3);
            string = zzet.zzz(zzfw.class.getCanonicalName());
            object = ((Throwable)object).getStackTrace();
            n = ((Object)object).length;
        } else {
            if (object instanceof zzes) {
                return zzes.zza((zzes)object);
            }
            if (!bl) return String.valueOf(object);
            return "-";
        }
        for (int i = 0; i < n; ++i) {
            String string4;
            Object object2 = object[i];
            if (((StackTraceElement)object2).isNativeMethod() || (string4 = ((StackTraceElement)object2).getClassName()) == null || !zzet.zzz(string4).equals(string)) continue;
            stringBuilder.append(": ");
            stringBuilder.append(object2);
            return stringBuilder.toString();
        }
        return stringBuilder.toString();
    }

    private static String zzz(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return "";
        }
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    static /* synthetic */ char zzq(zzet zzet2) {
        return zzet2.zza;
    }

    static /* synthetic */ char zzr(zzet zzet2, char c) {
        zzet2.zza = c;
        return c;
    }

    static /* synthetic */ long zzs(zzet zzet2) {
        return zzet2.zzb;
    }

    static /* synthetic */ long zzt(zzet zzet2, long l) {
        zzet2.zzb = 37000L;
        return 37000L;
    }
}

