/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.text.TextUtils;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.CollectionUtils;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzmg;
import com.google.android.gms.internal.measurement.zzt;
import com.google.android.gms.measurement.internal.zzaa;
import com.google.android.gms.measurement.internal.zzae;
import com.google.android.gms.measurement.internal.zzaq;
import com.google.android.gms.measurement.internal.zzas;
import com.google.android.gms.measurement.internal.zzea;
import com.google.android.gms.measurement.internal.zzek;
import com.google.android.gms.measurement.internal.zzem;
import com.google.android.gms.measurement.internal.zzen;
import com.google.android.gms.measurement.internal.zzfp;
import com.google.android.gms.measurement.internal.zzgi;
import com.google.android.gms.measurement.internal.zzgj;
import com.google.android.gms.measurement.internal.zzgl;
import com.google.android.gms.measurement.internal.zzgm;
import com.google.android.gms.measurement.internal.zzgn;
import com.google.android.gms.measurement.internal.zzgo;
import com.google.android.gms.measurement.internal.zzjf;
import com.google.android.gms.measurement.internal.zzko;
import java.io.ByteArrayInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import javax.security.auth.x500.X500Principal;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;

public final class zzkp
extends zzgj {
    private static final String[] zzb;
    private static final String[] zzc;
    private SecureRandom zzd;
    private final AtomicLong zze;
    private int zzf;
    private Integer zzg = null;
    public static final /* synthetic */ int zza;

    zzkp(zzfp object) {
        super((zzfp)object);
        this.zze = object = new AtomicLong(0L);
    }

    @Override
    protected final boolean zza() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @WorkerThread
    protected final void zzaz() {
        long l;
        this.zzg();
        SecureRandom secureRandom = new SecureRandom();
        long l2 = secureRandom.nextLong();
        if (l2 == 0L) {
            long l3 = secureRandom.nextLong();
            if (l3 == 0L) {
                this.zzs.zzau().zze().zza("Utils falling back to Random for random id");
                l = l3;
            } else {
                l = l3;
            }
        } else {
            l = l2;
        }
        this.zze.set(l);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final long zzd() {
        if (this.zze.get() == 0L) {
            AtomicLong atomicLong = this.zze;
            synchronized (atomicLong) {
                long l = System.nanoTime();
                Clock clock = this.zzs.zzay();
                Random random = new Random(l ^ clock.currentTimeMillis());
                long l2 = random.nextLong();
                int n = this.zzf;
                this.zzf = ++n;
                return l2 + (long)n;
            }
        }
        AtomicLong atomicLong = this.zze;
        synchronized (atomicLong) {
            this.zze.compareAndSet(-1L, 1L);
            return this.zze.getAndIncrement();
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    @EnsuresNonNull(value={"this.secureRandom"})
    @WorkerThread
    final SecureRandom zzf() {
        this.zzg();
        if (this.zzd == null) {
            SecureRandom secureRandom;
            this.zzd = secureRandom = new SecureRandom();
        }
        return this.zzd;
    }

    static boolean zzh(String string) {
        Preconditions.checkNotEmpty((String)string);
        return string.charAt(0) != '_' || string.equals("_ep");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final Bundle zzi(Uri uri) {
        String string;
        String string2;
        String string3;
        if (uri == null) {
            return null;
        }
        try {
            Object object;
            boolean bl = uri.isHierarchical();
            if (bl) {
                string3 = uri.getQueryParameter("utm_campaign");
                string2 = uri.getQueryParameter("utm_source");
                string = uri.getQueryParameter("utm_medium");
                String string4 = uri.getQueryParameter("gclid");
                object = string3;
                string3 = string2;
                string2 = string;
                string = string4;
            } else {
                object = null;
                string3 = null;
                string2 = null;
                string = null;
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            ((zzgi)object).zzs.zzau().zze().zzb("Install referrer url isn't a hierarchical URI", unsupportedOperationException);
            return null;
        }
        if (TextUtils.isEmpty((CharSequence)object) && TextUtils.isEmpty((CharSequence)string3) && TextUtils.isEmpty((CharSequence)string2) && TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        Bundle bundle = new Bundle();
        if (!TextUtils.isEmpty((CharSequence)object)) {
            bundle.putString("campaign", (String)object);
        }
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            bundle.putString("source", string3);
        }
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            bundle.putString("medium", string2);
        }
        if (!TextUtils.isEmpty((CharSequence)string)) {
            bundle.putString("gclid", string);
        }
        if (!TextUtils.isEmpty((CharSequence)(object = uri.getQueryParameter("utm_term")))) {
            bundle.putString("term", (String)object);
        }
        if (!TextUtils.isEmpty((CharSequence)(object = uri.getQueryParameter("utm_content")))) {
            bundle.putString("content", (String)object);
        }
        if (!TextUtils.isEmpty((CharSequence)(object = uri.getQueryParameter("aclid")))) {
            bundle.putString("aclid", (String)object);
        }
        if (!TextUtils.isEmpty((CharSequence)(object = uri.getQueryParameter("cp1")))) {
            bundle.putString("cp1", (String)object);
        }
        if (!TextUtils.isEmpty((CharSequence)(object = uri.getQueryParameter("anid")))) {
            bundle.putString("anid", (String)object);
        }
        return bundle;
    }

    final boolean zzj(String string, String string2) {
        int n;
        if (string2 == null) {
            this.zzs.zzau().zzd().zzb("Name is required and can't be null. Type", string);
            return false;
        }
        if (string2.length() == 0) {
            this.zzs.zzau().zzd().zzb("Name is required and can't be empty. Type", string);
            return false;
        }
        int n2 = string2.codePointAt(0);
        if (!Character.isLetter(n2)) {
            this.zzs.zzau().zzd().zzc("Name must start with a letter. Type, name", string, string2);
            return false;
        }
        int n3 = string2.length();
        for (n2 = Character.charCount(n2); n2 < n3; n2 += Character.charCount(n)) {
            n = string2.codePointAt(n2);
            if (n == 95 || Character.isLetterOrDigit(n)) {
                continue;
            }
            this.zzs.zzau().zzd().zzc("Name must consist of letters, digits or _ (underscores). Type, name", string, string2);
            return false;
        }
        return true;
    }

    final boolean zzk(String string, String string2) {
        block8: {
            int n;
            int n2;
            block7: {
                if (string2 == null) {
                    this.zzs.zzau().zzd().zzb("Name is required and can't be null. Type", string);
                    return false;
                }
                if (string2.length() == 0) {
                    this.zzs.zzau().zzd().zzb("Name is required and can't be empty. Type", string);
                    return false;
                }
                n2 = string2.codePointAt(0);
                if (Character.isLetter(n2)) break block7;
                if (n2 != 95) break block8;
                n2 = 95;
            }
            int n3 = string2.length();
            for (n2 = Character.charCount(n2); n2 < n3; n2 += Character.charCount(n)) {
                n = string2.codePointAt(n2);
                if (n == 95 || Character.isLetterOrDigit(n)) {
                    continue;
                }
                this.zzs.zzau().zzd().zzc("Name must consist of letters, digits or _ (underscores). Type, name", string, string2);
                return false;
            }
            return true;
        }
        this.zzs.zzau().zzd().zzc("Name must start with a letter or _ (underscore). Type, name", string, string2);
        return false;
    }

    final boolean zzl(String string, String[] stringArray, String[] stringArray2, String string2) {
        if (string2 == null) {
            this.zzs.zzau().zzd().zzb("Name is required and can't be null. Type", string);
            return false;
        }
        Preconditions.checkNotNull((Object)string2);
        String[] stringArray3 = zzb;
        for (int i = 0; i < 3; ++i) {
            if (!string2.startsWith(stringArray3[i])) continue;
            this.zzs.zzau().zzd().zzc("Name starts with reserved prefix. Type, name", string, string2);
            return false;
        }
        if (stringArray != null && zzkp.zzas(string2, stringArray) && (stringArray2 == null || !zzkp.zzas(string2, stringArray2))) {
            this.zzs.zzau().zzd().zzc("Name is reserved. Type, name", string, string2);
            return false;
        }
        return true;
    }

    final boolean zzm(String string, int n, String string2) {
        if (string2 == null) {
            this.zzs.zzau().zzd().zzb("Name is required and can't be null. Type", string);
            return false;
        }
        if (string2.codePointCount(0, string2.length()) > n) {
            this.zzs.zzau().zzd().zzd("Name is too long. Type, maximum supported length, name", string, n, string2);
            return false;
        }
        return true;
    }

    final int zzn(String string) {
        if (!this.zzk("event", string)) {
            return 2;
        }
        if (!this.zzl("event", zzgm.zza, zzgm.zzb, string)) {
            return 13;
        }
        this.zzs.zzc();
        if (!this.zzm("event", 40, string)) {
            return 2;
        }
        return 0;
    }

    final int zzo(String string) {
        if (!this.zzk("user property", string)) {
            return 6;
        }
        if (!this.zzl("user property", zzgo.zza, null, string)) {
            return 15;
        }
        this.zzs.zzc();
        if (!this.zzm("user property", 24, string)) {
            return 6;
        }
        return 0;
    }

    final int zzq(String string) {
        if (!this.zzj("event param", string)) {
            return 3;
        }
        if (!this.zzl("event param", null, null, string)) {
            return 14;
        }
        this.zzs.zzc();
        if (!this.zzm("event param", 40, string)) {
            return 3;
        }
        return 0;
    }

    final int zzr(String string) {
        if (!this.zzk("event param", string)) {
            return 3;
        }
        if (!this.zzl("event param", null, null, string)) {
            return 14;
        }
        this.zzs.zzc();
        if (!this.zzm("event param", 40, string)) {
            return 3;
        }
        return 0;
    }

    final boolean zzs(Object object) {
        return object instanceof Parcelable[] || object instanceof ArrayList || object instanceof Bundle;
    }

    final boolean zzt(String string, String string2, int n, Object object) {
        if (object == null) {
            return true;
        }
        if (object instanceof Long || object instanceof Float || object instanceof Integer || object instanceof Byte || object instanceof Short || object instanceof Boolean || object instanceof Double) {
            return true;
        }
        if (object instanceof String || object instanceof Character || object instanceof CharSequence) {
            if (((String)(object = String.valueOf(object))).codePointCount(0, ((String)object).length()) > n) {
                this.zzs.zzau().zzh().zzd("Value is too long; discarded. Value kind, name, value length", string, string2, ((String)object).length());
                return false;
            }
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    final void zzz(String string, String string2, String string3, Bundle bundle, List<String> list, boolean bl) {
        if (bundle == null) {
            return;
        }
        this.zzs.zzc();
        TreeSet treeSet = new TreeSet(bundle.keySet());
        Iterator iterator = treeSet.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int n2;
            String string4 = (String)iterator.next();
            if (list == null || !list.contains(string4)) {
                n2 = bl ? this.zzq(string4) : 0;
                if (n2 == 0) {
                    n2 = this.zzr(string4);
                }
            } else {
                n2 = 0;
            }
            if (n2 != 0) {
                String string5 = n2 == 3 ? string4 : null;
                this.zzI(bundle, n2, string4, string4, string5);
                bundle.remove(string4);
                continue;
            }
            if (this.zzs(bundle.get(string4))) {
                this.zzs.zzau().zzh().zzd("Nested Bundle parameters are not allowed; discarded. event name, param name, child param name", string2, string3, string4);
                n2 = 22;
            } else {
                n2 = this.zzD(string, string2, string4, bundle.get(string4), bundle, list, bl, false);
            }
            if (n2 != 0 && !"_ev".equals(string4)) {
                this.zzI(bundle, n2, string4, string4, bundle.get(string4));
                bundle.remove(string4);
                continue;
            }
            if (!zzkp.zzh(string4) || zzkp.zzas(string4, zzgn.zzd) || ++n <= 0) continue;
            this.zzs.zzau().zzd().zzc("Item cannot contain custom parameters", this.zzs.zzm().zzc(string2), this.zzs.zzm().zzf(bundle));
            zzkp.zzan(bundle, 23);
            bundle.remove(string4);
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    final boolean zzA(String string, String string2, String string3) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            if (zzkp.zzao(string)) return true;
            if (!this.zzs.zzq()) return false;
            this.zzs.zzau().zzd().zzb("Invalid google_app_id. Firebase Analytics disabled. See https://goo.gl/NAOOOI. provided id", zzem.zzl(string));
            return false;
        }
        zzmg.zzb();
        if (this.zzs.zzc().zzn(null, zzea.zzag) && !TextUtils.isEmpty((CharSequence)string3)) return true;
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            if (zzkp.zzao(string2)) {
                return true;
            }
            this.zzs.zzau().zzd().zzb("Invalid admob_app_id. Analytics disabled.", zzem.zzl(string2));
            return false;
        }
        if (!this.zzs.zzq()) return false;
        this.zzs.zzau().zzd().zza("Missing google_app_id. Firebase Analytics disabled. See https://goo.gl/NAOOOI");
        return false;
    }

    final boolean zzB(String string, String string2, String string3, String string4) {
        boolean bl = TextUtils.isEmpty((CharSequence)string);
        boolean bl2 = TextUtils.isEmpty((CharSequence)string2);
        if (!bl && !bl2) {
            Preconditions.checkNotNull((Object)string);
            return !string.equals(string2);
        }
        if (bl && bl2) {
            if (!TextUtils.isEmpty((CharSequence)string3) && !TextUtils.isEmpty((CharSequence)string4)) {
                return !string3.equals(string4);
            }
            return !TextUtils.isEmpty((CharSequence)string4);
        }
        if (!bl) {
            if (TextUtils.isEmpty((CharSequence)string4)) {
                return false;
            }
            return TextUtils.isEmpty((CharSequence)string3) || !string3.equals(string4);
        }
        return TextUtils.isEmpty((CharSequence)string3) || !string3.equals(string4);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Object zzap(int n, Object parcelableArray, boolean bl, boolean n2) {
        if (parcelableArray == null) {
            return null;
        }
        if (parcelableArray instanceof Long || parcelableArray instanceof Double) {
            return parcelableArray;
        }
        if (parcelableArray instanceof Integer) {
            return (long)((Integer)parcelableArray).intValue();
        }
        if (parcelableArray instanceof Byte) {
            return (long)((Byte)parcelableArray).byteValue();
        }
        if (parcelableArray instanceof Short) {
            return (long)((Short)parcelableArray).shortValue();
        }
        if (parcelableArray instanceof Boolean) {
            long l;
            if (!((Boolean)parcelableArray).booleanValue()) {
                l = 0L;
                return l;
            }
            l = 1L;
            return l;
        }
        if (parcelableArray instanceof Float) {
            return ((Float)parcelableArray).doubleValue();
        }
        if (parcelableArray instanceof String || parcelableArray instanceof Character || parcelableArray instanceof CharSequence) {
            return this.zzC(String.valueOf(parcelableArray), n, bl);
        }
        if (n2 == 0 || !(parcelableArray instanceof Bundle[]) && !(parcelableArray instanceof Parcelable[])) return null;
        ArrayList<Parcelable> arrayList = new ArrayList<Parcelable>();
        for (Parcelable parcelable : parcelableArray) {
            if (!(parcelable instanceof Bundle) || (parcelable = this.zzU((Bundle)parcelable)).isEmpty()) continue;
            arrayList.add(parcelable);
        }
        return arrayList.toArray(new Bundle[arrayList.size()]);
    }

    public final String zzC(String string, int n, boolean bl) {
        if (string == null) {
            return null;
        }
        if (string.codePointCount(0, string.length()) > n) {
            if (bl) {
                return String.valueOf(string.substring(0, string.offsetByCodePoints(0, n))).concat("...");
            }
            return null;
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    final int zzD(String object, String string, String string2, Object object2, Bundle bundle, List<String> list, boolean bl, boolean bl2) {
        int n;
        int n2;
        block17: {
            block18: {
                block21: {
                    block22: {
                        block23: {
                            int n3;
                            boolean bl3;
                            block20: {
                                block19: {
                                    ((zzgi)object3).zzg();
                                    if (!((zzkp)object3).zzs(object2)) break block18;
                                    if (!bl2) return 21;
                                    if (!zzkp.zzas(string2, zzgn.zzc)) {
                                        return 20;
                                    }
                                    zzjf zzjf2 = ((zzkp)object3).zzs.zzy();
                                    ((zzgi)zzjf2).zzg();
                                    zzjf2.zzb();
                                    if (zzjf2.zzD() && zzjf2.zzs.zzl().zzZ() < 200900) {
                                        return 25;
                                    }
                                    ((zzgi)object3).zzs.zzc();
                                    bl3 = object2 instanceof Parcelable[];
                                    if (!bl3) break block19;
                                    n3 = ((Parcelable[])object2).length;
                                    break block20;
                                }
                                if (!(object2 instanceof ArrayList)) break block21;
                                n3 = ((ArrayList)object2).size();
                            }
                            if (n3 <= 200) break block22;
                            ((zzgi)object3).zzs.zzau().zzh().zzd("Parameter array is too long; discarded. Value kind, name, array length", "param", string2, n3);
                            ((zzgi)object3).zzs.zzc();
                            if (!bl3) break block23;
                            Parcelable[] parcelableArray = (Parcelable[])object2;
                            if (parcelableArray.length > 200) {
                                bundle.putParcelableArray(string2, Arrays.copyOf(parcelableArray, 200));
                                n2 = 17;
                                break block17;
                            } else {
                                n2 = 17;
                            }
                            break block17;
                        }
                        if (object2 instanceof ArrayList) {
                            ArrayList arrayList = (ArrayList)object2;
                            if (arrayList.size() > 200) {
                                ArrayList arrayList2 = new ArrayList(arrayList.subList(0, 200));
                                bundle.putParcelableArrayList(string2, arrayList2);
                                n2 = 17;
                                break block17;
                            } else {
                                n2 = 17;
                            }
                            break block17;
                        } else {
                            n2 = 17;
                        }
                        break block17;
                    }
                    n2 = 0;
                    break block17;
                }
                n2 = 0;
                break block17;
            }
            n2 = 0;
        }
        if (((zzgi)object3).zzs.zzc().zzn((String)object, zzea.zzR) && zzkp.zzR(string) || zzkp.zzR(string2)) {
            ((zzgi)object3).zzs.zzc();
            n = 256;
        } else {
            ((zzgi)object3).zzs.zzc();
            n = 100;
        }
        if (((zzkp)object3).zzt("param", string2, n, object2)) {
            return n2;
        }
        if (!bl2) return 4;
        if (object2 instanceof Bundle) {
            ((zzkp)object3).zzz((String)object, string, string2, (Bundle)object2, list, bl);
            return n2;
        }
        if (object2 instanceof Parcelable[]) {
            Parcelable[] parcelableArray = (Parcelable[])object2;
            n = parcelableArray.length;
            int n4 = 0;
            while (n4 < n) {
                Parcelable parcelable = parcelableArray[n4];
                if (!(parcelable instanceof Bundle)) {
                    ((zzgi)object3).zzs.zzau().zzh().zzc("All Parcelable[] elements must be of type Bundle. Value type, name", parcelable.getClass(), string2);
                    return 4;
                }
                ((zzkp)object3).zzz((String)object, string, string2, (Bundle)parcelable, list, bl);
                ++n4;
            }
            return n2;
        }
        if (!(object2 instanceof ArrayList)) return 4;
        ArrayList arrayList = (ArrayList)object2;
        n = arrayList.size();
        int n5 = 0;
        while (n5 < n) {
            Object e = arrayList.get(n5);
            if (!(e instanceof Bundle)) {
                object = ((zzgi)object3).zzs.zzau().zzh();
                Object object3 = e != null ? e.getClass() : "null";
                ((zzek)object).zzc("All ArrayList elements must be of type Bundle. Value type, name", object3, string2);
                return 4;
            }
            ((zzkp)object3).zzz((String)object, string, string2, (Bundle)e, list, bl);
            ++n5;
        }
        return n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final Object zzE(String string, Object object) {
        int n;
        if ("_ev".equals(string)) {
            this.zzs.zzc();
            return this.zzap(256, object, true, true);
        }
        if (zzkp.zzR(string)) {
            this.zzs.zzc();
            n = 256;
            return this.zzap(n, object, false, true);
        }
        this.zzs.zzc();
        n = 100;
        return this.zzap(n, object, false, true);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    final Bundle zzF(String var1_1, String var2_2, Bundle var3_3, List<String> var4_4, boolean var5_5) {
        block12: {
            var9_6 = zzkp.zzas(var2_2, zzgm.zzd);
            var10_7 = new Bundle(var3_3);
            var11_8 = this.zzs.zzc().zzc();
            if (!this.zzs.zzc().zzn(var1_1, zzea.zzW)) break block12;
            var6_9 = new Set<E>(var3_3.keySet());
lbl6:
            // 2 sources

            while (true) {
                var12_11 = var6_9.iterator();
                var6_10 = 0;
                block1: while (var12_11.hasNext()) {
                    block13: {
                        block14: {
                            var13_17 = (String)var12_11.next();
                            if (var4_4 != null && var4_4.contains(var13_17)) break block13;
                            if (!var5_5) break block14;
                            var7_12 = this.zzq(var13_17);
lbl14:
                            // 2 sources

                            while (true) {
                                if (var7_12 == 0) {
                                    var7_12 = this.zzr(var13_17);
                                }
lbl17:
                                // 4 sources

                                while (true) {
                                    if (var7_12 != 0) {
                                        if (var7_12 == 3) {
                                            var8_15 = var13_17;
lbl21:
                                            // 2 sources

                                            while (true) {
                                                this.zzI(var10_7, var7_12, var13_17, var13_17, var8_15);
                                                var10_7.remove(var13_17);
                                                continue block1;
                                                break;
                                            }
                                        }
                                        var8_15 = null;
                                        ** continue;
                                    }
                                    var8_16 = this.zzD(var1_1, var2_2, var13_17, var3_3.get(var13_17), var10_7, var4_4, var5_5, var9_6);
                                    if (var8_16 == 17) {
                                        this.zzI(var10_7, 17, var13_17, var13_17, false);
lbl30:
                                        // 2 sources

                                        while (zzkp.zzh(var13_17) && ++var6_10 > var11_8) {
                                            var7_13 /* !! */  = new StringBuilder(48);
                                            var7_13 /* !! */ .append("Event can't contain more than ");
                                            var7_13 /* !! */ .append(var11_8);
                                            var7_13 /* !! */ .append(" params");
                                            var7_13 /* !! */  = var7_13 /* !! */ .toString();
                                            this.zzs.zzau().zzd().zzc((String)var7_13 /* !! */ , this.zzs.zzm().zzc(var2_2), this.zzs.zzm().zzf(var3_3));
                                            zzkp.zzan(var10_7, 5);
                                            var10_7.remove(var13_17);
                                            continue block1;
                                        }
                                        continue block1;
                                    }
                                    if (var8_16 == 0 || "_ev".equals(var13_17)) ** GOTO lbl30
                                    if (var8_16 == 21) {
                                        var7_14 = var2_2;
lbl48:
                                        // 2 sources

                                        while (true) {
                                            this.zzI(var10_7, var8_16, var7_14, var13_17, var3_3.get(var13_17));
                                            var10_7.remove(var13_17);
                                            continue block1;
                                            break;
                                        }
                                    }
                                    var7_14 = var13_17;
                                    ** continue;
                                    break;
                                }
                                break;
                            }
                        }
                        var7_12 = 0;
                        ** continue;
                    }
                    var7_12 = 0;
                    ** continue;
                }
                return var10_7;
            }
        }
        var6_9 = var3_3.keySet();
        ** while (true)
    }

    final void zzG(zzen zzen2, int n) {
        TreeSet treeSet = new TreeSet(zzen2.zzd.keySet());
        Iterator iterator = treeSet.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!zzkp.zzh(string) || ++n2 <= n) continue;
            CharSequence charSequence = new StringBuilder(48);
            charSequence.append("Event can't contain more than ");
            charSequence.append(n);
            charSequence.append(" params");
            charSequence = charSequence.toString();
            this.zzs.zzau().zzd().zzc((String)charSequence, this.zzs.zzm().zzc(zzen2.zza), this.zzs.zzm().zzf(zzen2.zzd));
            zzkp.zzan(zzen2.zzd, 5);
            zzen2.zzd.remove(string);
        }
    }

    final void zzH(Bundle bundle, Bundle bundle2) {
        if (bundle2 == null) {
            return;
        }
        for (String string : bundle2.keySet()) {
            if (bundle.containsKey(string)) continue;
            this.zzs.zzl().zzL(bundle, string, bundle2.get(string));
        }
    }

    final void zzI(Bundle bundle, int n, String string, String string2, Object object) {
        if (zzkp.zzan(bundle, n)) {
            this.zzs.zzc();
            bundle.putString("_ev", this.zzC(string, 40, true));
            if (object != null) {
                Preconditions.checkNotNull((Object)bundle);
                if (object instanceof String || object instanceof CharSequence) {
                    bundle.putLong("_el", (long)String.valueOf(object).length());
                    return;
                }
            }
        }
    }

    private final int zzaq(String string) {
        if ("_ldl".equals(string)) {
            this.zzs.zzc();
            return 2048;
        }
        if (!"_id".equals(string)) {
            if (this.zzs.zzc().zzn(null, zzea.zzae) && "_lgclid".equals(string)) {
                this.zzs.zzc();
                return 100;
            }
            this.zzs.zzc();
            return 36;
        }
        this.zzs.zzc();
        return 256;
    }

    /*
     * Enabled aggressive block sorting
     */
    final int zzJ(String string, Object object) {
        boolean bl = "_ldl".equals(string) ? this.zzt("user property referrer", string, this.zzaq(string), object) : this.zzt("user property", string, this.zzaq(string), object);
        if (bl) {
            return 0;
        }
        return 7;
    }

    final Object zzK(String string, Object object) {
        if ("_ldl".equals(string)) {
            return this.zzap(this.zzaq(string), object, true, false);
        }
        return this.zzap(this.zzaq(string), object, false, false);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    final void zzL(Bundle object, String string, Object object2) {
        void var1_3;
        void var2_5;
        void var3_6;
        if (object == null) {
            return;
        }
        if (var3_6 instanceof Long) {
            object.putLong((String)var2_5, ((Long)var3_6).longValue());
            return;
        }
        if (var3_6 instanceof String) {
            object.putString((String)var2_5, String.valueOf(var3_6));
            return;
        }
        if (var3_6 instanceof Double) {
            object.putDouble((String)var2_5, ((Double)var3_6).doubleValue());
            return;
        }
        if (var3_6 instanceof Bundle[]) {
            object.putParcelableArray((String)var2_5, (Parcelable[])((Bundle[])var3_6));
            return;
        }
        if (var2_5 == null) {
            return;
        }
        if (var3_6 != null) {
            String string2 = var3_6.getClass().getSimpleName();
        } else {
            Object var1_4 = null;
        }
        this.zzs.zzau().zzh().zzc("Not putting event parameter. Invalid value type. name, type", this.zzs.zzm().zzd((String)var2_5), var1_3);
    }

    final void zzM(zzko zzko2, String string, int n, String string2, String string3, int n2, boolean bl) {
        Bundle bundle = new Bundle();
        zzkp.zzan(bundle, n);
        if (!TextUtils.isEmpty((CharSequence)string2) && !TextUtils.isEmpty((CharSequence)string3)) {
            bundle.putString(string2, string3);
        }
        if (n == 6 || n == 7 || n == 2) {
            bundle.putLong("_el", (long)n2);
        }
        if (bl) {
            zzko2.zza(string, "_err", bundle);
            return;
        }
        this.zzs.zzat();
        this.zzs.zzk().zzs("auto", "_err", bundle);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static MessageDigest zzN() {
        int n = 0;
        while (n < 2) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                if (messageDigest != null) {
                    return messageDigest;
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
            ++n;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @VisibleForTesting
    static long zzO(byte[] byArray) {
        Preconditions.checkNotNull((Object)byArray);
        int n = byArray.length;
        int n2 = n > 0 ? 1 : 0;
        Preconditions.checkState(n2 != 0);
        long l = 0L;
        n2 = 0;
        for (int i = n + -1; i >= 0 && i >= byArray.length + -8; n2 += 8, --i) {
            long l2 = l + (((long)byArray[i] & 0xFFL) << n2);
            l = l2;
        }
        return l;
    }

    static boolean zzP(Context context, boolean bl) {
        Preconditions.checkNotNull((Object)context);
        if (Build.VERSION.SDK_INT >= 24) {
            return zzkp.zzar(context, "com.google.android.gms.measurement.AppMeasurementJobService");
        }
        return zzkp.zzar(context, "com.google.android.gms.measurement.AppMeasurementService");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean zzar(Context context, String string) {
        block6: {
            PackageManager packageManager;
            block5: {
                try {
                    packageManager = context.getPackageManager();
                    if (packageManager != null) break block5;
                    return false;
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    return false;
                }
            }
            ComponentName componentName = new ComponentName(context, string);
            context = packageManager.getServiceInfo(componentName, 0);
            if (context == null) break block6;
            boolean bl = context.enabled;
            if (!bl) break block6;
            return true;
        }
        return false;
    }

    @WorkerThread
    final boolean zzQ(String string) {
        this.zzg();
        if (Wrappers.packageManager((Context)this.zzs.zzax()).checkCallingOrSelfPermission(string) == 0) {
            return true;
        }
        this.zzs.zzau().zzj().zzb("Permission not granted", string);
        return false;
    }

    static boolean zzR(String string) {
        return !TextUtils.isEmpty((CharSequence)string) && string.startsWith("_");
    }

    static boolean zzS(String string, String string2) {
        if (string != null || string2 != null) {
            if (string == null) {
                return false;
            }
            return string.equals(string2);
        }
        return true;
    }

    final boolean zzT(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        Object object = this.zzs;
        object = ((zzfp)object).zzc();
        object = ((zzae)object).zzu();
        this.zzs.zzat();
        return ((String)object).equals(string);
    }

    final Bundle zzU(Bundle bundle) {
        Bundle bundle2 = new Bundle();
        if (bundle != null) {
            for (String string : bundle.keySet()) {
                Object object = this.zzE(string, bundle.get(string));
                if (object == null) {
                    this.zzs.zzau().zzh().zzb("Param value can't be null", this.zzs.zzm().zzd(string));
                    continue;
                }
                this.zzL(bundle2, string, object);
            }
        }
        return bundle2;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    final zzas zzV(String object, String string, Bundle object2, String string2, long l, boolean bl, boolean bl2) {
        void var5_11;
        void var7_12;
        void var4_10;
        void var3_7;
        void var3_5;
        Object object3;
        void var2_4;
        if (TextUtils.isEmpty((CharSequence)var2_4)) {
            return null;
        }
        if (((zzkp)object3).zzn((String)var2_4) != 0) {
            ((zzgi)object3).zzs.zzau().zzb().zzb("Invalid conditional property event name", ((zzgi)object3).zzs.zzm().zze((String)var2_4));
            object3 = new IllegalArgumentException();
            throw object3;
        }
        if (var3_5 != null) {
            Bundle bundle;
            Bundle bundle2 = bundle = new Bundle((Bundle)var3_5);
        } else {
            Bundle bundle = new Bundle();
        }
        var3_7.putString("_o", (String)var4_10);
        Bundle bundle = ((zzkp)object3).zzF((String)object, (String)var2_4, (Bundle)var3_7, CollectionUtils.listOf((Object)"_o"), false);
        object3 = var7_12 != false ? ((zzkp)object3).zzU(bundle) : bundle;
        Preconditions.checkNotNull((Object)object3);
        zzaq zzaq2 = new zzaq((Bundle)object3);
        return new zzas((String)var2_4, zzaq2, (String)var4_10, (long)var5_11);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    final boolean zzW(Context signature, String signatureArray) {
        X500Principal x500Principal = new X500Principal("CN=Android Debug,O=Android,C=US");
        signature = Wrappers.packageManager((Context)signature).getPackageInfo((String)signatureArray, 64);
        if (signature == null) return true;
        signatureArray = signature.signatures;
        if (signatureArray == null) return true;
        int n = signature.signatures.length;
        if (n <= 0) return true;
        try {
            signature = signature.signatures;
            signature = signature[0];
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(signature.toByteArray());
            return ((X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream)).getSubjectX500Principal().equals(x500Principal);
        }
        catch (CertificateException certificateException) {
            this.zzs.zzau().zzb().zzb("Error obtaining certificate", certificateException);
            return true;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            this.zzs.zzau().zzb().zzb("Package name not found", (Object)nameNotFoundException);
            return true;
        }
    }

    final byte[] zzX(Parcelable object) {
        if (object == null) {
            return null;
        }
        zzkp zzkp2 = Parcel.obtain();
        try {
            object.writeToParcel((Parcel)zzkp2, 0);
            object = zzkp2.marshall();
        }
        finally {
            zzkp2.recycle();
        }
        return object;
    }

    private static boolean zzas(String string, String[] stringArray) {
        Preconditions.checkNotNull((Object)stringArray);
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (!zzkp.zzS(string, stringArray[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean zzY(String string) {
        return !zzc[0].equals(string);
    }

    @EnsuresNonNull(value={"this.apkVersion"})
    public final int zzZ() {
        if (this.zzg == null) {
            this.zzg = GoogleApiAvailabilityLight.getInstance().getApkVersion(this.zzs.zzax()) / 1000;
        }
        return this.zzg;
    }

    public final int zzaa(int n) {
        return GoogleApiAvailabilityLight.getInstance().isGooglePlayServicesAvailable(this.zzs.zzax(), 12451000);
    }

    public final long zzab(long l, long l2) {
        return (l + l2 * 60000L) / 86400000L;
    }

    @WorkerThread
    final void zzac(Bundle bundle, long l) {
        long l2 = bundle.getLong("_et");
        if (l2 != 0L) {
            this.zzs.zzau().zze().zzb("Params already contained engagement", l2);
        }
        bundle.putLong("_et", l + l2);
    }

    public final void zzad(zzt zzt2, String string) {
        Bundle bundle = new Bundle();
        bundle.putString("r", string);
        try {
            zzt2.zzb(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzs.zzau().zze().zzb("Error returning string value to wrapper", (Object)remoteException);
            return;
        }
    }

    public final void zzae(zzt zzt2, long l) {
        Bundle bundle = new Bundle();
        bundle.putLong("r", l);
        try {
            zzt2.zzb(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzs.zzau().zze().zzb("Error returning long value to wrapper", (Object)remoteException);
            return;
        }
    }

    public final void zzaf(zzt zzt2, int n) {
        Bundle bundle = new Bundle();
        bundle.putInt("r", n);
        try {
            zzt2.zzb(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzs.zzau().zze().zzb("Error returning int value to wrapper", (Object)remoteException);
            return;
        }
    }

    public final void zzag(zzt zzt2, byte[] byArray) {
        Bundle bundle = new Bundle();
        bundle.putByteArray("r", byArray);
        try {
            zzt2.zzb(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzs.zzau().zze().zzb("Error returning byte array to wrapper", (Object)remoteException);
            return;
        }
    }

    public final void zzah(zzt zzt2, boolean bl) {
        Bundle bundle = new Bundle();
        bundle.putBoolean("r", bl);
        try {
            zzt2.zzb(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzs.zzau().zze().zzb("Error returning boolean value to wrapper", (Object)remoteException);
            return;
        }
    }

    public final void zzai(zzt zzt2, Bundle bundle) {
        try {
            zzt2.zzb(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzs.zzau().zze().zzb("Error returning bundle value to wrapper", (Object)remoteException);
            return;
        }
    }

    public final void zzaj(zzt zzt2, ArrayList<Bundle> arrayList) {
        Bundle bundle = new Bundle();
        bundle.putParcelableArrayList("r", arrayList);
        try {
            zzt2.zzb(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzs.zzau().zze().zzb("Error returning bundle list to wrapper", (Object)remoteException);
            return;
        }
    }

    public static ArrayList<Bundle> zzak(List<zzaa> object) {
        if (object == null) {
            object = new ArrayList(0);
            return object;
        }
        ArrayList<Bundle> arrayList = new ArrayList<Bundle>(object.size());
        object = object.iterator();
        while (object.hasNext()) {
            AbstractSafeParcelable abstractSafeParcelable = (zzaa)((Object)object.next());
            Bundle bundle = new Bundle();
            bundle.putString("app_id", abstractSafeParcelable.zza);
            bundle.putString("origin", abstractSafeParcelable.zzb);
            bundle.putLong("creation_timestamp", abstractSafeParcelable.zzd);
            bundle.putString("name", abstractSafeParcelable.zzc.zzb);
            zzgl.zza((Bundle)bundle, (Object)abstractSafeParcelable.zzc.zza());
            bundle.putBoolean("active", abstractSafeParcelable.zze);
            Object object2 = abstractSafeParcelable.zzf;
            if (object2 != null) {
                bundle.putString("trigger_event_name", object2);
            }
            if ((object2 = abstractSafeParcelable.zzg) != null) {
                bundle.putString("timed_out_event_name", ((zzas)((Object)object2)).zza);
                object2 = abstractSafeParcelable.zzg.zzb;
                if (object2 != null) {
                    bundle.putBundle("timed_out_event_params", ((zzaq)object2).zzf());
                }
            }
            bundle.putLong("trigger_timeout", abstractSafeParcelable.zzh);
            object2 = abstractSafeParcelable.zzi;
            if (object2 != null) {
                bundle.putString("triggered_event_name", ((zzas)((Object)object2)).zza);
                object2 = abstractSafeParcelable.zzi.zzb;
                if (object2 != null) {
                    bundle.putBundle("triggered_event_params", ((zzaq)object2).zzf());
                }
            }
            bundle.putLong("triggered_timestamp", abstractSafeParcelable.zzc.zzc);
            bundle.putLong("time_to_live", abstractSafeParcelable.zzj);
            object2 = abstractSafeParcelable.zzk;
            if (object2 != null) {
                bundle.putString("expired_event_name", ((zzas)((Object)object2)).zza);
                abstractSafeParcelable = abstractSafeParcelable.zzk.zzb;
                if (abstractSafeParcelable != null) {
                    bundle.putBundle("expired_event_params", abstractSafeParcelable.zzf());
                }
            }
            arrayList.add(bundle);
        }
        return arrayList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final URL zzal(long l, String string, String object, long l2) {
        Object object2;
        block4: {
            Preconditions.checkNotEmpty((String)object);
            Preconditions.checkNotEmpty((String)string);
            Object object3 = new Object[4];
            Object[] objectArray = new Object[]{39065L, this.zzZ()};
            object3[0] = String.format("v%s.%s", objectArray);
            object3[1] = object;
            object3[2] = string;
            object3[3] = l2;
            object = String.format("https://www.googleadservices.com/pagead/conversion/app/deeplink?id_type=adid&sdk_version=%s&rdid=%s&bundleid=%s&retry=%s", (Object[])object3);
            object3 = this.zzs.zzc();
            boolean bl = string.equals(((zzae)object3).zzv());
            if (!bl) break block4;
            try {
                object2 = ((String)object).concat("&ddl_test=1");
                return new URL((String)object2);
            }
            catch (IllegalArgumentException | MalformedURLException exception) {
                this.zzs.zzau().zzb().zzb("Failed to create BOW URL for Deferred Deep Link. exception", exception.getMessage());
                return null;
            }
        }
        object2 = object;
        return new URL((String)object2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean zzam(Context context) {
        block6: {
            PackageManager packageManager;
            block5: {
                Preconditions.checkNotNull((Object)context);
                try {
                    packageManager = context.getPackageManager();
                    if (packageManager != null) break block5;
                    return false;
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    return false;
                }
            }
            ComponentName componentName = new ComponentName(context, "com.google.android.gms.measurement.AppMeasurementReceiver");
            context = packageManager.getReceiverInfo(componentName, 0);
            if (context == null) break block6;
            boolean bl = context.enabled;
            if (!bl) break block6;
            return true;
        }
        return false;
    }

    static {
        String[] stringArray = new String[]{"firebase_", "google_", "ga_"};
        zzb = stringArray;
        stringArray = new String[]{"_err"};
        zzc = stringArray;
    }

    static final boolean zzan(Bundle bundle, int n) {
        if (bundle.getLong("_err") == 0L) {
            bundle.putLong("_err", (long)n);
            return true;
        }
        return false;
    }

    @VisibleForTesting
    static final boolean zzao(String string) {
        Preconditions.checkNotNull((Object)string);
        return string.matches("^(1:\\d+:android:[a-f0-9]+|ca-app-pub-.*)$");
    }
}

