/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.GuardedBy;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zzaf;
import com.google.android.gms.measurement.internal.zzev;
import com.google.android.gms.measurement.internal.zzew;
import com.google.android.gms.measurement.internal.zzex;
import com.google.android.gms.measurement.internal.zzgf;
import com.google.android.gms.measurement.internal.zzgi;
import com.google.android.gms.measurement.internal.zzhc;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;

public final class zzey
extends zzhc {
    private char zza = '\u0000';
    private long zzb = -1L;
    @GuardedBy(value="this")
    private String zzc;
    private final zzew zzd;
    private final zzew zze;
    private final zzew zzf;
    private final zzew zzg;
    private final zzew zzh;
    private final zzew zzi;
    private final zzew zzj;
    private final zzew zzk;
    private final zzew zzl;

    static /* bridge */ /* synthetic */ char zza(zzey zzey2) {
        return zzey2.zza;
    }

    static /* bridge */ /* synthetic */ long zzb(zzey zzey2) {
        return zzey2.zzb;
    }

    public final zzew zzc() {
        return this.zzk;
    }

    public final zzew zzd() {
        return this.zzd;
    }

    public final zzew zze() {
        return this.zzf;
    }

    public final zzew zzh() {
        return this.zze;
    }

    public final zzew zzi() {
        return this.zzj;
    }

    public final zzew zzj() {
        return this.zzl;
    }

    public final zzew zzk() {
        return this.zzg;
    }

    public final zzew zzl() {
        return this.zzi;
    }

    public final zzew zzm() {
        return this.zzh;
    }

    protected static Object zzn(String string) {
        if (string == null) {
            return null;
        }
        zzex zzex2 = new zzex(string);
        return zzex2;
    }

    /*
     * Enabled aggressive block sorting
     */
    static String zzo(boolean bl, String string, Object object, Object object2, Object object3) {
        String string2;
        if (string == null) {
            string = "";
        }
        object = zzey.zzp(bl, object);
        object2 = zzey.zzp(bl, object2);
        object3 = zzey.zzp(bl, object3);
        StringBuilder stringBuilder = new StringBuilder();
        if (!TextUtils.isEmpty((CharSequence)string)) {
            stringBuilder.append(string);
            string2 = ": ";
        } else {
            string2 = "";
        }
        if (!TextUtils.isEmpty((CharSequence)object)) {
            stringBuilder.append(string2);
            stringBuilder.append((String)object);
            string2 = ", ";
        }
        if (!TextUtils.isEmpty((CharSequence)object2)) {
            stringBuilder.append(string2);
            stringBuilder.append((String)object2);
            string2 = ", ";
        }
        if (!TextUtils.isEmpty((CharSequence)object3)) {
            stringBuilder.append(string2);
            stringBuilder.append((String)object3);
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    @VisibleForTesting
    static String zzp(boolean bl, Object object) {
        int n;
        String string;
        StringBuilder stringBuilder;
        if (object == null) {
            return "";
        }
        if (object instanceof Integer) {
            object = (long)((Integer)object).intValue();
        }
        if (object instanceof Long) {
            if (!bl) {
                return object.toString();
            }
            Long l = (Long)object;
            if (Math.abs(l) < 100L) {
                return object.toString();
            }
            String string2 = object.toString().charAt(0) == '-' ? "-" : "";
            object = String.valueOf(Math.abs(l));
            int n2 = ((String)object).length();
            double d = Math.pow(10.0, n2 + -1);
            long l2 = Math.round(d);
            int n3 = ((String)object).length();
            double d2 = Math.pow(10.0, n3);
            long l3 = Math.round(d2 + -1.0);
            StringBuilder stringBuilder2 = new StringBuilder();
            stringBuilder2.append(string2);
            stringBuilder2.append(l2);
            stringBuilder2.append("...");
            stringBuilder2.append(string2);
            stringBuilder2.append(l3);
            return stringBuilder2.toString();
        }
        if (object instanceof Boolean) {
            return object.toString();
        }
        if (object instanceof Throwable) {
            object = (Throwable)object;
            String string3 = bl ? object.getClass().getName() : ((Throwable)object).toString();
            stringBuilder = new StringBuilder(string3);
            string = zzey.zzy(zzgi.class.getCanonicalName());
            object = ((Throwable)object).getStackTrace();
            n = ((Object)object).length;
        } else {
            if (object instanceof zzex) {
                return zzex.zza((zzex)object);
            }
            if (!bl) return object.toString();
            return "-";
        }
        for (int i = 0; i < n; ++i) {
            String string4;
            Object object2 = object[i];
            if (((StackTraceElement)object2).isNativeMethod() || (string4 = ((StackTraceElement)object2).getClassName()) == null || !zzey.zzy(string4).equals(string)) continue;
            stringBuilder.append(": ");
            stringBuilder.append(object2);
            return stringBuilder.toString();
        }
        return stringBuilder.toString();
    }

    private static String zzy(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return "";
        }
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @EnsuresNonNull(value={"logTagDoNotUseDirectly"})
    @VisibleForTesting
    protected final String zzq() {
        synchronized (this) {
            Object object = this.zzc;
            if (object == null) {
                object = this.zzs.zzy();
                if (object != null) {
                    this.zzc = this.zzs.zzy();
                } else {
                    object = this.zzs.zzf();
                    this.zzc = ((zzaf)object).zzn();
                }
            }
            Preconditions.checkNotNull((Object)this.zzc);
            return this.zzc;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    static /* bridge */ /* synthetic */ void zzr(zzey zzey2, long l) {
        zzey2.zzb = 61000L;
    }

    static /* bridge */ /* synthetic */ void zzs(zzey zzey2, char c) {
        zzey2.zza = c;
    }

    zzey(zzgi object) {
        super((zzgi)object);
        this.zzd = object = new zzew(this, 6, false, false);
        this.zze = object = new zzew(this, 6, true, false);
        this.zzf = object = new zzew(this, 6, false, true);
        this.zzg = object = new zzew(this, 5, false, false);
        this.zzh = object = new zzew(this, 5, true, false);
        this.zzi = object = new zzew(this, 5, false, true);
        this.zzj = object = new zzew(this, 4, false, false);
        this.zzk = object = new zzew(this, 3, false, false);
        this.zzl = object = new zzew(this, 2, false, false);
    }

    protected final void zzt(int n, boolean bl, boolean bl2, String string, Object object, Object object2, Object object3) {
        if (!bl && Log.isLoggable((String)this.zzq(), (int)n)) {
            String string2 = zzey.zzo(false, string, object, object2, object3);
            Log.println((int)n, (String)this.zzq(), (String)string2);
        }
        if (!bl2 && n >= 5) {
            Preconditions.checkNotNull((Object)string);
            zzgf zzgf2 = this.zzs.zzo();
            if (zzgf2 == null) {
                Log.println((int)6, (String)this.zzq(), (String)"Scheduler not set. Not logging error/warn");
                return;
            }
            if (!zzgf2.zzx()) {
                Log.println((int)6, (String)this.zzq(), (String)"Scheduler not initialized. Not logging error/warn");
                return;
            }
            if (n >= 9) {
                n = 8;
            }
            zzev zzev2 = new zzev(this, n, string, object, object2, object3);
            zzgf2.zzp(zzev2);
            return;
        }
    }

    @Override
    protected final boolean zzf() {
        return false;
    }
}

