/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.os.Looper;
import android.os.RemoteException;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.internal.BaseGmsClient;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zzem;
import com.google.android.gms.measurement.internal.zzeo;
import com.google.android.gms.measurement.internal.zzeu;
import com.google.android.gms.measurement.internal.zzey;
import com.google.android.gms.measurement.internal.zzgf;
import com.google.android.gms.measurement.internal.zzgi;
import com.google.android.gms.measurement.internal.zzhb;
import com.google.android.gms.measurement.internal.zzhd;
import com.google.android.gms.measurement.internal.zzjv;
import com.google.android.gms.measurement.internal.zzjw;
import com.google.android.gms.measurement.internal.zzjx;
import com.google.android.gms.measurement.internal.zzjy;
import com.google.android.gms.measurement.internal.zzjz;
import com.google.android.gms.measurement.internal.zzkb;

@VisibleForTesting
public final class zzka
implements ServiceConnection,
BaseGmsClient.BaseConnectionCallbacks,
BaseGmsClient.BaseOnConnectionFailedListener {
    private volatile boolean zzb;
    private volatile zzeu zzc;
    final /* synthetic */ zzkb zza;

    static /* bridge */ /* synthetic */ void zza(zzka zzka2, boolean bl) {
        zzka2.zzb = false;
    }

    protected zzka(zzkb zzkb2) {
        this.zza = zzkb2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    public final void zzb(Intent object) {
        ((zzhb)this.zza).zzg();
        Context context = this.zza.zzs.zzav();
        ConnectionTracker connectionTracker = ConnectionTracker.getInstance();
        synchronized (this) {
            boolean bl = this.zzb;
            if (bl) {
                object = this.zza;
                object = ((zzhb)object).zzs.zzaz();
                ((zzey)object).zzj().zza("Connection attempt already in progress");
                return;
            }
            zzhb zzhb2 = this.zza;
            zzhb2 = zzhb2.zzs.zzaz();
            ((zzey)zzhb2).zzj().zza("Using local app measurement service");
            this.zzb = true;
            connectionTracker.bindService(context, (Intent)object, (ServiceConnection)zzkb.zzi(this.zza), 129);
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    public final void zzc() {
        ((zzhb)this.zza).zzg();
        Object object = this.zza.zzs.zzav();
        synchronized (this) {
            zzeu zzeu2;
            boolean bl;
            boolean bl2 = this.zzb;
            if (bl2) {
                object = this.zza;
                object = ((zzhb)object).zzs.zzaz();
                ((zzey)object).zzj().zza("Connection attempt already in progress");
                return;
            }
            zzeu zzeu3 = this.zzc;
            if (zzeu3 != null && ((bl = this.zzc.isConnecting()) || (bl = this.zzc.isConnected()))) {
                object = this.zza;
                object = ((zzhb)object).zzs.zzaz();
                ((zzey)object).zzj().zza("Already awaiting connection attempt");
                return;
            }
            this.zzc = zzeu2 = new zzeu((Context)object, Looper.getMainLooper(), this, this);
            object = this.zza;
            object = ((zzhb)object).zzs.zzaz();
            ((zzey)object).zzj().zza("Connecting to remote service");
            this.zzb = true;
            Preconditions.checkNotNull((Object)((Object)this.zzc));
            this.zzc.checkAvailabilityAndConnect();
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    @WorkerThread
    public final void zzd() {
        if (this.zzc != null && (this.zzc.isConnected() || this.zzc.isConnecting())) {
            this.zzc.disconnect();
        }
        this.zzc = null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @MainThread
    public final void onConnected(Bundle object) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnected");
        // MONITORENTER : this
        try {
            Preconditions.checkNotNull((Object)((Object)this.zzc));
            object = (zzeo)this.zzc.getService();
            zzhb zzhb2 = this.zza;
            zzhb2 = zzhb2.zzs.zzaA();
            zzjx zzjx2 = new zzjx(this, (zzeo)object);
            ((zzgf)zzhb2).zzp(zzjx2);
            // MONITOREXIT : this
            return;
        }
        catch (DeadObjectException | IllegalStateException throwable) {
            this.zzc = null;
            this.zzb = false;
            return;
            {
                catch (Throwable throwable2) {}
                {
                    // MONITOREXIT : this
                    throw throwable2;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @MainThread
    public final void onConnectionFailed(@NonNull ConnectionResult object) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnectionFailed");
        Object object2 = this.zza.zzs.zzl();
        if (object2 != null) {
            ((zzey)object2).zzk().zzb("Service connection failed", object);
        }
        synchronized (this) {
            this.zzb = false;
            this.zzc = null;
            // MONITOREXIT @DISABLED, blocks:[0, 2] lbl9 : MonitorExitStatement: MONITOREXIT : this
            object = this.zza;
            object = ((zzhb)object).zzs;
            object = ((zzgi)object).zzaA();
            object2 = new zzjz(this);
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
        ((zzgf)object).zzp((Runnable)object2);
    }

    @MainThread
    public final void onConnectionSuspended(int n) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnectionSuspended");
        this.zza.zzs.zzaz().zzc().zza("Service connection suspended");
        zzhd zzhd2 = this.zza;
        zzhd2 = ((zzhb)zzhd2).zzs;
        zzhd2 = ((zzgi)zzhd2).zzaA();
        zzjy zzjy2 = new zzjy(this);
        ((zzgf)zzhd2).zzp(zzjy2);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @MainThread
    public final void onServiceConnected(ComponentName object, IBinder object2) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onServiceConnected");
        // MONITORENTER : this
        if (object2 == null) {
            this.zzb = false;
            object = this.zza;
            object = ((zzhb)object).zzs.zzaz();
            ((zzey)object).zzd().zza("Service connected with null binder");
            // MONITOREXIT : this
            return;
        }
        try {
            object = object2.getInterfaceDescriptor();
            boolean bl = "com.google.android.gms.measurement.internal.IMeasurementService".equals(object);
            if (bl) {
                object = object2.queryLocalInterface("com.google.android.gms.measurement.internal.IMeasurementService");
                bl = object instanceof zzeo;
                object = bl ? (zzeo)object : new zzem((IBinder)object2);
                object2 = this.zza;
                object2 = ((zzhb)object2).zzs.zzaz();
                ((zzey)object2).zzj().zza("Bound to IMeasurementService interface");
                object2 = object;
            } else {
                object2 = this.zza;
                object2 = ((zzhb)object2).zzs.zzaz();
                ((zzey)object2).zzd().zzb("Got binder with a wrong descriptor", object);
                object2 = null;
            }
            object = object2;
        }
        catch (RemoteException remoteException) {
            block14: {
                object = null;
                break block14;
                catch (RemoteException remoteException2) {}
            }
            object2 = this.zza;
            object2 = ((zzhb)object2).zzs.zzaz();
            ((zzey)object2).zzd().zza("Service connect failed to get IMeasurementService");
        }
        if (object != null) {
            object2 = this.zza;
            object2 = ((zzhb)object2).zzs.zzaA();
            zzjv zzjv2 = new zzjv(this, (zzeo)object);
            ((zzgf)object2).zzp(zzjv2);
            return;
        }
        this.zzb = false;
        try {
            object = ConnectionTracker.getInstance();
            object2 = this.zza;
            object2 = ((zzhb)object2).zzs.zzav();
            object.unbindService((Context)object2, (ServiceConnection)zzkb.zzi(this.zza));
            // MONITOREXIT : this
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
    }

    @MainThread
    public final void onServiceDisconnected(ComponentName componentName) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onServiceDisconnected");
        this.zza.zzs.zzaz().zzc().zza("Service disconnected");
        zzhd zzhd2 = this.zza;
        zzhd2 = ((zzhb)zzhd2).zzs;
        zzhd2 = ((zzgi)zzhd2).zzaA();
        zzjw zzjw2 = new zzjw(this, componentName);
        ((zzgf)zzhd2).zzp(zzjw2);
    }
}

