/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.RemoteException;
import android.util.Pair;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzcf;
import com.google.android.gms.measurement.internal.zzac;
import com.google.android.gms.measurement.internal.zzap;
import com.google.android.gms.measurement.internal.zzaw;
import com.google.android.gms.measurement.internal.zze;
import com.google.android.gms.measurement.internal.zzeg;
import com.google.android.gms.measurement.internal.zzej;
import com.google.android.gms.measurement.internal.zzek;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzfi;
import com.google.android.gms.measurement.internal.zzgd;
import com.google.android.gms.measurement.internal.zzgw;
import com.google.android.gms.measurement.internal.zzip;
import com.google.android.gms.measurement.internal.zziy;
import com.google.android.gms.measurement.internal.zziz;
import com.google.android.gms.measurement.internal.zzja;
import com.google.android.gms.measurement.internal.zzjb;
import com.google.android.gms.measurement.internal.zzjc;
import com.google.android.gms.measurement.internal.zzjd;
import com.google.android.gms.measurement.internal.zzje;
import com.google.android.gms.measurement.internal.zzjf;
import com.google.android.gms.measurement.internal.zzjg;
import com.google.android.gms.measurement.internal.zzjh;
import com.google.android.gms.measurement.internal.zzji;
import com.google.android.gms.measurement.internal.zzjj;
import com.google.android.gms.measurement.internal.zzjk;
import com.google.android.gms.measurement.internal.zzjl;
import com.google.android.gms.measurement.internal.zzjm;
import com.google.android.gms.measurement.internal.zzjn;
import com.google.android.gms.measurement.internal.zzjo;
import com.google.android.gms.measurement.internal.zzjp;
import com.google.android.gms.measurement.internal.zzjq;
import com.google.android.gms.measurement.internal.zzjw;
import com.google.android.gms.measurement.internal.zzko;
import com.google.android.gms.measurement.internal.zzli;
import com.google.android.gms.measurement.internal.zzq;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

@VisibleForTesting
public final class zzjx
extends zzf {
    private final zzjw zza;
    private zzej zzb;
    private volatile Boolean zzc;
    private final zzap zzd;
    private final zzko zze;
    private final List zzf = new ArrayList();
    private final zzap zzg;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @WorkerThread
    private final zzq zzO(boolean bl) {
        Object object;
        ((zzgw)object).zzt.zzay();
        zzek zzek2 = ((zze)object).zzt.zzh();
        if (bl) {
            object = ((zzgw)object).zzt.zzaA();
            if (((zzgw)object).zzt.zzm().zzb == null) {
                object = null;
                return zzek2.zzj((String)object);
            }
            object = ((zzgw)object).zzt.zzm().zzb.zza();
            if (object != null) {
                if (object == zzfi.zza) {
                    object = null;
                    return zzek2.zzj((String)object);
                }
                String string = String.valueOf(((Pair)object).second);
                String string2 = (String)((Pair)object).first;
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(string);
                stringBuilder.append(":");
                stringBuilder.append(string2);
                object = stringBuilder.toString();
                return zzek2.zzj((String)object);
            }
            object = null;
            return zzek2.zzj((String)object);
        }
        object = null;
        return zzek2.zzj((String)object);
    }

    static /* bridge */ /* synthetic */ zzej zzh(zzjx zzjx2) {
        return zzjx2.zzb;
    }

    static /* bridge */ /* synthetic */ zzjw zzi(zzjx zzjx2) {
        return zzjx2.zza;
    }

    final Boolean zzj() {
        return this.zzc;
    }

    static /* bridge */ /* synthetic */ void zzl(zzjx zzjx2, zzej zzej2) {
        zzjx2.zzb = null;
    }

    static /* bridge */ /* synthetic */ void zzm(zzjx zzjx2) {
        zzjx2.zzP();
    }

    static /* bridge */ /* synthetic */ void zzo(zzjx zzjx2, ComponentName componentName) {
        ((zzgw)zzjx2).zzg();
        if (zzjx2.zzb != null) {
            zzjx2.zzb = null;
            zzjx2.zzt.zzaA().zzj().zzb("Disconnected from device MeasurementService", componentName);
            ((zzgw)zzjx2).zzg();
            zzjx2.zzr();
            return;
        }
    }

    static /* bridge */ /* synthetic */ void zzp(zzjx zzjx2) {
        zzjx2.zzQ();
    }

    protected zzjx(zzgd zzgd2) {
        super(zzgd2);
        this.zze = new zzko(zzgd2.zzax());
        this.zza = new zzjw(this);
        this.zzd = new zzjh(this, zzgd2);
        this.zzg = new zzjj(this, zzgd2);
    }

    @WorkerThread
    protected final void zzq() {
        ((zzgw)this).zzg();
        this.zza();
        zzq zzq2 = this.zzO(true);
        this.zzt.zzi().zzk();
        zzjx zzjx2 = this;
        zzjx2.zzR(new zzje(zzjx2, zzq2));
    }

    @WorkerThread
    final void zzr() {
        ((zzgw)this).zzg();
        this.zza();
        if (this.zzL()) {
            return;
        }
        if (!this.zzN()) {
            if (!this.zzt.zzf().zzx()) {
                this.zzt.zzay();
                List list = this.zzt.zzaw().getPackageManager().queryIntentServices(new Intent().setClassName(this.zzt.zzaw(), "com.google.android.gms.measurement.AppMeasurementService"), 65536);
                if (list != null && !list.isEmpty()) {
                    list = new Intent("com.google.android.gms.measurement.START");
                    Context context = this.zzt.zzaw();
                    this.zzt.zzay();
                    list.setComponent(new ComponentName(context, "com.google.android.gms.measurement.AppMeasurementService"));
                    this.zza.zzb((Intent)list);
                    return;
                }
                this.zzt.zzaA().zzd().zza("Unable to use remote or local measurement implementation. Please register the AppMeasurementService service in the app manifest");
                return;
            }
            return;
        }
        this.zza.zzc();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    public final void zzs() {
        ((zzgw)this).zzg();
        this.zza();
        this.zza.zzd();
        try {
            ConnectionTracker connectionTracker = ConnectionTracker.getInstance();
            Context context = this.zzt.zzaw();
            connectionTracker.unbindService(context, (ServiceConnection)this.zza);
        }
        catch (IllegalArgumentException | IllegalStateException runtimeException) {}
        this.zzb = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    private final void zzP() {
        ((zzgw)this).zzg();
        Object object = this.zzf.size();
        this.zzt.zzaA().zzj().zzb("Processing queued up service tasks", object);
        object = this.zzf.iterator();
        while (true) {
            if (!object.hasNext()) {
                this.zzf.clear();
                this.zzg.zzb();
                return;
            }
            Runnable runnable = (Runnable)object.next();
            try {
                runnable.run();
                continue;
            }
            catch (RuntimeException runtimeException) {
                this.zzt.zzaA().zzd().zzb("Task exception while flushing queue", runtimeException);
                continue;
            }
            break;
        }
    }

    @WorkerThread
    public final void zzt(zzcf zzcf2) {
        ((zzgw)this).zzg();
        this.zza();
        zzq zzq2 = this.zzO(false);
        zzjx zzjx2 = this;
        zzjx2.zzR(new zzjd(zzjx2, zzq2, zzcf2));
    }

    @WorkerThread
    public final void zzu(AtomicReference atomicReference) {
        ((zzgw)this).zzg();
        this.zza();
        zzq zzq2 = this.zzO(false);
        zzjx zzjx2 = this;
        zzjx2.zzR(new zzjc(zzjx2, atomicReference, zzq2));
    }

    @WorkerThread
    protected final void zzv(zzcf zzcf2, String string, String string2) {
        ((zzgw)this).zzg();
        this.zza();
        zzq zzq2 = this.zzO(false);
        zzjx zzjx2 = this;
        zzjx2.zzR(new zzjp(zzjx2, string, string2, zzq2, zzcf2));
    }

    @WorkerThread
    protected final void zzw(AtomicReference atomicReference, String object, String string, String string2) {
        ((zzgw)this).zzg();
        this.zza();
        object = this.zzO(false);
        zzjx zzjx2 = this;
        zzjx2.zzR(new zzjo(zzjx2, atomicReference, null, string, string2, (zzq)((Object)object)));
    }

    @WorkerThread
    protected final void zzx(AtomicReference atomicReference, boolean bl) {
        ((zzgw)this).zzg();
        this.zza();
        zzq zzq2 = this.zzO(false);
        zzjx zzjx2 = this;
        zzjx2.zzR(new zziz(zzjx2, atomicReference, zzq2, bl));
    }

    @WorkerThread
    protected final void zzy(zzcf zzcf2, String string, String string2, boolean bl) {
        ((zzgw)this).zzg();
        this.zza();
        zzq zzq2 = this.zzO(false);
        zzjx zzjx2 = this;
        zzjx2.zzR(new zziy(zzjx2, string, string2, zzq2, bl, zzcf2));
    }

    @WorkerThread
    protected final void zzz(AtomicReference atomicReference, String object, String string, String string2, boolean bl) {
        ((zzgw)this).zzg();
        this.zza();
        object = this.zzO(false);
        zzjx zzjx2 = this;
        zzjx2.zzR(new zzjq(zzjx2, atomicReference, null, string, string2, (zzq)((Object)object), bl));
    }

    @WorkerThread
    protected final void zzA(zzaw zzaw2, String string) {
        Preconditions.checkNotNull((Object)((Object)zzaw2));
        ((zzgw)this).zzg();
        this.zza();
        this.zzS();
        boolean bl = this.zzt.zzi().zzo(zzaw2);
        zzq zzq2 = this.zzO(true);
        zzjx zzjx2 = this;
        zzjx2.zzR(new zzjm(zzjx2, true, zzq2, bl, zzaw2, string));
    }

    @WorkerThread
    public final void zzB(zzcf zzcf2, zzaw zzaw2, String string) {
        ((zzgw)this).zzg();
        this.zza();
        if (this.zzt.zzv().zzo(12451000) != 0) {
            this.zzt.zzaA().zzk().zza("Not bundling data. Service unavailable or out of date");
            this.zzt.zzv().zzT(zzcf2, new byte[0]);
            return;
        }
        zzjx zzjx2 = this;
        zzjx2.zzR(new zzji(zzjx2, zzaw2, string, zzcf2));
    }

    @WorkerThread
    private final void zzQ() {
        ((zzgw)this).zzg();
        this.zze.zzb();
        this.zzt.zzf();
        this.zzd.zzd((Long)zzeg.zzJ.zza(null));
    }

    @WorkerThread
    protected final void zzC() {
        ((zzgw)this).zzg();
        this.zza();
        zzq zzq2 = this.zzO(false);
        this.zzS();
        this.zzt.zzi().zzj();
        zzjx zzjx2 = this;
        zzjx2.zzR(new zzjb(zzjx2, zzq2));
    }

    @WorkerThread
    private final void zzR(Runnable runnable) throws IllegalStateException {
        ((zzgw)this).zzg();
        if (this.zzL()) {
            runnable.run();
            return;
        }
        long l = this.zzf.size();
        this.zzt.zzf();
        if (l >= 1000L) {
            this.zzt.zzaA().zzd().zza("Discarding data. Max runnable queue size reached");
            return;
        }
        this.zzf.add(runnable);
        this.zzg.zzd(60000L);
        this.zzr();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    @VisibleForTesting
    final void zzD(zzej zzej2, AbstractSafeParcelable abstractSafeParcelable, zzq zzq2) {
        ((zzgw)this).zzg();
        this.zza();
        this.zzS();
        this.zzt.zzf();
        int n = 100;
        int n2 = 0;
        block6: while (true) {
            ArrayList<AbstractSafeParcelable> arrayList;
            if (n2 < 1001 && n == 100) {
                arrayList = new ArrayList<AbstractSafeParcelable>();
                List list = this.zzt.zzi().zzi(100);
                if (list != null) {
                    arrayList.addAll(list);
                    n = list.size();
                } else {
                    n = 0;
                }
                if (abstractSafeParcelable != null && n < 100) {
                    arrayList.add(abstractSafeParcelable);
                }
            } else {
                return;
            }
            int n3 = arrayList.size();
            int n4 = 0;
            while (true) {
                block19: {
                    if (n4 < n3) {
                        AbstractSafeParcelable abstractSafeParcelable2 = (AbstractSafeParcelable)arrayList.get(n4);
                        if (abstractSafeParcelable2 instanceof zzaw) {
                            zzej2.zzk((zzaw)abstractSafeParcelable2, zzq2);
                        }
                        if (abstractSafeParcelable2 instanceof zzli) {
                            zzej2.zzt((zzli)abstractSafeParcelable2, zzq2);
                        }
                        if (abstractSafeParcelable2 instanceof zzac) {
                            zzej2.zzn((zzac)abstractSafeParcelable2, zzq2);
                        } else {
                            this.zzt.zzaA().zzd().zza("Discarding data. Unrecognized parcel type.");
                        }
                    } else {
                        ++n2;
                        continue block6;
                        catch (RemoteException remoteException) {
                            this.zzt.zzaA().zzd().zzb("Failed to send event to the service", (Object)remoteException);
                        }
                    }
                    break block19;
                    catch (RemoteException remoteException) {
                        this.zzt.zzaA().zzd().zzb("Failed to send user property to the service", (Object)remoteException);
                    }
                    break block19;
                    catch (RemoteException remoteException) {
                        this.zzt.zzaA().zzd().zzb("Failed to send conditional user property to the service", (Object)remoteException);
                    }
                }
                ++n4;
            }
            break;
        }
    }

    @WorkerThread
    protected final void zzE(zzac zzac2) {
        Preconditions.checkNotNull((Object)((Object)zzac2));
        ((zzgw)this).zzg();
        this.zza();
        this.zzt.zzay();
        boolean bl = this.zzt.zzi().zzn(zzac2);
        zzac zzac3 = new zzac(zzac2);
        zzq zzq2 = this.zzO(true);
        zzjx zzjx2 = this;
        zzjx2.zzR(new zzjn(zzjx2, true, zzq2, bl, zzac3, zzac2));
    }

    @WorkerThread
    protected final void zzF(boolean bl) {
        ((zzgw)this).zzg();
        this.zza();
        if (bl) {
            this.zzS();
            this.zzt.zzi().zzj();
        }
        if (this.zzM()) {
            zzq zzq2 = this.zzO(false);
            zzjx zzjx2 = this;
            zzjx2.zzR(new zzjl(zzjx2, zzq2));
            return;
        }
    }

    @WorkerThread
    protected final void zzG(zzip zzip2) {
        ((zzgw)this).zzg();
        this.zza();
        zzjx zzjx2 = this;
        zzjx2.zzR(new zzjf(zzjx2, zzip2));
    }

    @WorkerThread
    public final void zzH(Bundle bundle) {
        ((zzgw)this).zzg();
        this.zza();
        zzq zzq2 = this.zzO(false);
        zzjx zzjx2 = this;
        zzjx2.zzR(new zzjg(zzjx2, zzq2, bundle));
    }

    @WorkerThread
    protected final void zzI() {
        ((zzgw)this).zzg();
        this.zza();
        zzq zzq2 = this.zzO(true);
        zzjx zzjx2 = this;
        zzjx2.zzR(new zzjk(zzjx2, zzq2));
    }

    @WorkerThread
    @VisibleForTesting
    protected final void zzJ(zzej zzej2) {
        ((zzgw)this).zzg();
        Preconditions.checkNotNull((Object)zzej2);
        this.zzb = zzej2;
        this.zzQ();
        this.zzP();
    }

    @WorkerThread
    protected final void zzK(zzli zzli2) {
        ((zzgw)this).zzg();
        this.zza();
        this.zzS();
        boolean bl = this.zzt.zzi().zzp(zzli2);
        zzq zzq2 = this.zzO(true);
        zzjx zzjx2 = this;
        zzjx2.zzR(new zzja(zzjx2, zzq2, bl, zzli2));
    }

    @WorkerThread
    public final boolean zzL() {
        ((zzgw)this).zzg();
        this.zza();
        return this.zzb != null;
    }

    @Override
    protected final boolean zzf() {
        return false;
    }

    @WorkerThread
    final boolean zzM() {
        ((zzgw)this).zzg();
        this.zza();
        if (this.zzN()) {
            return this.zzt.zzv().zzm() >= (Integer)zzeg.zzah.zza(null);
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    final boolean zzN() {
        ((zzgw)this).zzg();
        this.zza();
        if (this.zzc == null) {
            boolean bl;
            ((zzgw)this).zzg();
            this.zza();
            Object object = this.zzt.zzm();
            ((zzgw)object).zzg();
            object = !((zzfi)object).zza().contains("use_service") ? null : Boolean.valueOf(((zzfi)object).zza().getBoolean("use_service", false));
            if (object != null && ((Boolean)object).booleanValue()) {
                bl = true;
            } else {
                int n;
                this.zzt.zzay();
                if (this.zzt.zzh().zzh() == 1) {
                    bl = true;
                    n = 1;
                } else {
                    this.zzt.zzaA().zzj().zza("Checking service availability");
                    n = this.zzt.zzv().zzo(12451000);
                    switch (n) {
                        default: {
                            object = n;
                            this.zzt.zzaA().zzk().zzb("Unexpected service status", object);
                            bl = false;
                            n = 0;
                            break;
                        }
                        case 0: {
                            this.zzt.zzaA().zzj().zza("Service available");
                            bl = true;
                            n = 1;
                            break;
                        }
                        case 1: {
                            this.zzt.zzaA().zzj().zza("Service missing");
                            bl = false;
                            n = 1;
                            break;
                        }
                        case 2: {
                            this.zzt.zzaA().zzc().zza("Service container out of date");
                            if (this.zzt.zzv().zzm() < 17443) {
                                bl = false;
                                n = 1;
                                break;
                            }
                            bl = object == null;
                            n = 0;
                            break;
                        }
                        case 3: {
                            this.zzt.zzaA().zzk().zza("Service disabled");
                            bl = false;
                            n = 0;
                            break;
                        }
                        case 9: {
                            this.zzt.zzaA().zzk().zza("Service invalid");
                            bl = false;
                            n = 0;
                            break;
                        }
                        case 18: {
                            this.zzt.zzaA().zzk().zza("Service updating");
                            bl = true;
                            n = 1;
                        }
                    }
                }
                if (!bl && this.zzt.zzf().zzx()) {
                    this.zzt.zzaA().zzd().zza("No way to upload. Consider using the full version of Analytics");
                } else if (n != 0) {
                    zzfi zzfi2 = this.zzt.zzm();
                    zzfi2.zzg();
                    SharedPreferences.Editor editor = zzfi2.zza().edit();
                    editor.putBoolean("use_service", bl);
                    editor.apply();
                }
            }
            this.zzc = bl;
        }
        return this.zzc;
    }

    private final boolean zzS() {
        this.zzt.zzay();
        return true;
    }
}

