/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.os.Bundle;
import android.text.TextUtils;
import androidx.annotation.Size;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.ProcessUtils;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.measurement.internal.zzae;
import com.google.android.gms.measurement.internal.zzaf;
import com.google.android.gms.measurement.internal.zzeg;
import com.google.android.gms.measurement.internal.zzeh;
import com.google.android.gms.measurement.internal.zzeu;
import com.google.android.gms.measurement.internal.zzge;
import com.google.android.gms.measurement.internal.zzgx;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;

public final class zzag
extends zzgx {
    private Boolean zza;
    private zzaf zzb = zzae.zza;
    private Boolean zzc;

    @WorkerThread
    public final double zza(String string, zzeg zzeg2) {
        if (string == null) {
            return (Double)zzeg2.zza(null);
        }
        String string2 = ((zzag)((Object)string2)).zzb.zza(string, zzeg2.zzb());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return (Double)zzeg2.zza(null);
        }
        try {
            double d = (Double)zzeg2.zza(Double.parseDouble(string2));
            return d;
        }
        catch (NumberFormatException numberFormatException) {
            return (Double)zzeg2.zza(null);
        }
    }

    final int zzb(@Size(min=1L) String string) {
        return this.zzf(string, zzeh.zzH, 500, 2000);
    }

    public final int zzc() {
        if (this.zzt.zzv().zzai(201500000, true)) {
            return 100;
        }
        return 25;
    }

    public final int zzd(@Size(min=1L) String string) {
        return this.zzf(string, zzeh.zzI, 25, 100);
    }

    @WorkerThread
    public final int zze(String string, zzeg zzeg2) {
        if (string == null) {
            return (Integer)zzeg2.zza(null);
        }
        String string2 = ((zzag)((Object)string2)).zzb.zza(string, zzeg2.zzb());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return (Integer)zzeg2.zza(null);
        }
        try {
            int n = (Integer)zzeg2.zza(Integer.parseInt(string2));
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            return (Integer)zzeg2.zza(null);
        }
    }

    @WorkerThread
    public final int zzf(String string, zzeg zzeg2, int n, int n2) {
        return Math.max(Math.min(this.zze(string, zzeg2), n2), n);
    }

    public final long zzh() {
        this.zzt.zzay();
        return 77000L;
    }

    @WorkerThread
    public final long zzi(String string, zzeg zzeg2) {
        if (string == null) {
            return (Long)zzeg2.zza(null);
        }
        String string2 = ((zzag)((Object)string2)).zzb.zza(string, zzeg2.zzb());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return (Long)zzeg2.zza(null);
        }
        try {
            long l = (Long)zzeg2.zza(Long.parseLong(string2));
            return l;
        }
        catch (NumberFormatException numberFormatException) {
            return (Long)zzeg2.zza(null);
        }
    }

    @VisibleForTesting
    final Bundle zzj() {
        Object object;
        block7: {
            block6: {
                try {
                    object = zzag2.zzt.zzaw();
                    object = object.getPackageManager();
                    if (object != null) break block6;
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    zzag2.zzt.zzaA().zzd().zzb("Failed to load metadata: Package name not found", (Object)nameNotFoundException);
                    return null;
                }
                object = zzag2.zzt.zzaA();
                ((zzeu)object).zzd().zza("Failed to load metadata: PackageManager is null");
                return null;
            }
            object = zzag2.zzt.zzaw();
            object = Wrappers.packageManager((Context)object);
            Context context = zzag2.zzt.zzaw();
            object = object.getApplicationInfo(context.getPackageName(), 128);
            if (object != null) break block7;
            object = zzag2.zzt.zzaA();
            ((zzeu)object).zzd().zza("Failed to load metadata: ApplicationInfo is null");
            return null;
        }
        zzag zzag2 = ((ApplicationInfo)object).metaData;
        return zzag2;
    }

    @VisibleForTesting
    final Boolean zzk(@Size(min=1L) String string) {
        Preconditions.checkNotEmpty((String)string);
        Bundle bundle = this.zzj();
        if (bundle == null) {
            this.zzt.zzaA().zzd().zza("Failed to load metadata: Metadata bundle is null");
            return null;
        }
        if (!bundle.containsKey(string)) {
            return null;
        }
        return bundle.getBoolean(string);
    }

    public final String zzl() {
        return this.zzB("debug.firebase.analytics.app", "");
    }

    public final String zzm() {
        return this.zzB("debug.deferred.deeplink", "");
    }

    final String zzn() {
        this.zzt.zzay();
        return "FA";
    }

    @WorkerThread
    public final String zzo(String string, zzeg zzeg2) {
        if (string == null) {
            return (String)zzeg2.zza(null);
        }
        zzeg zzeg3 = zzeg2;
        return (String)zzeg3.zza(this.zzb.zza(string, zzeg3.zzb()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String zzB(String string, String string2) {
        string2 = "";
        try {
            string = (String)Class.forName("android.os.SystemProperties").getMethod("get", String.class, String.class).invoke(null, string, string2);
            Preconditions.checkNotNull((Object)string);
            return string;
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.zzt.zzaA().zzd().zzb("Could not find SystemProperties class", classNotFoundException);
            return string2;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.zzt.zzaA().zzd().zzb("Could not find SystemProperties.get() method", noSuchMethodException);
            return string2;
        }
        catch (IllegalAccessException illegalAccessException) {
            this.zzt.zzaA().zzd().zzb("Could not access SystemProperties.get()", illegalAccessException);
            return string2;
        }
        catch (InvocationTargetException invocationTargetException) {
            this.zzt.zzaA().zzd().zzb("SystemProperties.get() threw an exception", invocationTargetException);
            return string2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @VisibleForTesting
    final List zzp(@Size(min=1L) String object) {
        object = "analytics.safelisted_events";
        Preconditions.checkNotEmpty((String)object);
        Bundle bundle = ((zzag)this).zzj();
        if (bundle == null) {
            ((zzgx)this).zzt.zzaA().zzd().zza("Failed to load metadata: Metadata bundle is null");
            return null;
        }
        if (!bundle.containsKey((String)object)) {
            return null;
        }
        object = bundle.getInt((String)object);
        if (object == null) {
            return null;
        }
        try {
            bundle = ((zzgx)this).zzt.zzaw();
            object = bundle.getResources().getStringArray(((Integer)object).intValue());
            if (object != null) return Arrays.asList(object);
            return null;
        }
        catch (Resources.NotFoundException notFoundException) {
            ((zzgx)this).zzt.zzaA().zzd().zzb("Failed to load string array from metadata: resource not found", (Object)notFoundException);
            return null;
        }
    }

    zzag(zzge zzge2) {
        super(zzge2);
    }

    final void zzq(zzaf zzaf2) {
        this.zzb = zzaf2;
    }

    public final boolean zzr() {
        return (this = ((zzag)this).zzk("google_analytics_adid_collection_enabled")) == null || ((Boolean)this).booleanValue();
    }

    @WorkerThread
    public final boolean zzs(String string, zzeg zzeg2) {
        if (string == null) {
            return (Boolean)zzeg2.zza(null);
        }
        String string2 = ((zzag)((Object)string2)).zzb.zza(string, zzeg2.zzb());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return (Boolean)zzeg2.zza(null);
        }
        return (Boolean)zzeg2.zza("1".equals(string2));
    }

    public final boolean zzt(String string) {
        String string2 = "gaia_collection_enabled";
        String string3 = ((zzag)((Object)string3)).zzb.zza(string, string2);
        return "1".equals(string3);
    }

    public final boolean zzu() {
        return (this = ((zzag)this).zzk("google_analytics_automatic_screen_reporting_enabled")) == null || ((Boolean)this).booleanValue();
    }

    public final boolean zzv() {
        ((zzgx)((Object)bl)).zzt.zzay();
        Boolean bl = ((zzag)((Object)bl)).zzk("firebase_analytics_collection_deactivated");
        return bl != null && bl != false;
    }

    public final boolean zzw(String string) {
        String string2 = "measurement.event_sampling_enabled";
        String string3 = ((zzag)((Object)string3)).zzb.zza(string, string2);
        return "1".equals(string3);
    }

    @WorkerThread
    final boolean zzx() {
        if (this.zza == null) {
            this.zza = this.zzk("app_measurement_lite");
            if (this.zza == null) {
                this.zza = false;
            }
        }
        return this.zza != false || !this.zzt.zzN();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @EnsuresNonNull(value={"this.isMainProcess"})
    public final boolean zzy() {
        if (this.zzc != null) return this.zzc;
        synchronized (this) {
            Object object;
            Object object2 = this.zzc;
            if (object2 != null) return this.zzc;
            object2 = this.zzt.zzaw();
            object2 = object2.getApplicationInfo();
            String string = ProcessUtils.getMyProcessName();
            if (object2 != null) {
                boolean bl;
                object2 = ((ApplicationInfo)object2).processName;
                bl = object2 != null ? (bl = ((String)object2).equals(string)) : false;
                this.zzc = bl;
            }
            if ((object = this.zzc) != null) return this.zzc;
            this.zzc = Boolean.TRUE;
            object = this.zzt.zzaA();
            ((zzeu)object).zzd().zza("My process not in the list of running processes");
            return this.zzc;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    public static final long zzz() {
        return (Long)zzeh.zzd.zza(null);
    }

    public static final long zzA() {
        return (Long)zzeh.zzD.zza(null);
    }
}

