/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.os.Looper;
import android.os.RemoteException;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.internal.BaseGmsClient;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.measurement.internal.zzeh;
import com.google.android.gms.measurement.internal.zzej;
import com.google.android.gms.measurement.internal.zzep;
import com.google.android.gms.measurement.internal.zzet;
import com.google.android.gms.measurement.internal.zzga;
import com.google.android.gms.measurement.internal.zzgw;
import com.google.android.gms.measurement.internal.zzjt;
import com.google.android.gms.measurement.internal.zzju;
import com.google.android.gms.measurement.internal.zzjv;
import com.google.android.gms.measurement.internal.zzjw;
import com.google.android.gms.measurement.internal.zzjx;
import com.google.android.gms.measurement.internal.zzjz;

@VisibleForTesting
public final class zzjy
implements ServiceConnection,
BaseGmsClient.BaseConnectionCallbacks,
BaseGmsClient.BaseOnConnectionFailedListener {
    private volatile boolean zzb;
    private volatile zzep zzc;
    final /* synthetic */ zzjz zza;

    static /* bridge */ /* synthetic */ void zza(zzjy zzjy2, boolean bl) {
        zzjy2.zzb = false;
    }

    protected zzjy(zzjz zzjz2) {
        this.zza = zzjz2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    public final void zzb(Intent object) {
        ((zzgw)this.zza).zzg();
        Context context = this.zza.zzt.zzaw();
        ConnectionTracker connectionTracker = ConnectionTracker.getInstance();
        synchronized (this) {
            boolean bl = this.zzb;
            if (bl) {
                object = this.zza;
                object = ((zzgw)object).zzt.zzaA();
                ((zzet)object).zzj().zza("Connection attempt already in progress");
                return;
            }
            zzgw zzgw2 = this.zza;
            zzgw2 = zzgw2.zzt.zzaA();
            ((zzet)zzgw2).zzj().zza("Using local app measurement service");
            this.zzb = true;
            connectionTracker.bindService(context, (Intent)object, (ServiceConnection)zzjz.zzi(this.zza), 129);
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    public final void zzc() {
        ((zzgw)this.zza).zzg();
        Object object = this.zza.zzt.zzaw();
        synchronized (this) {
            boolean bl;
            boolean bl2 = this.zzb;
            if (bl2) {
                object = this.zza;
                object = ((zzgw)object).zzt.zzaA();
                ((zzet)object).zzj().zza("Connection attempt already in progress");
                return;
            }
            zzep zzep2 = this.zzc;
            if (zzep2 != null && ((bl = this.zzc.isConnecting()) || (bl = this.zzc.isConnected()))) {
                object = this.zza;
                object = ((zzgw)object).zzt.zzaA();
                ((zzet)object).zzj().zza("Already awaiting connection attempt");
                return;
            }
            zzjy zzjy2 = this;
            this.zzc = new zzep((Context)object, Looper.getMainLooper(), zzjy2, zzjy2);
            object = this.zza;
            object = ((zzgw)object).zzt.zzaA();
            ((zzet)object).zzj().zza("Connecting to remote service");
            this.zzb = true;
            Preconditions.checkNotNull((Object)((Object)this.zzc));
            this.zzc.checkAvailabilityAndConnect();
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    @WorkerThread
    public final void zzd() {
        if (this.zzc != null && (this.zzc.isConnected() || this.zzc.isConnecting())) {
            this.zzc.disconnect();
        }
        this.zzc = null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @MainThread
    public final void onConnected(Bundle object) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnected");
        // MONITORENTER : this
        try {
            Preconditions.checkNotNull((Object)((Object)this.zzc));
            object = (zzej)this.zzc.getService();
            zzgw zzgw2 = this.zza;
            zzgw2 = zzgw2.zzt.zzaB();
            ((zzga)zzgw2).zzp(new zzjv(this, (zzej)object));
            // MONITOREXIT : this
            return;
        }
        catch (DeadObjectException | IllegalStateException throwable) {
            this.zzc = null;
            this.zzb = false;
            return;
            {
                catch (Throwable throwable2) {}
                {
                    // MONITOREXIT : this
                    throw throwable2;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @MainThread
    public final void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnectionFailed");
        zzet zzet2 = this.zza.zzt.zzl();
        if (zzet2 != null) {
            zzet2.zzk().zzb("Service connection failed", connectionResult);
        }
        synchronized (this) {
            this.zzb = false;
            this.zzc = null;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
        this.zza.zzt.zzaB().zzp(new zzjx(this));
    }

    @MainThread
    public final void onConnectionSuspended(int n) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnectionSuspended");
        this.zza.zzt.zzaA().zzc().zza("Service connection suspended");
        this.zza.zzt.zzaB().zzp(new zzjw(this));
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @MainThread
    public final void onServiceConnected(ComponentName object, IBinder object2) {
        block13: {
            Preconditions.checkMainThread((String)"MeasurementServiceConnection.onServiceConnected");
            // MONITORENTER : this
            if (object2 == null) {
                this.zzb = false;
                object = this.zza;
                object = ((zzgw)object).zzt.zzaA();
                ((zzet)object).zzd().zza("Service connected with null binder");
                // MONITOREXIT : this
                return;
            }
            try {
                object = object2.getInterfaceDescriptor();
                boolean bl = "com.google.android.gms.measurement.internal.IMeasurementService".equals(object);
                if (bl) {
                    object = object2.queryLocalInterface("com.google.android.gms.measurement.internal.IMeasurementService");
                    bl = object instanceof zzej;
                    object = bl ? (zzej)object : new zzeh((IBinder)object2);
                    object2 = this.zza;
                    object2 = ((zzgw)object2).zzt.zzaA();
                    ((zzet)object2).zzj().zza("Bound to IMeasurementService interface");
                    break block13;
                }
                object2 = this.zza;
                object2 = ((zzgw)object2).zzt.zzaA();
                ((zzet)object2).zzd().zzb("Got binder with a wrong descriptor", object);
                object = null;
            }
            catch (RemoteException remoteException) {
                block14: {
                    object = null;
                    break block14;
                    catch (RemoteException remoteException2) {}
                }
                object2 = this.zza;
                object2 = ((zzgw)object2).zzt.zzaA();
                ((zzet)object2).zzd().zza("Service connect failed to get IMeasurementService");
            }
        }
        if (object != null) {
            object2 = this.zza;
            object2 = ((zzgw)object2).zzt.zzaB();
            ((zzga)object2).zzp(new zzjt(this, (zzej)object));
            return;
        }
        this.zzb = false;
        try {
            object = ConnectionTracker.getInstance();
            object2 = this.zza;
            object2 = ((zzgw)object2).zzt.zzaw();
            object.unbindService((Context)object2, (ServiceConnection)zzjz.zzi(this.zza));
            // MONITOREXIT : this
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
    }

    @MainThread
    public final void onServiceDisconnected(ComponentName componentName) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onServiceDisconnected");
        this.zza.zzt.zzaA().zzc().zza("Service disconnected");
        this.zza.zzt.zzaB().zzp(new zzju(this, componentName));
    }
}

