/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.os.Bundle;
import androidx.annotation.WorkerThread;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.measurement.internal.zza;
import com.google.android.gms.measurement.internal.zzd;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzhf;
import com.google.android.gms.measurement.internal.zzid;
import com.google.android.gms.measurement.internal.zzki;
import com.google.android.gms.measurement.internal.zznd;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class zzb
extends zzf {
    private final Map<String, Long> zza;
    private final Map<String, Integer> zzb = new ArrayMap();
    private long zzc;

    static /* synthetic */ void zza(zzb zzb2, String string, long l) {
        Integer n;
        long l2 = l;
        String string2 = string;
        zzb zzb3 = zzb2;
        ((zzid)zzb3).zzt();
        Preconditions.checkNotEmpty((String)string2);
        if (zzb3.zzb.isEmpty()) {
            zzb3.zzc = l2;
        }
        if ((n = zzb3.zzb.get(string2)) != null) {
            zzb3.zzb.put(string2, n + 1);
            return;
        }
        if (zzb3.zzb.size() >= 100) {
            ((zzid)zzb3).zzj().zzu().zza("Too many ads visible");
            return;
        }
        zzb3.zzb.put(string2, 1);
        zzb3.zza.put(string2, l2);
    }

    static /* synthetic */ void zzb(zzb zzb2, String string, long l) {
        long l2 = l;
        String string2 = string;
        zzb zzb3 = zzb2;
        ((zzid)zzb3).zzt();
        Preconditions.checkNotEmpty((String)string2);
        Integer n = zzb3.zzb.get(string2);
        if (n != null) {
            zzki zzki2 = ((zzf)zzb3).zzn().zza(false);
            int n2 = n - 1;
            if (n2 == 0) {
                zzb3.zzb.remove(string2);
                Long l3 = zzb3.zza.get(string2);
                if (l3 == null) {
                    ((zzid)zzb3).zzj().zzg().zza("First ad unit exposure time was never set");
                } else {
                    long l4 = l2 - l3;
                    zzb3.zza.remove(string2);
                    zzb3.zza(string2, l4, zzki2);
                }
                if (zzb3.zzb.isEmpty()) {
                    if (zzb3.zzc == 0L) {
                        ((zzid)zzb3).zzj().zzg().zza("First ad exposure time was never set");
                        return;
                    }
                    zzb3.zza(l2 - zzb3.zzc, zzki2);
                    zzb3.zzc = 0L;
                }
                return;
            }
            zzb3.zzb.put(string2, n2);
            return;
        }
        ((zzid)zzb3).zzj().zzg().zza("Call to endAdUnitExposure for unknown ad unit id", string2);
    }

    static /* synthetic */ void zza(zzb zzb2, long l) {
        zzb2.zzb(l);
    }

    public zzb(zzhf zzhf2) {
        super(zzhf2);
        this.zza = new ArrayMap();
    }

    public final void zza(String string, long l) {
        if (string == null || string.length() == 0) {
            ((zzid)this).zzj().zzg().zza("Ad unit id must be a non-empty string");
            return;
        }
        ((zzid)this).zzl().zzb(new zza(this, string, l));
    }

    public final void zzb(String string, long l) {
        if (string == null || string.length() == 0) {
            ((zzid)this).zzj().zzg().zza("Ad unit id must be a non-empty string");
            return;
        }
        ((zzid)this).zzl().zzb(new zzd(this, string, l));
    }

    @WorkerThread
    private final void zza(long l, @Nullable zzki zzki2) {
        if (zzki2 == null) {
            ((zzid)this).zzj().zzp().zza("Not logging ad exposure. No active activity");
            return;
        }
        if (l < 1000L) {
            ((zzid)this).zzj().zzp().zza("Not logging ad exposure. Less than 1000 ms. exposure", l);
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putLong("_xt", l);
        zznd.zza(zzki2, bundle, true);
        ((zzf)this).zzm().zzc("am", "_xa", bundle);
    }

    @WorkerThread
    private final void zza(String string, long l, @Nullable zzki zzki2) {
        if (zzki2 == null) {
            ((zzid)this).zzj().zzp().zza("Not logging ad unit exposure. No active activity");
            return;
        }
        if (l < 1000L) {
            ((zzid)this).zzj().zzp().zza("Not logging ad unit exposure. Less than 1000 ms. exposure", l);
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putString("_ai", string);
        bundle.putLong("_xt", l);
        zznd.zza(zzki2, bundle, true);
        ((zzf)this).zzm().zzc("am", "_xu", bundle);
    }

    @WorkerThread
    public final void zza(long l) {
        zzki zzki2 = ((zzf)this).zzn().zza(false);
        for (String string : this.zza.keySet()) {
            long l2 = this.zza.get(string);
            this.zza(string, l - l2, zzki2);
        }
        if (!this.zza.isEmpty()) {
            this.zza(l - this.zzc, zzki2);
        }
        this.zzb(l);
    }

    @WorkerThread
    private final void zzb(long l) {
        for (String string : this.zza.keySet()) {
            this.zza.put(string, l);
        }
        if (!this.zza.isEmpty()) {
            this.zzc = l;
        }
    }
}

