/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Pair;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import androidx.core.content.ContextCompat;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzdd;
import com.google.android.gms.internal.measurement.zzgv;
import com.google.android.gms.internal.measurement.zzns;
import com.google.android.gms.internal.measurement.zzok;
import com.google.android.gms.internal.measurement.zzph;
import com.google.android.gms.internal.measurement.zzqf;
import com.google.android.gms.measurement.internal.zzab;
import com.google.android.gms.measurement.internal.zzag;
import com.google.android.gms.measurement.internal.zzaj;
import com.google.android.gms.measurement.internal.zzav;
import com.google.android.gms.measurement.internal.zzay;
import com.google.android.gms.measurement.internal.zzb;
import com.google.android.gms.measurement.internal.zzbg;
import com.google.android.gms.measurement.internal.zze;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzfd;
import com.google.android.gms.measurement.internal.zzfj;
import com.google.android.gms.measurement.internal.zzfm;
import com.google.android.gms.measurement.internal.zzfn;
import com.google.android.gms.measurement.internal.zzfo;
import com.google.android.gms.measurement.internal.zzfp;
import com.google.android.gms.measurement.internal.zzgb;
import com.google.android.gms.measurement.internal.zzgw;
import com.google.android.gms.measurement.internal.zzhc;
import com.google.android.gms.measurement.internal.zzhe;
import com.google.android.gms.measurement.internal.zzhf;
import com.google.android.gms.measurement.internal.zzia;
import com.google.android.gms.measurement.internal.zzib;
import com.google.android.gms.measurement.internal.zzid;
import com.google.android.gms.measurement.internal.zzif;
import com.google.android.gms.measurement.internal.zzil;
import com.google.android.gms.measurement.internal.zzim;
import com.google.android.gms.measurement.internal.zzio;
import com.google.android.gms.measurement.internal.zzjx;
import com.google.android.gms.measurement.internal.zzkc;
import com.google.android.gms.measurement.internal.zzke;
import com.google.android.gms.measurement.internal.zzkh;
import com.google.android.gms.measurement.internal.zzkq;
import com.google.android.gms.measurement.internal.zzly;
import com.google.android.gms.measurement.internal.zzng;
import com.google.android.gms.measurement.internal.zzq;
import java.net.URL;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.json.JSONException;
import org.json.JSONObject;

public class zzhd
implements zzid {
    private static volatile @Nullable zzhd zzb;
    private final Context zzc;
    private final @Nullable String zzd;
    private final @Nullable String zze;
    private final @Nullable String zzf;
    private final boolean zzg;
    private final zzab zzh;
    private final zzag zzi;
    private final zzgb zzj;
    private final zzfp zzk;
    private final zzgw zzl;
    private final zzly zzm;
    private final zzng zzn;
    private final zzfo zzo;
    private final Clock zzp;
    private final zzkh zzq;
    private final zzio zzr;
    private final zzb zzs;
    private final zzkc zzt;
    private final @Nullable String zzu;
    private zzfm zzv;
    private zzkq zzw;
    private zzay zzx;
    private zzfj zzy;
    private boolean zzz = false;
    private Boolean zzaa;
    private long zzab;
    private volatile @Nullable Boolean zzac;
    @VisibleForTesting
    private Boolean zzad;
    @VisibleForTesting
    private Boolean zzae;
    private volatile boolean zzaf;
    private int zzag;
    private int zzah;
    private AtomicInteger zzai = new AtomicInteger(0);
    @VisibleForTesting
    final long zza;

    @WorkerThread
    public final int zzc() {
        ((zzib)this.zzl()).zzt();
        if (this.zzi.zzw()) {
            return 1;
        }
        if (this.zzae != null && this.zzae.booleanValue()) {
            return 2;
        }
        if (!this.zzad()) {
            return 8;
        }
        Boolean bl = this.zzn().zzv();
        if (bl != null) {
            if (bl.booleanValue()) {
                return 0;
            }
            return 3;
        }
        zzag zzag2 = this.zzi;
        Boolean bl2 = zzag2.zze("firebase_analytics_collection_enabled");
        if (bl2 != null) {
            if (bl2.booleanValue()) {
                return 0;
            }
            return 4;
        }
        if (this.zzad != null) {
            if (this.zzad.booleanValue()) {
                return 0;
            }
            return 5;
        }
        if (this.zzac != null) {
            if (this.zzac.booleanValue()) {
                return 0;
            }
            return 7;
        }
        return 0;
    }

    @Override
    @Pure
    public final Context zza() {
        return this.zzc;
    }

    @Override
    @Pure
    public final Clock zzb() {
        return this.zzp;
    }

    @Pure
    public final zzb zze() {
        if (this.zzs == null) {
            throw new IllegalStateException("Component not created");
        }
        return this.zzs;
    }

    @Override
    @Pure
    public final zzab zzd() {
        return this.zzh;
    }

    @Pure
    public final zzag zzf() {
        return this.zzi;
    }

    @Pure
    public final zzay zzg() {
        zzhd.zza(this.zzx);
        return this.zzx;
    }

    @Pure
    public final zzfj zzh() {
        zzhd.zza(this.zzy);
        return this.zzy;
    }

    @Pure
    public final zzfm zzi() {
        zzhd.zza(this.zzv);
        return this.zzv;
    }

    @Pure
    public final zzfo zzk() {
        return this.zzo;
    }

    @Override
    @Pure
    public final zzfp zzj() {
        zzhd.zza(this.zzk);
        return this.zzk;
    }

    public final @Nullable zzfp zzm() {
        if (this.zzk != null && this.zzk.zzaf()) {
            return this.zzk;
        }
        return null;
    }

    @Pure
    public final zzgb zzn() {
        zzhd.zza((zzib)this.zzj);
        return this.zzj;
    }

    @Override
    @Pure
    public final zzgw zzl() {
        zzhd.zza(this.zzl);
        return this.zzl;
    }

    @SideEffectFree
    final @Nullable zzgw zzo() {
        return this.zzl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzhd zza(Context context, @Nullable zzdd zzdd2, @Nullable Long l) {
        if (zzdd2 != null && (zzdd2.zze == null || zzdd2.zzf == null)) {
            zzdd2 = new zzdd(zzdd2.zza, zzdd2.zzb, zzdd2.zzc, zzdd2.zzd, null, null, zzdd2.zzg, null);
        }
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)context.getApplicationContext());
        if (zzb == null) {
            Class<zzhd> clazz = zzhd.class;
            synchronized (zzhd.class) {
                if (zzb == null) {
                    zzim zzim2 = new zzim(context, zzdd2, l);
                    zzb = new zzhd(zzim2);
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
        } else if (zzdd2 != null && zzdd2.zzg != null && zzdd2.zzg.containsKey("dataCollectionDefaultEnabled")) {
            Preconditions.checkNotNull((Object)zzb);
            zzb.zza(zzdd2.zzg.getBoolean("dataCollectionDefaultEnabled"));
        }
        {
            Preconditions.checkNotNull((Object)zzb);
            return zzb;
        }
    }

    @Pure
    public final zzio zzp() {
        zzhd.zza(this.zzr);
        return this.zzr;
    }

    @Pure
    private final zzkc zzai() {
        zzhd.zza(this.zzt);
        return this.zzt;
    }

    @Pure
    public final zzkh zzq() {
        zzhd.zza(this.zzq);
        return this.zzq;
    }

    @Pure
    public final zzkq zzr() {
        zzhd.zza(this.zzw);
        return this.zzw;
    }

    @Pure
    public final zzly zzs() {
        zzhd.zza(this.zzm);
        return this.zzm;
    }

    @Pure
    public final zzng zzt() {
        zzhd.zza((zzib)this.zzn);
        return this.zzn;
    }

    @Pure
    public final @Nullable String zzu() {
        return this.zzd;
    }

    @Pure
    public final @Nullable String zzv() {
        return this.zze;
    }

    @Pure
    public final @Nullable String zzw() {
        return this.zzf;
    }

    @Pure
    public final @Nullable String zzx() {
        return this.zzu;
    }

    static /* synthetic */ void zza(zzhd zzhd2, zzim zzim2) {
        zzim zzim3 = zzim2;
        zzhd zzhd3 = zzhd2;
        ((zzib)zzhd3.zzl()).zzt();
        Object object = zzhd3;
        zzay zzay2 = new zzay((zzhd)object);
        zzay2.zzad();
        zzhd3.zzx = zzay2;
        zzhd zzhd4 = zzhd3;
        object = zzim3;
        zzfj zzfj2 = new zzfj(zzhd4, ((zzim)object).zzf);
        zzfj2.zzv();
        zzhd3.zzy = zzfj2;
        object = zzhd3;
        zzfm zzfm2 = new zzfm((zzhd)object);
        zzfm2.zzv();
        zzhd3.zzv = zzfm2;
        object = zzhd3;
        zzkq zzkq2 = new zzkq((zzhd)object);
        zzkq2.zzv();
        zzhd3.zzw = zzkq2;
        zzhd3.zzn.zzae();
        zzhd3.zzj.zzae();
        zzhd3.zzy.zzw();
        zzhd3.zzj().zzn().zza("App measurement initialized, version", 84002L);
        zzhd3.zzj().zzn().zza("To enable debug logging run: adb shell setprop log.tag.FA VERBOSE");
        String string = zzfj2.zzad();
        if (TextUtils.isEmpty((CharSequence)zzhd3.zzd)) {
            if (zzhd3.zzt().zzf(string)) {
                zzhd3.zzj().zzn().zza("Faster debug mode event logging enabled. To disable, run:\n  adb shell setprop debug.firebase.analytics.app .none.");
            } else {
                String string2 = string;
                zzhd3.zzj().zzn().zza("To enable faster debug mode event logging run:\n  adb shell setprop debug.firebase.analytics.app " + string2);
            }
        }
        zzhd3.zzj().zzc().zza("Debug-level message logging enabled");
        if (zzhd3.zzag != zzhd3.zzai.get()) {
            zzhd3.zzj().zzg().zza("Not all components initialized", zzhd3.zzag, zzhd3.zzai.get());
        }
        zzhd3.zzz = true;
    }

    private zzhd(zzim zzim2) {
        Object object;
        Preconditions.checkNotNull((Object)zzim2);
        Object object2 = zzim2.zza;
        zzfd.zza = this.zzh = new zzab((Context)object2);
        this.zzc = zzim2.zza;
        this.zzd = zzim2.zzb;
        this.zze = zzim2.zzc;
        this.zzf = zzim2.zzd;
        this.zzg = zzim2.zzh;
        this.zzac = zzim2.zze;
        this.zzu = zzim2.zzj;
        this.zzaf = true;
        zzdd zzdd2 = zzim2.zzg;
        if (zzdd2 != null && zzdd2.zzg != null) {
            object = zzdd2.zzg.get("measurementEnabled");
            if (object instanceof Boolean) {
                this.zzad = (Boolean)object;
            }
            if ((object = zzdd2.zzg.get("measurementDeactivated")) instanceof Boolean) {
                this.zzae = (Boolean)object;
            }
        }
        zzgv.zzb(this.zzc);
        this.zzp = DefaultClock.getInstance();
        this.zza = zzim2.zzi != null ? zzim2.zzi.longValue() : this.zzp.currentTimeMillis();
        object2 = this;
        this.zzi = new zzag((zzhd)object2);
        object2 = this;
        object = new zzgb((zzhd)object2);
        ((zzia)object).zzad();
        this.zzj = object;
        object2 = this;
        zzfp zzfp2 = new zzfp((zzhd)object2);
        zzfp2.zzad();
        this.zzk = zzfp2;
        object2 = this;
        zzng zzng2 = new zzng((zzhd)object2);
        zzng2.zzad();
        this.zzn = zzng2;
        zzhd zzhd2 = this;
        object2 = zzim2;
        Object object3 = new zzil((zzim)object2, zzhd2);
        this.zzo = new zzfo((zzfn)object3);
        object2 = this;
        this.zzs = new zzb((zzhd)object2);
        object2 = this;
        zzkh zzkh2 = new zzkh((zzhd)object2);
        zzkh2.zzv();
        this.zzq = zzkh2;
        object2 = this;
        zzio zzio2 = new zzio((zzhd)object2);
        zzio2.zzv();
        this.zzr = zzio2;
        object2 = this;
        zzly zzly2 = new zzly((zzhd)object2);
        zzly2.zzv();
        this.zzm = zzly2;
        object2 = this;
        zzkc zzkc2 = new zzkc((zzhd)object2);
        zzkc2.zzad();
        this.zzt = zzkc2;
        object2 = this;
        zzgw zzgw2 = new zzgw((zzhd)object2);
        zzgw2.zzad();
        this.zzl = zzgw2;
        boolean bl = zzim2.zzg != null && zzim2.zzg.zzb != 0L;
        boolean bl2 = !bl;
        object2 = this;
        if (((zzhd)object2).zzc.getApplicationContext() instanceof Application) {
            boolean bl3 = bl2;
            object3 = ((zzhd)object2).zzp();
            if (((zzib)object3).zza().getApplicationContext() instanceof Application) {
                Application application = (Application)((zzib)object3).zza().getApplicationContext();
                if (((zzio)object3).zza == null) {
                    ((zzio)object3).zza = new zzjx((zzio)object3);
                }
                if (bl3) {
                    application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)((zzio)object3).zza);
                    application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)((zzio)object3).zza);
                    ((zzib)object3).zzj().zzp().zza("Registered activity lifecycle callback");
                }
            }
        } else {
            ((zzhd)object2).zzj().zzu().zza("Application context is not an Application");
        }
        this.zzl.zzb(new zzhe(this, zzim2));
    }

    private static void zza(zzib zzib2) {
        if (zzib2 == null) {
            throw new IllegalStateException("Component not created");
        }
    }

    private static void zza(zze zze2) {
        if (zze2 == null) {
            throw new IllegalStateException("Component not created");
        }
        if (!zze2.zzy()) {
            String string = String.valueOf(zze2.getClass());
            throw new IllegalStateException("Component not initialized: " + string);
        }
    }

    private static void zza(zzia zzia2) {
        if (zzia2 == null) {
            throw new IllegalStateException("Component not created");
        }
        if (!zzia2.zzaf()) {
            String string = String.valueOf(zzia2.getClass());
            throw new IllegalStateException("Component not initialized: " + string);
        }
    }

    final void zzy() {
        throw new IllegalStateException("Unexpected call on client side");
    }

    final void zzz() {
        this.zzai.incrementAndGet();
    }

    final /* synthetic */ void zza(String string, int n, Throwable throwable, byte[] byArray, Map map) {
        Throwable throwable2 = throwable;
        byte[] byArray2 = byArray;
        int n2 = n;
        zzhd zzhd2 = this;
        if (!((n2 == 200 || n2 == 204 || n2 == 304) && throwable2 == null)) {
            zzhd2.zzj().zzu().zza("Network Request for Deferred Deep Link failed. response, exception", n2, throwable2);
            return;
        }
        zzhd2.zzn().zzo.zza(true);
        if (byArray2 == null || byArray2.length == 0) {
            zzhd2.zzj().zzc().zza("Deferred Deep Link response empty.");
            return;
        }
        String string2 = new String(byArray2);
        try {
            JSONObject jSONObject = new JSONObject(string2);
            String string3 = jSONObject.optString("deeplink", "");
            String string4 = jSONObject.optString("gclid", "");
            String string5 = jSONObject.optString("gbraid", "");
            double d = jSONObject.optDouble("timestamp", 0.0);
            if (TextUtils.isEmpty((CharSequence)string3)) {
                zzhd2.zzj().zzc().zza("Deferred Deep Link is empty.");
                return;
            }
            Bundle bundle = new Bundle();
            if (zzok.zza() && zzhd2.zzi.zza(zzbg.zzcs)) {
                if (!zzhd2.zzt().zzi(string3)) {
                    zzhd2.zzj().zzu().zza("Deferred Deep Link validation failed. gclid, gbraid, deep link", string4, string5, string3);
                    return;
                }
                bundle.putString("gbraid", string5);
            } else if (!zzhd2.zzt().zzi(string3)) {
                zzhd2.zzj().zzu().zza("Deferred Deep Link validation failed. gclid, deep link", string4, string3);
                return;
            }
            bundle.putString("gclid", string4);
            bundle.putString("_cis", "ddp");
            zzhd2.zzr.zzc("auto", "_cmp", bundle);
            String string6 = string3;
            zzng zzng2 = zzhd2.zzt();
            if (!TextUtils.isEmpty((CharSequence)string6) && zzng2.zza(string6, d)) {
                Intent intent = new Intent("android.google.analytics.action.DEEPLINK_ACTION");
                ((zzib)zzng2).zza().sendBroadcast(intent);
            }
            return;
        }
        catch (JSONException jSONException) {
            zzhd2.zzj().zzg().zza("Failed to parse the Deferred Deep Link response. exception", (Object)jSONException);
            return;
        }
    }

    final void zzaa() {
        ++this.zzag;
    }

    @WorkerThread
    final void zza(boolean bl) {
        this.zzac = bl;
    }

    @WorkerThread
    public final void zzb(boolean bl) {
        ((zzib)this.zzl()).zzt();
        this.zzaf = bl;
    }

    @WorkerThread
    protected final void zza(@Nullable zzdd zzdd2) {
        zzif zzif2;
        IntentFilter intentFilter;
        zzid zzid2;
        ((zzib)this.zzl()).zzt();
        if (zzph.zza() && this.zzi.zza(zzbg.zzcf) && this.zzt().zzw()) {
            zzid2 = this.zzt();
            ((zzib)zzid2).zzt();
            intentFilter = new IntentFilter();
            intentFilter.addAction("com.google.android.gms.measurement.TRIGGERS_AVAILABLE");
            zzq zzq2 = new zzq(((zzng)zzid2).zzu);
            ContextCompat.registerReceiver((Context)((zzib)zzid2).zza(), (BroadcastReceiver)zzq2, (IntentFilter)intentFilter, (int)2);
            ((zzib)zzid2).zzj().zzc().zza("Registered app receiver");
        }
        zzif zzif3 = this.zzn().zzn();
        int n = zzif3.zza();
        zzif zzif4 = null;
        zzid2 = this.zzi;
        Boolean bl = ((zzag)zzid2).zze("google_analytics_default_allow_ad_storage");
        zzid2 = this.zzi;
        Boolean bl2 = ((zzag)zzid2).zze("google_analytics_default_allow_analytics_storage");
        if ((bl != null || bl2 != null) && this.zzn().zza(-10)) {
            zzif4 = new zzif(bl, bl2, -10);
        } else if (!(TextUtils.isEmpty((CharSequence)this.zzh().zzae()) || n != 0 && n != 30 && n != 10 && n != 30 && n != 30 && n != 40)) {
            this.zzp().zza(new zzif(null, null, -10), this.zza);
        } else if (TextUtils.isEmpty((CharSequence)this.zzh().zzae()) && zzdd2 != null && zzdd2.zzg != null && this.zzn().zza(30) && (zzif2 = zzif.zza(zzdd2.zzg, 30)).zzi()) {
            zzif4 = zzif2;
        }
        if (zzif4 != null) {
            zzif3 = zzif4;
            this.zzp().zza(zzif3, this.zza);
        }
        this.zzp().zza(zzif3);
        if (zzns.zza() && this.zzi.zza(zzbg.zzcl)) {
            intentFilter = zzdd2;
            zzid2 = this;
            int n2 = ((zzhd)zzid2).zzn().zzm().zza();
            zzag zzag2 = ((zzhd)zzid2).zzi;
            Boolean bl3 = zzag2.zze("google_analytics_default_allow_ad_user_data");
            if (bl3 != null && zzif.zza(-10, n2)) {
                ((zzhd)zzid2).zzp().zza(new zzav(bl3, -10));
            } else if (!(TextUtils.isEmpty((CharSequence)((zzhd)zzid2).zzh().zzae()) || n2 != 0 && n2 != 30)) {
                ((zzhd)zzid2).zzp().zza(new zzav(null, -10));
            } else {
                Boolean bl4;
                zzav zzav2;
                if (TextUtils.isEmpty((CharSequence)((zzhd)zzid2).zzh().zzae()) && intentFilter != null && intentFilter.zzg != null && zzif.zza(30, n2) && (zzav2 = zzav.zza(intentFilter.zzg, 30)).zzg()) {
                    ((zzhd)zzid2).zzp().zza(zzav2);
                }
                if (TextUtils.isEmpty((CharSequence)((zzhd)zzid2).zzh().zzae()) && intentFilter != null && intentFilter.zzg != null && ((zzhd)zzid2).zzn().zzh.zza() == null && (bl4 = zzav.zza(intentFilter.zzg)) != null) {
                    ((zzhd)zzid2).zzp().zza(intentFilter.zze, "allow_personalized_ads", (Object)bl4.toString(), false);
                }
            }
        }
        if (zzqf.zza() && this.zzi.zza(zzbg.zzcw)) {
            this.zzj().zzc().zza("TCF client enabled.");
            this.zzp().zzap();
            this.zzp().zzan();
        }
        if (this.zzn().zzc.zza() == 0L) {
            this.zzj().zzp().zza("Persisting first open", this.zza);
            this.zzn().zzc.zza(this.zza);
        }
        this.zzp().zzb.zzb();
        if (!this.zzaf()) {
            if (this.zzac()) {
                if (!this.zzt().zze("android.permission.INTERNET")) {
                    this.zzj().zzg().zza("App is missing INTERNET permission");
                }
                if (!this.zzt().zze("android.permission.ACCESS_NETWORK_STATE")) {
                    this.zzj().zzg().zza("App is missing ACCESS_NETWORK_STATE permission");
                }
                if (!Wrappers.packageManager((Context)this.zzc).isCallerInstantApp() && !this.zzi.zzx()) {
                    if (!zzng.zza(this.zzc)) {
                        this.zzj().zzg().zza("AppMeasurementReceiver not registered/enabled");
                    }
                    if (!zzng.zza(this.zzc, false)) {
                        this.zzj().zzg().zza("AppMeasurementService not registered/enabled");
                    }
                }
                this.zzj().zzg().zza("Uploading is not possible. App measurement disabled");
            }
        } else {
            if (!TextUtils.isEmpty((CharSequence)this.zzh().zzae()) || !TextUtils.isEmpty((CharSequence)this.zzh().zzac())) {
                this.zzt();
                if (zzng.zza(this.zzh().zzae(), this.zzn().zzy(), this.zzh().zzac(), this.zzn().zzx())) {
                    this.zzj().zzn().zza("Rechecking which service to use due to a GMP App Id change");
                    this.zzn().zzz();
                    this.zzi().zzaa();
                    this.zzw.zzae();
                    this.zzw.zzad();
                    this.zzn().zzc.zza(this.zza);
                    this.zzn().zze.zza(null);
                }
                this.zzn().zzc(this.zzh().zzae());
                this.zzn().zzb(this.zzh().zzac());
            }
            if (!this.zzn().zzn().zza(zzif.zza.zzb)) {
                this.zzn().zze.zza(null);
            }
            this.zzp().zza(this.zzn().zze.zza());
            if (!this.zzt().zzx() && !TextUtils.isEmpty((CharSequence)this.zzn().zzq.zza())) {
                this.zzj().zzu().zza("Remote config removed with active feature rollouts");
                this.zzn().zzq.zza(null);
            }
            if (!TextUtils.isEmpty((CharSequence)this.zzh().zzae()) || !TextUtils.isEmpty((CharSequence)this.zzh().zzac())) {
                boolean bl5 = this.zzac();
                if (!this.zzn().zzab() && !this.zzi.zzw()) {
                    this.zzn().zzb(!bl5);
                }
                if (bl5) {
                    this.zzp().zzaj();
                }
                this.zzs().zza.zza();
                this.zzr().zza(new AtomicReference<String>());
                this.zzr().zza(this.zzn().zzt.zza());
            }
        }
        if (zzph.zza() && this.zzi.zza(zzbg.zzcf) && this.zzt().zzw()) {
            zzio zzio2 = this.zzp();
            Objects.requireNonNull(zzio2);
            zzio zzio3 = zzio2;
            new Thread(new zzhc(zzio3)).start();
        }
        this.zzn().zzj.zza(true);
    }

    @WorkerThread
    public final boolean zzab() {
        return this.zzac != null && this.zzac != false;
    }

    @WorkerThread
    public final boolean zzac() {
        return this.zzc() == 0;
    }

    @WorkerThread
    public final boolean zzad() {
        ((zzib)this.zzl()).zzt();
        return this.zzaf;
    }

    @Pure
    public final boolean zzae() {
        return TextUtils.isEmpty((CharSequence)this.zzd);
    }

    @WorkerThread
    protected final boolean zzaf() {
        if (!this.zzz) {
            throw new IllegalStateException("AppMeasurement is not initialized");
        }
        ((zzib)this.zzl()).zzt();
        if (this.zzaa == null || this.zzab == 0L || this.zzaa != null && !this.zzaa.booleanValue() && Math.abs(this.zzp.elapsedRealtime() - this.zzab) > 1000L) {
            this.zzab = this.zzp.elapsedRealtime();
            this.zzaa = this.zzt().zze("android.permission.INTERNET") && this.zzt().zze("android.permission.ACCESS_NETWORK_STATE") && (Wrappers.packageManager((Context)this.zzc).isCallerInstantApp() || this.zzi.zzx() || zzng.zza(this.zzc) && zzng.zza(this.zzc, false));
            if (this.zzaa.booleanValue()) {
                this.zzaa = this.zzt().zza(this.zzh().zzae(), this.zzh().zzac()) || !TextUtils.isEmpty((CharSequence)this.zzh().zzac());
            }
        }
        return this.zzaa;
    }

    @Pure
    public final boolean zzag() {
        return this.zzg;
    }

    @WorkerThread
    public final boolean zzah() {
        URL uRL;
        zzib zzib2;
        ((zzib)this.zzl()).zzt();
        zzhd.zza(this.zzai());
        String string = this.zzh().zzad();
        Pair<String, Boolean> pair = this.zzn().zza(string);
        if (!this.zzi.zzu() || ((Boolean)pair.second).booleanValue() || TextUtils.isEmpty((CharSequence)((CharSequence)pair.first))) {
            this.zzj().zzc().zza("ADID unavailable to retrieve Deferred Deep Link. Skipping");
            return false;
        }
        if (!this.zzai().zzc()) {
            this.zzj().zzu().zza("Network is not available for Deferred Deep Link request. Skipping");
            return false;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (zzns.zza() && this.zzi.zza(zzbg.zzcn)) {
            zzib2 = this.zzr();
            zzib2.zzt();
            ((zze)zzib2).zzu();
            if (!((zzkq)zzib2).zzak() ? true : zzib2.zzq().zzg() >= 234200) {
                uRL = null;
                zzib2 = this.zzp();
                zzib2.zzt();
                zzaj zzaj2 = ((zzf)zzib2).zzo().zzaa();
                if (zzaj2 != null) {
                    uRL = zzaj2.zza;
                }
                if (uRL == null) {
                    boolean bl = this.zzah++ < 10;
                    String string2 = bl ? "Retrying." : "Skipping.";
                    this.zzj().zzc().zza("Failed to retrieve DMA consent from the service, " + string2 + " retryCount", this.zzah);
                    return bl;
                }
                zzif zzif2 = zzif.zza((Bundle)uRL, 100);
                stringBuilder.append("&gcs=").append(zzif2.zze());
                zzav zzav2 = zzav.zza((Bundle)uRL, 100);
                stringBuilder.append("&dma=").append(zzav2.zzd() == Boolean.FALSE ? 0 : 1);
                if (!TextUtils.isEmpty((CharSequence)zzav2.zze())) {
                    stringBuilder.append("&dma_cps=").append(zzav2.zze());
                }
                int n = zzav.zza((Bundle)uRL) == Boolean.TRUE ? 0 : 1;
                stringBuilder.append("&npa=").append(n);
                this.zzj().zzp().zza("Consent query parameters to Bow", stringBuilder);
            }
        }
        zzng zzng2 = this.zzt();
        this.zzh();
        uRL = zzng2.zza(84002L, string, (String)pair.first, this.zzn().zzp.zza() - 1L, stringBuilder.toString());
        if (uRL != null) {
            zzhd zzhd2 = this;
            zzhf zzhf2 = new zzhf(zzhd2);
            URL uRL2 = uRL;
            String string3 = string;
            zzib2 = this.zzai();
            zzib2.zzt();
            ((zzia)zzib2).zzac();
            Preconditions.checkNotNull((Object)uRL2);
            Preconditions.checkNotNull((Object)zzhf2);
            zzib2.zzl().zza(new zzke((zzkc)zzib2, string3, uRL2, null, null, zzhf2));
        }
        return false;
    }
}

