/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.os.Bundle;
import androidx.annotation.WorkerThread;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.measurement.internal.zzb;
import com.google.android.gms.measurement.internal.zzc;
import com.google.android.gms.measurement.internal.zzd;
import com.google.android.gms.measurement.internal.zzho;
import com.google.android.gms.measurement.internal.zzim;
import com.google.android.gms.measurement.internal.zzks;
import com.google.android.gms.measurement.internal.zznt;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class zza
extends zzd {
    private final Map<String, Long> zza;
    private final Map<String, Integer> zzb = new ArrayMap();
    private long zzc;

    static /* synthetic */ void zza(zza zza2, String string, long l) {
        Integer n;
        long l2 = l;
        String string2 = string;
        zza zza3 = zza2;
        ((zzim)zza3).zzt();
        Preconditions.checkNotEmpty((String)string2);
        if (zza3.zzb.isEmpty()) {
            zza3.zzc = l2;
        }
        if ((n = zza3.zzb.get(string2)) != null) {
            zza3.zzb.put(string2, n + 1);
            return;
        }
        if (zza3.zzb.size() >= 100) {
            ((zzim)zza3).zzj().zzu().zza("Too many ads visible");
            return;
        }
        zza3.zzb.put(string2, 1);
        zza3.zza.put(string2, l2);
    }

    static /* synthetic */ void zzb(zza zza2, String string, long l) {
        long l2 = l;
        String string2 = string;
        zza zza3 = zza2;
        ((zzim)zza3).zzt();
        Preconditions.checkNotEmpty((String)string2);
        Integer n = zza3.zzb.get(string2);
        if (n != null) {
            zzks zzks2 = ((zzd)zza3).zzn().zza(false);
            int n2 = n - 1;
            if (n2 == 0) {
                zza3.zzb.remove(string2);
                Long l3 = zza3.zza.get(string2);
                if (l3 == null) {
                    ((zzim)zza3).zzj().zzg().zza("First ad unit exposure time was never set");
                } else {
                    long l4 = l2 - l3;
                    zza3.zza.remove(string2);
                    zza3.zza(string2, l4, zzks2);
                }
                if (zza3.zzb.isEmpty()) {
                    if (zza3.zzc == 0L) {
                        ((zzim)zza3).zzj().zzg().zza("First ad exposure time was never set");
                        return;
                    }
                    zza3.zza(l2 - zza3.zzc, zzks2);
                    zza3.zzc = 0L;
                }
                return;
            }
            zza3.zzb.put(string2, n2);
            return;
        }
        ((zzim)zza3).zzj().zzg().zza("Call to endAdUnitExposure for unknown ad unit id", string2);
    }

    static /* synthetic */ void zza(zza zza2, long l) {
        zza2.zzb(l);
    }

    public zza(zzho zzho2) {
        super(zzho2);
        this.zza = new ArrayMap();
    }

    public final void zza(String string, long l) {
        if (string == null || string.length() == 0) {
            ((zzim)this).zzj().zzg().zza("Ad unit id must be a non-empty string");
            return;
        }
        ((zzim)this).zzl().zzb(new zzc(this, string, l));
    }

    public final void zzb(String string, long l) {
        if (string == null || string.length() == 0) {
            ((zzim)this).zzj().zzg().zza("Ad unit id must be a non-empty string");
            return;
        }
        ((zzim)this).zzl().zzb(new zzb(this, string, l));
    }

    @WorkerThread
    private final void zza(long l, @Nullable zzks zzks2) {
        if (zzks2 == null) {
            ((zzim)this).zzj().zzp().zza("Not logging ad exposure. No active activity");
            return;
        }
        if (l < 1000L) {
            ((zzim)this).zzj().zzp().zza("Not logging ad exposure. Less than 1000 ms. exposure", l);
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putLong("_xt", l);
        zznt.zza(zzks2, bundle, true);
        ((zzd)this).zzm().zzc("am", "_xa", bundle);
    }

    @WorkerThread
    private final void zza(String string, long l, @Nullable zzks zzks2) {
        if (zzks2 == null) {
            ((zzim)this).zzj().zzp().zza("Not logging ad unit exposure. No active activity");
            return;
        }
        if (l < 1000L) {
            ((zzim)this).zzj().zzp().zza("Not logging ad unit exposure. Less than 1000 ms. exposure", l);
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putString("_ai", string);
        bundle.putLong("_xt", l);
        zznt.zza(zzks2, bundle, true);
        ((zzd)this).zzm().zzc("am", "_xu", bundle);
    }

    @WorkerThread
    public final void zza(long l) {
        zzks zzks2 = ((zzd)this).zzn().zza(false);
        for (String string : this.zza.keySet()) {
            long l2 = this.zza.get(string);
            this.zza(string, l - l2, zzks2);
        }
        if (!this.zza.isEmpty()) {
            this.zza(l - this.zzc, zzks2);
        }
        this.zzb(l);
    }

    @WorkerThread
    private final void zzb(long l) {
        for (String string : this.zza.keySet()) {
            this.zza.put(string, l);
        }
        if (!this.zza.isEmpty()) {
            this.zzc = l;
        }
    }
}

