/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.content.ContentResolver;
import android.database.ContentObserver;
import android.database.Cursor;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import android.os.StrictMode;
import android.util.Log;
import androidx.annotation.GuardedBy;
import androidx.annotation.Nullable;
import androidx.collection.ArrayMap;
import com.google.android.gms.internal.measurement.zzgs;
import com.google.android.gms.internal.measurement.zzgu;
import com.google.android.gms.internal.measurement.zzgv;
import com.google.android.gms.internal.measurement.zzgw;
import com.google.android.gms.internal.measurement.zzgz;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class zzgt
implements zzgw {
    @GuardedBy(value="ConfigurationContentLoader.class")
    private static final Map<Uri, zzgt> zza = new ArrayMap();
    private static final String[] zzb = new String[]{"key", "value"};
    private final ContentResolver zzc;
    private final Uri zzd;
    private final Runnable zze;
    private final ContentObserver zzf = new zzgv(this, null);
    private final Object zzg = new Object();
    private volatile Map<String, String> zzh;
    @GuardedBy(value="this")
    private final List<zzgu> zzi = new ArrayList<zzgu>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzgt zza(ContentResolver contentResolver, Uri uri, Runnable runnable) {
        Class<zzgt> clazz = zzgt.class;
        synchronized (zzgt.class) {
            zzgt zzgt2 = zza.get(uri);
            if (zzgt2 == null) {
                try {
                    zzgt2 = new zzgt(contentResolver, uri, runnable);
                    zza.put(uri, zzgt2);
                }
                catch (SecurityException securityException) {}
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return zzgt2;
        }
    }

    @Override
    public final /* synthetic */ Object zza(String string) {
        String string2 = string;
        return this.zza().get(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Map<String, String> zza() {
        Map<String, String> map = this.zzh;
        if (map == null) {
            Object object = this.zzg;
            synchronized (object) {
                map = this.zzh;
                if (map == null) {
                    this.zzh = map = this.zze();
                }
            }
        }
        if (map != null) {
            return map;
        }
        return Collections.emptyMap();
    }

    final /* synthetic */ Map zzb() {
        Cursor cursor = this.zzc.query(this.zzd, zzb, null, null, null);
        if (cursor == null) {
            return Collections.emptyMap();
        }
        try {
            Object object;
            int n = cursor.getCount();
            if (n == 0) {
                Map map = Collections.emptyMap();
                return map;
            }
            Object object2 = object = n <= 256 ? new ArrayMap(n) : new HashMap(n, 1.0f);
            while (cursor.moveToNext()) {
                object.put(cursor.getString(0), cursor.getString(1));
            }
            Object object3 = object;
            return object3;
        }
        finally {
            cursor.close();
        }
    }

    @Nullable
    private final Map<String, String> zze() {
        StrictMode.ThreadPolicy threadPolicy = StrictMode.allowThreadDiskReads();
        try {
            zzgt zzgt2 = this;
            Map map = (Map)zzgz.zza(new zzgs(zzgt2));
            return map;
        }
        catch (SQLiteException | IllegalStateException | SecurityException throwable) {
            Log.e((String)"ConfigurationContentLdr", (String)"PhenotypeFlag unable to load ContentProvider, using default values");
            return null;
        }
        finally {
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)threadPolicy);
        }
    }

    private zzgt(ContentResolver contentResolver, Uri uri, Runnable runnable) {
        Preconditions.checkNotNull((Object)contentResolver);
        Preconditions.checkNotNull((Object)uri);
        this.zzc = contentResolver;
        this.zzd = uri;
        this.zze = runnable;
        contentResolver.registerContentObserver(uri, false, this.zzf);
    }

    static synchronized void zzc() {
        for (zzgt zzgt2 : zza.values()) {
            zzgt2.zzc.unregisterContentObserver(zzgt2.zzf);
        }
        zza.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzd() {
        zzgt zzgt2;
        Object object = this.zzg;
        synchronized (object) {
            this.zzh = null;
            this.zze.run();
        }
        zzgt zzgt3 = zzgt2 = this;
        synchronized (zzgt2) {
            Iterator<zzgu> iterator = zzgt2.zzi.iterator();
            while (iterator.hasNext()) {
                iterator.next().zza();
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }
}

