/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Activity;
import android.os.Bundle;
import androidx.annotation.GuardedBy;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Size;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.measurement.internal.zza;
import com.google.android.gms.measurement.internal.zzd;
import com.google.android.gms.measurement.internal.zze;
import com.google.android.gms.measurement.internal.zzg;
import com.google.android.gms.measurement.internal.zzho;
import com.google.android.gms.measurement.internal.zzio;
import com.google.android.gms.measurement.internal.zzkx;
import com.google.android.gms.measurement.internal.zzky;
import com.google.android.gms.measurement.internal.zzkz;
import com.google.android.gms.measurement.internal.zzla;
import com.google.android.gms.measurement.internal.zzlb;
import com.google.android.gms.measurement.internal.zzlc;
import com.google.android.gms.measurement.internal.zzld;
import com.google.android.gms.measurement.internal.zznw;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class zzkw
extends zzg {
    private volatile @Nullable zzkx zzb;
    private volatile @Nullable zzkx zzc;
    @VisibleForTesting
    protected @Nullable zzkx zza;
    private final Map<Activity, zzkx> zzd;
    @GuardedBy(value="activityLock")
    private @Nullable Activity zze;
    @GuardedBy(value="activityLock")
    private volatile boolean zzf;
    private volatile @Nullable zzkx zzg;
    private @Nullable zzkx zzh;
    @GuardedBy(value="activityLock")
    private boolean zzi;
    private final Object zzj = new Object();

    static /* bridge */ /* synthetic */ zzkx zza(zzkw zzkw2) {
        return zzkw2.zzh;
    }

    @MainThread
    private final zzkx zzd(@NonNull Activity activity) {
        Preconditions.checkNotNull((Object)activity);
        zzkx zzkx2 = this.zzd.get(activity);
        if (zzkx2 == null) {
            String string = this.zza(activity.getClass(), "Activity");
            zzkx2 = new zzkx(null, string, ((zzio)this).zzq().zzm());
            this.zzd.put(activity, zzkx2);
        }
        if (this.zzg != null) {
            return this.zzg;
        }
        return zzkx2;
    }

    public final @Nullable zzkx zzaa() {
        return this.zzb;
    }

    @WorkerThread
    public final @Nullable zzkx zza(boolean bl) {
        this.zzu();
        ((zzio)this).zzt();
        if (!bl) {
            return this.zza;
        }
        if (this.zza != null) {
            return this.zza;
        }
        return this.zzh;
    }

    @VisibleForTesting
    private final String zza(Class<?> clazz, String string) {
        String string2 = clazz.getCanonicalName();
        if (string2 == null) {
            return string;
        }
        String string3 = string2;
        zzkw zzkw2 = this;
        String[] stringArray = string3.split("\\.");
        String string4 = stringArray.length > 0 ? stringArray[stringArray.length - 1] : "";
        if (string4.length() > ((zzio)zzkw2).zze().zza(null, false)) {
            return string4.substring(0, ((zzio)zzkw2).zze().zza(null, false));
        }
        return string4;
    }

    static /* bridge */ /* synthetic */ void zza(zzkw zzkw2, zzkx zzkx2) {
        zzkw2.zzh = null;
    }

    static /* bridge */ /* synthetic */ void zza(zzkw zzkw2, zzkx zzkx2, zzkx zzkx3, long l, boolean bl, Bundle bundle) {
        zzkw2.zza(zzkx2, zzkx3, l, bl, null);
    }

    static /* synthetic */ void zza(zzkw zzkw2, Bundle bundle, zzkx zzkx2, zzkx zzkx3, long l) {
        long l2 = l;
        zzkx zzkx4 = zzkx3;
        zzkx zzkx5 = zzkx2;
        Bundle bundle2 = bundle;
        zzkw zzkw3 = zzkw2;
        if (bundle2 != null) {
            bundle2.remove("screen_name");
            bundle2.remove("screen_class");
        }
        Bundle bundle3 = ((zzio)zzkw3).zzq().zza(null, "screen_view", bundle2, null, false);
        zzkw3.zza(zzkx5, zzkx4, l2, true, bundle3);
    }

    static /* bridge */ /* synthetic */ void zza(zzkw zzkw2, zzkx zzkx2, boolean bl, long l) {
        zzkw2.zza(zzkx2, false, l);
    }

    public zzkw(zzho zzho2) {
        super(zzho2);
        this.zzd = new ConcurrentHashMap<Activity, zzkx>();
    }

    @MainThread
    private final void zza(Activity activity, zzkx zzkx2, boolean bl) {
        zzkx zzkx3;
        zzkx zzkx4;
        zzkx zzkx5 = zzkx4 = this.zzb == null ? this.zzc : this.zzb;
        if (zzkx2.zzb == null) {
            zzkx3 = activity != null ? this.zza(activity.getClass(), "Activity") : null;
            zzkx2 = new zzkx(zzkx2.zza, (String)((Object)zzkx3), zzkx2.zzc, zzkx2.zze, zzkx2.zzf);
        }
        zzkx3 = zzkx2;
        this.zzc = this.zzb;
        this.zzb = zzkx3;
        long l = ((zzio)this).zzb().elapsedRealtime();
        ((zzio)this).zzl().zzb(new zzky(this, zzkx3, zzkx4, l, bl));
    }

    @WorkerThread
    private final void zza(zzkx zzkx2, @Nullable zzkx zzkx3, long l, boolean bl, @Nullable Bundle bundle) {
        boolean bl2;
        ((zzio)this).zzt();
        boolean bl3 = zzkx3 == null || zzkx3.zzc != zzkx2.zzc || !Objects.equals(zzkx3.zzb, zzkx2.zzb) || !Objects.equals(zzkx3.zza, zzkx2.zza);
        boolean bl4 = bl2 = bl && this.zza != null;
        if (bl3) {
            long l2;
            long l3;
            Bundle bundle2 = bundle != null ? new Bundle(bundle) : new Bundle();
            zznw.zza(zzkx2, bundle2, true);
            if (zzkx3 != null) {
                if (zzkx3.zza != null) {
                    bundle2.putString("_pn", zzkx3.zza);
                }
                if (zzkx3.zzb != null) {
                    bundle2.putString("_pc", zzkx3.zzb);
                }
                bundle2.putLong("_pi", zzkx3.zzc);
            }
            if (bl2 && (l3 = ((zzd)this).zzp().zzb.zza(l2 = l)) > 0L) {
                ((zzio)this).zzq().zza(bundle2, l3);
            }
            if (!((zzio)this).zze().zzv()) {
                bundle2.putLong("_mst", 1L);
            }
            String string = zzkx2.zze ? "app" : "auto";
            long l4 = ((zzio)this).zzb().currentTimeMillis();
            if (zzkx2.zze && zzkx2.zzf != 0L) {
                l4 = zzkx2.zzf;
            }
            ((zzd)this).zzm().zza(string, "_vs", l4, bundle2);
        }
        if (bl2) {
            this.zza(this.zza, true, l);
        }
        this.zza = zzkx2;
        if (zzkx2.zze) {
            this.zzh = zzkx2;
        }
        ((zzd)this).zzo().zza(zzkx2);
    }

    @MainThread
    public final void zza(Activity activity, @Nullable Bundle bundle) {
        if (!((zzio)this).zze().zzv()) {
            return;
        }
        if (bundle == null) {
            return;
        }
        Bundle bundle2 = bundle.getBundle("com.google.app_measurement.screen_service");
        if (bundle2 == null) {
            return;
        }
        zzkx zzkx2 = new zzkx(bundle2.getString("name"), bundle2.getString("referrer_name"), bundle2.getLong("id"));
        this.zzd.put(activity, zzkx2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void zza(Activity activity) {
        Object object = this.zzj;
        synchronized (object) {
            if (activity == this.zze) {
                this.zze = null;
            }
        }
        if (!((zzio)this).zze().zzv()) {
            return;
        }
        this.zzd.remove(activity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void zzb(Activity activity) {
        Object object = this.zzj;
        synchronized (object) {
            this.zzi = false;
            this.zzf = true;
        }
        long l = ((zzio)this).zzb().elapsedRealtime();
        if (!((zzio)this).zze().zzv()) {
            this.zzb = null;
            ((zzio)this).zzl().zzb(new zzla(this, l));
            return;
        }
        zzkx zzkx2 = this.zzd(activity);
        this.zzc = this.zzb;
        this.zzb = null;
        ((zzio)this).zzl().zzb(new zzld(this, zzkx2, l));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void zzc(Activity activity) {
        zzd zzd2;
        Object object = this.zzj;
        synchronized (object) {
            this.zzi = true;
            if (activity != this.zze) {
                Activity activity2 = activity;
                zzd2 = this;
                Object object2 = ((zzkw)zzd2).zzj;
                synchronized (object2) {
                    ((zzkw)zzd2).zze = activity2;
                    ((zzkw)zzd2).zzf = false;
                }
                if (zzd2.zze().zzv()) {
                    ((zzkw)zzd2).zzg = null;
                    zzd2.zzl().zzb(new zzlc((zzkw)zzd2));
                }
            }
        }
        if (!((zzio)this).zze().zzv()) {
            this.zzb = this.zzg;
            ((zzio)this).zzl().zzb(new zzlb(this));
            return;
        }
        object = this.zzd(activity);
        this.zza(activity, (zzkx)object, false);
        zzd2 = ((zzd)this).zzc();
        long l = zzd2.zzb().elapsedRealtime();
        zzd2.zzl().zzb(new zze((zza)zzd2, l));
    }

    @MainThread
    public final void zzb(Activity activity, Bundle bundle) {
        if (!((zzio)this).zze().zzv()) {
            return;
        }
        if (bundle == null) {
            return;
        }
        zzkx zzkx2 = this.zzd.get(activity);
        if (zzkx2 == null) {
            return;
        }
        Bundle bundle2 = new Bundle();
        bundle2.putLong("id", zzkx2.zzc);
        bundle2.putString("name", zzkx2.zza);
        bundle2.putString("referrer_name", zzkx2.zzb);
        bundle.putBundle("com.google.app_measurement.screen_service", bundle2);
    }

    @WorkerThread
    private final void zza(@Nullable zzkx zzkx2, boolean bl, long l) {
        boolean bl2;
        ((zzd)this).zzc().zza(((zzio)this).zzb().elapsedRealtime());
        boolean bl3 = bl2 = zzkx2 != null && zzkx2.zzd;
        if (((zzd)this).zzp().zza(bl2, bl, l) && zzkx2 != null) {
            zzkx2.zzd = false;
        }
    }

    @Deprecated
    public final void zza(@NonNull Activity activity, @Size(min=1L, max=36L) @Nullable String string, @Size(min=1L, max=36L) @Nullable String string2) {
        if (!((zzio)this).zze().zzv()) {
            ((zzio)this).zzj().zzv().zza("setCurrentScreen cannot be called while screen reporting is disabled.");
            return;
        }
        zzkx zzkx2 = this.zzb;
        if (zzkx2 == null) {
            ((zzio)this).zzj().zzv().zza("setCurrentScreen cannot be called while no activity active");
            return;
        }
        if (this.zzd.get(activity) == null) {
            ((zzio)this).zzj().zzv().zza("setCurrentScreen must be called with an activity in the activity lifecycle");
            return;
        }
        if (string2 == null) {
            string2 = this.zza(activity.getClass(), "Activity");
        }
        boolean bl = Objects.equals(zzkx2.zzb, string2);
        boolean bl2 = Objects.equals(zzkx2.zza, string);
        if (bl && bl2) {
            ((zzio)this).zzj().zzv().zza("setCurrentScreen cannot be called with the same class and name");
            return;
        }
        if (string != null && (string.length() <= 0 || string.length() > ((zzio)this).zze().zza(null, false))) {
            ((zzio)this).zzj().zzv().zza("Invalid screen name length in setCurrentScreen. Length", string.length());
            return;
        }
        if (string2 != null && (string2.length() <= 0 || string2.length() > ((zzio)this).zze().zza(null, false))) {
            ((zzio)this).zzj().zzv().zza("Invalid class name length in setCurrentScreen. Length", string2.length());
            return;
        }
        ((zzio)this).zzj().zzp().zza("Setting current screen to name, class", string == null ? "null" : string, string2);
        zzkx zzkx3 = new zzkx(string, string2, ((zzio)this).zzq().zzm());
        this.zzd.put(activity, zzkx3);
        this.zza(activity, zzkx3, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(Bundle bundle, long l) {
        zzkx zzkx2;
        String string = null;
        String string2 = null;
        Object object = this.zzj;
        synchronized (object) {
            if (!this.zzi) {
                ((zzio)this).zzj().zzv().zza("Cannot log screen view event when the app is in the background.");
                return;
            }
            if (bundle != null) {
                string = bundle.getString("screen_name");
                if (string != null && (string.length() <= 0 || string.length() > ((zzio)this).zze().zza(null, false))) {
                    ((zzio)this).zzj().zzv().zza("Invalid screen name length for screen view. Length", string.length());
                    return;
                }
                string2 = bundle.getString("screen_class");
                if (string2 != null && (string2.length() <= 0 || string2.length() > ((zzio)this).zze().zza(null, false))) {
                    ((zzio)this).zzj().zzv().zza("Invalid screen class length for screen view. Length", string2.length());
                    return;
                }
            }
            if (string2 == null) {
                string2 = this.zze != null ? this.zza(this.zze.getClass(), "Activity") : "Activity";
            }
            zzkx2 = this.zzb;
            if (this.zzf && zzkx2 != null) {
                this.zzf = false;
                boolean bl = Objects.equals(zzkx2.zzb, string2);
                boolean bl2 = Objects.equals(zzkx2.zza, string);
                if (bl && bl2) {
                    ((zzio)this).zzj().zzv().zza("Ignoring call to log screen view event with duplicate parameters.");
                    return;
                }
            }
        }
        ((zzio)this).zzj().zzp().zza("Logging screen view with name, class", string == null ? "null" : string, string2 == null ? "null" : string2);
        object = this.zzb == null ? this.zzc : this.zzb;
        this.zzb = zzkx2 = new zzkx(string, string2, ((zzio)this).zzq().zzm(), true, l);
        this.zzc = object;
        this.zzg = zzkx2;
        long l2 = ((zzio)this).zzb().elapsedRealtime();
        ((zzio)this).zzl().zzb(new zzkz(this, bundle, zzkx2, (zzkx)object, l2));
    }

    @Override
    protected final boolean zzz() {
        return false;
    }
}

