/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.RemoteException;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.internal.BaseGmsClient;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.measurement.internal.zzfq;
import com.google.android.gms.measurement.internal.zzfs;
import com.google.android.gms.measurement.internal.zzfy;
import com.google.android.gms.measurement.internal.zzgb;
import com.google.android.gms.measurement.internal.zzio;
import com.google.android.gms.measurement.internal.zzlf;
import com.google.android.gms.measurement.internal.zzmc;
import com.google.android.gms.measurement.internal.zzmd;
import com.google.android.gms.measurement.internal.zzme;
import com.google.android.gms.measurement.internal.zzmf;
import com.google.android.gms.measurement.internal.zzmh;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class zzma
implements ServiceConnection,
BaseGmsClient.BaseConnectionCallbacks,
BaseGmsClient.BaseOnConnectionFailedListener {
    private volatile boolean zzb;
    private volatile @Nullable zzfy zzc;
    final /* synthetic */ zzlf zza;

    static /* bridge */ /* synthetic */ void zza(zzma zzma2, boolean bl) {
        zzma2.zzb = false;
    }

    protected zzma(zzlf zzlf2) {
        this.zza = zzlf2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zza(Intent intent) {
        ((zzio)this.zza).zzt();
        Context context = ((zzio)this.zza).zza();
        ConnectionTracker connectionTracker = ConnectionTracker.getInstance();
        zzma zzma2 = this;
        synchronized (zzma2) {
            if (this.zzb) {
                ((zzio)this.zza).zzj().zzp().zza("Connection attempt already in progress");
                return;
            }
            ((zzio)this.zza).zzj().zzp().zza("Using local app measurement service");
            this.zzb = true;
            connectionTracker.bindService(context, intent, (ServiceConnection)zzlf.zzb(this.zza), 129);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zza() {
        ((zzio)this.zza).zzt();
        Context context = ((zzio)this.zza).zza();
        zzma zzma2 = this;
        synchronized (zzma2) {
            if (this.zzb) {
                ((zzio)this.zza).zzj().zzp().zza("Connection attempt already in progress");
                return;
            }
            if (this.zzc != null && (this.zzc.isConnecting() || this.zzc.isConnected())) {
                ((zzio)this.zza).zzj().zzp().zza("Already awaiting connection attempt");
                return;
            }
            this.zzc = new zzfy(context, Looper.getMainLooper(), this, this);
            ((zzio)this.zza).zzj().zzp().zza("Connecting to remote service");
            this.zzb = true;
            Preconditions.checkNotNull((Object)((Object)this.zzc));
            this.zzc.checkAvailabilityAndConnect();
            return;
        }
    }

    @WorkerThread
    public final void zzb() {
        if (this.zzc != null && (this.zzc.isConnected() || this.zzc.isConnecting())) {
            this.zzc.disconnect();
        }
        this.zzc = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onConnected(@Nullable Bundle bundle) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnected");
        zzma zzma2 = this;
        synchronized (zzma2) {
            try {
                Preconditions.checkNotNull((Object)((Object)this.zzc));
                zzfq zzfq2 = (zzfq)this.zzc.getService();
                ((zzio)this.zza).zzl().zzb(new zzmf(this, zzfq2));
            }
            catch (DeadObjectException | IllegalStateException throwable) {
                this.zzc = null;
                this.zzb = false;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnectionFailed");
        zzgb zzgb2 = this.zza.zzu.zzm();
        if (zzgb2 != null) {
            zzgb2.zzu().zza("Service connection failed", connectionResult);
        }
        zzma zzma2 = this;
        synchronized (zzma2) {
            this.zzb = false;
            this.zzc = null;
        }
        ((zzio)this.zza).zzl().zzb(new zzmh(this));
    }

    @MainThread
    public final void onConnectionSuspended(int n) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnectionSuspended");
        ((zzio)this.zza).zzj().zzc().zza("Service connection suspended");
        ((zzio)this.zza).zzl().zzb(new zzme(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onServiceConnected(ComponentName componentName, @Nullable IBinder iBinder) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onServiceConnected");
        zzma zzma2 = this;
        synchronized (zzma2) {
            String string;
            if (iBinder == null) {
                this.zzb = false;
                ((zzio)this.zza).zzj().zzg().zza("Service connected with null binder");
                return;
            }
            zzfq zzfq2 = null;
            try {
                string = iBinder.getInterfaceDescriptor();
                if ("com.google.android.gms.measurement.internal.IMeasurementService".equals(string)) {
                    IInterface iInterface;
                    IBinder iBinder2 = iBinder;
                    zzfq2 = iBinder2 == null ? null : ((iInterface = iBinder2.queryLocalInterface("com.google.android.gms.measurement.internal.IMeasurementService")) instanceof zzfq ? (zzfq)iInterface : new zzfs(iBinder2));
                    ((zzio)this.zza).zzj().zzp().zza("Bound to IMeasurementService interface");
                } else {
                    ((zzio)this.zza).zzj().zzg().zza("Got binder with a wrong descriptor", string);
                }
            }
            catch (RemoteException remoteException) {
                ((zzio)this.zza).zzj().zzg().zza("Service connect failed to get IMeasurementService");
            }
            if (zzfq2 == null) {
                this.zzb = false;
                try {
                    ConnectionTracker.getInstance().unbindService(((zzio)this.zza).zza(), (ServiceConnection)zzlf.zzb(this.zza));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            } else {
                string = zzfq2;
                ((zzio)this.zza).zzl().zzb(new zzmd(this, (zzfq)((Object)string)));
            }
            return;
        }
    }

    @MainThread
    public final void onServiceDisconnected(ComponentName componentName) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onServiceDisconnected");
        ((zzio)this.zza).zzj().zzc().zza("Service disconnected");
        ((zzio)this.zza).zzl().zzb(new zzmc(this, componentName));
    }
}

