/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.content.pm.Signature;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ext.SdkExtensions;
import android.text.TextUtils;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import androidx.privacysandbox.ads.adservices.java.measurement.MeasurementManagerFutures;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.CollectionUtils;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzdi;
import com.google.android.gms.internal.measurement.zzpn;
import com.google.android.gms.internal.measurement.zzqr;
import com.google.android.gms.measurement.internal.zzae;
import com.google.android.gms.measurement.internal.zzbc;
import com.google.android.gms.measurement.internal.zzbd;
import com.google.android.gms.measurement.internal.zzbf;
import com.google.android.gms.measurement.internal.zzfz;
import com.google.android.gms.measurement.internal.zzgd;
import com.google.android.gms.measurement.internal.zzhm;
import com.google.android.gms.measurement.internal.zzim;
import com.google.android.gms.measurement.internal.zzip;
import com.google.android.gms.measurement.internal.zzir;
import com.google.android.gms.measurement.internal.zziu;
import com.google.android.gms.measurement.internal.zziv;
import com.google.android.gms.measurement.internal.zziw;
import com.google.android.gms.measurement.internal.zzkv;
import com.google.android.gms.measurement.internal.zznt;
import com.google.android.gms.measurement.internal.zznx;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Random;
import java.util.TreeSet;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import javax.security.auth.x500.X500Principal;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class zzny
extends zzip {
    private static final String[] zza = new String[]{"firebase_", "google_", "ga_"};
    private static final String[] zzb = new String[]{"_err"};
    private @MonotonicNonNull SecureRandom zzc;
    private final AtomicLong zzd = new AtomicLong(0L);
    private int zze;
    private @Nullable MeasurementManagerFutures zzf;
    private Boolean zzg;
    private @MonotonicNonNull Integer zzh = null;

    /*
     * Unable to fully structure code
     */
    @WorkerThread
    private final int zza(@Nullable String var1_1, @Nullable String var2_2, @Nullable String var3_3, @Nullable Object var4_4, Bundle var5_5, @Nullable List<String> var6_6, boolean var7_7, boolean var8_8) {
        block25: {
            block26: {
                block27: {
                    this.zzt();
                    var9_9 = 0;
                    if (!zzny.zza(var4_4)) break block25;
                    if (!var8_8) break block26;
                    if (!zzny.zza(var3_3, zziw.zzc)) {
                        return 20;
                    }
                    if (!this.zzu.zzr().zzal()) {
                        return 25;
                    }
                    var15_10 = var4_4;
                    var13_11 = var3_3;
                    var12_12 = "param";
                    var11_13 = this;
                    if (!(var15_10 instanceof Parcelable[])) break block27;
                    var16_14 = ((Parcelable[])var15_10).length;
                    ** GOTO lbl21
                }
                if (!(var15_10 instanceof ArrayList)) {
                    v0 = true;
                } else {
                    var16_14 = ((ArrayList)var15_10).size();
lbl21:
                    // 2 sources

                    if (var16_14 > 200) {
                        var11_13.zzj().zzv().zza("Parameter array is too long; discarded. Value kind, name, array length", var12_12, var13_11, var16_14);
                        v0 = false;
                    } else {
                        v0 = true;
                    }
                }
                if (!v0) {
                    var9_9 = 17;
                    var14_17 = var4_4;
                    var12_12 = var3_3;
                    var11_13 = var5_5;
                    if (var14_17 instanceof Parcelable[]) {
                        if (((Parcelable[])var14_17).length > 200) {
                            var11_13.putParcelableArray(var12_12, Arrays.copyOf((Parcelable[])var14_17, 200));
                        }
                    } else if (var14_17 instanceof ArrayList && (var16_15 = (ArrayList)var14_17).size() > 200) {
                        var11_13.putParcelableArrayList(var12_12, new ArrayList<E>(var16_15.subList(0, 200)));
                    }
                }
                break block25;
            }
            return 21;
        }
        if (this.zza("param", var3_3, var10_18 = zzny.zzg(var2_2) != false || zzny.zzg(var3_3) != false ? this.zze().zzb(null, false) : this.zze().zza(null, false), var4_4)) {
            return var9_9;
        }
        if (var8_8) {
            var17_19 = var7_7;
            var16_16 = var6_6;
            var15_10 = var4_4;
            var14_17 = var3_3;
            var13_11 = var2_2;
            var12_12 = var1_1;
            var11_13 = this;
            if (var15_10 instanceof Bundle) {
                var11_13.zza(var12_12, var13_11, (String)var14_17, (Bundle)var15_10, var16_16, var17_19);
                v1 = true;
            } else if (var15_10 instanceof Parcelable[]) {
                for (Parcelable var21_24 : (Parcelable[])var15_10) {
                    if (!(var21_24 instanceof Bundle)) {
                        var11_13.zzj().zzv().zza("All Parcelable[] elements must be of type Bundle. Value type, name", var21_24.getClass(), var14_17);
                        ** break block24
                    }
                    var11_13.zza(var12_12, var13_11, (String)var14_17, (Bundle)var21_24, var16_16, var17_19);
                }
                v1 = true;
            } else if (var15_10 instanceof ArrayList) {
                var22_25 = (ArrayList)var15_10;
                var23_26 = var22_25.size();
                for (var24_27 = 0; var24_27 < var23_26; ++var24_27) {
                    v2 = var22_25.get(var24_27);
                    var19_22 = v2;
                    if (!(v2 instanceof Bundle)) {
                        var11_13.zzj().zzv().zza("All ArrayList elements must be of type Bundle. Value type, name", var19_22 != null ? var19_22.getClass() : "null", var14_17);
                        ** break block24
                    }
                    var11_13.zza(var12_12, var13_11, (String)var14_17, (Bundle)var19_22, var16_16, var17_19);
                }
                v1 = true;
            } else lbl-1000:
            // 3 sources

            {
                v1 = false;
            }
            if (v1) {
                return var9_9;
            }
        }
        return 4;
    }

    final int zza(@Nullable String string, @Nullable Object object) {
        boolean bl = "_ldl".equals(string) ? this.zza("user property referrer", string, zzny.zzm(string), object) : this.zza("user property", string, zzny.zzm(string), object);
        if (bl) {
            return 0;
        }
        return 7;
    }

    final int zza(@Nullable String string) {
        if (!this.zzb("event", string)) {
            return 2;
        }
        if (!this.zza("event", zziu.zza, zziu.zzb, string)) {
            return 13;
        }
        if (!this.zza("event", 40, string)) {
            return 2;
        }
        return 0;
    }

    private final int zzk(@Nullable String string) {
        if (!this.zzb("event param", string)) {
            return 3;
        }
        if (!this.zza("event param", null, string)) {
            return 14;
        }
        if (!this.zza("event param", 40, string)) {
            return 3;
        }
        return 0;
    }

    private final int zzl(String string) {
        if (!this.zzc("event param", string)) {
            return 3;
        }
        if (!this.zza("event param", null, string)) {
            return 14;
        }
        if (!this.zza("event param", 40, string)) {
            return 3;
        }
        return 0;
    }

    final int zzb(@Nullable String string) {
        if (!this.zzb("user property", string)) {
            return 6;
        }
        if (!this.zza("user property", zziv.zza, string)) {
            return 15;
        }
        if (!this.zza("user property", 24, string)) {
            return 6;
        }
        return 0;
    }

    static int zzc() {
        if (Build.VERSION.SDK_INT >= 30 && SdkExtensions.getExtensionVersion((int)30) > 3) {
            return SdkExtensions.getExtensionVersion((int)1000000);
        }
        return 0;
    }

    @EnsuresNonNull(value={"this.apkVersion"})
    public final int zzg() {
        if (this.zzh == null) {
            this.zzh = GoogleApiAvailabilityLight.getInstance().getApkVersion(((zzim)this).zza()) / 1000;
        }
        return this.zzh;
    }

    private static int zzm(@Nullable String string) {
        if ("_ldl".equals(string)) {
            return 2048;
        }
        if ("_id".equals(string)) {
            return 256;
        }
        if ("_lgclid".equals(string)) {
            return 100;
        }
        if ("_gbraid".equals(string)) {
            return 100;
        }
        return 36;
    }

    public final int zza(int n) {
        return GoogleApiAvailabilityLight.getInstance().isGooglePlayServicesAvailable(((zzim)this).zza(), 12451000);
    }

    @WorkerThread
    final long zzc(String string) {
        int n = 0;
        if (((zzim)this).zza().getPackageManager() == null) {
            return 0L;
        }
        try {
            ApplicationInfo applicationInfo = Wrappers.packageManager((Context)((zzim)this).zza()).getApplicationInfo(string, 0);
            if (applicationInfo != null) {
                n = applicationInfo.targetSdkVersion;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            ((zzim)this).zzj().zzn().zza("PackageManager failed to find running app: app_id", string);
        }
        return n;
    }

    @WorkerThread
    final long zzh() {
        ((zzim)this).zzt();
        long l = 0L;
        if (!zzny.zzd(this.zzu.zzh().zzad())) {
            return 0L;
        }
        if (Build.VERSION.SDK_INT < 30) {
            l = 4L;
        } else if (SdkExtensions.getExtensionVersion((int)30) < 4) {
            l = 8L;
        } else if (zzny.zzc() < (Integer)zzbf.zzav.zza(null)) {
            l = 16L;
        }
        if (!this.zze("android.permission.ACCESS_ADSERVICES_ATTRIBUTION")) {
            l |= 2L;
        }
        if (l == 0L && !this.zzy()) {
            l |= 0x40L;
        }
        if (l == 0L) {
            return 1L;
        }
        return l;
    }

    @WorkerThread
    final long zza(Context context, String string) {
        ((zzim)this).zzt();
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotEmpty((String)string);
        long l = 0L;
        PackageManager packageManager = context.getPackageManager();
        MessageDigest messageDigest = zzny.zzu();
        if (messageDigest == null) {
            ((zzim)this).zzj().zzg().zza("Could not get MD5 instance");
            l = -1L;
        } else if (packageManager != null) {
            try {
                if (!this.zzb(context, string)) {
                    PackageInfo packageInfo = Wrappers.packageManager((Context)context).getPackageInfo(((zzim)this).zza().getPackageName(), 64);
                    if (packageInfo.signatures != null && packageInfo.signatures.length > 0) {
                        l = zzny.zza(messageDigest.digest(packageInfo.signatures[0].toByteArray()));
                    } else {
                        ((zzim)this).zzj().zzu().zza("Could not get signatures");
                        l = -1L;
                    }
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                ((zzim)this).zzj().zzg().zza("Package name not found", (Object)nameNotFoundException);
            }
        }
        return l;
    }

    @VisibleForTesting
    static long zza(byte[] byArray) {
        Preconditions.checkNotNull((Object)byArray);
        Preconditions.checkState((byArray.length > 0 ? 1 : 0) != 0);
        long l = 0L;
        int n = 0;
        for (int i = byArray.length - 1; i >= 0 && i >= byArray.length - 8; --i) {
            l += ((long)byArray[i] & 0xFFL) << n;
            n += 8;
        }
        return l;
    }

    public static long zza(zzbc zzbc2) {
        if (zzbc2 == null) {
            return 0L;
        }
        long l = 0L;
        for (String string : zzbc2) {
            Object object = zzbc2.zzc(string);
            if (!(object instanceof Parcelable[])) continue;
            l += (long)((Parcelable[])object).length;
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long zzm() {
        if (this.zzd.get() == 0L) {
            AtomicLong atomicLong = this.zzd;
            synchronized (atomicLong) {
                return new Random(System.nanoTime() ^ ((zzim)this).zzb().currentTimeMillis()).nextLong() + (long)(++this.zze);
            }
        }
        AtomicLong atomicLong = this.zzd;
        synchronized (atomicLong) {
            this.zzd.compareAndSet(-1L, 1L);
            return this.zzd.getAndIncrement();
        }
    }

    public static long zza(long l, long l2) {
        return (l + l2 * 60000L) / 86400000L;
    }

    public static Bundle zza(@Nullable List<zznt> list) {
        Bundle bundle = new Bundle();
        if (list == null) {
            return bundle;
        }
        for (zznt zznt2 : list) {
            if (zznt2.zzd != null) {
                bundle.putString(zznt2.zza, zznt2.zzd);
                continue;
            }
            if (zznt2.zzc != null) {
                bundle.putLong(zznt2.zza, zznt2.zzc.longValue());
                continue;
            }
            if (zznt2.zzf == null) continue;
            bundle.putDouble(zznt2.zza, zznt2.zzf.doubleValue());
        }
        return bundle;
    }

    final @Nullable Bundle zza(@Nullable Uri uri, boolean bl) {
        if (uri == null) {
            return null;
        }
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        try {
            if (uri.isHierarchical()) {
                string = uri.getQueryParameter("utm_campaign");
                string2 = uri.getQueryParameter("utm_source");
                string3 = uri.getQueryParameter("utm_medium");
                string4 = uri.getQueryParameter("gclid");
                if (bl) {
                    string5 = uri.getQueryParameter("gbraid");
                }
                string6 = uri.getQueryParameter("utm_id");
                string7 = uri.getQueryParameter("dclid");
                string8 = uri.getQueryParameter("srsltid");
                string9 = uri.getQueryParameter("sfmc_id");
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            ((zzim)this).zzj().zzu().zza("Install referrer url isn't a hierarchical URI", unsupportedOperationException);
            return null;
        }
        if (!(TextUtils.isEmpty(string) && TextUtils.isEmpty(string2) && TextUtils.isEmpty(string3) && TextUtils.isEmpty(string4) && (!bl || TextUtils.isEmpty(string5)) && TextUtils.isEmpty(string6) && TextUtils.isEmpty(string7) && TextUtils.isEmpty(string8) && TextUtils.isEmpty(string9))) {
            String string10;
            String string11;
            String string12;
            String string13;
            String string14;
            String string15;
            String string16;
            String string17;
            Bundle bundle = new Bundle();
            if (!TextUtils.isEmpty((CharSequence)string)) {
                bundle.putString("campaign", string);
            }
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                bundle.putString("source", string2);
            }
            if (!TextUtils.isEmpty((CharSequence)string3)) {
                bundle.putString("medium", string3);
            }
            if (!TextUtils.isEmpty((CharSequence)string4)) {
                bundle.putString("gclid", string4);
            }
            if (bl && !TextUtils.isEmpty((CharSequence)string5)) {
                bundle.putString("gbraid", string5);
            }
            if (!TextUtils.isEmpty((CharSequence)(string17 = uri.getQueryParameter("utm_term")))) {
                bundle.putString("term", string17);
            }
            if (!TextUtils.isEmpty((CharSequence)(string16 = uri.getQueryParameter("utm_content")))) {
                bundle.putString("content", string16);
            }
            if (!TextUtils.isEmpty((CharSequence)(string15 = uri.getQueryParameter("aclid")))) {
                bundle.putString("aclid", string15);
            }
            if (!TextUtils.isEmpty((CharSequence)(string14 = uri.getQueryParameter("cp1")))) {
                bundle.putString("cp1", string14);
            }
            if (!TextUtils.isEmpty((CharSequence)(string13 = uri.getQueryParameter("anid")))) {
                bundle.putString("anid", string13);
            }
            if (!TextUtils.isEmpty((CharSequence)string6)) {
                bundle.putString("campaign_id", string6);
            }
            if (!TextUtils.isEmpty((CharSequence)string7)) {
                bundle.putString("dclid", string7);
            }
            if (!TextUtils.isEmpty((CharSequence)(string12 = uri.getQueryParameter("utm_source_platform")))) {
                bundle.putString("source_platform", string12);
            }
            if (!TextUtils.isEmpty((CharSequence)(string11 = uri.getQueryParameter("utm_creative_format")))) {
                bundle.putString("creative_format", string11);
            }
            if (!TextUtils.isEmpty((CharSequence)(string10 = uri.getQueryParameter("utm_marketing_tactic")))) {
                bundle.putString("marketing_tactic", string10);
            }
            if (!TextUtils.isEmpty((CharSequence)string8)) {
                bundle.putString("srsltid", string8);
            }
            if (!TextUtils.isEmpty((CharSequence)string9)) {
                bundle.putString("sfmc_id", string9);
            }
            return bundle;
        }
        return null;
    }

    public static Bundle zza(Bundle bundle) {
        if (bundle == null) {
            return new Bundle();
        }
        Bundle bundle2 = new Bundle(bundle);
        for (String string : bundle2.keySet()) {
            int n;
            Object object;
            Object object2 = bundle2.get(string);
            if (object2 instanceof Bundle) {
                bundle2.putBundle(string, new Bundle((Bundle)object2));
                continue;
            }
            if (object2 instanceof Parcelable[]) {
                object = (Parcelable[])object2;
                for (n = 0; n < ((Parcelable[])object).length; ++n) {
                    if (!(object[n] instanceof Bundle)) continue;
                    object[n] = new Bundle((Bundle)object[n]);
                }
                continue;
            }
            if (!(object2 instanceof List)) continue;
            object = (List)object2;
            for (n = 0; n < object.size(); ++n) {
                Object e = object.get(n);
                if (!(e instanceof Bundle)) continue;
                object.set(n, new Bundle((Bundle)e));
            }
        }
        return bundle2;
    }

    final Bundle zza(@Nullable Bundle bundle, @Nullable String string) {
        Bundle bundle2 = new Bundle();
        if (bundle != null) {
            for (String string2 : bundle.keySet()) {
                Object object = this.zzb(string2, bundle.get(string2));
                if (object == null) {
                    ((zzim)this).zzj().zzv().zza("Param value can't be null", ((zzim)this).zzi().zzb(string2));
                    continue;
                }
                this.zza(bundle2, string2, object);
            }
        }
        return bundle2;
    }

    final @Nullable Bundle zza(@Nullable String string, String string2, @Nullable Bundle bundle, @Nullable List<String> list, boolean bl) {
        boolean bl2 = zzny.zza(string2, zziu.zzd);
        Bundle bundle2 = null;
        if (bundle != null) {
            bundle2 = new Bundle(bundle);
            int n = 0;
            int n2 = ((zzim)this).zze().zzg();
            for (String string3 : new TreeSet(bundle.keySet())) {
                String string4;
                int n3 = 0;
                if (list == null || !list.contains(string3)) {
                    if (!bl) {
                        n3 = this.zzl(string3);
                    }
                    if (n3 == 0) {
                        n3 = this.zzk(string3);
                    }
                }
                if (n3 != 0) {
                    zzny.zza(bundle2, n3, string3, (Object)(n3 == 3 ? string3 : null));
                    bundle2.remove(string3);
                    continue;
                }
                n3 = this.zza(string, string2, string3, bundle.get(string3), bundle2, list, bl, bl2);
                if (n3 == 17) {
                    zzny.zza(bundle2, n3, string3, false);
                } else if (n3 != 0 && !"_ev".equals(string3)) {
                    string4 = n3 == 21 ? string2 : string3;
                    zzny.zza(bundle2, n3, string4, bundle.get(string3));
                    bundle2.remove(string3);
                    continue;
                }
                if (!zzny.zzh(string3) || ++n <= n2) continue;
                int n4 = n2;
                string4 = "Event can't contain more than " + n4 + " params";
                ((zzim)this).zzj().zzh().zza(string4, ((zzim)this).zzi().zza(string2), ((zzim)this).zzi().zza(bundle));
                zzny.zzb(bundle2, 5);
                bundle2.remove(string3);
            }
        }
        return bundle2;
    }

    final @Nullable MeasurementManagerFutures zzn() {
        if (this.zzf == null) {
            this.zzf = MeasurementManagerFutures.from((Context)((zzim)this).zza());
        }
        return this.zzf;
    }

    final @Nullable zzbd zza(@Nullable String string, @Nullable String string2, @Nullable Bundle bundle, String string3, long l, boolean bl, boolean bl2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        if (this.zza(string2) != 0) {
            ((zzim)this).zzj().zzg().zza("Invalid conditional property event name", ((zzim)this).zzi().zzc(string2));
            throw new IllegalArgumentException();
        }
        bundle = bundle != null ? new Bundle(bundle) : new Bundle();
        bundle.putString("_o", string3);
        List list = CollectionUtils.listOf((Object)"_o");
        Bundle bundle2 = this.zza(string, string2, bundle, list, true);
        Bundle bundle3 = bl ? this.zza(bundle2, string) : bundle2;
        Preconditions.checkNotNull((Object)bundle3);
        return new zzbd(string2, new zzbc(bundle3), string3, l);
    }

    final @Nullable Object zzb(String string, @Nullable Object object) {
        if ("_ev".equals(string)) {
            return this.zza(((zzim)this).zze().zzb(null, false), object, true, true, null);
        }
        return this.zza(zzny.zzg(string) ? ((zzim)this).zze().zzb(null, false) : ((zzim)this).zze().zza(null, false), object, false, true, null);
    }

    final @Nullable Object zzc(@Nullable String string, @Nullable Object object) {
        if ("_ldl".equals(string)) {
            return this.zza(zzny.zzm(string), object, true, false, null);
        }
        return this.zza(zzny.zzm(string), object, false, false, null);
    }

    private final @Nullable Object zza(int n, @Nullable Object object, boolean bl, boolean bl2, @Nullable String string) {
        if (object == null) {
            return null;
        }
        if (object instanceof Long || object instanceof Double) {
            return object;
        }
        if (object instanceof Integer) {
            return (long)((Integer)object).intValue();
        }
        if (object instanceof Byte) {
            return (long)((Byte)object).byteValue();
        }
        if (object instanceof Short) {
            return (long)((Short)object).shortValue();
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1L : 0L;
        }
        if (object instanceof Float) {
            return ((Float)object).doubleValue();
        }
        if (object instanceof String || object instanceof Character || object instanceof CharSequence) {
            return zzny.zza(String.valueOf(object), n, bl);
        }
        if (bl2 && (object instanceof Bundle[] || object instanceof Parcelable[])) {
            ArrayList<Bundle> arrayList = new ArrayList<Bundle>();
            for (Parcelable parcelable : (Parcelable[])object) {
                Bundle bundle;
                if (!(parcelable instanceof Bundle) || (bundle = this.zza((Bundle)parcelable, (String)null)) == null || bundle.isEmpty()) continue;
                arrayList.add(bundle);
            }
            return arrayList.toArray(new Bundle[arrayList.size()]);
        }
        return null;
    }

    final String zzp() {
        byte[] byArray = new byte[16];
        this.zzv().nextBytes(byArray);
        return String.format(Locale.US, "%032x", new BigInteger(1, byArray));
    }

    public static @Nullable String zza(@Nullable String string, int n, boolean bl) {
        if (string == null) {
            return null;
        }
        if (string.codePointCount(0, string.length()) > n) {
            if (bl) {
                String string2 = string.substring(0, string.offsetByCodePoints(0, n));
                return string2 + "...";
            }
            return null;
        }
        return string;
    }

    public final @Nullable URL zza(long l, String string, String string2, long l2, String string3) {
        try {
            Preconditions.checkNotEmpty((String)string2);
            Preconditions.checkNotEmpty((String)string);
            String string4 = String.format("https://www.googleadservices.com/pagead/conversion/app/deeplink?id_type=adid&sdk_version=%s&rdid=%s&bundleid=%s&retry=%s", String.format("v%s.%s", l, this.zzg()), string2, string, l2);
            if (string.equals(((zzim)this).zze().zzo())) {
                string4 = string4.concat("&ddl_test=1");
            }
            if (!string3.isEmpty()) {
                if (string3.charAt(0) != '&') {
                    string4 = string4.concat("&");
                }
                string4 = string4.concat(string3);
            }
            return new URL(string4);
        }
        catch (IllegalArgumentException | MalformedURLException exception) {
            ((zzim)this).zzj().zzg().zza("Failed to create BOW URL for Deferred Deep Link. exception", exception.getMessage());
            return null;
        }
    }

    static @Nullable MessageDigest zzu() {
        for (int i = 0; i < 2; ++i) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                if (messageDigest == null) continue;
                return messageDigest;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
        }
        return null;
    }

    @EnsuresNonNull(value={"this.secureRandom"})
    @WorkerThread
    final SecureRandom zzv() {
        ((zzim)this).zzt();
        if (this.zzc == null) {
            this.zzc = new SecureRandom();
        }
        return this.zzc;
    }

    public static ArrayList<Bundle> zzb(@Nullable List<zzae> list) {
        if (list == null) {
            return new ArrayList<Bundle>(0);
        }
        ArrayList<Bundle> arrayList = new ArrayList<Bundle>(list.size());
        for (zzae zzae2 : list) {
            zzbd zzbd2;
            Bundle bundle = new Bundle();
            bundle.putString("app_id", zzae2.zza);
            bundle.putString("origin", zzae2.zzb);
            bundle.putLong("creation_timestamp", zzae2.zzd);
            bundle.putString("name", zzae2.zzc.zza);
            zzir.zza((Bundle)bundle, (Object)Preconditions.checkNotNull((Object)zzae2.zzc.zza()));
            bundle.putBoolean("active", zzae2.zze);
            if (zzae2.zzf != null) {
                bundle.putString("trigger_event_name", zzae2.zzf);
            }
            if (zzae2.zzg != null) {
                zzbd2 = zzae2.zzg;
                bundle.putString("timed_out_event_name", zzbd2.zza);
                if (zzbd2.zzb != null) {
                    bundle.putBundle("timed_out_event_params", zzbd2.zzb.zzb());
                }
            }
            bundle.putLong("trigger_timeout", zzae2.zzh);
            if (zzae2.zzi != null) {
                zzbd2 = zzae2.zzi;
                bundle.putString("triggered_event_name", zzbd2.zza);
                if (zzbd2.zzb != null) {
                    bundle.putBundle("triggered_event_params", zzbd2.zzb.zzb());
                }
            }
            bundle.putLong("triggered_timestamp", zzae2.zzc.zzb);
            bundle.putLong("time_to_live", zzae2.zzj);
            if (zzae2.zzk != null) {
                zzbd2 = zzae2.zzk;
                bundle.putString("expired_event_name", zzbd2.zza);
                if (zzbd2.zzb != null) {
                    bundle.putBundle("expired_event_params", zzbd2.zzb.zzb());
                }
            }
            arrayList.add(bundle);
        }
        return arrayList;
    }

    zzny(zzhm zzhm2) {
        super(zzhm2);
    }

    @WorkerThread
    final void zza(Bundle bundle, long l) {
        long l2 = bundle.getLong("_et");
        if (l2 != 0L) {
            ((zzim)this).zzj().zzu().zza("Params already contained engagement", l2);
        }
        bundle.putLong("_et", l + l2);
    }

    private static void zza(Bundle bundle, int n, String string, @Nullable Object object) {
        if (zzny.zzb(bundle, n)) {
            String string2 = zzny.zza(string, 40, true);
            bundle.putString("_ev", string2);
            if (object != null) {
                Object object2 = object;
                Bundle bundle2 = bundle;
                Preconditions.checkNotNull((Object)bundle2);
                if (object2 != null && (object2 instanceof String || object2 instanceof CharSequence)) {
                    String string3 = String.valueOf(object2);
                    bundle2.putLong("_el", (long)string3.length());
                }
            }
        }
    }

    @WorkerThread
    public static void zza(@Nullable zzkv zzkv2, @Nullable Bundle bundle, boolean bl) {
        if (bundle != null && zzkv2 != null && (!bundle.containsKey("_sc") || bl)) {
            if (zzkv2.zza != null) {
                bundle.putString("_sn", zzkv2.zza);
            } else {
                bundle.remove("_sn");
            }
            if (zzkv2.zzb != null) {
                bundle.putString("_sc", zzkv2.zzb);
            } else {
                bundle.remove("_sc");
            }
            bundle.putLong("_si", zzkv2.zzc);
            return;
        }
        if (bundle != null && zzkv2 == null && bl) {
            bundle.remove("_sn");
            bundle.remove("_sc");
            bundle.remove("_si");
        }
    }

    final void zza(Bundle bundle, @Nullable Bundle bundle2) {
        if (bundle2 == null) {
            return;
        }
        for (String string : bundle2.keySet()) {
            if (bundle.containsKey(string)) continue;
            ((zzim)this).zzq().zza(bundle, string, bundle2.get(string));
        }
    }

    final void zza(Parcelable @Nullable [] parcelableArray, int n, boolean bl) {
        Preconditions.checkNotNull((Object)parcelableArray);
        Parcelable[] parcelableArray2 = parcelableArray;
        int n2 = parcelableArray.length;
        for (int i = 0; i < n2; ++i) {
            Parcelable parcelable = parcelableArray2[i];
            int n3 = 0;
            Bundle bundle = (Bundle)parcelable;
            for (String string : new TreeSet(bundle.keySet())) {
                if (!zzny.zzh(string) || zzny.zza(string, zziw.zzd) || ++n3 <= n) continue;
                if (bl) {
                    int n4 = n;
                    ((zzim)this).zzj().zzh().zza("Param can't contain more than " + n4 + " item-scoped custom parameters", ((zzim)this).zzi().zzb(string), ((zzim)this).zzi().zza(bundle));
                    zzny.zzb(bundle, 28);
                } else {
                    ((zzim)this).zzj().zzh().zza("Param cannot contain item-scoped custom parameters", ((zzim)this).zzi().zzb(string), ((zzim)this).zzi().zza(bundle));
                    zzny.zzb(bundle, 23);
                }
                bundle.remove(string);
            }
        }
    }

    final void zza(zzgd zzgd2, int n) {
        int n2 = 0;
        for (String string : new TreeSet(zzgd2.zzb.keySet())) {
            if (!zzny.zzh(string) || ++n2 <= n) continue;
            int n3 = n;
            String string2 = "Event can't contain more than " + n3 + " params";
            ((zzim)this).zzj().zzh().zza(string2, ((zzim)this).zzi().zza(zzgd2.zza), ((zzim)this).zzi().zza(zzgd2.zzb));
            zzny.zzb(zzgd2.zzb, 5);
            zzgd2.zzb.remove(string);
        }
    }

    public static void zza(zznx zznx2, int n, @Nullable String string, @Nullable String string2, int n2) {
        zzny.zza(zznx2, null, n, string, string2, n2);
    }

    static void zza(zznx zznx2, @Nullable String string, int n, @Nullable String string2, @Nullable String string3, int n2) {
        Bundle bundle = new Bundle();
        zzny.zzb(bundle, n);
        if (!TextUtils.isEmpty((CharSequence)string2) && !TextUtils.isEmpty((CharSequence)string3)) {
            bundle.putString(string2, string3);
        }
        if (n == 6 || n == 7 || n == 2) {
            bundle.putLong("_el", (long)n2);
        }
        zznx2.zza(string, "_err", bundle);
    }

    @Override
    @WorkerThread
    protected final void zzaa() {
        ((zzim)this).zzt();
        SecureRandom secureRandom = new SecureRandom();
        long l = secureRandom.nextLong();
        if (l == 0L && (l = secureRandom.nextLong()) == 0L) {
            ((zzim)this).zzj().zzu().zza("Utils falling back to Random for random id");
        }
        this.zzd.set(l);
    }

    final void zza(@Nullable Bundle bundle, @Nullable String string, @Nullable Object object) {
        if (bundle == null) {
            return;
        }
        if (object instanceof Long) {
            bundle.putLong(string, ((Long)object).longValue());
            return;
        }
        if (object instanceof String) {
            String string2 = String.valueOf(object);
            bundle.putString(string, string2);
            return;
        }
        if (object instanceof Double) {
            bundle.putDouble(string, ((Double)object).doubleValue());
            return;
        }
        if (object instanceof Bundle[]) {
            bundle.putParcelableArray(string, (Parcelable[])((Bundle[])object));
            return;
        }
        if (string != null) {
            String string3 = object != null ? object.getClass().getSimpleName() : null;
            ((zzim)this).zzj().zzv().zza("Not putting event parameter. Invalid value type. name, type", ((zzim)this).zzi().zzb(string), string3);
        }
    }

    public final void zza(zzdi zzdi2, boolean bl) {
        Bundle bundle = new Bundle();
        bundle.putBoolean("r", bl);
        try {
            zzdi2.zza(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzu.zzj().zzu().zza("Error returning boolean value to wrapper", (Object)remoteException);
            return;
        }
    }

    public final void zza(zzdi zzdi2, ArrayList<Bundle> arrayList) {
        Bundle bundle = new Bundle();
        bundle.putParcelableArrayList("r", arrayList);
        try {
            zzdi2.zza(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzu.zzj().zzu().zza("Error returning bundle list to wrapper", (Object)remoteException);
            return;
        }
    }

    public final void zza(zzdi zzdi2, Bundle bundle) {
        try {
            zzdi2.zza(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzu.zzj().zzu().zza("Error returning bundle value to wrapper", (Object)remoteException);
            return;
        }
    }

    public final void zza(zzdi zzdi2, byte @Nullable [] byArray) {
        Bundle bundle = new Bundle();
        bundle.putByteArray("r", byArray);
        try {
            zzdi2.zza(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzu.zzj().zzu().zza("Error returning byte array to wrapper", (Object)remoteException);
            return;
        }
    }

    public final void zza(zzdi zzdi2, int n) {
        Bundle bundle = new Bundle();
        bundle.putInt("r", n);
        try {
            zzdi2.zza(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzu.zzj().zzu().zza("Error returning int value to wrapper", (Object)remoteException);
            return;
        }
    }

    public final void zza(zzdi zzdi2, long l) {
        Bundle bundle = new Bundle();
        bundle.putLong("r", l);
        try {
            zzdi2.zza(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzu.zzj().zzu().zza("Error returning long value to wrapper", (Object)remoteException);
            return;
        }
    }

    public final void zza(zzdi zzdi2, @Nullable String string) {
        Bundle bundle = new Bundle();
        bundle.putString("r", string);
        try {
            zzdi2.zza(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzu.zzj().zzu().zza("Error returning string value to wrapper", (Object)remoteException);
            return;
        }
    }

    private final void zza(@Nullable String string, @Nullable String string2, @Nullable String string3, Bundle bundle, @Nullable List<String> list, boolean bl) {
        if (bundle == null) {
            return;
        }
        int n = 0;
        int n2 = ((zzim)this).zze().zzc();
        for (String string4 : new TreeSet(bundle.keySet())) {
            int n3 = 0;
            if (list == null || !list.contains(string4)) {
                if (!bl) {
                    n3 = this.zzl(string4);
                }
                if (n3 == 0) {
                    n3 = this.zzk(string4);
                }
            }
            if (n3 != 0) {
                zzny.zza(bundle, n3, string4, (Object)(n3 == 3 ? string4 : null));
                bundle.remove(string4);
                continue;
            }
            if (zzny.zza(bundle.get(string4))) {
                ((zzim)this).zzj().zzv().zza("Nested Bundle parameters are not allowed; discarded. event name, param name, child param name", string2, string3, string4);
                n3 = 22;
            } else {
                n3 = this.zza(string, string2, string4, bundle.get(string4), bundle, list, bl, false);
            }
            if (n3 != 0 && !"_ev".equals(string4)) {
                zzny.zza(bundle, n3, string4, bundle.get(string4));
                bundle.remove(string4);
                continue;
            }
            if (!zzny.zzh(string4) || zzny.zza(string4, zziw.zzd)) continue;
            ++n;
            if (!this.zza(231100000, true)) {
                ((zzim)this).zzj().zzh().zza("Item array not supported on client's version of Google Play Services (Android Only)", ((zzim)this).zzi().zza(string2), ((zzim)this).zzi().zza(bundle));
                zzny.zzb(bundle, 23);
                bundle.remove(string4);
                continue;
            }
            if (n <= n2) continue;
            if (zzpn.zza() && ((zzim)this).zze().zza(zzbf.zzcb)) {
                int n4 = n2;
                ((zzim)this).zzj().zzh().zza("Item can't contain more than " + n4 + " item-scoped custom params", ((zzim)this).zzi().zza(string2), ((zzim)this).zzi().zza(bundle));
                zzny.zzb(bundle, 28);
                bundle.remove(string4);
                continue;
            }
            ((zzim)this).zzj().zzh().zza("Item cannot contain custom parameters", ((zzim)this).zzi().zza(string2), ((zzim)this).zzi().zza(bundle));
            zzny.zzb(bundle, 23);
            bundle.remove(string4);
        }
    }

    private static boolean zzb(@Nullable Bundle bundle, int n) {
        if (bundle == null) {
            return false;
        }
        if (bundle.getLong("_err") == 0L) {
            bundle.putLong("_err", (long)n);
            return true;
        }
        return false;
    }

    static boolean zzd(String string) {
        return zzny.zze(zzbf.zzbb.zza(null), string);
    }

    private static boolean zza(@Nullable String string, @Nullable String[] stringArray) {
        Preconditions.checkNotNull((Object)stringArray);
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string2 = stringArray2[i];
            if (!Objects.equals(string, string2)) continue;
            return true;
        }
        return false;
    }

    final boolean zza(@Nullable String string, @Nullable String string2) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            if (!zzny.zzn(string)) {
                if (this.zzu.zzae()) {
                    ((zzim)this).zzj().zzh().zza("Invalid google_app_id. Firebase Analytics disabled. See https://goo.gl/NAOOOI. provided id", zzfz.zza(string));
                }
                return false;
            }
        } else if (!TextUtils.isEmpty((CharSequence)string2)) {
            if (!zzny.zzn(string2)) {
                ((zzim)this).zzj().zzh().zza("Invalid admob_app_id. Analytics disabled.", zzfz.zza(string2));
                return false;
            }
        } else {
            if (this.zzu.zzae()) {
                ((zzim)this).zzj().zzh().zza("Missing google_app_id. Firebase Analytics disabled. See https://goo.gl/NAOOOI");
            }
            return false;
        }
        return true;
    }

    final boolean zza(String string, int n, @Nullable String string2) {
        if (string2 == null) {
            ((zzim)this).zzj().zzh().zza("Name is required and can't be null. Type", string);
            return false;
        }
        if (string2.codePointCount(0, string2.length()) > n) {
            ((zzim)this).zzj().zzh().zza("Name is too long. Type, maximum supported length, name", string, n, string2);
            return false;
        }
        return true;
    }

    final boolean zza(String string, String @Nullable [] stringArray, @Nullable String string2) {
        return this.zza(string, stringArray, null, string2);
    }

    final boolean zza(String string, String @Nullable [] stringArray, String @Nullable [] stringArray2, @Nullable String string2) {
        boolean bl;
        block4: {
            if (string2 == null) {
                ((zzim)this).zzj().zzh().zza("Name is required and can't be null. Type", string);
                return false;
            }
            String string3 = string2;
            Preconditions.checkNotNull((Object)string3);
            String[] stringArray3 = zza;
            int n = zza.length;
            for (int i = 0; i < n; ++i) {
                String string4 = stringArray3[i];
                if (!string3.startsWith(string4)) continue;
                bl = true;
                break block4;
            }
            bl = false;
        }
        if (bl) {
            ((zzim)this).zzj().zzh().zza("Name starts with reserved prefix. Type, name", string, string2);
            return false;
        }
        if (stringArray != null && zzny.zza(string2, stringArray) && (stringArray2 == null || !zzny.zza(string2, stringArray2))) {
            ((zzim)this).zzj().zzh().zza("Name is reserved. Type, name", string, string2);
            return false;
        }
        return true;
    }

    final boolean zza(String string, @Nullable String string2, int n, @Nullable Object object) {
        if (object == null) {
            return true;
        }
        if (object instanceof Long || object instanceof Float || object instanceof Integer || object instanceof Byte || object instanceof Short || object instanceof Boolean || object instanceof Double) {
            return true;
        }
        if (object instanceof String || object instanceof Character || object instanceof CharSequence) {
            String string3 = String.valueOf(object);
            if (string3.codePointCount(0, string3.length()) > n) {
                ((zzim)this).zzj().zzv().zza("Value is too long; discarded. Value kind, name, value length", string, string2, string3.length());
                return false;
            }
            return true;
        }
        return false;
    }

    final boolean zzb(String string, @Nullable String string2) {
        int n;
        if (string2 == null) {
            ((zzim)this).zzj().zzh().zza("Name is required and can't be null. Type", string);
            return false;
        }
        if (string2.length() == 0) {
            ((zzim)this).zzj().zzh().zza("Name is required and can't be empty. Type", string);
            return false;
        }
        int n2 = string2.codePointAt(0);
        if (!Character.isLetter(n2) && n2 != 95) {
            ((zzim)this).zzj().zzh().zza("Name must start with a letter or _ (underscore). Type, name", string, string2);
            return false;
        }
        int n3 = string2.length();
        for (int i = Character.charCount(n2); i < n3; i += Character.charCount(n)) {
            n = string2.codePointAt(i);
            if (n == 95 || Character.isLetterOrDigit(n)) continue;
            ((zzim)this).zzj().zzh().zza("Name must consist of letters, digits or _ (underscores). Type, name", string, string2);
            return false;
        }
        return true;
    }

    final boolean zzc(String string, String string2) {
        int n;
        if (string2 == null) {
            ((zzim)this).zzj().zzh().zza("Name is required and can't be null. Type", string);
            return false;
        }
        if (string2.length() == 0) {
            ((zzim)this).zzj().zzh().zza("Name is required and can't be empty. Type", string);
            return false;
        }
        int n2 = string2.codePointAt(0);
        if (!Character.isLetter(n2)) {
            ((zzim)this).zzj().zzh().zza("Name must start with a letter. Type, name", string, string2);
            return false;
        }
        int n3 = string2.length();
        for (int i = Character.charCount(n2); i < n3; i += Character.charCount(n)) {
            n = string2.codePointAt(i);
            if (n == 95 || Character.isLetterOrDigit(n)) continue;
            ((zzim)this).zzj().zzh().zza("Name must consist of letters, digits or _ (underscores). Type, name", string, string2);
            return false;
        }
        return true;
    }

    static boolean zza(Bundle bundle, int n) {
        if (bundle.size() <= n) {
            return false;
        }
        TreeSet treeSet = new TreeSet(bundle.keySet());
        int n2 = 0;
        for (String string : treeSet) {
            if (++n2 <= n) continue;
            bundle.remove(string);
        }
        return true;
    }

    @WorkerThread
    @TargetApi(value=30)
    private final boolean zzy() {
        if (this.zzg == null) {
            MeasurementManagerFutures measurementManagerFutures = this.zzn();
            if (measurementManagerFutures == null) {
                return false;
            }
            ListenableFuture listenableFuture = measurementManagerFutures.getMeasurementApiStatusAsync();
            Integer n = null;
            try {
                n = (Integer)listenableFuture.get(10000L, TimeUnit.MILLISECONDS);
                this.zzg = n != null && n == 1;
            }
            catch (InterruptedException | CancellationException | ExecutionException | TimeoutException exception) {
                ((zzim)this).zzj().zzu().zza("Measurement manager api exception", exception);
                this.zzg = false;
            }
            ((zzim)this).zzj().zzp().zza("Measurement manager api status result", n);
        }
        return this.zzg;
    }

    @WorkerThread
    final boolean zze(String string) {
        ((zzim)this).zzt();
        if (Wrappers.packageManager((Context)((zzim)this).zza()).checkCallingOrSelfPermission(string) == 0) {
            return true;
        }
        ((zzim)this).zzj().zzc().zza("Permission not granted", string);
        return false;
    }

    static boolean zzf(String string) {
        return zzny.zze(zzbf.zzbv.zza(null), string);
    }

    final boolean zzd(@Nullable String string, @Nullable String string2) {
        if (zzqr.zza() && ((zzim)this).zze().zza(zzbf.zzbu) && !TextUtils.isEmpty((CharSequence)string2)) {
            return true;
        }
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        String string3 = ((zzim)this).zze().zzn();
        return string3.equals(string);
    }

    static boolean zza(@Nullable Object object) {
        return object instanceof Parcelable[] || object instanceof ArrayList || object instanceof Bundle;
    }

    @VisibleForTesting
    private final boolean zzb(Context context, String string) {
        X500Principal x500Principal = new X500Principal("CN=Android Debug,O=Android,C=US");
        try {
            PackageInfo packageInfo = Wrappers.packageManager((Context)context).getPackageInfo(string, 64);
            if (packageInfo != null && packageInfo.signatures != null && packageInfo.signatures.length > 0) {
                Signature signature = packageInfo.signatures[0];
                return ((X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(signature.toByteArray()))).getSubjectX500Principal().equals(x500Principal);
            }
        }
        catch (CertificateException certificateException) {
            ((zzim)this).zzj().zzg().zza("Error obtaining certificate", certificateException);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            ((zzim)this).zzj().zzg().zza("Package name not found", (Object)nameNotFoundException);
        }
        return true;
    }

    @WorkerThread
    final boolean zzw() {
        ((zzim)this).zzt();
        return this.zzh() == 1L;
    }

    public final boolean zzx() {
        try {
            ((zzim)this).zza().getClassLoader().loadClass("com.google.firebase.remoteconfig.FirebaseRemoteConfig");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public final boolean zza(int n, boolean bl) {
        block3: {
            block2: {
                Boolean bl2 = this.zzu.zzr().zzab();
                if (this.zzg() >= n / 1000) break block2;
                if (bl2 == null || bl2.booleanValue()) break block3;
            }
            return true;
        }
        return false;
    }

    static boolean zzg(@Nullable String string) {
        return !TextUtils.isEmpty((CharSequence)string) && string.startsWith("_");
    }

    static boolean zzh(String string) {
        Preconditions.checkNotEmpty((String)string);
        return string.charAt(0) != '_' || string.equals("_ep");
    }

    static boolean zza(Context context) {
        Preconditions.checkNotNull((Object)context);
        try {
            PackageManager packageManager = context.getPackageManager();
            if (packageManager == null) {
                return false;
            }
            ActivityInfo activityInfo = packageManager.getReceiverInfo(new ComponentName(context, "com.google.android.gms.measurement.AppMeasurementReceiver"), 0);
            if (activityInfo != null && activityInfo.enabled) {
                return true;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        return false;
    }

    private static boolean zzc(Context context, String string) {
        try {
            PackageManager packageManager = context.getPackageManager();
            if (packageManager == null) {
                return false;
            }
            ServiceInfo serviceInfo = packageManager.getServiceInfo(new ComponentName(context, string), 0);
            if (serviceInfo != null && serviceInfo.enabled) {
                return true;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        return false;
    }

    static boolean zza(Context context, boolean bl) {
        Preconditions.checkNotNull((Object)context);
        if (Build.VERSION.SDK_INT >= 24) {
            return zzny.zzc(context, "com.google.android.gms.measurement.AppMeasurementJobService");
        }
        return zzny.zzc(context, "com.google.android.gms.measurement.AppMeasurementService");
    }

    public final boolean zzi(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        List list = ((zzim)this).zza().getPackageManager().queryIntentActivities(new Intent("android.intent.action.VIEW", Uri.parse((String)string)), 0);
        return list != null && !list.isEmpty();
    }

    private static boolean zze(String string, String string2) {
        return string.equals("*") || Arrays.asList(string.split(",")).contains(string2);
    }

    @Override
    protected final boolean zzo() {
        return true;
    }

    @SuppressLint(value={"ApplySharedPref"})
    final boolean zza(String string, double d) {
        try {
            SharedPreferences.Editor editor = ((zzim)this).zza().getSharedPreferences("google.analytics.deferred.deeplink.prefs", 0).edit();
            editor.putString("deeplink", string);
            editor.putLong("timestamp", Double.doubleToRawLongBits(d));
            return editor.commit();
        }
        catch (RuntimeException runtimeException) {
            ((zzim)this).zzj().zzg().zza("Failed to persist Deferred Deep Link. exception", runtimeException);
            return false;
        }
    }

    static boolean zza(Intent intent) {
        String string = intent.getStringExtra("android.intent.extra.REFERRER_NAME");
        return "android-app://com.google.android.googlequicksearchbox/https/www.google.com".equals(string) || "https://www.google.com".equals(string) || "android-app://com.google.appcrawler".equals(string);
    }

    public static boolean zzj(String string) {
        String[] stringArray = zzb;
        int n = zzb.length;
        for (int i = 0; i < n; ++i) {
            if (!stringArray[i].equals(string)) continue;
            return false;
        }
        return true;
    }

    static boolean zza(@Nullable String string, @Nullable String string2, @Nullable String string3, @Nullable String string4) {
        boolean bl = TextUtils.isEmpty((CharSequence)string);
        boolean bl2 = TextUtils.isEmpty((CharSequence)string2);
        if (!bl && !bl2) {
            Preconditions.checkNotNull((Object)string);
            return !string.equals(string2);
        }
        if (bl && bl2) {
            if (!TextUtils.isEmpty((CharSequence)string3) && !TextUtils.isEmpty((CharSequence)string4)) {
                return !string3.equals(string4);
            }
            return !TextUtils.isEmpty((CharSequence)string4);
        }
        if (!bl && bl2) {
            if (TextUtils.isEmpty((CharSequence)string4)) {
                return false;
            }
            return TextUtils.isEmpty((CharSequence)string3) || !string3.equals(string4);
        }
        return TextUtils.isEmpty((CharSequence)string3) || !string3.equals(string4);
    }

    @VisibleForTesting
    private static boolean zzn(String string) {
        Preconditions.checkNotNull((Object)string);
        String string2 = "^(1:\\d+:android:[a-f0-9]+|ca-app-pub-.*)$";
        return string.matches(string2);
    }

    static byte @Nullable [] zza(@Nullable Parcelable parcelable) {
        if (parcelable == null) {
            return null;
        }
        Parcel parcel = Parcel.obtain();
        try {
            parcelable.writeToParcel(parcel, 0);
            byte[] byArray = parcel.marshall();
            return byArray;
        }
        finally {
            parcel.recycle();
        }
    }

    static Bundle @Nullable [] zzb(@Nullable Object object) {
        if (object instanceof Bundle) {
            return new Bundle[]{(Bundle)object};
        }
        if (object instanceof Parcelable[]) {
            return (Bundle[])Arrays.copyOf((Parcelable[])object, ((Parcelable[])object).length, Bundle[].class);
        }
        if (object instanceof ArrayList) {
            ArrayList arrayList = (ArrayList)object;
            return arrayList.toArray(new Bundle[arrayList.size()]);
        }
        return null;
    }
}

