/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.RemoteException;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.internal.measurement.zzdl;
import com.google.android.gms.internal.measurement.zzpd;
import com.google.android.gms.measurement.internal.zzaf;
import com.google.android.gms.measurement.internal.zzak;
import com.google.android.gms.measurement.internal.zzax;
import com.google.android.gms.measurement.internal.zzbh;
import com.google.android.gms.measurement.internal.zzbj;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzg;
import com.google.android.gms.measurement.internal.zzgb;
import com.google.android.gms.measurement.internal.zzhw;
import com.google.android.gms.measurement.internal.zziy;
import com.google.android.gms.measurement.internal.zzlh;
import com.google.android.gms.measurement.internal.zzlo;
import com.google.android.gms.measurement.internal.zzlq;
import com.google.android.gms.measurement.internal.zzlr;
import com.google.android.gms.measurement.internal.zzls;
import com.google.android.gms.measurement.internal.zzlt;
import com.google.android.gms.measurement.internal.zzlu;
import com.google.android.gms.measurement.internal.zzlv;
import com.google.android.gms.measurement.internal.zzlw;
import com.google.android.gms.measurement.internal.zzlx;
import com.google.android.gms.measurement.internal.zzly;
import com.google.android.gms.measurement.internal.zzlz;
import com.google.android.gms.measurement.internal.zzma;
import com.google.android.gms.measurement.internal.zzmb;
import com.google.android.gms.measurement.internal.zzmc;
import com.google.android.gms.measurement.internal.zzmd;
import com.google.android.gms.measurement.internal.zzme;
import com.google.android.gms.measurement.internal.zzmf;
import com.google.android.gms.measurement.internal.zzmg;
import com.google.android.gms.measurement.internal.zzmh;
import com.google.android.gms.measurement.internal.zzmi;
import com.google.android.gms.measurement.internal.zzmj;
import com.google.android.gms.measurement.internal.zzmk;
import com.google.android.gms.measurement.internal.zzml;
import com.google.android.gms.measurement.internal.zzmm;
import com.google.android.gms.measurement.internal.zzmn;
import com.google.android.gms.measurement.internal.zznk;
import com.google.android.gms.measurement.internal.zznl;
import com.google.android.gms.measurement.internal.zzok;
import com.google.android.gms.measurement.internal.zzp;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class zzlp
extends zzf {
    private final zzmm zza;
    private @Nullable zzgb zzb;
    private volatile Boolean zzc;
    private final zzax zzd;
    private final zznl zze;
    private final List<Runnable> zzf = new ArrayList<Runnable>();
    private final zzax zzg;

    @WorkerThread
    private final @Nullable zzp zzc(boolean bl) {
        return ((zzg)this).zzg().zza(bl ? ((zziy)this).zzj().zzx() : null);
    }

    @WorkerThread
    protected final @Nullable zzak zzaa() {
        ((zziy)this).zzt();
        this.zzu();
        zzgb zzgb2 = this.zzb;
        if (zzgb2 == null) {
            this.zzae();
            ((zziy)this).zzj().zzc().zza("Failed to get consents; not connected to service yet.");
            return null;
        }
        zzp zzp2 = this.zzc(false);
        Preconditions.checkNotNull((Object)((Object)zzp2));
        try {
            zzak zzak2 = zzgb2.zza(zzp2);
            this.zzar();
            return zzak2;
        }
        catch (RemoteException remoteException) {
            ((zziy)this).zzj().zzg().zza("Failed to get consents; remote exception", (Object)remoteException);
            return null;
        }
    }

    static /* bridge */ /* synthetic */ zzgb zza(zzlp zzlp2) {
        return zzlp2.zzb;
    }

    static /* bridge */ /* synthetic */ zzmm zzb(zzlp zzlp2) {
        return zzlp2.zza;
    }

    final Boolean zzab() {
        return this.zzc;
    }

    static /* bridge */ /* synthetic */ void zza(zzlp zzlp2, zzgb zzgb2) {
        zzlp2.zzb = null;
    }

    static /* synthetic */ void zzc(zzlp zzlp2) {
        zzlp2.zzaq();
    }

    static /* synthetic */ void zzd(zzlp zzlp2) {
        zzlp zzlp3 = zzlp2;
        ((zziy)zzlp3).zzt();
        if (zzlp3.zzal()) {
            ((zziy)zzlp3).zzj().zzp().zza("Inactivity, disconnecting from the service");
            zzlp3.zzaf();
        }
    }

    static /* synthetic */ void zza(zzlp zzlp2, ComponentName componentName) {
        ComponentName componentName2 = componentName;
        zzlp zzlp3 = zzlp2;
        ((zziy)zzlp3).zzt();
        if (zzlp3.zzb != null) {
            zzlp3.zzb = null;
            ((zziy)zzlp3).zzj().zzp().zza("Disconnected from device MeasurementService", componentName2);
            zzlp zzlp4 = zzlp3;
            ((zziy)zzlp4).zzt();
            zzlp4.zzae();
        }
    }

    static /* synthetic */ void zze(zzlp zzlp2) {
        zzlp2.zzar();
    }

    protected zzlp(zzhw zzhw2) {
        super(zzhw2);
        this.zze = new zznl(zzhw2.zzb());
        this.zza = new zzmm(this);
        this.zzd = new zzlq(this, zzhw2);
        this.zzg = new zzmd(this, zzhw2);
    }

    @WorkerThread
    protected final void zzac() {
        ((zziy)this).zzt();
        this.zzu();
        zzp zzp2 = this.zzc(true);
        this.zza(new zzmb(this, zzp2));
    }

    @WorkerThread
    protected final void zzad() {
        ((zziy)this).zzt();
        this.zzu();
        zzp zzp2 = this.zzc(true);
        ((zzg)this).zzh().zzab();
        this.zza(new zzly(this, zzp2));
    }

    @WorkerThread
    final void zzae() {
        ((zziy)this).zzt();
        this.zzu();
        if (this.zzal()) {
            return;
        }
        if (this.zzap()) {
            this.zza.zza();
            return;
        }
        if (!((zziy)this).zze().zzaa()) {
            Intent intent;
            zzlp zzlp2 = this;
            PackageManager packageManager = ((zziy)zzlp2).zza().getPackageManager();
            List list = packageManager.queryIntentServices(intent = new Intent().setClassName(((zziy)zzlp2).zza(), "com.google.android.gms.measurement.AppMeasurementService"), 65536);
            if (list != null && !list.isEmpty()) {
                Intent intent2 = new Intent("com.google.android.gms.measurement.START");
                intent2.setComponent(new ComponentName(((zziy)this).zza(), "com.google.android.gms.measurement.AppMeasurementService"));
                this.zza.zza(intent2);
                return;
            }
            ((zziy)this).zzj().zzg().zza("Unable to use remote or local measurement implementation. Please register the AppMeasurementService service in the app manifest");
        }
    }

    @WorkerThread
    public final void zzaf() {
        ((zziy)this).zzt();
        this.zzu();
        this.zza.zzb();
        try {
            ConnectionTracker.getInstance().unbindService(((zziy)this).zza(), (ServiceConnection)this.zza);
        }
        catch (IllegalArgumentException | IllegalStateException runtimeException) {}
        this.zzb = null;
    }

    @WorkerThread
    private final void zzaq() {
        ((zziy)this).zzt();
        ((zziy)this).zzj().zzp().zza("Processing queued up service tasks", this.zzf.size());
        for (Runnable runnable : this.zzf) {
            try {
                runnable.run();
            }
            catch (RuntimeException runtimeException) {
                ((zziy)this).zzj().zzg().zza("Task exception while flushing queue", runtimeException);
            }
        }
        this.zzf.clear();
        this.zzg.zza();
    }

    @WorkerThread
    public final void zza(zzdl zzdl2) {
        ((zziy)this).zzt();
        this.zzu();
        zzp zzp2 = this.zzc(false);
        this.zza(new zzlz(this, zzp2, zzdl2));
    }

    @WorkerThread
    public final void zza(AtomicReference<String> atomicReference) {
        ((zziy)this).zzt();
        this.zzu();
        zzp zzp2 = this.zzc(false);
        this.zza(new zzlw(this, atomicReference, zzp2));
    }

    @WorkerThread
    protected final void zza(zzdl zzdl2, @Nullable String string, @Nullable String string2) {
        ((zziy)this).zzt();
        this.zzu();
        zzp zzp2 = this.zzc(false);
        this.zza(new zzmk(this, string, string2, zzp2, zzdl2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzaf>> atomicReference, @Nullable String string, @Nullable String string2, @Nullable String string3) {
        ((zziy)this).zzt();
        this.zzu();
        zzp zzp2 = this.zzc(false);
        this.zza(new zzml(this, atomicReference, string, string2, string3, zzp2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<@Nullable List<zznk>> atomicReference, Bundle bundle) {
        ((zziy)this).zzt();
        this.zzu();
        zzp zzp2 = this.zzc(false);
        this.zza(new zzlv(this, atomicReference, zzp2, bundle));
    }

    @WorkerThread
    protected final void zza(AtomicReference<@Nullable List<zzok>> atomicReference, boolean bl) {
        ((zziy)this).zzt();
        this.zzu();
        zzp zzp2 = this.zzc(false);
        this.zza(new zzls(this, atomicReference, zzp2, bl));
    }

    @WorkerThread
    protected final void zza(zzdl zzdl2, @Nullable String string, @Nullable String string2, boolean bl) {
        ((zziy)this).zzt();
        this.zzu();
        zzp zzp2 = this.zzc(false);
        this.zza(new zzlt(this, string, string2, zzp2, bl, zzdl2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzok>> atomicReference, @Nullable String string, @Nullable String string2, @Nullable String string3, boolean bl) {
        ((zziy)this).zzt();
        this.zzu();
        zzp zzp2 = this.zzc(false);
        this.zza(new zzmn(this, atomicReference, string, string2, string3, zzp2, bl));
    }

    final /* synthetic */ void zzag() {
        zzgb zzgb2 = this.zzb;
        if (zzgb2 == null) {
            ((zziy)this).zzj().zzg().zza("Failed to send Dma consent settings to service");
            return;
        }
        try {
            zzp zzp2 = this.zzc(false);
            Preconditions.checkNotNull((Object)((Object)zzp2));
            zzgb2.zzg(zzp2);
            this.zzar();
            return;
        }
        catch (RemoteException remoteException) {
            ((zziy)this).zzj().zzg().zza("Failed to send Dma consent settings to the service", (Object)remoteException);
            return;
        }
    }

    final /* synthetic */ void zzah() {
        zzgb zzgb2 = this.zzb;
        if (zzgb2 == null) {
            ((zziy)this).zzj().zzg().zza("Failed to send storage consent settings to service");
            return;
        }
        try {
            zzp zzp2 = this.zzc(false);
            Preconditions.checkNotNull((Object)((Object)zzp2));
            zzgb2.zzi(zzp2);
            this.zzar();
            return;
        }
        catch (RemoteException remoteException) {
            ((zziy)this).zzj().zzg().zza("Failed to send storage consent settings to the service", (Object)remoteException);
            return;
        }
    }

    @WorkerThread
    protected final void zza(zzbh zzbh2, @Nullable String string) {
        Preconditions.checkNotNull((Object)((Object)zzbh2));
        ((zziy)this).zzt();
        this.zzu();
        boolean bl = ((zzg)this).zzh().zza(zzbh2);
        zzp zzp2 = this.zzc(true);
        this.zza(new zzmj(this, true, zzp2, bl, zzbh2, string));
    }

    @WorkerThread
    public final void zza(zzdl zzdl2, zzbh zzbh2, String string) {
        ((zziy)this).zzt();
        this.zzu();
        if (((zziy)this).zzq().zza(12451000) != 0) {
            ((zziy)this).zzj().zzu().zza("Not bundling data. Service unavailable or out of date");
            ((zziy)this).zzq().zza(zzdl2, new byte[0]);
            return;
        }
        this.zza(new zzme(this, zzbh2, string, zzdl2));
    }

    @WorkerThread
    private final void zzar() {
        ((zziy)this).zzt();
        this.zze.zzb();
        this.zzd.zza((Long)zzbj.zzal.zza(null));
    }

    @WorkerThread
    protected final void zzai() {
        ((zziy)this).zzt();
        this.zzu();
        zzp zzp2 = this.zzc(false);
        ((zzg)this).zzh().zzaa();
        this.zza(new zzlx(this, zzp2));
    }

    @WorkerThread
    private final void zza(Runnable runnable) throws IllegalStateException {
        ((zziy)this).zzt();
        if (this.zzal()) {
            runnable.run();
            return;
        }
        if ((long)this.zzf.size() >= 1000L) {
            ((zziy)this).zzj().zzg().zza("Discarding data. Max runnable queue size reached");
            return;
        }
        this.zzf.add(runnable);
        this.zzg.zza(60000L);
        this.zzae();
    }

    @WorkerThread
    final void zza(zzgb zzgb2, @Nullable AbstractSafeParcelable abstractSafeParcelable, zzp zzp2) {
        ((zziy)this).zzt();
        this.zzu();
        int n = 100;
        for (int i = 0; i < 1001 && n == 100; ++i) {
            ArrayList<AbstractSafeParcelable> arrayList = new ArrayList<AbstractSafeParcelable>();
            n = 0;
            List<AbstractSafeParcelable> list = ((zzg)this).zzh().zza(100);
            if (list != null) {
                arrayList.addAll(list);
                n = list.size();
            }
            if (abstractSafeParcelable != null && n < 100) {
                arrayList.add(abstractSafeParcelable);
            }
            ArrayList<AbstractSafeParcelable> arrayList2 = arrayList;
            int n2 = arrayList2.size();
            int n3 = 0;
            while (n3 < n2) {
                Object e = arrayList2.get(n3);
                ++n3;
                AbstractSafeParcelable abstractSafeParcelable2 = (AbstractSafeParcelable)e;
                if (abstractSafeParcelable2 instanceof zzbh) {
                    try {
                        zzgb2.zza((zzbh)abstractSafeParcelable2, zzp2);
                    }
                    catch (RemoteException remoteException) {
                        ((zziy)this).zzj().zzg().zza("Failed to send event to the service", (Object)remoteException);
                    }
                    continue;
                }
                if (abstractSafeParcelable2 instanceof zzok) {
                    try {
                        zzgb2.zza((zzok)abstractSafeParcelable2, zzp2);
                    }
                    catch (RemoteException remoteException) {
                        ((zziy)this).zzj().zzg().zza("Failed to send user property to the service", (Object)remoteException);
                    }
                    continue;
                }
                if (abstractSafeParcelable2 instanceof zzaf) {
                    try {
                        zzgb2.zza((zzaf)abstractSafeParcelable2, zzp2);
                    }
                    catch (RemoteException remoteException) {
                        ((zziy)this).zzj().zzg().zza("Failed to send conditional user property to the service", (Object)remoteException);
                    }
                    continue;
                }
                ((zziy)this).zzj().zzg().zza("Discarding data. Unrecognized parcel type.");
            }
        }
    }

    @WorkerThread
    protected final void zza(zzaf zzaf2) {
        Preconditions.checkNotNull((Object)((Object)zzaf2));
        ((zziy)this).zzt();
        this.zzu();
        boolean bl = ((zzg)this).zzh().zza(zzaf2);
        zzaf zzaf3 = new zzaf(zzaf2);
        zzp zzp2 = this.zzc(true);
        this.zza(new zzmi(this, true, zzp2, bl, zzaf3, zzaf2));
    }

    @WorkerThread
    protected final void zza(boolean bl) {
        ((zziy)this).zzt();
        this.zzu();
        if (!(zzpd.zza() && ((zziy)this).zze().zza(zzbj.zzdb) || !bl)) {
            ((zzg)this).zzh().zzaa();
        }
        if (this.zzan()) {
            zzp zzp2 = this.zzc(false);
            this.zza(new zzmg(this, zzp2));
        }
    }

    @WorkerThread
    protected final void zza(@Nullable zzlh zzlh2) {
        ((zziy)this).zzt();
        this.zzu();
        this.zza(new zzma(this, zzlh2));
    }

    @WorkerThread
    public final void zza(Bundle bundle) {
        ((zziy)this).zzt();
        this.zzu();
        zzp zzp2 = this.zzc(false);
        this.zza(new zzmc(this, zzp2, bundle));
    }

    @WorkerThread
    public final void zzb(Bundle bundle) {
        ((zziy)this).zzt();
        this.zzu();
        if (((zziy)this).zze().zza(zzbj.zzdl)) {
            zzp zzp2 = this.zzc(false);
            this.zza(new zzmf(this, zzp2, bundle));
        }
    }

    @WorkerThread
    protected final void zzaj() {
        ((zziy)this).zzt();
        this.zzu();
        zzlp zzlp2 = this;
        this.zza(new zzlr(zzlp2));
    }

    @WorkerThread
    protected final void zzak() {
        ((zziy)this).zzt();
        this.zzu();
        zzp zzp2 = this.zzc(true);
        this.zza(new zzmh(this, zzp2));
    }

    @WorkerThread
    protected final void zza(zzgb zzgb2) {
        ((zziy)this).zzt();
        Preconditions.checkNotNull((Object)zzgb2);
        this.zzb = zzgb2;
        this.zzar();
        this.zzaq();
    }

    @WorkerThread
    protected final void zzb(boolean bl) {
        ((zziy)this).zzt();
        this.zzu();
        if (!(zzpd.zza() && ((zziy)this).zze().zza(zzbj.zzdb) || !bl)) {
            ((zzg)this).zzh().zzaa();
        }
        zzlp zzlp2 = this;
        this.zza(new zzlo(zzlp2));
    }

    @WorkerThread
    protected final void zza(zzok zzok2) {
        ((zziy)this).zzt();
        this.zzu();
        boolean bl = ((zzg)this).zzh().zza(zzok2);
        zzp zzp2 = this.zzc(true);
        this.zza(new zzlu(this, zzp2, bl, zzok2));
    }

    @WorkerThread
    public final boolean zzal() {
        ((zziy)this).zzt();
        this.zzu();
        return this.zzb != null;
    }

    @Override
    protected final boolean zzz() {
        return false;
    }

    @WorkerThread
    final boolean zzam() {
        ((zziy)this).zzt();
        this.zzu();
        if (!this.zzap()) {
            return true;
        }
        return ((zziy)this).zzq().zzg() >= 200900;
    }

    @WorkerThread
    final boolean zzan() {
        ((zziy)this).zzt();
        this.zzu();
        if (!this.zzap()) {
            return true;
        }
        return ((zziy)this).zzq().zzg() >= (Integer)zzbj.zzbs.zza(null);
    }

    @WorkerThread
    final boolean zzao() {
        ((zziy)this).zzt();
        this.zzu();
        if (!this.zzap()) {
            return true;
        }
        return ((zziy)this).zzq().zzg() >= 241200;
    }

    @WorkerThread
    final boolean zzap() {
        ((zziy)this).zzt();
        this.zzu();
        if (this.zzc == null) {
            boolean bl;
            zzlp zzlp2 = this;
            ((zziy)zzlp2).zzt();
            zzlp2.zzu();
            Boolean bl2 = ((zziy)zzlp2).zzk().zzp();
            if (bl2 != null && bl2.booleanValue()) {
                bl = true;
            } else {
                boolean bl3;
                boolean bl4;
                if (((zzg)zzlp2).zzg().zzaa() == 1) {
                    bl4 = true;
                    bl3 = true;
                } else {
                    ((zziy)zzlp2).zzj().zzp().zza("Checking service availability");
                    int n = ((zziy)zzlp2).zzq().zza(12451000);
                    switch (n) {
                        case 0: {
                            ((zziy)zzlp2).zzj().zzp().zza("Service available");
                            bl4 = true;
                            bl3 = true;
                            break;
                        }
                        case 1: {
                            ((zziy)zzlp2).zzj().zzp().zza("Service missing");
                            bl4 = false;
                            bl3 = true;
                            break;
                        }
                        case 18: {
                            ((zziy)zzlp2).zzj().zzu().zza("Service updating");
                            bl4 = true;
                            bl3 = true;
                            break;
                        }
                        case 2: {
                            ((zziy)zzlp2).zzj().zzc().zza("Service container out of date");
                            if (((zziy)zzlp2).zzq().zzg() < 17443) {
                                bl4 = false;
                                bl3 = true;
                                break;
                            }
                            bl4 = bl2 == null;
                            bl3 = false;
                            break;
                        }
                        case 3: {
                            ((zziy)zzlp2).zzj().zzu().zza("Service disabled");
                            bl4 = false;
                            bl3 = false;
                            break;
                        }
                        case 9: {
                            ((zziy)zzlp2).zzj().zzu().zza("Service invalid");
                            bl4 = false;
                            bl3 = false;
                            break;
                        }
                        default: {
                            ((zziy)zzlp2).zzj().zzu().zza("Unexpected service status", n);
                            bl4 = false;
                            bl3 = false;
                        }
                    }
                }
                if (!bl4 && ((zziy)zzlp2).zze().zzaa()) {
                    ((zziy)zzlp2).zzj().zzg().zza("No way to upload. Consider using the full version of Analytics");
                    bl3 = false;
                }
                if (bl3) {
                    ((zziy)zzlp2).zzk().zza(bl4);
                }
                bl = bl4;
            }
            this.zzc = bl;
        }
        return this.zzc;
    }
}

