/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Pair;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import androidx.core.content.ContextCompat;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzdw;
import com.google.android.gms.internal.measurement.zzhj;
import com.google.android.gms.internal.measurement.zzov;
import com.google.android.gms.internal.measurement.zzpn;
import com.google.android.gms.measurement.internal.zzab;
import com.google.android.gms.measurement.internal.zzag;
import com.google.android.gms.measurement.internal.zzaj;
import com.google.android.gms.measurement.internal.zzax;
import com.google.android.gms.measurement.internal.zzaz;
import com.google.android.gms.measurement.internal.zzb;
import com.google.android.gms.measurement.internal.zzbh;
import com.google.android.gms.measurement.internal.zzga;
import com.google.android.gms.measurement.internal.zzgf;
import com.google.android.gms.measurement.internal.zzgg;
import com.google.android.gms.measurement.internal.zzgh;
import com.google.android.gms.measurement.internal.zzgo;
import com.google.android.gms.measurement.internal.zzh;
import com.google.android.gms.measurement.internal.zzha;
import com.google.android.gms.measurement.internal.zzhv;
import com.google.android.gms.measurement.internal.zzia;
import com.google.android.gms.measurement.internal.zzib;
import com.google.android.gms.measurement.internal.zzid;
import com.google.android.gms.measurement.internal.zzja;
import com.google.android.gms.measurement.internal.zzjc;
import com.google.android.gms.measurement.internal.zzjd;
import com.google.android.gms.measurement.internal.zzje;
import com.google.android.gms.measurement.internal.zzjh;
import com.google.android.gms.measurement.internal.zzjn;
import com.google.android.gms.measurement.internal.zzjo;
import com.google.android.gms.measurement.internal.zzjq;
import com.google.android.gms.measurement.internal.zzle;
import com.google.android.gms.measurement.internal.zzlg;
import com.google.android.gms.measurement.internal.zzlj;
import com.google.android.gms.measurement.internal.zzls;
import com.google.android.gms.measurement.internal.zznb;
import com.google.android.gms.measurement.internal.zzos;
import com.google.android.gms.measurement.internal.zzp;
import java.net.URL;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.json.JSONException;
import org.json.JSONObject;

public class zzhy
implements zzjc {
    private static volatile @Nullable zzhy zzb;
    private final Context zzc;
    private final @Nullable String zzd;
    private final @Nullable String zze;
    private final @Nullable String zzf;
    private final boolean zzg;
    private final zzab zzh;
    private final zzag zzi;
    private final zzha zzj;
    private final zzgo zzk;
    private final zzhv zzl;
    private final zznb zzm;
    private final zzos zzn;
    private final zzgh zzo;
    private final Clock zzp;
    private final zzlj zzq;
    private final zzjq zzr;
    private final zzb zzs;
    private final zzle zzt;
    private final @Nullable String zzu;
    private zzgf zzv;
    private zzls zzw;
    private zzaz zzx;
    private zzgg zzy;
    private boolean zzz = false;
    private Boolean zzaa;
    private long zzab;
    private volatile @Nullable Boolean zzac;
    @VisibleForTesting
    private Boolean zzad;
    @VisibleForTesting
    private Boolean zzae;
    private volatile boolean zzaf;
    private int zzag;
    private int zzah;
    private AtomicInteger zzai = new AtomicInteger(0);
    @VisibleForTesting
    final long zza;

    @WorkerThread
    public final int zzc() {
        ((zzja)this.zzl()).zzt();
        if (this.zzi.zzx()) {
            return 1;
        }
        if (this.zzae != null && this.zzae.booleanValue()) {
            return 2;
        }
        if (!this.zzad()) {
            return 8;
        }
        Boolean bl = this.zzn().zzv();
        if (bl != null) {
            if (bl.booleanValue()) {
                return 0;
            }
            return 3;
        }
        zzag zzag2 = this.zzi;
        Boolean bl2 = zzag2.zze("firebase_analytics_collection_enabled");
        if (bl2 != null) {
            if (bl2.booleanValue()) {
                return 0;
            }
            return 4;
        }
        if (this.zzad != null) {
            if (this.zzad.booleanValue()) {
                return 0;
            }
            return 5;
        }
        if (this.zzac != null) {
            if (this.zzac.booleanValue()) {
                return 0;
            }
            return 7;
        }
        return 0;
    }

    @Override
    @Pure
    public final Context zza() {
        return this.zzc;
    }

    @Override
    @Pure
    public final Clock zzb() {
        return this.zzp;
    }

    @Pure
    public final zzb zze() {
        if (this.zzs == null) {
            throw new IllegalStateException("Component not created");
        }
        return this.zzs;
    }

    @Override
    @Pure
    public final zzab zzd() {
        return this.zzh;
    }

    @Pure
    public final zzag zzf() {
        return this.zzi;
    }

    @Pure
    public final zzaz zzg() {
        zzhy.zza(this.zzx);
        return this.zzx;
    }

    @Pure
    public final zzgg zzh() {
        zzhy.zza(this.zzy);
        return this.zzy;
    }

    @Pure
    public final zzgf zzi() {
        zzhy.zza(this.zzv);
        return this.zzv;
    }

    @Pure
    public final zzgh zzk() {
        return this.zzo;
    }

    @Override
    @Pure
    public final zzgo zzj() {
        zzhy.zza(this.zzk);
        return this.zzk;
    }

    public final @Nullable zzgo zzm() {
        if (this.zzk != null && this.zzk.zzaf()) {
            return this.zzk;
        }
        return null;
    }

    @Pure
    public final zzha zzn() {
        zzhy.zza((zzja)this.zzj);
        return this.zzj;
    }

    @Override
    @Pure
    public final zzhv zzl() {
        zzhy.zza(this.zzl);
        return this.zzl;
    }

    @SideEffectFree
    final @Nullable zzhv zzo() {
        return this.zzl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzhy zza(Context context, @Nullable zzdw zzdw2, @Nullable Long l) {
        if (zzdw2 != null && (zzdw2.zze == null || zzdw2.zzf == null)) {
            zzdw2 = new zzdw(zzdw2.zza, zzdw2.zzb, zzdw2.zzc, zzdw2.zzd, null, null, zzdw2.zzg, null);
        }
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)context.getApplicationContext());
        if (zzb == null) {
            Class<zzhy> clazz = zzhy.class;
            synchronized (zzhy.class) {
                if (zzb == null) {
                    zzjo zzjo2 = new zzjo(context, zzdw2, l);
                    zzb = new zzhy(zzjo2);
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
        } else if (zzdw2 != null && zzdw2.zzg != null && zzdw2.zzg.containsKey("dataCollectionDefaultEnabled")) {
            Preconditions.checkNotNull((Object)zzb);
            zzb.zza(zzdw2.zzg.getBoolean("dataCollectionDefaultEnabled"));
        }
        {
            Preconditions.checkNotNull((Object)zzb);
            return zzb;
        }
    }

    @Pure
    public final zzjq zzp() {
        zzhy.zza(this.zzr);
        return this.zzr;
    }

    @Pure
    private final zzle zzai() {
        zzhy.zza(this.zzt);
        return this.zzt;
    }

    @Pure
    public final zzlj zzq() {
        zzhy.zza(this.zzq);
        return this.zzq;
    }

    @Pure
    public final zzls zzr() {
        zzhy.zza(this.zzw);
        return this.zzw;
    }

    @Pure
    public final zznb zzs() {
        zzhy.zza(this.zzm);
        return this.zzm;
    }

    @Pure
    public final zzos zzt() {
        zzhy.zza((zzja)this.zzn);
        return this.zzn;
    }

    @Pure
    public final @Nullable String zzu() {
        return this.zzd;
    }

    @Pure
    public final @Nullable String zzv() {
        return this.zze;
    }

    @Pure
    public final @Nullable String zzw() {
        return this.zzf;
    }

    @Pure
    public final @Nullable String zzx() {
        return this.zzu;
    }

    static /* synthetic */ void zza(zzhy zzhy2, zzjo zzjo2) {
        zzjo zzjo3 = zzjo2;
        zzhy zzhy3 = zzhy2;
        ((zzja)zzhy3.zzl()).zzt();
        Object object = zzhy3;
        zzaz zzaz2 = new zzaz((zzhy)object);
        zzaz2.zzad();
        zzhy3.zzx = zzaz2;
        zzhy zzhy4 = zzhy3;
        object = zzjo3;
        zzgg zzgg2 = new zzgg(zzhy4, ((zzjo)object).zzf);
        zzgg2.zzv();
        zzhy3.zzy = zzgg2;
        object = zzhy3;
        zzgf zzgf2 = new zzgf((zzhy)object);
        zzgf2.zzv();
        zzhy3.zzv = zzgf2;
        object = zzhy3;
        zzls zzls2 = new zzls((zzhy)object);
        zzls2.zzv();
        zzhy3.zzw = zzls2;
        zzhy3.zzn.zzae();
        zzhy3.zzj.zzae();
        zzhy3.zzy.zzw();
        zzhy3.zzj().zzo().zza("App measurement initialized, version", 106000L);
        zzhy3.zzj().zzo().zza("To enable debug logging run: adb shell setprop log.tag.FA VERBOSE");
        String string = zzgg2.zzad();
        if (TextUtils.isEmpty((CharSequence)zzhy3.zzd)) {
            if (zzhy3.zzt().zzd(string, zzhy3.zzi.zzu())) {
                zzhy3.zzj().zzo().zza("Faster debug mode event logging enabled. To disable, run:\n  adb shell setprop debug.firebase.analytics.app .none.");
            } else {
                String string2 = string;
                zzhy3.zzj().zzo().zza("To enable faster debug mode event logging run:\n  adb shell setprop debug.firebase.analytics.app " + string2);
            }
        }
        zzhy3.zzj().zzc().zza("Debug-level message logging enabled");
        if (zzhy3.zzag != zzhy3.zzai.get()) {
            zzhy3.zzj().zzg().zza("Not all components initialized", zzhy3.zzag, zzhy3.zzai.get());
        }
        zzhy3.zzz = true;
    }

    private zzhy(zzjo zzjo2) {
        Object object;
        Preconditions.checkNotNull((Object)zzjo2);
        Object object2 = zzjo2.zza;
        zzga.zza = this.zzh = new zzab((Context)object2);
        this.zzc = zzjo2.zza;
        this.zzd = zzjo2.zzb;
        this.zze = zzjo2.zzc;
        this.zzf = zzjo2.zzd;
        this.zzg = zzjo2.zzh;
        this.zzac = zzjo2.zze;
        this.zzu = zzjo2.zzj;
        this.zzaf = true;
        zzdw zzdw2 = zzjo2.zzg;
        if (zzdw2 != null && zzdw2.zzg != null) {
            object = zzdw2.zzg.get("measurementEnabled");
            if (object instanceof Boolean) {
                this.zzad = (Boolean)object;
            }
            if ((object = zzdw2.zzg.get("measurementDeactivated")) instanceof Boolean) {
                this.zzae = (Boolean)object;
            }
        }
        zzhj.zzb(this.zzc);
        this.zzp = DefaultClock.getInstance();
        this.zza = zzjo2.zzi != null ? zzjo2.zzi.longValue() : this.zzp.currentTimeMillis();
        object2 = this;
        this.zzi = new zzag((zzhy)object2);
        object2 = this;
        object = new zzha((zzhy)object2);
        ((zzjd)object).zzad();
        this.zzj = object;
        object2 = this;
        zzgo zzgo2 = new zzgo((zzhy)object2);
        zzgo2.zzad();
        this.zzk = zzgo2;
        object2 = this;
        zzos zzos2 = new zzos((zzhy)object2);
        zzos2.zzad();
        this.zzn = zzos2;
        zzhy zzhy2 = this;
        object2 = zzjo2;
        zzjn zzjn2 = new zzjn((zzjo)object2, zzhy2);
        this.zzo = new zzgh(zzjn2);
        object2 = this;
        this.zzs = new zzb((zzhy)object2);
        object2 = this;
        zzlj zzlj2 = new zzlj((zzhy)object2);
        zzlj2.zzv();
        this.zzq = zzlj2;
        object2 = this;
        zzjq zzjq2 = new zzjq((zzhy)object2);
        zzjq2.zzv();
        this.zzr = zzjq2;
        object2 = this;
        zznb zznb2 = new zznb((zzhy)object2);
        zznb2.zzv();
        this.zzm = zznb2;
        object2 = this;
        zzle zzle2 = new zzle((zzhy)object2);
        zzle2.zzad();
        this.zzt = zzle2;
        object2 = this;
        zzhv zzhv2 = new zzhv((zzhy)object2);
        zzhv2.zzad();
        this.zzl = zzhv2;
        boolean bl = zzjo2.zzg != null && zzjo2.zzg.zzb != 0L;
        boolean bl2 = !bl;
        object2 = this;
        if (((zzhy)object2).zzc.getApplicationContext() instanceof Application) {
            ((zzhy)object2).zzp().zzb(bl2);
        } else {
            ((zzhy)object2).zzj().zzu().zza("Application context is not an Application");
        }
        this.zzl.zzb(new zzid(this, zzjo2));
    }

    private static void zza(zzja zzja2) {
        if (zzja2 == null) {
            throw new IllegalStateException("Component not created");
        }
    }

    private static void zza(zzh zzh2) {
        if (zzh2 == null) {
            throw new IllegalStateException("Component not created");
        }
        if (!zzh2.zzy()) {
            String string = String.valueOf(zzh2.getClass());
            throw new IllegalStateException("Component not initialized: " + string);
        }
    }

    private static void zza(zzjd zzjd2) {
        if (zzjd2 == null) {
            throw new IllegalStateException("Component not created");
        }
        if (!zzjd2.zzaf()) {
            String string = String.valueOf(zzjd2.getClass());
            throw new IllegalStateException("Component not initialized: " + string);
        }
    }

    final void zzy() {
        throw new IllegalStateException("Unexpected call on client side");
    }

    final void zzz() {
        this.zzai.incrementAndGet();
    }

    final /* synthetic */ void zza(String string, int n, Throwable throwable, byte[] byArray, Map map) {
        Throwable throwable2 = throwable;
        byte[] byArray2 = byArray;
        int n2 = n;
        zzhy zzhy2 = this;
        if (!((n2 == 200 || n2 == 204 || n2 == 304) && throwable2 == null)) {
            zzhy2.zzj().zzu().zza("Network Request for Deferred Deep Link failed. response, exception", n2, throwable2);
            return;
        }
        zzhy2.zzn().zzo.zza(true);
        if (byArray2 == null || byArray2.length == 0) {
            zzhy2.zzj().zzc().zza("Deferred Deep Link response empty.");
            return;
        }
        String string2 = new String(byArray2);
        try {
            JSONObject jSONObject = new JSONObject(string2);
            String string3 = jSONObject.optString("deeplink", "");
            if (TextUtils.isEmpty((CharSequence)string3)) {
                zzhy2.zzj().zzc().zza("Deferred Deep Link is empty.");
                return;
            }
            String string4 = jSONObject.optString("gclid", "");
            String string5 = jSONObject.optString("gbraid", "");
            String string6 = jSONObject.optString("gad_source", "");
            double d = jSONObject.optDouble("timestamp", 0.0);
            Bundle bundle = new Bundle();
            if (zzov.zza() && zzhy2.zzi.zza(zzbh.zzct)) {
                if (!zzhy2.zzt().zzi(string3)) {
                    zzhy2.zzj().zzu().zza("Deferred Deep Link validation failed. gclid, gbraid, deep link", string4, string5, string3);
                    return;
                }
                if (!TextUtils.isEmpty((CharSequence)string5)) {
                    bundle.putString("gbraid", string5);
                }
                if (!TextUtils.isEmpty((CharSequence)string6)) {
                    bundle.putString("gad_source", string6);
                }
            } else if (!zzhy2.zzt().zzi(string3)) {
                zzhy2.zzj().zzu().zza("Deferred Deep Link validation failed. gclid, deep link", string4, string3);
                return;
            }
            if (zzov.zza()) {
                zzhy2.zzi.zza(zzbh.zzct);
            }
            bundle.putString("gclid", string4);
            bundle.putString("_cis", "ddp");
            zzhy2.zzr.zzc("auto", "_cmp", bundle);
            String string7 = string3;
            zzos zzos2 = zzhy2.zzt();
            if (!TextUtils.isEmpty((CharSequence)string7) && zzos2.zza(string7, d)) {
                Intent intent = new Intent("android.google.analytics.action.DEEPLINK_ACTION");
                ((zzja)zzos2).zza().sendBroadcast(intent);
            }
            return;
        }
        catch (JSONException jSONException) {
            zzhy2.zzj().zzg().zza("Failed to parse the Deferred Deep Link response. exception", (Object)jSONException);
            return;
        }
    }

    final void zzaa() {
        ++this.zzag;
    }

    @WorkerThread
    final void zza(boolean bl) {
        this.zzac = bl;
    }

    @WorkerThread
    public final void zzb(boolean bl) {
        ((zzja)this.zzl()).zzt();
        this.zzaf = bl;
    }

    @WorkerThread
    protected final void zza(@Nullable zzdw zzdw2) {
        zzjh zzjh2;
        zzje zzje2;
        Object object;
        zzjc zzjc2;
        ((zzja)this.zzl()).zzt();
        if (zzpn.zza() && this.zzi.zza(zzbh.zzci) && this.zzt().zzw()) {
            zzjc2 = this.zzt();
            ((zzja)zzjc2).zzt();
            object = new IntentFilter();
            object.addAction("com.google.android.gms.measurement.TRIGGERS_AVAILABLE");
            zzp zzp2 = new zzp(((zzos)zzjc2).zzu);
            ContextCompat.registerReceiver((Context)((zzja)zzjc2).zza(), (BroadcastReceiver)zzp2, (IntentFilter)object, (int)2);
            ((zzja)zzjc2).zzj().zzc().zza("Registered app receiver");
        }
        zzje zzje3 = this.zzn().zzo();
        int n = zzje3.zza();
        zzje zzje4 = null;
        zzjh zzjh3 = this.zzi.zzc("google_analytics_default_allow_ad_storage", false);
        zzjh zzjh4 = this.zzi.zzc("google_analytics_default_allow_analytics_storage", false);
        if ((zzjh3 != zzjh.zza || zzjh4 != zzjh.zza) && this.zzn().zza(-10)) {
            zzje4 = zzje.zza(zzjh3, zzjh4, -10);
        } else if (!(TextUtils.isEmpty((CharSequence)this.zzh().zzae()) || n != 0 && n != 30 && n != 10 && n != 30 && n != 30 && n != 40)) {
            this.zzp().zza(new zzje(null, null, -10), this.zza, false);
        } else if (TextUtils.isEmpty((CharSequence)this.zzh().zzae()) && zzdw2 != null && zzdw2.zzg != null && this.zzn().zza(30) && (zzje2 = zzje.zza(zzdw2.zzg, 30)).zzi()) {
            zzje4 = zzje2;
        }
        if (zzje4 != null) {
            zzje3 = zzje4;
            this.zzp().zza(zzje3, this.zza, true);
        }
        this.zzp().zza(zzje3);
        object = zzdw2;
        zzjc2 = this;
        int n2 = ((zzhy)zzjc2).zzn().zzn().zza();
        zzjh zzjh5 = ((zzhy)zzjc2).zzi.zzc("google_analytics_default_allow_ad_personalization_signals", true);
        if (zzjh5 != zzjh.zza) {
            ((zzhy)zzjc2).zzj().zzp().zza("Default ad personalization consent from Manifest", (Object)zzjh5);
        }
        if ((zzjh2 = ((zzhy)zzjc2).zzi.zzc("google_analytics_default_allow_ad_user_data", true)) != zzjh.zza && zzje.zza(-10, n2)) {
            ((zzhy)zzjc2).zzp().zza(zzax.zza(zzjh2, -10), true);
        } else if (!(TextUtils.isEmpty((CharSequence)((zzhy)zzjc2).zzh().zzae()) || n2 != 0 && n2 != 30)) {
            ((zzhy)zzjc2).zzp().zza(new zzax(null, -10), true);
        } else {
            Boolean bl;
            zzax zzax2;
            if (TextUtils.isEmpty((CharSequence)((zzhy)zzjc2).zzh().zzae()) && object != null && ((zzdw)object).zzg != null && zzje.zza(30, n2) && (zzax2 = zzax.zza(((zzdw)object).zzg, 30)).zzg()) {
                ((zzhy)zzjc2).zzp().zza(zzax2, true);
            }
            if (TextUtils.isEmpty((CharSequence)((zzhy)zzjc2).zzh().zzae()) && object != null && ((zzdw)object).zzg != null && ((zzhy)zzjc2).zzn().zzh.zza() == null && (bl = zzax.zza(((zzdw)object).zzg)) != null) {
                ((zzhy)zzjc2).zzp().zza(((zzdw)object).zze, "allow_personalized_ads", (Object)bl.toString(), false);
            }
        }
        zzjc2 = this.zzi;
        object = ((zzag)zzjc2).zze("google_analytics_tcf_data_enabled");
        if (object == null ? true : (Boolean)object) {
            this.zzj().zzc().zza("TCF client enabled.");
            this.zzp().zzat();
            this.zzp().zzar();
        }
        if (this.zzn().zzc.zza() == 0L) {
            this.zzj().zzp().zza("Persisting first open", this.zza);
            this.zzn().zzc.zza(this.zza);
        }
        this.zzp().zza.zzb();
        if (!this.zzaf()) {
            if (this.zzac()) {
                if (!this.zzt().zze("android.permission.INTERNET")) {
                    this.zzj().zzg().zza("App is missing INTERNET permission");
                }
                if (!this.zzt().zze("android.permission.ACCESS_NETWORK_STATE")) {
                    this.zzj().zzg().zza("App is missing ACCESS_NETWORK_STATE permission");
                }
                if (!Wrappers.packageManager((Context)this.zzc).isCallerInstantApp() && !this.zzi.zzy()) {
                    if (!zzos.zza(this.zzc)) {
                        this.zzj().zzg().zza("AppMeasurementReceiver not registered/enabled");
                    }
                    if (!zzos.zza(this.zzc, false)) {
                        this.zzj().zzg().zza("AppMeasurementService not registered/enabled");
                    }
                }
                this.zzj().zzg().zza("Uploading is not possible. App measurement disabled");
            }
        } else {
            if (!TextUtils.isEmpty((CharSequence)this.zzh().zzae()) || !TextUtils.isEmpty((CharSequence)this.zzh().zzac())) {
                this.zzt();
                if (zzos.zza(this.zzh().zzae(), this.zzn().zzy(), this.zzh().zzac(), this.zzn().zzx())) {
                    this.zzj().zzo().zza("Rechecking which service to use due to a GMP App Id change");
                    this.zzn().zzz();
                    this.zzi().zzaa();
                    this.zzw.zzaf();
                    this.zzw.zzae();
                    this.zzn().zzc.zza(this.zza);
                    this.zzn().zze.zza(null);
                }
                this.zzn().zzc(this.zzh().zzae());
                this.zzn().zzb(this.zzh().zzac());
            }
            if (!this.zzn().zzo().zza(zzje.zza.zzb)) {
                this.zzn().zze.zza(null);
            }
            this.zzp().zzc(this.zzn().zze.zza());
            if (!this.zzt().zzx() && !TextUtils.isEmpty((CharSequence)this.zzn().zzq.zza())) {
                this.zzj().zzu().zza("Remote config removed with active feature rollouts");
                this.zzn().zzq.zza(null);
            }
            if (!TextUtils.isEmpty((CharSequence)this.zzh().zzae()) || !TextUtils.isEmpty((CharSequence)this.zzh().zzac())) {
                boolean bl = this.zzac();
                if (!this.zzn().zzab() && !this.zzi.zzx()) {
                    this.zzn().zzb(!bl);
                }
                if (bl) {
                    this.zzp().zzan();
                }
                this.zzs().zza.zza();
                this.zzr().zza(new AtomicReference<String>());
                this.zzr().zza(this.zzn().zzt.zza());
            }
        }
        if (zzpn.zza() && this.zzi.zza(zzbh.zzci) && this.zzt().zzw()) {
            zzjq zzjq2 = this.zzp();
            Objects.requireNonNull(zzjq2);
            zzjq zzjq3 = zzjq2;
            new Thread(new zzib(zzjq3)).start();
        }
        this.zzn().zzj.zza(true);
    }

    @WorkerThread
    public final boolean zzab() {
        return this.zzac != null && this.zzac != false;
    }

    @WorkerThread
    public final boolean zzac() {
        return this.zzc() == 0;
    }

    @WorkerThread
    public final boolean zzad() {
        ((zzja)this.zzl()).zzt();
        return this.zzaf;
    }

    @Pure
    public final boolean zzae() {
        return TextUtils.isEmpty((CharSequence)this.zzd);
    }

    @WorkerThread
    protected final boolean zzaf() {
        if (!this.zzz) {
            throw new IllegalStateException("AppMeasurement is not initialized");
        }
        ((zzja)this.zzl()).zzt();
        if (this.zzaa == null || this.zzab == 0L || this.zzaa != null && !this.zzaa.booleanValue() && Math.abs(this.zzp.elapsedRealtime() - this.zzab) > 1000L) {
            this.zzab = this.zzp.elapsedRealtime();
            this.zzaa = this.zzt().zze("android.permission.INTERNET") && this.zzt().zze("android.permission.ACCESS_NETWORK_STATE") && (Wrappers.packageManager((Context)this.zzc).isCallerInstantApp() || this.zzi.zzy() || zzos.zza(this.zzc) && zzos.zza(this.zzc, false));
            if (this.zzaa.booleanValue()) {
                this.zzaa = this.zzt().zza(this.zzh().zzae(), this.zzh().zzac()) || !TextUtils.isEmpty((CharSequence)this.zzh().zzac());
            }
        }
        return this.zzaa;
    }

    @Pure
    public final boolean zzag() {
        return this.zzg;
    }

    @WorkerThread
    public final boolean zzah() {
        Object object;
        ((zzja)this.zzl()).zzt();
        zzhy.zza(this.zzai());
        String string = this.zzh().zzad();
        if (!this.zzi.zzv()) {
            this.zzj().zzp().zza("ADID collection is disabled from Manifest. Skipping");
            return false;
        }
        Pair<String, Boolean> pair = this.zzn().zza(string);
        if (((Boolean)pair.second).booleanValue() || TextUtils.isEmpty((CharSequence)((CharSequence)pair.first))) {
            this.zzj().zzp().zza("ADID unavailable to retrieve Deferred Deep Link. Skipping");
            return false;
        }
        if (!this.zzai().zzc()) {
            this.zzj().zzu().zza("Network is not available for Deferred Deep Link request. Skipping");
            return false;
        }
        StringBuilder stringBuilder = new StringBuilder();
        zzja zzja2 = this.zzr();
        zzja2.zzt();
        ((zzh)zzja2).zzu();
        if (!((zzls)zzja2).zzap() ? true : zzja2.zzq().zzg() >= 234200) {
            object = null;
            zzaj zzaj2 = this.zzp().zzab();
            if (zzaj2 != null) {
                object = zzaj2.zza;
            }
            if (object == null) {
                boolean bl = this.zzah++ < 10;
                String string2 = bl ? "Retrying." : "Skipping.";
                this.zzj().zzc().zza("Failed to retrieve DMA consent from the service, " + string2 + " retryCount", this.zzah);
                return bl;
            }
            zzje zzje2 = zzje.zza(object, 100);
            stringBuilder.append("&gcs=").append(zzje2.zze());
            zzax zzax2 = zzax.zza(object, 100);
            stringBuilder.append("&dma=").append(zzax2.zzd() == Boolean.FALSE ? 0 : 1);
            if (!TextUtils.isEmpty((CharSequence)zzax2.zze())) {
                stringBuilder.append("&dma_cps=").append(zzax2.zze());
            }
            int n = zzax.zza(object) == Boolean.TRUE ? 0 : 1;
            stringBuilder.append("&npa=").append(n);
            this.zzj().zzp().zza("Consent query parameters to Bow", stringBuilder);
        }
        zzos zzos2 = this.zzt();
        this.zzh();
        object = zzos2.zza(106000L, string, (String)pair.first, this.zzn().zzp.zza() - 1L, stringBuilder.toString());
        if (object != null) {
            zzhy zzhy2 = this;
            zzia zzia2 = new zzia(zzhy2);
            Object object2 = object;
            String string3 = string;
            zzja2 = this.zzai();
            zzja2.zzt();
            ((zzjd)zzja2).zzac();
            Preconditions.checkNotNull((Object)object2);
            Preconditions.checkNotNull((Object)zzia2);
            zzja2.zzl().zza(new zzlg((zzle)zzja2, string3, (URL)object2, null, null, zzia2));
        }
        return false;
    }
}

