/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Activity;
import android.os.Bundle;
import androidx.annotation.GuardedBy;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Size;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.measurement.internal.zzb;
import com.google.android.gms.measurement.internal.zzc;
import com.google.android.gms.measurement.internal.zze;
import com.google.android.gms.measurement.internal.zzh;
import com.google.android.gms.measurement.internal.zzhy;
import com.google.android.gms.measurement.internal.zzja;
import com.google.android.gms.measurement.internal.zzlk;
import com.google.android.gms.measurement.internal.zzll;
import com.google.android.gms.measurement.internal.zzlm;
import com.google.android.gms.measurement.internal.zzln;
import com.google.android.gms.measurement.internal.zzlo;
import com.google.android.gms.measurement.internal.zzlp;
import com.google.android.gms.measurement.internal.zzlq;
import com.google.android.gms.measurement.internal.zzos;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class zzlj
extends zzh {
    private volatile @Nullable zzlk zzb;
    private volatile @Nullable zzlk zzc;
    @VisibleForTesting
    protected @Nullable zzlk zza;
    private final Map<Integer, zzlk> zzd;
    @GuardedBy(value="activityLock")
    private @Nullable Activity zze;
    @GuardedBy(value="activityLock")
    private volatile boolean zzf;
    private volatile @Nullable zzlk zzg;
    private @Nullable zzlk zzh;
    @GuardedBy(value="activityLock")
    private boolean zzi;
    private final Object zzj = new Object();

    static /* bridge */ /* synthetic */ zzlk zza(zzlj zzlj2) {
        return zzlj2.zzh;
    }

    @MainThread
    private final zzlk zzd(@NonNull Activity activity) {
        Preconditions.checkNotNull((Object)activity);
        zzlk zzlk2 = this.zzd.get(activity.hashCode());
        if (zzlk2 == null) {
            String string = this.zza(activity.getClass(), "Activity");
            zzlk2 = new zzlk(null, string, ((zzja)this).zzq().zzn());
            this.zzd.put(activity.hashCode(), zzlk2);
        }
        if (this.zzg != null) {
            return this.zzg;
        }
        return zzlk2;
    }

    public final @Nullable zzlk zzaa() {
        return this.zzb;
    }

    @WorkerThread
    public final @Nullable zzlk zza(boolean bl) {
        this.zzu();
        ((zzja)this).zzt();
        if (!bl) {
            return this.zza;
        }
        if (this.zza != null) {
            return this.zza;
        }
        return this.zzh;
    }

    @VisibleForTesting
    private final String zza(Class<?> clazz, String string) {
        String string2 = clazz.getCanonicalName();
        if (string2 == null) {
            return string;
        }
        String string3 = string2;
        zzlj zzlj2 = this;
        String[] stringArray = string3.split("\\.");
        String string4 = stringArray.length > 0 ? stringArray[stringArray.length - 1] : "";
        if (string4.length() > ((zzja)zzlj2).zze().zza(null, false)) {
            return string4.substring(0, ((zzja)zzlj2).zze().zza(null, false));
        }
        return string4;
    }

    static /* bridge */ /* synthetic */ void zza(zzlj zzlj2, zzlk zzlk2) {
        zzlj2.zzh = null;
    }

    static /* bridge */ /* synthetic */ void zza(zzlj zzlj2, zzlk zzlk2, zzlk zzlk3, long l, boolean bl, Bundle bundle) {
        zzlj2.zza(zzlk2, zzlk3, l, bl, null);
    }

    static /* synthetic */ void zza(zzlj zzlj2, Bundle bundle, zzlk zzlk2, zzlk zzlk3, long l) {
        long l2 = l;
        zzlk zzlk4 = zzlk3;
        zzlk zzlk5 = zzlk2;
        Bundle bundle2 = bundle;
        zzlj zzlj3 = zzlj2;
        if (bundle2 != null) {
            bundle2.remove("screen_name");
            bundle2.remove("screen_class");
        }
        Bundle bundle3 = ((zzja)zzlj3).zzq().zza(null, "screen_view", bundle2, null, false);
        zzlj3.zza(zzlk5, zzlk4, l2, true, bundle3);
    }

    static /* bridge */ /* synthetic */ void zza(zzlj zzlj2, zzlk zzlk2, boolean bl, long l) {
        zzlj2.zza(zzlk2, false, l);
    }

    public zzlj(zzhy zzhy2) {
        super(zzhy2);
        this.zzd = new ConcurrentHashMap<Integer, zzlk>();
    }

    @MainThread
    private final void zza(Activity activity, zzlk zzlk2, boolean bl) {
        zzlk zzlk3;
        zzlk zzlk4;
        zzlk zzlk5 = zzlk4 = this.zzb == null ? this.zzc : this.zzb;
        if (zzlk2.zzb == null) {
            zzlk3 = activity != null ? this.zza(activity.getClass(), "Activity") : null;
            zzlk2 = new zzlk(zzlk2.zza, (String)((Object)zzlk3), zzlk2.zzc, zzlk2.zze, zzlk2.zzf);
        }
        zzlk3 = zzlk2;
        this.zzc = this.zzb;
        this.zzb = zzlk3;
        long l = ((zzja)this).zzb().elapsedRealtime();
        ((zzja)this).zzl().zzb(new zzll(this, zzlk3, zzlk4, l, bl));
    }

    @WorkerThread
    private final void zza(zzlk zzlk2, @Nullable zzlk zzlk3, long l, boolean bl, @Nullable Bundle bundle) {
        boolean bl2;
        ((zzja)this).zzt();
        boolean bl3 = zzlk3 == null || zzlk3.zzc != zzlk2.zzc || !Objects.equals(zzlk3.zzb, zzlk2.zzb) || !Objects.equals(zzlk3.zza, zzlk2.zza);
        boolean bl4 = bl2 = bl && this.zza != null;
        if (bl3) {
            long l2;
            long l3;
            Bundle bundle2 = bundle != null ? new Bundle(bundle) : new Bundle();
            zzos.zza(zzlk2, bundle2, true);
            if (zzlk3 != null) {
                if (zzlk3.zza != null) {
                    bundle2.putString("_pn", zzlk3.zza);
                }
                if (zzlk3.zzb != null) {
                    bundle2.putString("_pc", zzlk3.zzb);
                }
                bundle2.putLong("_pi", zzlk3.zzc);
            }
            if (bl2 && (l3 = ((zze)this).zzp().zzb.zza(l2 = l)) > 0L) {
                ((zzja)this).zzq().zza(bundle2, l3);
            }
            if (!((zzja)this).zze().zzw()) {
                bundle2.putLong("_mst", 1L);
            }
            String string = zzlk2.zze ? "app" : "auto";
            long l4 = ((zzja)this).zzb().currentTimeMillis();
            if (zzlk2.zze && zzlk2.zzf != 0L) {
                l4 = zzlk2.zzf;
            }
            ((zze)this).zzm().zza(string, "_vs", l4, bundle2);
        }
        if (bl2) {
            this.zza(this.zza, true, l);
        }
        this.zza = zzlk2;
        if (zzlk2.zze) {
            this.zzh = zzlk2;
        }
        ((zze)this).zzo().zza(zzlk2);
    }

    @MainThread
    public final void zza(Activity activity, @Nullable Bundle bundle) {
        if (!((zzja)this).zze().zzw()) {
            return;
        }
        if (bundle == null) {
            return;
        }
        Bundle bundle2 = bundle.getBundle("com.google.app_measurement.screen_service");
        if (bundle2 == null) {
            return;
        }
        zzlk zzlk2 = new zzlk(bundle2.getString("name"), bundle2.getString("referrer_name"), bundle2.getLong("id"));
        this.zzd.put(activity.hashCode(), zzlk2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void zza(Activity activity) {
        Object object = this.zzj;
        synchronized (object) {
            if (activity == this.zze) {
                this.zze = null;
            }
        }
        if (!((zzja)this).zze().zzw()) {
            return;
        }
        this.zzd.remove(activity.hashCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void zzb(Activity activity) {
        Object object = this.zzj;
        synchronized (object) {
            this.zzi = false;
            this.zzf = true;
        }
        long l = ((zzja)this).zzb().elapsedRealtime();
        if (!((zzja)this).zze().zzw()) {
            this.zzb = null;
            ((zzja)this).zzl().zzb(new zzln(this, l));
            return;
        }
        zzlk zzlk2 = this.zzd(activity);
        this.zzc = this.zzb;
        this.zzb = null;
        ((zzja)this).zzl().zzb(new zzlq(this, zzlk2, l));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void zzc(Activity activity) {
        zze zze2;
        Object object = this.zzj;
        synchronized (object) {
            this.zzi = true;
            if (activity != this.zze) {
                Activity activity2 = activity;
                zze2 = this;
                Object object2 = ((zzlj)zze2).zzj;
                synchronized (object2) {
                    ((zzlj)zze2).zze = activity2;
                    ((zzlj)zze2).zzf = false;
                }
                if (zze2.zze().zzw()) {
                    ((zzlj)zze2).zzg = null;
                    zze2.zzl().zzb(new zzlp((zzlj)zze2));
                }
            }
        }
        if (!((zzja)this).zze().zzw()) {
            this.zzb = this.zzg;
            ((zzja)this).zzl().zzb(new zzlo(this));
            return;
        }
        object = this.zzd(activity);
        this.zza(activity, (zzlk)object, false);
        zze2 = ((zze)this).zzc();
        long l = zze2.zzb().elapsedRealtime();
        zze2.zzl().zzb(new zzc((zzb)zze2, l));
    }

    @MainThread
    public final void zzb(Activity activity, Bundle bundle) {
        if (!((zzja)this).zze().zzw()) {
            return;
        }
        if (bundle == null) {
            return;
        }
        zzlk zzlk2 = this.zzd.get(activity.hashCode());
        if (zzlk2 == null) {
            return;
        }
        Bundle bundle2 = new Bundle();
        bundle2.putLong("id", zzlk2.zzc);
        bundle2.putString("name", zzlk2.zza);
        bundle2.putString("referrer_name", zzlk2.zzb);
        bundle.putBundle("com.google.app_measurement.screen_service", bundle2);
    }

    @WorkerThread
    private final void zza(@Nullable zzlk zzlk2, boolean bl, long l) {
        boolean bl2;
        ((zze)this).zzc().zza(((zzja)this).zzb().elapsedRealtime());
        boolean bl3 = bl2 = zzlk2 != null && zzlk2.zzd;
        if (((zze)this).zzp().zza(bl2, bl, l) && zzlk2 != null) {
            zzlk2.zzd = false;
        }
    }

    @Deprecated
    public final void zza(@NonNull Activity activity, @Size(min=1L, max=36L) @Nullable String string, @Size(min=1L, max=36L) @Nullable String string2) {
        if (!((zzja)this).zze().zzw()) {
            ((zzja)this).zzj().zzv().zza("setCurrentScreen cannot be called while screen reporting is disabled.");
            return;
        }
        zzlk zzlk2 = this.zzb;
        if (zzlk2 == null) {
            ((zzja)this).zzj().zzv().zza("setCurrentScreen cannot be called while no activity active");
            return;
        }
        if (this.zzd.get(activity.hashCode()) == null) {
            ((zzja)this).zzj().zzv().zza("setCurrentScreen must be called with an activity in the activity lifecycle");
            return;
        }
        if (string2 == null) {
            string2 = this.zza(activity.getClass(), "Activity");
        }
        boolean bl = Objects.equals(zzlk2.zzb, string2);
        boolean bl2 = Objects.equals(zzlk2.zza, string);
        if (bl && bl2) {
            ((zzja)this).zzj().zzv().zza("setCurrentScreen cannot be called with the same class and name");
            return;
        }
        if (string != null && (string.length() <= 0 || string.length() > ((zzja)this).zze().zza(null, false))) {
            ((zzja)this).zzj().zzv().zza("Invalid screen name length in setCurrentScreen. Length", string.length());
            return;
        }
        if (string2 != null && (string2.length() <= 0 || string2.length() > ((zzja)this).zze().zza(null, false))) {
            ((zzja)this).zzj().zzv().zza("Invalid class name length in setCurrentScreen. Length", string2.length());
            return;
        }
        ((zzja)this).zzj().zzp().zza("Setting current screen to name, class", string == null ? "null" : string, string2);
        zzlk zzlk3 = new zzlk(string, string2, ((zzja)this).zzq().zzn());
        this.zzd.put(activity.hashCode(), zzlk3);
        this.zza(activity, zzlk3, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(Bundle bundle, long l) {
        zzlk zzlk2;
        String string = null;
        String string2 = null;
        Object object = this.zzj;
        synchronized (object) {
            if (!this.zzi) {
                ((zzja)this).zzj().zzv().zza("Cannot log screen view event when the app is in the background.");
                return;
            }
            if (bundle != null) {
                string = bundle.getString("screen_name");
                if (string != null && (string.length() <= 0 || string.length() > ((zzja)this).zze().zza(null, false))) {
                    ((zzja)this).zzj().zzv().zza("Invalid screen name length for screen view. Length", string.length());
                    return;
                }
                string2 = bundle.getString("screen_class");
                if (string2 != null && (string2.length() <= 0 || string2.length() > ((zzja)this).zze().zza(null, false))) {
                    ((zzja)this).zzj().zzv().zza("Invalid screen class length for screen view. Length", string2.length());
                    return;
                }
            }
            if (string2 == null) {
                string2 = this.zze != null ? this.zza(this.zze.getClass(), "Activity") : "Activity";
            }
            zzlk2 = this.zzb;
            if (this.zzf && zzlk2 != null) {
                this.zzf = false;
                boolean bl = Objects.equals(zzlk2.zzb, string2);
                boolean bl2 = Objects.equals(zzlk2.zza, string);
                if (bl && bl2) {
                    ((zzja)this).zzj().zzv().zza("Ignoring call to log screen view event with duplicate parameters.");
                    return;
                }
            }
        }
        ((zzja)this).zzj().zzp().zza("Logging screen view with name, class", string == null ? "null" : string, string2 == null ? "null" : string2);
        object = this.zzb == null ? this.zzc : this.zzb;
        this.zzb = zzlk2 = new zzlk(string, string2, ((zzja)this).zzq().zzn(), true, l);
        this.zzc = object;
        this.zzg = zzlk2;
        long l2 = ((zzja)this).zzb().elapsedRealtime();
        ((zzja)this).zzl().zzb(new zzlm(this, bundle, zzlk2, (zzlk)object, l2));
    }

    @Override
    protected final boolean zzz() {
        return false;
    }
}

