/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.RemoteException;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.internal.measurement.zzdo;
import com.google.android.gms.internal.measurement.zznm;
import com.google.android.gms.measurement.internal.zzae;
import com.google.android.gms.measurement.internal.zzaj;
import com.google.android.gms.measurement.internal.zzav;
import com.google.android.gms.measurement.internal.zzbf;
import com.google.android.gms.measurement.internal.zzbh;
import com.google.android.gms.measurement.internal.zze;
import com.google.android.gms.measurement.internal.zzgb;
import com.google.android.gms.measurement.internal.zzgm;
import com.google.android.gms.measurement.internal.zzh;
import com.google.android.gms.measurement.internal.zzhy;
import com.google.android.gms.measurement.internal.zzja;
import com.google.android.gms.measurement.internal.zzlk;
import com.google.android.gms.measurement.internal.zzlr;
import com.google.android.gms.measurement.internal.zzlt;
import com.google.android.gms.measurement.internal.zzlu;
import com.google.android.gms.measurement.internal.zzlv;
import com.google.android.gms.measurement.internal.zzlw;
import com.google.android.gms.measurement.internal.zzlx;
import com.google.android.gms.measurement.internal.zzly;
import com.google.android.gms.measurement.internal.zzlz;
import com.google.android.gms.measurement.internal.zzma;
import com.google.android.gms.measurement.internal.zzmb;
import com.google.android.gms.measurement.internal.zzmc;
import com.google.android.gms.measurement.internal.zzmd;
import com.google.android.gms.measurement.internal.zzme;
import com.google.android.gms.measurement.internal.zzmf;
import com.google.android.gms.measurement.internal.zzmg;
import com.google.android.gms.measurement.internal.zzmh;
import com.google.android.gms.measurement.internal.zzmi;
import com.google.android.gms.measurement.internal.zzmj;
import com.google.android.gms.measurement.internal.zzmk;
import com.google.android.gms.measurement.internal.zzml;
import com.google.android.gms.measurement.internal.zzmm;
import com.google.android.gms.measurement.internal.zzmn;
import com.google.android.gms.measurement.internal.zzmo;
import com.google.android.gms.measurement.internal.zzmq;
import com.google.android.gms.measurement.internal.zznl;
import com.google.android.gms.measurement.internal.zzno;
import com.google.android.gms.measurement.internal.zzo;
import com.google.android.gms.measurement.internal.zzon;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class zzls
extends zzh {
    private final zzmq zza;
    private @Nullable zzgb zzb;
    private volatile Boolean zzc;
    private final zzav zzd;
    private final zznl zze;
    private final List<Runnable> zzf = new ArrayList<Runnable>();
    private final zzav zzg;

    @WorkerThread
    private final @Nullable zzo zzc(boolean bl) {
        return ((zze)this).zzg().zza(bl ? ((zzja)this).zzj().zzx() : null);
    }

    @WorkerThread
    protected final @Nullable zzaj zzaa() {
        ((zzja)this).zzt();
        this.zzu();
        zzgb zzgb2 = this.zzb;
        if (zzgb2 == null) {
            this.zzae();
            ((zzja)this).zzj().zzc().zza("Failed to get consents; not connected to service yet.");
            return null;
        }
        zzo zzo2 = this.zzc(false);
        Preconditions.checkNotNull((Object)((Object)zzo2));
        try {
            zzaj zzaj2 = zzgb2.zza(zzo2);
            this.zzar();
            return zzaj2;
        }
        catch (RemoteException remoteException) {
            ((zzja)this).zzj().zzg().zza("Failed to get consents; remote exception", (Object)remoteException);
            return null;
        }
    }

    static /* bridge */ /* synthetic */ zzgb zza(zzls zzls2) {
        return zzls2.zzb;
    }

    static /* bridge */ /* synthetic */ zzmq zzb(zzls zzls2) {
        return zzls2.zza;
    }

    final Boolean zzab() {
        return this.zzc;
    }

    static /* bridge */ /* synthetic */ void zza(zzls zzls2, zzgb zzgb2) {
        zzls2.zzb = null;
    }

    static /* synthetic */ void zzc(zzls zzls2) {
        zzls2.zzaq();
    }

    static /* synthetic */ void zzd(zzls zzls2) {
        zzls zzls3 = zzls2;
        ((zzja)zzls3).zzt();
        if (zzls3.zzal()) {
            ((zzja)zzls3).zzj().zzp().zza("Inactivity, disconnecting from the service");
            zzls3.zzaf();
        }
    }

    static /* synthetic */ void zza(zzls zzls2, ComponentName componentName) {
        ComponentName componentName2 = componentName;
        zzls zzls3 = zzls2;
        ((zzja)zzls3).zzt();
        if (zzls3.zzb != null) {
            zzls3.zzb = null;
            ((zzja)zzls3).zzj().zzp().zza("Disconnected from device MeasurementService", componentName2);
            zzls zzls4 = zzls3;
            ((zzja)zzls4).zzt();
            zzls4.zzae();
        }
    }

    static /* synthetic */ void zze(zzls zzls2) {
        zzls2.zzar();
    }

    protected zzls(zzhy zzhy2) {
        super(zzhy2);
        this.zze = new zznl(zzhy2.zzb());
        this.zza = new zzmq(this);
        this.zzd = new zzlt(this, zzhy2);
        this.zzg = new zzmg(this, zzhy2);
    }

    @WorkerThread
    protected final void zzac() {
        ((zzja)this).zzt();
        this.zzu();
        zzo zzo2 = this.zzc(true);
        this.zza(new zzme(this, zzo2));
    }

    @WorkerThread
    protected final void zzad() {
        ((zzja)this).zzt();
        this.zzu();
        zzo zzo2 = this.zzc(true);
        ((zze)this).zzh().zzab();
        this.zza(new zzmb(this, zzo2));
    }

    @WorkerThread
    final void zzae() {
        ((zzja)this).zzt();
        this.zzu();
        if (this.zzal()) {
            return;
        }
        if (this.zzap()) {
            this.zza.zza();
            return;
        }
        if (!((zzja)this).zze().zzy()) {
            Intent intent;
            zzls zzls2 = this;
            PackageManager packageManager = ((zzja)zzls2).zza().getPackageManager();
            List list = packageManager.queryIntentServices(intent = new Intent().setClassName(((zzja)zzls2).zza(), "com.google.android.gms.measurement.AppMeasurementService"), 65536);
            if (list != null && !list.isEmpty()) {
                Intent intent2 = new Intent("com.google.android.gms.measurement.START");
                intent2.setComponent(new ComponentName(((zzja)this).zza(), "com.google.android.gms.measurement.AppMeasurementService"));
                this.zza.zza(intent2);
                return;
            }
            ((zzja)this).zzj().zzg().zza("Unable to use remote or local measurement implementation. Please register the AppMeasurementService service in the app manifest");
        }
    }

    @WorkerThread
    public final void zzaf() {
        ((zzja)this).zzt();
        this.zzu();
        this.zza.zzb();
        try {
            ConnectionTracker.getInstance().unbindService(((zzja)this).zza(), (ServiceConnection)this.zza);
        }
        catch (IllegalArgumentException | IllegalStateException runtimeException) {}
        this.zzb = null;
    }

    @WorkerThread
    private final void zzaq() {
        ((zzja)this).zzt();
        ((zzja)this).zzj().zzp().zza("Processing queued up service tasks", this.zzf.size());
        for (Runnable runnable : this.zzf) {
            try {
                runnable.run();
            }
            catch (RuntimeException runtimeException) {
                ((zzja)this).zzj().zzg().zza("Task exception while flushing queue", runtimeException);
            }
        }
        this.zzf.clear();
        this.zzg.zza();
    }

    @WorkerThread
    public final void zza(zzdo zzdo2) {
        ((zzja)this).zzt();
        this.zzu();
        zzo zzo2 = this.zzc(false);
        this.zza(new zzmc(this, zzo2, zzdo2));
    }

    @WorkerThread
    public final void zza(AtomicReference<String> atomicReference) {
        ((zzja)this).zzt();
        this.zzu();
        zzo zzo2 = this.zzc(false);
        this.zza(new zzlz(this, atomicReference, zzo2));
    }

    @WorkerThread
    protected final void zza(zzdo zzdo2, @Nullable String string, @Nullable String string2) {
        ((zzja)this).zzt();
        this.zzu();
        zzo zzo2 = this.zzc(false);
        this.zza(new zzmo(this, string, string2, zzo2, zzdo2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzae>> atomicReference, @Nullable String string, @Nullable String string2, @Nullable String string3) {
        ((zzja)this).zzt();
        this.zzu();
        zzo zzo2 = this.zzc(false);
        this.zza(new zzml(this, atomicReference, string, string2, string3, zzo2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<@Nullable List<zzno>> atomicReference, Bundle bundle) {
        ((zzja)this).zzt();
        this.zzu();
        zzo zzo2 = this.zzc(false);
        this.zza(new zzly(this, atomicReference, zzo2, bundle));
    }

    @WorkerThread
    protected final void zza(AtomicReference<@Nullable List<zzon>> atomicReference, boolean bl) {
        ((zzja)this).zzt();
        this.zzu();
        zzo zzo2 = this.zzc(false);
        this.zza(new zzlv(this, atomicReference, zzo2, bl));
    }

    @WorkerThread
    protected final void zza(zzdo zzdo2, @Nullable String string, @Nullable String string2, boolean bl) {
        ((zzja)this).zzt();
        this.zzu();
        zzo zzo2 = this.zzc(false);
        this.zza(new zzlw(this, string, string2, zzo2, bl, zzdo2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzon>> atomicReference, @Nullable String string, @Nullable String string2, @Nullable String string3, boolean bl) {
        ((zzja)this).zzt();
        this.zzu();
        zzo zzo2 = this.zzc(false);
        this.zza(new zzmn(this, atomicReference, string, string2, string3, zzo2, bl));
    }

    final /* synthetic */ void zzag() {
        zzgb zzgb2 = this.zzb;
        if (zzgb2 == null) {
            ((zzja)this).zzj().zzg().zza("Failed to send Dma consent settings to service");
            return;
        }
        try {
            zzo zzo2 = this.zzc(false);
            Preconditions.checkNotNull((Object)((Object)zzo2));
            zzgb2.zzg(zzo2);
            this.zzar();
            return;
        }
        catch (RemoteException remoteException) {
            ((zzja)this).zzj().zzg().zza("Failed to send Dma consent settings to the service", (Object)remoteException);
            return;
        }
    }

    final /* synthetic */ void zzah() {
        zzgb zzgb2 = this.zzb;
        if (zzgb2 == null) {
            ((zzja)this).zzj().zzg().zza("Failed to send storage consent settings to service");
            return;
        }
        try {
            zzo zzo2 = this.zzc(false);
            Preconditions.checkNotNull((Object)((Object)zzo2));
            zzgb2.zzi(zzo2);
            this.zzar();
            return;
        }
        catch (RemoteException remoteException) {
            ((zzja)this).zzj().zzg().zza("Failed to send storage consent settings to the service", (Object)remoteException);
            return;
        }
    }

    @WorkerThread
    protected final void zza(zzbf zzbf2, @Nullable String string) {
        Preconditions.checkNotNull((Object)((Object)zzbf2));
        ((zzja)this).zzt();
        this.zzu();
        boolean bl = ((zze)this).zzh().zza(zzbf2);
        zzo zzo2 = this.zzc(true);
        this.zza(new zzmj(this, true, zzo2, bl, zzbf2, string));
    }

    @WorkerThread
    public final void zza(zzdo zzdo2, zzbf zzbf2, String string) {
        ((zzja)this).zzt();
        this.zzu();
        if (((zzja)this).zzq().zza(12451000) != 0) {
            ((zzja)this).zzj().zzu().zza("Not bundling data. Service unavailable or out of date");
            ((zzja)this).zzq().zza(zzdo2, new byte[0]);
            return;
        }
        this.zza(new zzmi(this, zzbf2, string, zzdo2));
    }

    @WorkerThread
    private final void zzar() {
        ((zzja)this).zzt();
        this.zze.zzb();
        this.zzd.zza((Long)zzbh.zzal.zza(null));
    }

    @WorkerThread
    protected final void zzai() {
        ((zzja)this).zzt();
        this.zzu();
        zzo zzo2 = this.zzc(false);
        ((zze)this).zzh().zzaa();
        this.zza(new zzma(this, zzo2));
    }

    @WorkerThread
    private final void zza(Runnable runnable) throws IllegalStateException {
        ((zzja)this).zzt();
        if (this.zzal()) {
            runnable.run();
            return;
        }
        if ((long)this.zzf.size() >= 1000L) {
            ((zzja)this).zzj().zzg().zza("Discarding data. Max runnable queue size reached");
            return;
        }
        this.zzf.add(runnable);
        this.zzg.zza(60000L);
        this.zzae();
    }

    @WorkerThread
    final void zza(zzgb zzgb2, @Nullable AbstractSafeParcelable abstractSafeParcelable, zzo zzo2) {
        ((zzja)this).zzt();
        this.zzu();
        int n = 100;
        for (int i = 0; i < 1001 && n == 100; ++i) {
            ArrayList<AbstractSafeParcelable> arrayList = new ArrayList<AbstractSafeParcelable>();
            n = 0;
            List<AbstractSafeParcelable> list = ((zze)this).zzh().zza(100);
            if (list != null) {
                arrayList.addAll(list);
                n = list.size();
            }
            if (abstractSafeParcelable != null && n < 100) {
                arrayList.add(abstractSafeParcelable);
            }
            boolean bl = ((zzja)this).zze().zza(zzbh.zzce);
            ArrayList<AbstractSafeParcelable> arrayList2 = arrayList;
            int n2 = arrayList2.size();
            int n3 = 0;
            while (n3 < n2) {
                Object e = arrayList2.get(n3);
                ++n3;
                AbstractSafeParcelable abstractSafeParcelable2 = (AbstractSafeParcelable)e;
                if (abstractSafeParcelable2 instanceof zzbf) {
                    long l = 0L;
                    long l2 = 0L;
                    try {
                        if (bl) {
                            l = this.zzu.zzb().currentTimeMillis();
                            l2 = this.zzu.zzb().elapsedRealtime();
                        }
                        zzgb2.zza((zzbf)abstractSafeParcelable2, zzo2);
                        if (!bl) continue;
                        ((zzja)this).zzj().zzp().zza("Logging telemetry for logEvent from database");
                        zzgm.zza(this.zzu).zza(36301, 0, l, this.zzu.zzb().currentTimeMillis(), (int)(this.zzu.zzb().elapsedRealtime() - l2));
                    }
                    catch (RemoteException remoteException) {
                        ((zzja)this).zzj().zzg().zza("Failed to send event to the service", (Object)remoteException);
                        if (!bl || l == 0L) continue;
                        zzgm.zza(this.zzu).zza(36301, 13, l, this.zzu.zzb().currentTimeMillis(), (int)(this.zzu.zzb().elapsedRealtime() - l2));
                    }
                    continue;
                }
                if (abstractSafeParcelable2 instanceof zzon) {
                    try {
                        zzgb2.zza((zzon)abstractSafeParcelable2, zzo2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzja)this).zzj().zzg().zza("Failed to send user property to the service", (Object)remoteException);
                    }
                    continue;
                }
                if (abstractSafeParcelable2 instanceof zzae) {
                    try {
                        zzgb2.zza((zzae)abstractSafeParcelable2, zzo2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzja)this).zzj().zzg().zza("Failed to send conditional user property to the service", (Object)remoteException);
                    }
                    continue;
                }
                ((zzja)this).zzj().zzg().zza("Discarding data. Unrecognized parcel type.");
            }
        }
    }

    @WorkerThread
    protected final void zza(zzae zzae2) {
        Preconditions.checkNotNull((Object)((Object)zzae2));
        ((zzja)this).zzt();
        this.zzu();
        boolean bl = ((zze)this).zzh().zza(zzae2);
        zzae zzae3 = new zzae(zzae2);
        zzo zzo2 = this.zzc(true);
        this.zza(new zzmm(this, true, zzo2, bl, zzae3, zzae2));
    }

    @WorkerThread
    protected final void zza(boolean bl) {
        ((zzja)this).zzt();
        this.zzu();
        if (!(zznm.zza() && ((zzja)this).zze().zza(zzbh.zzcx) || !bl)) {
            ((zze)this).zzh().zzaa();
        }
        if (this.zzan()) {
            zzo zzo2 = this.zzc(false);
            this.zza(new zzmk(this, zzo2));
        }
    }

    @WorkerThread
    protected final void zza(@Nullable zzlk zzlk2) {
        ((zzja)this).zzt();
        this.zzu();
        this.zza(new zzmd(this, zzlk2));
    }

    @WorkerThread
    public final void zza(Bundle bundle) {
        ((zzja)this).zzt();
        this.zzu();
        zzo zzo2 = this.zzc(false);
        this.zza(new zzmf(this, zzo2, bundle));
    }

    @WorkerThread
    protected final void zzaj() {
        ((zzja)this).zzt();
        this.zzu();
        zzls zzls2 = this;
        this.zza(new zzlu(zzls2));
    }

    @WorkerThread
    protected final void zzak() {
        ((zzja)this).zzt();
        this.zzu();
        zzo zzo2 = this.zzc(true);
        this.zza(new zzmh(this, zzo2));
    }

    @WorkerThread
    protected final void zza(zzgb zzgb2) {
        ((zzja)this).zzt();
        Preconditions.checkNotNull((Object)zzgb2);
        this.zzb = zzgb2;
        this.zzar();
        this.zzaq();
    }

    @WorkerThread
    protected final void zzb(boolean bl) {
        ((zzja)this).zzt();
        this.zzu();
        if (!(zznm.zza() && ((zzja)this).zze().zza(zzbh.zzcx) || !bl)) {
            ((zze)this).zzh().zzaa();
        }
        zzls zzls2 = this;
        this.zza(new zzlr(zzls2));
    }

    @WorkerThread
    protected final void zza(zzon zzon2) {
        ((zzja)this).zzt();
        this.zzu();
        boolean bl = ((zze)this).zzh().zza(zzon2);
        zzo zzo2 = this.zzc(true);
        this.zza(new zzlx(this, zzo2, bl, zzon2));
    }

    @WorkerThread
    public final boolean zzal() {
        ((zzja)this).zzt();
        this.zzu();
        return this.zzb != null;
    }

    @Override
    protected final boolean zzz() {
        return false;
    }

    @WorkerThread
    final boolean zzam() {
        ((zzja)this).zzt();
        this.zzu();
        if (!this.zzap()) {
            return true;
        }
        return ((zzja)this).zzq().zzg() >= 200900;
    }

    @WorkerThread
    final boolean zzan() {
        ((zzja)this).zzt();
        this.zzu();
        if (!this.zzap()) {
            return true;
        }
        return ((zzja)this).zzq().zzg() >= (Integer)zzbh.zzbt.zza(null);
    }

    @WorkerThread
    final boolean zzao() {
        ((zzja)this).zzt();
        this.zzu();
        if (!this.zzap()) {
            return true;
        }
        return ((zzja)this).zzq().zzg() >= 241200;
    }

    @WorkerThread
    final boolean zzap() {
        ((zzja)this).zzt();
        this.zzu();
        if (this.zzc == null) {
            boolean bl;
            zzls zzls2 = this;
            ((zzja)zzls2).zzt();
            zzls2.zzu();
            Boolean bl2 = ((zzja)zzls2).zzk().zzp();
            if (bl2 != null && bl2.booleanValue()) {
                bl = true;
            } else {
                boolean bl3;
                boolean bl4;
                if (((zze)zzls2).zzg().zzaa() == 1) {
                    bl4 = true;
                    bl3 = true;
                } else {
                    ((zzja)zzls2).zzj().zzp().zza("Checking service availability");
                    int n = ((zzja)zzls2).zzq().zza(12451000);
                    switch (n) {
                        case 0: {
                            ((zzja)zzls2).zzj().zzp().zza("Service available");
                            bl4 = true;
                            bl3 = true;
                            break;
                        }
                        case 1: {
                            ((zzja)zzls2).zzj().zzp().zza("Service missing");
                            bl4 = false;
                            bl3 = true;
                            break;
                        }
                        case 18: {
                            ((zzja)zzls2).zzj().zzu().zza("Service updating");
                            bl4 = true;
                            bl3 = true;
                            break;
                        }
                        case 2: {
                            ((zzja)zzls2).zzj().zzc().zza("Service container out of date");
                            if (((zzja)zzls2).zzq().zzg() < 17443) {
                                bl4 = false;
                                bl3 = true;
                                break;
                            }
                            bl4 = bl2 == null;
                            bl3 = false;
                            break;
                        }
                        case 3: {
                            ((zzja)zzls2).zzj().zzu().zza("Service disabled");
                            bl4 = false;
                            bl3 = false;
                            break;
                        }
                        case 9: {
                            ((zzja)zzls2).zzj().zzu().zza("Service invalid");
                            bl4 = false;
                            bl3 = false;
                            break;
                        }
                        default: {
                            ((zzja)zzls2).zzj().zzu().zza("Unexpected service status", n);
                            bl4 = false;
                            bl3 = false;
                        }
                    }
                }
                if (!bl4 && ((zzja)zzls2).zze().zzy()) {
                    ((zzja)zzls2).zzj().zzg().zza("No way to upload. Consider using the full version of Analytics");
                    bl3 = false;
                }
                if (bl3) {
                    ((zzja)zzls2).zzk().zza(bl4);
                }
                bl = bl4;
            }
            this.zzc = bl;
        }
        return this.zzc;
    }
}

