/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.annotation.TargetApi;
import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.os.Build;
import android.os.PersistableBundle;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.measurement.zzgf;
import com.google.android.gms.measurement.internal.zzbn;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzg;
import com.google.android.gms.measurement.internal.zzic;
import com.google.android.gms.measurement.internal.zzjf;
import com.google.android.gms.measurement.internal.zzpn;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class zzls
extends zzf {
    private @Nullable JobScheduler zza;

    @VisibleForTesting
    private final int zzad() {
        String string = ((zzjf)this).zza().getPackageName();
        return ("measurement-client" + string).hashCode();
    }

    @WorkerThread
    final zzgf.zzo.zza zzac() {
        this.zzw();
        ((zzjf)this).zzv();
        if (!((zzjf)this).zze().zza(zzbn.zzcl)) {
            return zzgf.zzo.zza.zzi;
        }
        if (this.zza == null) {
            return zzgf.zzo.zza.zzg;
        }
        if (!((zzjf)this).zze().zzab()) {
            return zzgf.zzo.zza.zzh;
        }
        if (!((zzjf)this).zze().zza(zzbn.zzcn)) {
            return zzgf.zzo.zza.zzf;
        }
        if (!zzpn.zzb(((zzjf)this).zza(), "com.google.android.gms.measurement.AppMeasurementJobService")) {
            return zzgf.zzo.zza.zzc;
        }
        if (Build.VERSION.SDK_INT < 24) {
            return zzgf.zzo.zza.zzd;
        }
        if (!((zzg)this).zzq().zzap()) {
            return zzgf.zzo.zza.zze;
        }
        return zzgf.zzo.zza.zzb;
    }

    public zzls(zzic zzic2) {
        super(zzic2);
    }

    @Override
    @WorkerThread
    @TargetApi(value=24)
    protected final void zzz() {
        this.zza = (JobScheduler)((zzjf)this).zza().getSystemService("jobscheduler");
    }

    @TargetApi(value=24)
    @WorkerThread
    public final void zza(long l) {
        this.zzw();
        ((zzjf)this).zzv();
        if (this.zza != null && this.zza.getPendingJob(this.zzad()) != null) {
            ((zzjf)this).zzj().zzq().zza("[sgtm] There's an existing pending job, skip this schedule.");
            return;
        }
        zzgf.zzo.zza zza2 = this.zzac();
        if (zza2 != zzgf.zzo.zza.zzb) {
            ((zzjf)this).zzj().zzq().zza("[sgtm] Not eligible for Scion upload", zza2.name());
            return;
        }
        ((zzjf)this).zzj().zzq().zza("[sgtm] Scheduling Scion upload, millis", l);
        PersistableBundle persistableBundle = new PersistableBundle();
        persistableBundle.putString("action", "com.google.android.gms.measurement.SCION_UPLOAD");
        JobInfo jobInfo = new JobInfo.Builder(this.zzad(), new ComponentName(((zzjf)this).zza(), "com.google.android.gms.measurement.AppMeasurementJobService")).setRequiredNetworkType(1).setMinimumLatency(l).setOverrideDeadline(l << 1).setExtras(persistableBundle).build();
        int n = ((JobScheduler)Preconditions.checkNotNull((Object)this.zza)).schedule(jobInfo);
        ((zzjf)this).zzj().zzq().zza("[sgtm] Scion upload job scheduled with result", n == 1 ? "SUCCESS" : "FAILURE");
    }

    @Override
    protected final boolean zzab() {
        return true;
    }
}

