/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.RemoteException;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.internal.BaseGmsClient;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.measurement.internal.zzfz;
import com.google.android.gms.measurement.internal.zzgb;
import com.google.android.gms.measurement.internal.zzgn;
import com.google.android.gms.measurement.internal.zzgo;
import com.google.android.gms.measurement.internal.zzjf;
import com.google.android.gms.measurement.internal.zzme;
import com.google.android.gms.measurement.internal.zzni;
import com.google.android.gms.measurement.internal.zznk;
import com.google.android.gms.measurement.internal.zznl;
import com.google.android.gms.measurement.internal.zznm;
import com.google.android.gms.measurement.internal.zznn;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class zznj
implements ServiceConnection,
BaseGmsClient.BaseConnectionCallbacks,
BaseGmsClient.BaseOnConnectionFailedListener {
    private volatile boolean zzb;
    private volatile @Nullable zzgn zzc;
    final /* synthetic */ zzme zza;

    static /* bridge */ /* synthetic */ void zza(zznj zznj2, boolean bl) {
        zznj2.zzb = false;
    }

    protected zznj(zzme zzme2) {
        this.zza = zzme2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zza(Intent intent) {
        ((zzjf)this.zza).zzv();
        Context context = ((zzjf)this.zza).zza();
        ConnectionTracker connectionTracker = ConnectionTracker.getInstance();
        zznj zznj2 = this;
        synchronized (zznj2) {
            if (this.zzb) {
                ((zzjf)this.zza).zzj().zzq().zza("Connection attempt already in progress");
                return;
            }
            ((zzjf)this.zza).zzj().zzq().zza("Using local app measurement service");
            this.zzb = true;
            connectionTracker.bindService(context, intent, (ServiceConnection)zzme.zzb(this.zza), 129);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zza() {
        ((zzjf)this.zza).zzv();
        Context context = ((zzjf)this.zza).zza();
        zznj zznj2 = this;
        synchronized (zznj2) {
            if (this.zzb) {
                ((zzjf)this.zza).zzj().zzq().zza("Connection attempt already in progress");
                return;
            }
            if (this.zzc != null && (this.zzc.isConnecting() || this.zzc.isConnected())) {
                ((zzjf)this.zza).zzj().zzq().zza("Already awaiting connection attempt");
                return;
            }
            this.zzc = new zzgn(context, Looper.getMainLooper(), this, this);
            ((zzjf)this.zza).zzj().zzq().zza("Connecting to remote service");
            this.zzb = true;
            Preconditions.checkNotNull((Object)((Object)this.zzc));
            this.zzc.checkAvailabilityAndConnect();
            return;
        }
    }

    @WorkerThread
    public final void zzb() {
        if (this.zzc != null && (this.zzc.isConnected() || this.zzc.isConnecting())) {
            this.zzc.disconnect();
        }
        this.zzc = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onConnected(@Nullable Bundle bundle) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnected");
        zznj zznj2 = this;
        synchronized (zznj2) {
            try {
                Preconditions.checkNotNull((Object)((Object)this.zzc));
                zzfz zzfz2 = (zzfz)this.zzc.getService();
                ((zzjf)this.zza).zzl().zzb(new zznk(this, zzfz2));
            }
            catch (DeadObjectException | IllegalStateException throwable) {
                this.zzc = null;
                this.zzb = false;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnectionFailed");
        zzgo zzgo2 = this.zza.zzu.zzm();
        if (zzgo2 != null) {
            zzgo2.zzr().zza("Service connection failed", connectionResult);
        }
        zznj zznj2 = this;
        synchronized (zznj2) {
            this.zzb = false;
            this.zzc = null;
        }
        ((zzjf)this.zza).zzl().zzb(new zznm(this));
    }

    @MainThread
    public final void onConnectionSuspended(int n) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnectionSuspended");
        ((zzjf)this.zza).zzj().zzc().zza("Service connection suspended");
        ((zzjf)this.zza).zzl().zzb(new zznn(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onServiceConnected(ComponentName componentName, @Nullable IBinder iBinder) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onServiceConnected");
        zznj zznj2 = this;
        synchronized (zznj2) {
            String string;
            if (iBinder == null) {
                this.zzb = false;
                ((zzjf)this.zza).zzj().zzg().zza("Service connected with null binder");
                return;
            }
            zzfz zzfz2 = null;
            try {
                string = iBinder.getInterfaceDescriptor();
                if ("com.google.android.gms.measurement.internal.IMeasurementService".equals(string)) {
                    IInterface iInterface;
                    IBinder iBinder2 = iBinder;
                    zzfz2 = iBinder2 == null ? null : ((iInterface = iBinder2.queryLocalInterface("com.google.android.gms.measurement.internal.IMeasurementService")) instanceof zzfz ? (zzfz)iInterface : new zzgb(iBinder2));
                    ((zzjf)this.zza).zzj().zzq().zza("Bound to IMeasurementService interface");
                } else {
                    ((zzjf)this.zza).zzj().zzg().zza("Got binder with a wrong descriptor", string);
                }
            }
            catch (RemoteException remoteException) {
                ((zzjf)this.zza).zzj().zzg().zza("Service connect failed to get IMeasurementService");
            }
            if (zzfz2 == null) {
                this.zzb = false;
                try {
                    ConnectionTracker.getInstance().unbindService(((zzjf)this.zza).zza(), (ServiceConnection)zzme.zzb(this.zza));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            } else {
                string = zzfz2;
                ((zzjf)this.zza).zzl().zzb(new zzni(this, (zzfz)((Object)string)));
            }
            return;
        }
    }

    @MainThread
    public final void onServiceDisconnected(ComponentName componentName) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onServiceDisconnected");
        ((zzjf)this.zza).zzj().zzc().zza("Service disconnected");
        ((zzjf)this.zza).zzl().zzb(new zznl(this, componentName));
    }
}

