/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.os.Bundle;
import androidx.annotation.WorkerThread;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.measurement.internal.zza;
import com.google.android.gms.measurement.internal.zzd;
import com.google.android.gms.measurement.internal.zze;
import com.google.android.gms.measurement.internal.zzim;
import com.google.android.gms.measurement.internal.zzjq;
import com.google.android.gms.measurement.internal.zzmh;
import com.google.android.gms.measurement.internal.zzqd;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class zzb
extends zze {
    private final Map<String, Long> zza;
    private final Map<String, Integer> zzb = new ArrayMap();
    private long zzc;

    static /* synthetic */ void zza(zzb zzb2, String string, long l) {
        Integer n;
        long l2 = l;
        String string2 = string;
        zzb zzb3 = zzb2;
        ((zzjq)zzb3).zzv();
        Preconditions.checkNotEmpty((String)string2);
        if (zzb3.zzb.isEmpty()) {
            zzb3.zzc = l2;
        }
        if ((n = zzb3.zzb.get(string2)) != null) {
            zzb3.zzb.put(string2, n + 1);
            return;
        }
        if (zzb3.zzb.size() >= 100) {
            ((zzjq)zzb3).zzj().zzr().zza("Too many ads visible");
            return;
        }
        zzb3.zzb.put(string2, 1);
        zzb3.zza.put(string2, l2);
    }

    static /* synthetic */ void zzb(zzb zzb2, String string, long l) {
        long l2 = l;
        String string2 = string;
        zzb zzb3 = zzb2;
        ((zzjq)zzb3).zzv();
        Preconditions.checkNotEmpty((String)string2);
        Integer n = zzb3.zzb.get(string2);
        if (n != null) {
            zzmh zzmh2 = ((zze)zzb3).zzp().zza(false);
            int n2 = n - 1;
            if (n2 == 0) {
                zzb3.zzb.remove(string2);
                Long l3 = zzb3.zza.get(string2);
                if (l3 == null) {
                    ((zzjq)zzb3).zzj().zzg().zza("First ad unit exposure time was never set");
                } else {
                    long l4 = l2 - l3;
                    zzb3.zza.remove(string2);
                    zzb3.zza(string2, l4, zzmh2);
                }
                if (zzb3.zzb.isEmpty()) {
                    if (zzb3.zzc == 0L) {
                        ((zzjq)zzb3).zzj().zzg().zza("First ad exposure time was never set");
                        return;
                    }
                    zzb3.zza(l2 - zzb3.zzc, zzmh2);
                    zzb3.zzc = 0L;
                }
                return;
            }
            zzb3.zzb.put(string2, n2);
            return;
        }
        ((zzjq)zzb3).zzj().zzg().zza("Call to endAdUnitExposure for unknown ad unit id", string2);
    }

    static /* synthetic */ void zza(zzb zzb2, long l) {
        zzb2.zzb(l);
    }

    public zzb(zzim zzim2) {
        super(zzim2);
        this.zza = new ArrayMap();
    }

    public final void zza(String string, long l) {
        if (string == null || string.length() == 0) {
            ((zzjq)this).zzj().zzg().zza("Ad unit id must be a non-empty string");
            return;
        }
        ((zzjq)this).zzl().zzb(new zza(this, string, l));
    }

    public final void zzb(String string, long l) {
        if (string == null || string.length() == 0) {
            ((zzjq)this).zzj().zzg().zza("Ad unit id must be a non-empty string");
            return;
        }
        ((zzjq)this).zzl().zzb(new zzd(this, string, l));
    }

    @WorkerThread
    private final void zza(long l, @Nullable zzmh zzmh2) {
        if (zzmh2 == null) {
            ((zzjq)this).zzj().zzq().zza("Not logging ad exposure. No active activity");
            return;
        }
        if (l < 1000L) {
            ((zzjq)this).zzj().zzq().zza("Not logging ad exposure. Less than 1000 ms. exposure", l);
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putLong("_xt", l);
        zzqd.zza(zzmh2, bundle, true);
        ((zze)this).zzm().zzc("am", "_xa", bundle);
    }

    @WorkerThread
    private final void zza(String string, long l, @Nullable zzmh zzmh2) {
        if (zzmh2 == null) {
            ((zzjq)this).zzj().zzq().zza("Not logging ad unit exposure. No active activity");
            return;
        }
        if (l < 1000L) {
            ((zzjq)this).zzj().zzq().zza("Not logging ad unit exposure. Less than 1000 ms. exposure", l);
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putString("_ai", string);
        bundle.putLong("_xt", l);
        zzqd.zza(zzmh2, bundle, true);
        ((zze)this).zzm().zzc("am", "_xu", bundle);
    }

    @WorkerThread
    public final void zza(long l) {
        zzmh zzmh2 = ((zze)this).zzp().zza(false);
        for (String string : this.zza.keySet()) {
            long l2 = this.zza.get(string);
            this.zza(string, l - l2, zzmh2);
        }
        if (!this.zza.isEmpty()) {
            this.zza(l - this.zzc, zzmh2);
        }
        this.zzb(l);
    }

    @WorkerThread
    private final void zzb(long l) {
        for (String string : this.zza.keySet()) {
            this.zza.put(string, l);
        }
        if (!this.zza.isEmpty()) {
            this.zzc = l;
        }
    }
}

