/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.measurement.internal.zzik;
import com.google.android.gms.measurement.internal.zzil;
import com.google.android.gms.measurement.internal.zzim;
import com.google.android.gms.measurement.internal.zzin;
import com.google.android.gms.measurement.internal.zzjq;
import com.google.android.gms.measurement.internal.zzjt;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public final class zzij
extends zzjt {
    private static final AtomicLong zza = new AtomicLong(Long.MIN_VALUE);
    @Nullable
    private zzin zzb;
    @Nullable
    private zzin zzc;
    private final PriorityBlockingQueue<zzik<?>> zzd;
    private final BlockingQueue<zzik<?>> zze;
    private final Thread.UncaughtExceptionHandler zzf;
    private final Thread.UncaughtExceptionHandler zzg;
    private final Object zzh = new Object();
    private final Semaphore zzi = new Semaphore(2);
    private volatile boolean zzj;

    static /* bridge */ /* synthetic */ zzin zza(zzij zzij2) {
        return zzij2.zzc;
    }

    static /* bridge */ /* synthetic */ zzin zzb(zzij zzij2) {
        return zzij2.zzb;
    }

    static /* bridge */ /* synthetic */ Object zzc(zzij zzij2) {
        return zzij2.zzh;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    final <T> T zza(AtomicReference<T> atomicReference, long l, String string, Runnable runnable) {
        AtomicReference<T> atomicReference2 = atomicReference;
        synchronized (atomicReference2) {
            ((zzjq)this).zzl().zzb(runnable);
            try {
                atomicReference.wait(l);
            }
            catch (InterruptedException interruptedException) {
                String string2 = string;
                ((zzjq)this).zzj().zzr().zza("Interrupted waiting for " + string2);
                return null;
            }
        }
        atomicReference2 = atomicReference.get();
        if (atomicReference2 == null) {
            String string3 = string;
            ((zzjq)this).zzj().zzr().zza("Timed out waiting for " + string3);
        }
        return (T)atomicReference2;
    }

    public final <V> Future<V> zza(Callable<V> callable) throws IllegalStateException {
        this.zzae();
        Preconditions.checkNotNull(callable);
        zzik zzik2 = new zzik(this, callable, false, "Task exception on worker thread");
        if (Thread.currentThread() == this.zzb) {
            if (!this.zzd.isEmpty()) {
                ((zzjq)this).zzj().zzr().zza("Callable skipped the worker queue.");
            }
            zzik2.run();
        } else {
            this.zza(zzik2);
        }
        return zzik2;
    }

    public final <V> Future<V> zzb(Callable<V> callable) throws IllegalStateException {
        this.zzae();
        Preconditions.checkNotNull(callable);
        zzik zzik2 = new zzik(this, callable, true, "Task exception on worker thread");
        if (Thread.currentThread() == this.zzb) {
            zzik2.run();
        } else {
            this.zza(zzik2);
        }
        return zzik2;
    }

    static /* bridge */ /* synthetic */ Semaphore zzd(zzij zzij2) {
        return zzij2.zzi;
    }

    static /* bridge */ /* synthetic */ AtomicLong zzc() {
        return zza;
    }

    static /* bridge */ /* synthetic */ void zza(zzij zzij2, zzin zzin2) {
        zzij2.zzc = null;
    }

    static /* bridge */ /* synthetic */ void zzb(zzij zzij2, zzin zzin2) {
        zzij2.zzb = null;
    }

    zzij(zzim zzim2) {
        super(zzim2);
        this.zzd = new PriorityBlockingQueue();
        this.zze = new LinkedBlockingQueue();
        this.zzf = new zzil(this, "Thread death: Uncaught exception on worker thread");
        this.zzg = new zzil(this, "Thread death: Uncaught exception on network thread");
    }

    @Override
    public final void zzt() {
        if (Thread.currentThread() != this.zzc) {
            throw new IllegalStateException("Call expected from network thread");
        }
    }

    @Override
    public final void zzv() {
        if (Thread.currentThread() != this.zzb) {
            throw new IllegalStateException("Call expected from worker thread");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zza(zzik<?> zzik2) {
        Object object = this.zzh;
        synchronized (object) {
            this.zzd.add(zzik2);
            if (this.zzb == null) {
                this.zzb = new zzin(this, "Measurement Worker", this.zzd);
                this.zzb.setUncaughtExceptionHandler(this.zzf);
                this.zzb.start();
            } else {
                this.zzb.zza();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(Runnable runnable) throws IllegalStateException {
        this.zzae();
        Preconditions.checkNotNull((Object)runnable);
        zzik zzik2 = new zzik(this, runnable, false, "Task exception on network thread");
        zzij zzij2 = this;
        Object object = zzij2.zzh;
        synchronized (object) {
            zzij2.zze.add(zzik2);
            if (zzij2.zzc == null) {
                zzij2.zzc = new zzin(zzij2, "Measurement Network", zzij2.zze);
                zzij2.zzc.setUncaughtExceptionHandler(zzij2.zzg);
                zzij2.zzc.start();
            } else {
                zzij2.zzc.zza();
            }
            return;
        }
    }

    public final void zzb(Runnable runnable) throws IllegalStateException {
        this.zzae();
        Preconditions.checkNotNull((Object)runnable);
        this.zza(new zzik(this, runnable, false, "Task exception on worker thread"));
    }

    public final void zzc(Runnable runnable) throws IllegalStateException {
        this.zzae();
        Preconditions.checkNotNull((Object)runnable);
        this.zza(new zzik(this, runnable, true, "Task exception on worker thread"));
    }

    static /* bridge */ /* synthetic */ boolean zze(zzij zzij2) {
        return zzij2.zzj;
    }

    public final boolean zzg() {
        return Thread.currentThread() == this.zzc;
    }

    public final boolean zzm() {
        return Thread.currentThread() == this.zzb;
    }

    @Override
    protected final boolean zzh() {
        return false;
    }
}

