/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Pair;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import androidx.core.content.ContextCompat;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzdz;
import com.google.android.gms.internal.measurement.zzgg;
import com.google.android.gms.internal.measurement.zzhu;
import com.google.android.gms.internal.measurement.zzpf;
import com.google.android.gms.measurement.internal.zzad;
import com.google.android.gms.measurement.internal.zzak;
import com.google.android.gms.measurement.internal.zzan;
import com.google.android.gms.measurement.internal.zzb;
import com.google.android.gms.measurement.internal.zzbb;
import com.google.android.gms.measurement.internal.zzbd;
import com.google.android.gms.measurement.internal.zzbl;
import com.google.android.gms.measurement.internal.zze;
import com.google.android.gms.measurement.internal.zzgf;
import com.google.android.gms.measurement.internal.zzgr;
import com.google.android.gms.measurement.internal.zzgu;
import com.google.android.gms.measurement.internal.zzgv;
import com.google.android.gms.measurement.internal.zzh;
import com.google.android.gms.measurement.internal.zzhc;
import com.google.android.gms.measurement.internal.zzho;
import com.google.android.gms.measurement.internal.zzij;
import com.google.android.gms.measurement.internal.zzio;
import com.google.android.gms.measurement.internal.zzip;
import com.google.android.gms.measurement.internal.zzjq;
import com.google.android.gms.measurement.internal.zzjs;
import com.google.android.gms.measurement.internal.zzjt;
import com.google.android.gms.measurement.internal.zzju;
import com.google.android.gms.measurement.internal.zzjx;
import com.google.android.gms.measurement.internal.zzkd;
import com.google.android.gms.measurement.internal.zzkf;
import com.google.android.gms.measurement.internal.zzkg;
import com.google.android.gms.measurement.internal.zzma;
import com.google.android.gms.measurement.internal.zzmc;
import com.google.android.gms.measurement.internal.zzmd;
import com.google.android.gms.measurement.internal.zzmk;
import com.google.android.gms.measurement.internal.zzmp;
import com.google.android.gms.measurement.internal.zzoi;
import com.google.android.gms.measurement.internal.zzqd;
import com.google.android.gms.measurement.internal.zzs;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.json.JSONException;
import org.json.JSONObject;

public class zzim
implements zzjs {
    private static volatile @Nullable zzim zzb;
    private final Context zzc;
    private final @Nullable String zzd;
    private final @Nullable String zze;
    private final @Nullable String zzf;
    private final boolean zzg;
    private final zzad zzh;
    private final zzak zzi;
    private final zzho zzj;
    private final zzhc zzk;
    private final zzij zzl;
    private final zzoi zzm;
    private final zzqd zzn;
    private final zzgv zzo;
    private final Clock zzp;
    private final zzmk zzq;
    private final zzkf zzr;
    private final zzb zzs;
    private final zzma zzt;
    private final @Nullable String zzu;
    private zzgu zzv;
    private zzmp zzw;
    private zzbd zzx;
    private zzgr zzy;
    private zzmd zzz;
    private boolean zzaa = false;
    private Boolean zzab;
    private long zzac;
    private volatile @Nullable Boolean zzad;
    private volatile boolean zzae;
    private int zzaf;
    private int zzag;
    private AtomicInteger zzah = new AtomicInteger(0);
    @VisibleForTesting
    final long zza;

    @WorkerThread
    public final int zzc() {
        ((zzjq)this.zzl()).zzv();
        if (this.zzi.zzy()) {
            return 1;
        }
        if (!this.zzaf()) {
            return 8;
        }
        Boolean bl = this.zzn().zzw();
        if (bl != null) {
            if (bl.booleanValue()) {
                return 0;
            }
            return 3;
        }
        zzak zzak2 = this.zzi;
        Boolean bl2 = zzak2.zze("firebase_analytics_collection_enabled");
        if (bl2 != null) {
            if (bl2.booleanValue()) {
                return 0;
            }
            return 4;
        }
        if (this.zzad != null) {
            if (this.zzad.booleanValue()) {
                return 0;
            }
            return 7;
        }
        return 0;
    }

    @Override
    @Pure
    public final Context zza() {
        return this.zzc;
    }

    @Override
    @Pure
    public final Clock zzb() {
        return this.zzp;
    }

    @Pure
    public final zzb zze() {
        zzim.zza(this.zzs);
        return this.zzs;
    }

    @Override
    @Pure
    public final zzad zzd() {
        return this.zzh;
    }

    @Pure
    public final zzak zzf() {
        return this.zzi;
    }

    @Pure
    public final zzbd zzg() {
        zzim.zza(this.zzx);
        return this.zzx;
    }

    @Pure
    public final zzgr zzh() {
        zzim.zza(this.zzy);
        return this.zzy;
    }

    @Pure
    public final zzgu zzi() {
        zzim.zza(this.zzv);
        return this.zzv;
    }

    @Pure
    public final zzgv zzk() {
        return this.zzo;
    }

    @Override
    @Pure
    public final zzhc zzj() {
        zzim.zza(this.zzk);
        return this.zzk;
    }

    public final @Nullable zzhc zzm() {
        if (this.zzk != null && this.zzk.zzah()) {
            return this.zzk;
        }
        return null;
    }

    @Pure
    public final zzho zzn() {
        zzim.zza((zzjq)this.zzj);
        return this.zzj;
    }

    @Override
    @Pure
    public final zzij zzl() {
        zzim.zza(this.zzl);
        return this.zzl;
    }

    @SideEffectFree
    final @Nullable zzij zzo() {
        return this.zzl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzim zza(Context context, @Nullable zzdz zzdz2, @Nullable Long l) {
        if (zzdz2 != null && (zzdz2.zze == null || zzdz2.zzf == null)) {
            zzdz2 = new zzdz(zzdz2.zza, zzdz2.zzb, zzdz2.zzc, zzdz2.zzd, null, null, zzdz2.zzg, null);
        }
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)context.getApplicationContext());
        if (zzb == null) {
            Class<zzim> clazz = zzim.class;
            synchronized (zzim.class) {
                if (zzb == null) {
                    zzkd zzkd2 = new zzkd(context, zzdz2, l);
                    zzb = new zzim(zzkd2);
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
        } else if (zzdz2 != null && zzdz2.zzg != null && zzdz2.zzg.containsKey("dataCollectionDefaultEnabled")) {
            Preconditions.checkNotNull((Object)zzb);
            zzb.zza(zzdz2.zzg.getBoolean("dataCollectionDefaultEnabled"));
        }
        {
            Preconditions.checkNotNull((Object)zzb);
            return zzb;
        }
    }

    @Pure
    public final zzkf zzp() {
        zzim.zza(this.zzr);
        return this.zzr;
    }

    @Pure
    public final zzma zzq() {
        zzim.zza(this.zzt);
        return this.zzt;
    }

    @Pure
    public final zzmd zzr() {
        zzim.zza((zze)this.zzz);
        return this.zzz;
    }

    @Pure
    public final zzmk zzs() {
        zzim.zza(this.zzq);
        return this.zzq;
    }

    @Pure
    public final zzmp zzt() {
        zzim.zza(this.zzw);
        return this.zzw;
    }

    @Pure
    public final zzoi zzu() {
        zzim.zza(this.zzm);
        return this.zzm;
    }

    @Pure
    public final zzqd zzv() {
        zzim.zza((zzjq)this.zzn);
        return this.zzn;
    }

    @Pure
    public final @Nullable String zzw() {
        return this.zzd;
    }

    @Pure
    public final @Nullable String zzx() {
        return this.zze;
    }

    @Pure
    public final @Nullable String zzy() {
        return this.zzf;
    }

    @Pure
    public final @Nullable String zzz() {
        return this.zzu;
    }

    public static /* synthetic */ void zza(zzim zzim2, String string, int n, Throwable throwable, byte[] byArray, Map map) {
        Throwable throwable2;
        byte[] byArray2 = byArray;
        Throwable throwable3 = throwable2 = throwable;
        byte[] byArray3 = byArray2;
        int n2 = n;
        zzim zzim3 = zzim2;
        if (!((n2 == 200 || n2 == 204 || n2 == 304) && throwable3 == null)) {
            zzim3.zzj().zzr().zza("Network Request for Deferred Deep Link failed. response, exception", n2, throwable3);
            return;
        }
        zzim3.zzn().zzo.zza(true);
        if (byArray3 == null || byArray3.length == 0) {
            zzim3.zzj().zzc().zza("Deferred Deep Link response empty.");
            return;
        }
        String string2 = new String(byArray3);
        try {
            List list;
            JSONObject jSONObject = new JSONObject(string2);
            String string3 = jSONObject.optString("deeplink", "");
            if (TextUtils.isEmpty((CharSequence)string3)) {
                zzim3.zzj().zzc().zza("Deferred Deep Link is empty.");
                return;
            }
            String string4 = jSONObject.optString("gclid", "");
            String string5 = jSONObject.optString("gbraid", "");
            String string6 = jSONObject.optString("gad_source", "");
            double d = jSONObject.optDouble("timestamp", 0.0);
            Bundle bundle = new Bundle();
            String string7 = string3;
            zzqd zzqd2 = zzim3.zzv();
            if (!(!TextUtils.isEmpty((CharSequence)string7) && (list = ((zzjq)zzqd2).zza().getPackageManager().queryIntentActivities(new Intent("android.intent.action.VIEW", Uri.parse((String)string7)), 0)) != null && !list.isEmpty())) {
                zzim3.zzj().zzr().zza("Deferred Deep Link validation failed. gclid, gbraid, deep link", string4, string5, string3);
                return;
            }
            if (!TextUtils.isEmpty((CharSequence)string5)) {
                bundle.putString("gbraid", string5);
            }
            if (!TextUtils.isEmpty((CharSequence)string6)) {
                bundle.putString("gad_source", string6);
            }
            bundle.putString("gclid", string4);
            bundle.putString("_cis", "ddp");
            zzim3.zzr.zzc("auto", "_cmp", bundle);
            zzim3.zzv().zza(string3, d);
            return;
        }
        catch (JSONException jSONException) {
            zzim3.zzj().zzg().zza("Failed to parse the Deferred Deep Link response. exception", (Object)jSONException);
            return;
        }
    }

    static /* synthetic */ void zza(zzim zzim2, zzkd zzkd2) {
        zzkd zzkd3 = zzkd2;
        zzim zzim3 = zzim2;
        ((zzjq)zzim3.zzl()).zzv();
        Object object = zzim3;
        zzbd zzbd2 = new zzbd((zzim)object);
        zzbd2.zzaf();
        zzim3.zzx = zzbd2;
        zzim zzim4 = zzim3;
        object = zzkd3;
        zzgr zzgr2 = new zzgr(zzim4, ((zzkd)object).zzf);
        zzgr2.zzx();
        zzim3.zzy = zzgr2;
        object = zzim3;
        zzgu zzgu2 = new zzgu((zzim)object);
        zzgu2.zzx();
        zzim3.zzv = zzgu2;
        object = zzim3;
        zzmp zzmp2 = new zzmp((zzim)object);
        zzmp2.zzx();
        zzim3.zzw = zzmp2;
        zzim3.zzn.zzag();
        zzim3.zzj.zzag();
        zzim3.zzy.zzy();
        object = zzim3;
        zzmd zzmd2 = new zzmd((zzim)object);
        zzmd2.zzx();
        zzim3.zzz = zzmd2;
        zzim3.zzz.zzy();
        zzim3.zzj().zzp().zza("App measurement initialized, version", 118003L);
        zzim3.zzj().zzp().zza("To enable debug logging run: adb shell setprop log.tag.FA VERBOSE");
        String string = zzgr2.zzaf();
        if (TextUtils.isEmpty((CharSequence)zzim3.zzd)) {
            if (zzim3.zzv().zzd(string, zzim3.zzi.zzr())) {
                zzim3.zzj().zzp().zza("Faster debug mode event logging enabled. To disable, run:\n  adb shell setprop debug.firebase.analytics.app .none.");
            } else {
                String string2 = string;
                zzim3.zzj().zzp().zza("To enable faster debug mode event logging run:\n  adb shell setprop debug.firebase.analytics.app " + string2);
            }
        }
        zzim3.zzj().zzc().zza("Debug-level message logging enabled");
        if (zzim3.zzaf != zzim3.zzah.get()) {
            zzim3.zzj().zzg().zza("Not all components initialized", zzim3.zzaf, zzim3.zzah.get());
        }
        zzim3.zzaa = true;
    }

    private zzim(zzkd zzkd2) {
        Preconditions.checkNotNull((Object)zzkd2);
        Object object = zzkd2.zza;
        zzgf.zza = this.zzh = new zzad((Context)object);
        this.zzc = zzkd2.zza;
        this.zzd = zzkd2.zzb;
        this.zze = zzkd2.zzc;
        this.zzf = zzkd2.zzd;
        this.zzg = zzkd2.zzh;
        this.zzad = zzkd2.zze;
        this.zzu = zzkd2.zzj;
        this.zzae = true;
        zzhu.zzb(this.zzc);
        this.zzp = DefaultClock.getInstance();
        this.zza = zzkd2.zzi != null ? zzkd2.zzi.longValue() : this.zzp.currentTimeMillis();
        object = this;
        this.zzi = new zzak((zzim)object);
        object = this;
        zzho zzho2 = new zzho((zzim)object);
        zzho2.zzaf();
        this.zzj = zzho2;
        object = this;
        zzhc zzhc2 = new zzhc((zzim)object);
        zzhc2.zzaf();
        this.zzk = zzhc2;
        object = this;
        zzqd zzqd2 = new zzqd((zzim)object);
        zzqd2.zzaf();
        this.zzn = zzqd2;
        zzim zzim2 = this;
        object = zzkd2;
        zzkg zzkg2 = new zzkg((zzkd)object, zzim2);
        this.zzo = new zzgv(zzkg2);
        object = this;
        this.zzs = new zzb((zzim)object);
        object = this;
        zzmk zzmk2 = new zzmk((zzim)object);
        zzmk2.zzx();
        this.zzq = zzmk2;
        object = this;
        zzkf zzkf2 = new zzkf((zzim)object);
        zzkf2.zzx();
        this.zzr = zzkf2;
        object = this;
        zzoi zzoi2 = new zzoi((zzim)object);
        zzoi2.zzx();
        this.zzm = zzoi2;
        object = this;
        zzma zzma2 = new zzma((zzim)object);
        zzma2.zzaf();
        this.zzt = zzma2;
        object = this;
        zzij zzij2 = new zzij((zzim)object);
        zzij2.zzaf();
        this.zzl = zzij2;
        boolean bl = zzkd2.zzg != null && zzkd2.zzg.zzb != 0L;
        boolean bl2 = !bl;
        object = this;
        if (((zzim)object).zzc.getApplicationContext() instanceof Application) {
            ((zzim)object).zzp().zzb(bl2);
        } else {
            ((zzim)object).zzj().zzr().zza("Application context is not an Application");
        }
        this.zzl.zzb(new zzio(this, zzkd2));
    }

    private static void zza(zze zze2) {
        if (zze2 == null) {
            throw new IllegalStateException("Component not created");
        }
    }

    private static void zza(zzjq zzjq2) {
        if (zzjq2 == null) {
            throw new IllegalStateException("Component not created");
        }
    }

    private static void zza(zzh zzh2) {
        if (zzh2 == null) {
            throw new IllegalStateException("Component not created");
        }
        if (!zzh2.zzaa()) {
            String string = String.valueOf(zzh2.getClass());
            throw new IllegalStateException("Component not initialized: " + string);
        }
    }

    private static void zza(zzjt zzjt2) {
        if (zzjt2 == null) {
            throw new IllegalStateException("Component not created");
        }
        if (!zzjt2.zzah()) {
            String string = String.valueOf(zzjt2.getClass());
            throw new IllegalStateException("Component not initialized: " + string);
        }
    }

    final void zzaa() {
        throw new IllegalStateException("Unexpected call on client side");
    }

    final void zzab() {
        this.zzah.incrementAndGet();
    }

    final void zzac() {
        ++this.zzaf;
    }

    @WorkerThread
    final void zza(boolean bl) {
        this.zzad = bl;
    }

    @WorkerThread
    public final void zzb(boolean bl) {
        ((zzjq)this.zzl()).zzv();
        this.zzae = bl;
    }

    @WorkerThread
    protected final void zza(@Nullable zzdz zzdz2) {
        zzjx zzjx2;
        zzju zzju2;
        Object object;
        zzjs zzjs2;
        boolean bl;
        ((zzjq)this.zzl()).zzv();
        boolean bl2 = bl = this.zzi.zza(zzbl.zzcq) && this.zzr().zzac() == zzgg.zzo.zzb.zzb;
        if (zzpf.zza() && this.zzi.zza(zzbl.zzcv) && this.zzv().zzx() || bl) {
            zzjs2 = this.zzv();
            ((zzjq)zzjs2).zzv();
            object = new IntentFilter();
            object.addAction("com.google.android.gms.measurement.TRIGGERS_AVAILABLE");
            if (((zzjq)zzjs2).zze().zza(zzbl.zzcq)) {
                object.addAction("com.google.android.gms.measurement.BATCHES_AVAILABLE");
            }
            zzs zzs2 = new zzs(((zzqd)zzjs2).zzu);
            ContextCompat.registerReceiver((Context)((zzjq)zzjs2).zza(), (BroadcastReceiver)zzs2, (IntentFilter)object, (int)2);
            ((zzjq)zzjs2).zzj().zzc().zza("Registered app receiver");
        }
        if (bl) {
            this.zzr().zza((Long)zzbl.zzab.zza(null));
        }
        zzju zzju3 = this.zzn().zzp();
        int n = zzju3.zza();
        zzju zzju4 = null;
        zzjx zzjx3 = this.zzi.zzc("google_analytics_default_allow_ad_storage", false);
        zzjx zzjx4 = this.zzi.zzc("google_analytics_default_allow_analytics_storage", false);
        if ((zzjx3 != zzjx.zza || zzjx4 != zzjx.zza) && this.zzn().zza(-10)) {
            zzju4 = zzju.zza(zzjx3, zzjx4, -10);
        } else if (!(TextUtils.isEmpty((CharSequence)this.zzh().zzah()) || n != 0 && n != 30 && n != 10 && n != 30 && n != 30 && n != 40)) {
            this.zzp().zza(new zzju(null, null, -10), false);
        } else if (TextUtils.isEmpty((CharSequence)this.zzh().zzah()) && zzdz2 != null && zzdz2.zzg != null && this.zzn().zza(30) && (zzju2 = zzju.zza(zzdz2.zzg, 30)).zzi()) {
            zzju4 = zzju2;
        }
        if (zzju4 != null) {
            zzju3 = zzju4;
            this.zzp().zza(zzju3, true);
        }
        this.zzp().zza(zzju3);
        object = zzdz2;
        zzjs2 = this;
        int n2 = ((zzim)zzjs2).zzn().zzo().zza();
        zzjx zzjx5 = ((zzim)zzjs2).zzi.zzc("google_analytics_default_allow_ad_personalization_signals", true);
        if (zzjx5 != zzjx.zza) {
            ((zzim)zzjs2).zzj().zzq().zza("Default ad personalization consent from Manifest", (Object)zzjx5);
        }
        if ((zzjx2 = ((zzim)zzjs2).zzi.zzc("google_analytics_default_allow_ad_user_data", true)) != zzjx.zza && zzju.zza(-10, n2)) {
            ((zzim)zzjs2).zzp().zza(zzbb.zza(zzjx2, -10), true);
        } else if (!(TextUtils.isEmpty((CharSequence)((zzim)zzjs2).zzh().zzah()) || n2 != 0 && n2 != 30)) {
            ((zzim)zzjs2).zzp().zza(new zzbb(null, -10), true);
        } else {
            Boolean bl3;
            zzbb zzbb2;
            if (TextUtils.isEmpty((CharSequence)((zzim)zzjs2).zzh().zzah()) && object != null && ((zzdz)object).zzg != null && zzju.zza(30, n2) && (zzbb2 = zzbb.zza(((zzdz)object).zzg, 30)).zzg()) {
                ((zzim)zzjs2).zzp().zza(zzbb2, true);
            }
            if (TextUtils.isEmpty((CharSequence)((zzim)zzjs2).zzh().zzah()) && object != null && ((zzdz)object).zzg != null && ((zzim)zzjs2).zzn().zzh.zza() == null && (bl3 = zzbb.zza(((zzdz)object).zzg)) != null) {
                ((zzim)zzjs2).zzp().zza(((zzdz)object).zze, "allow_personalized_ads", (Object)bl3.toString(), false);
            }
        }
        zzjs2 = this.zzi;
        object = ((zzak)zzjs2).zze("google_analytics_tcf_data_enabled");
        if (object == null ? true : (Boolean)object) {
            this.zzj().zzc().zza("TCF client enabled.");
            this.zzp().zzaw();
            this.zzp().zzau();
        }
        if (this.zzn().zzc.zza() == 0L) {
            this.zzj().zzq().zza("Persisting first open", this.zza);
            this.zzn().zzc.zza(this.zza);
        }
        this.zzp().zza.zzb();
        if (!this.zzah()) {
            if (this.zzae()) {
                if (!this.zzv().zze("android.permission.INTERNET")) {
                    this.zzj().zzg().zza("App is missing INTERNET permission");
                }
                if (!this.zzv().zze("android.permission.ACCESS_NETWORK_STATE")) {
                    this.zzj().zzg().zza("App is missing ACCESS_NETWORK_STATE permission");
                }
                if (!Wrappers.packageManager((Context)this.zzc).isCallerInstantApp() && !this.zzi.zzz()) {
                    if (!zzqd.zza(this.zzc)) {
                        this.zzj().zzg().zza("AppMeasurementReceiver not registered/enabled");
                    }
                    if (!zzqd.zza(this.zzc, false)) {
                        this.zzj().zzg().zza("AppMeasurementService not registered/enabled");
                    }
                }
                this.zzj().zzg().zza("Uploading is not possible. App measurement disabled");
            }
        } else {
            if (!TextUtils.isEmpty((CharSequence)this.zzh().zzah()) || !TextUtils.isEmpty((CharSequence)this.zzh().zzae())) {
                this.zzv();
                if (zzqd.zza(this.zzh().zzah(), this.zzn().zzz(), this.zzh().zzae(), this.zzn().zzy())) {
                    this.zzj().zzp().zza("Rechecking which service to use due to a GMP App Id change");
                    this.zzn().zzab();
                    this.zzi().zzac();
                    this.zzw.zzah();
                    this.zzw.zzag();
                    this.zzn().zzc.zza(this.zza);
                    this.zzn().zze.zza(null);
                }
                this.zzn().zzc(this.zzh().zzah());
                this.zzn().zzb(this.zzh().zzae());
            }
            if (!this.zzn().zzp().zza(zzju.zza.zzb)) {
                this.zzn().zze.zza(null);
            }
            this.zzp().zzb(this.zzn().zze.zza());
            if (!this.zzv().zzy() && !TextUtils.isEmpty((CharSequence)this.zzn().zzq.zza())) {
                this.zzj().zzr().zza("Remote config removed with active feature rollouts");
                this.zzn().zzq.zza(null);
            }
            if (!TextUtils.isEmpty((CharSequence)this.zzh().zzah()) || !TextUtils.isEmpty((CharSequence)this.zzh().zzae())) {
                n = this.zzae() ? 1 : 0;
                if (!this.zzn().zzad() && !this.zzi.zzy()) {
                    this.zzn().zzb(n == 0);
                }
                if (n != 0) {
                    this.zzp().zzap();
                }
                this.zzu().zza.zza();
                this.zzt().zza(new AtomicReference<String>());
                this.zzt().zza(this.zzn().zzt.zza());
            }
        }
        if (zzpf.zza() && this.zzi.zza(zzbl.zzcv) && this.zzv().zzx()) {
            long l = 1000L * (long)((Integer)zzbl.zzbv.zza(null)).intValue() + (long)new Random().nextInt(5000);
            long l2 = Math.max(500L, l - this.zzp.elapsedRealtime());
            if (l2 > 500L) {
                this.zzj().zzq().zza("Waiting to fetch trigger URIs until some time after boot. Delay in millis", l2);
            }
            this.zzp().zzc(l2);
        }
        this.zzn().zzj.zza(true);
    }

    @WorkerThread
    public final boolean zzad() {
        return this.zzad != null && this.zzad != false;
    }

    @WorkerThread
    public final boolean zzae() {
        return this.zzc() == 0;
    }

    @WorkerThread
    public final boolean zzaf() {
        ((zzjq)this.zzl()).zzv();
        return this.zzae;
    }

    @Pure
    public final boolean zzag() {
        return TextUtils.isEmpty((CharSequence)this.zzd);
    }

    @WorkerThread
    protected final boolean zzah() {
        if (!this.zzaa) {
            throw new IllegalStateException("AppMeasurement is not initialized");
        }
        ((zzjq)this.zzl()).zzv();
        if (this.zzab == null || this.zzac == 0L || this.zzab != null && !this.zzab.booleanValue() && Math.abs(this.zzp.elapsedRealtime() - this.zzac) > 1000L) {
            this.zzac = this.zzp.elapsedRealtime();
            this.zzab = this.zzv().zze("android.permission.INTERNET") && this.zzv().zze("android.permission.ACCESS_NETWORK_STATE") && (Wrappers.packageManager((Context)this.zzc).isCallerInstantApp() || this.zzi.zzz() || zzqd.zza(this.zzc) && zzqd.zza(this.zzc, false));
            if (this.zzab.booleanValue()) {
                this.zzab = this.zzv().zza(this.zzh().zzah(), this.zzh().zzae()) || !TextUtils.isEmpty((CharSequence)this.zzh().zzae());
            }
        }
        return this.zzab;
    }

    @Pure
    public final boolean zzai() {
        return this.zzg;
    }

    @WorkerThread
    public final boolean zzaj() {
        Object object;
        ((zzjq)this.zzl()).zzv();
        zzim.zza(this.zzq());
        String string = this.zzh().zzaf();
        if (!this.zzi.zzw()) {
            this.zzj().zzq().zza("ADID collection is disabled from Manifest. Skipping");
            return false;
        }
        Pair<String, Boolean> pair = this.zzn().zza(string);
        if (((Boolean)pair.second).booleanValue() || TextUtils.isEmpty((CharSequence)((CharSequence)pair.first))) {
            this.zzj().zzq().zza("ADID unavailable to retrieve Deferred Deep Link. Skipping");
            return false;
        }
        if (!this.zzq().zzc()) {
            this.zzj().zzr().zza("Network is not available for Deferred Deep Link request. Skipping");
            return false;
        }
        StringBuilder stringBuilder = new StringBuilder();
        zzjq zzjq2 = this.zzt();
        zzjq2.zzv();
        ((zzh)zzjq2).zzw();
        if (!((zzmp)zzjq2).zzap() ? true : zzjq2.zzs().zzg() >= 234200) {
            object = null;
            zzan zzan2 = this.zzp().zzac();
            if (zzan2 != null) {
                object = zzan2.zza;
            }
            if (object == null) {
                boolean bl = this.zzag++ < 10;
                String string2 = bl ? "Retrying." : "Skipping.";
                this.zzj().zzc().zza("Failed to retrieve DMA consent from the service, " + string2 + " retryCount", this.zzag);
                return bl;
            }
            zzju zzju2 = zzju.zza(object, 100);
            stringBuilder.append("&gcs=").append(zzju2.zze());
            zzbb zzbb2 = zzbb.zza(object, 100);
            stringBuilder.append("&dma=").append(Objects.equals(zzbb2.zzd(), false) ? 0 : 1);
            if (!TextUtils.isEmpty((CharSequence)zzbb2.zze())) {
                stringBuilder.append("&dma_cps=").append(zzbb2.zze());
            }
            int n = Objects.equals(zzbb.zza(object), true) ? 0 : 1;
            stringBuilder.append("&npa=").append(n);
            this.zzj().zzq().zza("Consent query parameters to Bow", stringBuilder);
        }
        zzqd zzqd2 = this.zzv();
        this.zzh();
        object = zzqd2.zza(118003L, string, (String)pair.first, this.zzn().zzp.zza() - 1L, stringBuilder.toString());
        if (object != null) {
            zzim zzim2 = this;
            zzip zzip2 = new zzip(zzim2);
            Object object2 = object;
            String string3 = string;
            zzjq2 = this.zzq();
            ((zzjt)zzjq2).zzae();
            Preconditions.checkNotNull((Object)object2);
            Preconditions.checkNotNull((Object)zzip2);
            zzjq2.zzl().zza(new zzmc((zzma)zzjq2, string3, (URL)object2, null, null, zzip2));
        }
        return false;
    }
}

