/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.annotation.TargetApi;
import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.os.Build;
import android.os.PersistableBundle;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.measurement.zzgg;
import com.google.android.gms.measurement.internal.zzbl;
import com.google.android.gms.measurement.internal.zze;
import com.google.android.gms.measurement.internal.zzh;
import com.google.android.gms.measurement.internal.zzim;
import com.google.android.gms.measurement.internal.zzjq;
import com.google.android.gms.measurement.internal.zzqd;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class zzmd
extends zzh {
    private @Nullable JobScheduler zza;

    @VisibleForTesting
    private final int zzad() {
        String string = ((zzjq)this).zza().getPackageName();
        return ("measurement-client" + string).hashCode();
    }

    @WorkerThread
    final zzgg.zzo.zzb zzac() {
        this.zzw();
        ((zzjq)this).zzv();
        if (!((zzjq)this).zze().zza(zzbl.zzcq)) {
            return zzgg.zzo.zzb.zzi;
        }
        if (this.zza == null) {
            return zzgg.zzo.zzb.zzg;
        }
        if (!((zzjq)this).zze().zzab()) {
            return zzgg.zzo.zzb.zzh;
        }
        if (!((zzjq)this).zze().zza(zzbl.zzcs)) {
            return zzgg.zzo.zzb.zzf;
        }
        if (!zzqd.zzb(((zzjq)this).zza(), "com.google.android.gms.measurement.AppMeasurementJobService")) {
            return zzgg.zzo.zzb.zzc;
        }
        if (Build.VERSION.SDK_INT < 24) {
            return zzgg.zzo.zzb.zzd;
        }
        if (!((zze)this).zzq().zzap()) {
            return zzgg.zzo.zzb.zze;
        }
        return zzgg.zzo.zzb.zzb;
    }

    public zzmd(zzim zzim2) {
        super(zzim2);
    }

    @Override
    @WorkerThread
    @TargetApi(value=24)
    protected final void zzz() {
        this.zza = (JobScheduler)((zzjq)this).zza().getSystemService("jobscheduler");
    }

    @TargetApi(value=24)
    @WorkerThread
    public final void zza(long l) {
        this.zzw();
        ((zzjq)this).zzv();
        if (this.zza != null && this.zza.getPendingJob(this.zzad()) != null) {
            ((zzjq)this).zzj().zzq().zza("[sgtm] There's an existing pending job, skip this schedule.");
            return;
        }
        zzgg.zzo.zzb zzb2 = this.zzac();
        if (zzb2 != zzgg.zzo.zzb.zzb) {
            ((zzjq)this).zzj().zzq().zza("[sgtm] Not eligible for Scion upload", zzb2.name());
            return;
        }
        ((zzjq)this).zzj().zzq().zza("[sgtm] Scheduling Scion upload, millis", l);
        PersistableBundle persistableBundle = new PersistableBundle();
        persistableBundle.putString("action", "com.google.android.gms.measurement.SCION_UPLOAD");
        JobInfo jobInfo = new JobInfo.Builder(this.zzad(), new ComponentName(((zzjq)this).zza(), "com.google.android.gms.measurement.AppMeasurementJobService")).setRequiredNetworkType(1).setMinimumLatency(l).setOverrideDeadline(l << 1).setExtras(persistableBundle).build();
        int n = ((JobScheduler)Preconditions.checkNotNull((Object)this.zza)).schedule(jobInfo);
        ((zzjq)this).zzj().zzq().zza("[sgtm] Scion upload job scheduled with result", n == 1 ? "SUCCESS" : "FAILURE");
    }

    @Override
    protected final boolean zzab() {
        return true;
    }
}

