/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.content.ContentResolver;
import android.database.ContentObserver;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import android.os.RemoteException;
import android.os.StrictMode;
import android.util.Log;
import androidx.annotation.GuardedBy;
import androidx.collection.ArrayMap;
import com.google.android.gms.internal.measurement.zzjo;
import com.google.android.gms.internal.measurement.zzjp;
import com.google.android.gms.internal.measurement.zzjr;
import com.google.android.gms.internal.measurement.zzju;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class zzjq
implements zzju {
    @GuardedBy(value="ConfigurationContentLoader.class")
    private static final Map zzb = new ArrayMap();
    private final ContentResolver zzc;
    private final Uri zzd;
    private final Runnable zze;
    private final ContentObserver zzf;
    private final Object zzg = new Object();
    private volatile Map zzh;
    @GuardedBy(value="this")
    private final List zzi = new ArrayList();
    public static final String[] zza;

    private zzjq(ContentResolver contentResolver, Uri uri, Runnable runnable) {
        Preconditions.checkNotNull((Object)contentResolver);
        Preconditions.checkNotNull((Object)uri);
        this.zzc = contentResolver;
        this.zzd = uri;
        this.zze = runnable;
        this.zzf = new zzjo(this, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static zzjq zza(ContentResolver object, Uri uri, Runnable runnable) {
        Class<zzjq> clazz = zzjq.class;
        synchronized (clazz) {
            zzjq zzjq2;
            Map map = zzb;
            zzjq zzjq3 = (zzjq)map.get(uri);
            if (zzjq3 != null) return zzjq3;
            try {
                zzjq2 = new zzjq((ContentResolver)object, uri, runnable);
            }
            catch (SecurityException securityException) {
                return zzjq3;
            }
            try {}
            catch (SecurityException securityException) {
                return zzjq2;
            }
            object.registerContentObserver(uri, false, zzjq2.zzf);
            map.put(uri, zzjq2);
            return zzjq2;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Map zzb() {
        var1_2 = this.zzh;
        if (var1_2 != null) ** GOTO lbl24
        var2_3 = this.zzg;
        synchronized (var2_3) {
            block12: {
                var1_2 = this.zzh;
                if (var1_2 != null) ** GOTO lbl23
                var1_2 = StrictMode.allowThreadDiskReads();
                try {
                    var3_4 = (Map)zzju.zzg(new zzjp(this));
                    ** GOTO lbl19
                }
                catch (SQLiteException | IllegalStateException | SecurityException var3_5) {
                    block11: {
                        try {
                            Log.w((String)"ConfigurationContentLdr", (String)"Unable to query ContentProvider, using default values", (Throwable)var3_5);
                            var3_6 = Collections.emptyMap();
                            break block11;
                        }
                        catch (Throwable var0_1) {
                            break block12;
                        }
lbl19:
                        // 1 sources

                        StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)var1_2);
                        var1_2 = var3_4;
lbl21:
                        // 2 sources

                        while (true) {
                            this.zzh = var1_2;
lbl23:
                            // 2 sources

                            // MONITOREXIT @DISABLED, blocks:[6, 7, 9] lbl23 : MonitorExitStatement: MONITOREXIT : var2_3
lbl24:
                            // 2 sources

                            if (var1_2 != null) {
                                return var1_2;
                            }
                            return Collections.emptyMap();
                        }
                    }
                    StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)var1_2);
                    var1_2 = var3_6;
                    ** continue;
                }
            }
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)var1_2);
            throw var0_1;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzc() {
        Iterator iterator = this.zzg;
        synchronized (iterator) {
            this.zzh = null;
            this.zze.run();
        }
        synchronized (this) {
            boolean bl;
            iterator = this.zzi.iterator();
            while (bl = iterator.hasNext()) {
                ((zzjr)iterator.next()).zza();
            }
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    static synchronized void zzd() {
        Map map = zzb;
        for (zzjq zzjq2 : map.values()) {
            zzjq2.zzc.unregisterContentObserver(zzjq2.zzf);
        }
        map.clear();
    }

    static {
        String string = "key";
        zza = new String[]{string, "value"};
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final /* synthetic */ Map zzf() {
        block20: {
            block21: {
                block19: {
                    block18: {
                        this = this.zzd;
                        var1_4 = this.zzc.acquireUnstableContentProviderClient((Uri)this);
                        if (var1_4 == null) {
                            Log.w((String)"ConfigurationContentLdr", (String)"Unable to acquire ContentProviderClient, using default values");
                            return Collections.emptyMap();
                        }
                        var2_5 = var1_4.query((Uri)this, zzjq.zza, null, null, null);
                        if (var2_5 != null) break block18;
                        Log.w((String)"ConfigurationContentLdr", (String)"ContentProvider query returned null cursor, using default values");
                        this = Collections.emptyMap();
                        var1_4.release();
                        return this;
                    }
                    var0_1 = var2_5.getCount();
                    if (var0_1 != 0) break block19;
                    this = Collections.emptyMap();
                    var2_5.close();
                    var1_4.release();
                    return this;
                }
                if (var0_1 > 256) ** GOTO lbl33
                this = new ArrayMap(var0_1);
                break block21;
lbl33:
                // 2 sources

                this = new HashMap<K, V>(var0_1, 1.0f);
            }
            while (var3_7 = var2_5.moveToNext()) {
                this.put(var2_5.getString(0), var2_5.getString(1));
            }
            var3_7 = var2_5.isAfterLast();
            if (var3_7) break block20;
            Log.w((String)"ConfigurationContentLdr", (String)"Cursor read incomplete (ContentProvider dead?), using default values");
            this = Collections.emptyMap();
            var2_5.close();
            var1_4.release();
            return this;
        }
        var2_5.close();
        var1_4.release();
        return this;
        catch (Throwable var0_3) {
            if (var2_5 != null) {
                var2_5.close();
            }
            try {
                throw var0_3;
            }
            catch (RemoteException var0_2) {
                try {
                    Log.w((String)"ConfigurationContentLdr", (String)"ContentProvider query failed, using default values", (Throwable)var0_2);
                    this = Collections.emptyMap();
                }
                catch (Throwable v0) {
                    var1_4.release();
                    throw v0;
                }
                var1_4.release();
                return this;
            }
            catch (Throwable var2_6) {
                var0_3.addSuppressed(var2_6);
                throw var0_3;
            }
        }
    }
}

