/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.os.Bundle;
import android.text.TextUtils;
import androidx.annotation.Size;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.ProcessUtils;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.measurement.internal.zzaj;
import com.google.android.gms.measurement.internal.zzak;
import com.google.android.gms.measurement.internal.zzfw;
import com.google.android.gms.measurement.internal.zzfx;
import com.google.android.gms.measurement.internal.zzgt;
import com.google.android.gms.measurement.internal.zzib;
import com.google.android.gms.measurement.internal.zzjd;
import com.google.android.gms.measurement.internal.zzjf;
import com.google.android.gms.measurement.internal.zzjh;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;

public final class zzal
extends zzjd {
    private Boolean zza;
    private String zzb;
    private zzak zzc = zzaj.zza;
    private Boolean zzd;

    zzal(zzib zzib2) {
        super(zzib2);
    }

    final void zza(zzak zzak2) {
        this.zzc = zzak2;
    }

    final String zzb() {
        this.zzu.zzaU();
        return "FA";
    }

    public final int zzc() {
        if (this.zzu.zzk().zzag(201500000, true)) {
            return 100;
        }
        return 25;
    }

    public final int zzd(@Size(min=1L) String string) {
        return this.zzn(string, zzfx.zzX, 25, 100);
    }

    final int zze(String string, boolean bl) {
        if (bl) {
            return this.zzn(string, zzfx.zzah, 100, 500);
        }
        return 500;
    }

    final int zzf(String string, boolean bl) {
        return Math.max(this.zze(string, bl), 256);
    }

    final int zzh(@Size(min=1L) String string) {
        return this.zzn(string, zzfx.zzW, 500, 2000);
    }

    public final long zzi() {
        this.zzu.zzaU();
        return 130000L;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @EnsuresNonNull(value={"this.isMainProcess"})
    public final boolean zzj() {
        if (this.zzd != null) return this.zzd;
        synchronized (this) {
            Object object;
            Object object2 = this.zzd;
            if (object2 != null) return this.zzd;
            zzib zzib2 = this.zzu;
            object2 = zzib2.zzaY();
            object2 = object2.getApplicationInfo();
            String string = ProcessUtils.getMyProcessName();
            if (object2 != null) {
                boolean bl;
                object2 = ((ApplicationInfo)object2).processName;
                bl = object2 != null ? (bl = ((String)object2).equals(string)) : false;
                this.zzd = bl;
            }
            if ((object = this.zzd) != null) return this.zzd;
            this.zzd = Boolean.TRUE;
            object = zzib2.zzaV();
            ((zzgt)object).zzb().zza("My process not in the list of running processes");
            return this.zzd;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    @WorkerThread
    public final String zzk(String string, zzfw zzfw2) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return (String)zzfw2.zzb(null);
        }
        zzfw zzfw3 = zzfw2;
        return (String)zzfw3.zzb(this.zzc.zza(string, zzfw3.zza()));
    }

    @WorkerThread
    public final long zzl(String string, zzfw zzfw2) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return (Long)zzfw2.zzb(null);
        }
        String string2 = ((zzal)((Object)string2)).zzc.zza(string, zzfw2.zza());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return (Long)zzfw2.zzb(null);
        }
        try {
            long l = (Long)zzfw2.zzb(Long.parseLong(string2));
            return l;
        }
        catch (NumberFormatException numberFormatException) {
            return (Long)zzfw2.zzb(null);
        }
    }

    @WorkerThread
    public final int zzm(String string, zzfw zzfw2) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return (Integer)zzfw2.zzb(null);
        }
        String string2 = ((zzal)((Object)string2)).zzc.zza(string, zzfw2.zza());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return (Integer)zzfw2.zzb(null);
        }
        try {
            int n = (Integer)zzfw2.zzb(Integer.parseInt(string2));
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            return (Integer)zzfw2.zzb(null);
        }
    }

    @WorkerThread
    public final int zzn(String string, zzfw zzfw2, int n, int n2) {
        return Math.max(Math.min(this.zzm(string, zzfw2), n2), n);
    }

    @WorkerThread
    public final double zzo(String string, zzfw zzfw2) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return (Double)zzfw2.zzb(null);
        }
        String string2 = ((zzal)((Object)string2)).zzc.zza(string, zzfw2.zza());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return (Double)zzfw2.zzb(null);
        }
        try {
            double d = (Double)zzfw2.zzb(Double.parseDouble(string2));
            return d;
        }
        catch (NumberFormatException numberFormatException) {
            return (Double)zzfw2.zzb(null);
        }
    }

    @WorkerThread
    public final boolean zzp(String string, zzfw zzfw2) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return (Boolean)zzfw2.zzb(null);
        }
        String string2 = ((zzal)((Object)string2)).zzc.zza(string, zzfw2.zza());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return (Boolean)zzfw2.zzb(null);
        }
        return (Boolean)zzfw2.zzb("1".equals(string2));
    }

    @VisibleForTesting
    final Bundle zzq() {
        Context context;
        block7: {
            zzjf zzjf2;
            block6: {
                try {
                    zzjf2 = zzal2.zzu;
                    context = ((zzib)zzjf2).zzaY();
                    context = context.getPackageManager();
                    if (context != null) break block6;
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    zzal2.zzu.zzaV().zzb().zzb("Failed to load metadata: Package name not found", (Object)nameNotFoundException);
                    return null;
                }
                zzjf2 = ((zzib)zzjf2).zzaV();
                ((zzgt)zzjf2).zzb().zza("Failed to load metadata: PackageManager is null");
                return null;
            }
            context = ((zzib)zzjf2).zzaY();
            context = Wrappers.packageManager((Context)context);
            Context context2 = ((zzib)zzjf2).zzaY();
            context = context.getApplicationInfo(context2.getPackageName(), 128);
            if (context != null) break block7;
            zzjf2 = ((zzib)zzjf2).zzaV();
            ((zzgt)zzjf2).zzb().zza("Failed to load metadata: ApplicationInfo is null");
            return null;
        }
        zzal zzal2 = context.metaData;
        return zzal2;
    }

    final Boolean zzr(@Size(min=1L) String string) {
        Preconditions.checkNotEmpty((String)string);
        Bundle bundle = this.zzq();
        if (bundle == null) {
            this.zzu.zzaV().zzb().zza("Failed to load metadata: Metadata bundle is null");
            return null;
        }
        if (!bundle.containsKey(string)) {
            return null;
        }
        return bundle.getBoolean(string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final List zzs(@Size(min=1L) String object) {
        object = "analytics.safelisted_events";
        Preconditions.checkNotEmpty((String)object);
        Bundle bundle = ((zzal)this).zzq();
        if (bundle == null) {
            ((zzjd)this).zzu.zzaV().zzb().zza("Failed to load metadata: Metadata bundle is null");
            return null;
        }
        if (!bundle.containsKey((String)object)) {
            return null;
        }
        object = bundle.getInt((String)object);
        if (object == null) {
            return null;
        }
        try {
            bundle = ((zzjd)this).zzu.zzaY();
            object = bundle.getResources().getStringArray(((Integer)object).intValue());
            if (object != null) return Arrays.asList(object);
            return null;
        }
        catch (Resources.NotFoundException notFoundException) {
            ((zzjd)this).zzu.zzaV().zzb().zzb("Failed to load string array from metadata: resource not found", (Object)notFoundException);
            return null;
        }
    }

    public final boolean zzt() {
        ((zzjd)((Object)bl)).zzu.zzaU();
        Boolean bl = ((zzal)((Object)bl)).zzr("firebase_analytics_collection_deactivated");
        return bl != null && bl != false;
    }

    public final boolean zzu() {
        return (this = ((zzal)this).zzr("google_analytics_adid_collection_enabled")) == null || ((Boolean)this).booleanValue();
    }

    public final boolean zzv() {
        return (this = ((zzal)this).zzr("google_analytics_automatic_screen_reporting_enabled")) == null || ((Boolean)this).booleanValue();
    }

    /*
     * Enabled aggressive block sorting
     */
    public final zzjh zzw(String string, boolean bl) {
        Preconditions.checkNotEmpty((String)string);
        zzib zzib2 = ((zzjd)object).zzu;
        Object object = ((zzal)object).zzq();
        if (object == null) {
            zzib2.zzaV().zzb().zza("Failed to load metadata: Metadata bundle is null");
            object = null;
        } else {
            object = object.get(string);
        }
        if (object == null) {
            return zzjh.zza;
        }
        if (Boolean.TRUE.equals(object)) {
            return zzjh.zzd;
        }
        if (Boolean.FALSE.equals(object)) {
            return zzjh.zzc;
        }
        if (bl && "eu_consent_policy".equals(object)) {
            return zzjh.zzb;
        }
        zzib2.zzaV().zze().zzb("Invalid manifest metadata for", string);
        return zzjh.zza;
    }

    public final boolean zzx() {
        if ((this = ((zzal)this).zzr("google_analytics_sgtm_upload_enabled")) == null) {
            return false;
        }
        return (Boolean)this;
    }

    public final void zzy(String string) {
        this.zzb = string;
    }

    public final String zzz() {
        return this.zzb;
    }

    public final String zzA() {
        return this.zzK("debug.firebase.analytics.app", "");
    }

    public final String zzB() {
        return this.zzK("debug.deferred.deeplink", "");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String zzK(String string, String string2) {
        string2 = "";
        try {
            string = (String)Class.forName("android.os.SystemProperties").getMethod("get", String.class, String.class).invoke(null, string, string2);
            Preconditions.checkNotNull((Object)string);
            return string;
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.zzu.zzaV().zzb().zzb("Could not find SystemProperties class", classNotFoundException);
            return string2;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.zzu.zzaV().zzb().zzb("Could not find SystemProperties.get() method", noSuchMethodException);
            return string2;
        }
        catch (IllegalAccessException illegalAccessException) {
            this.zzu.zzaV().zzb().zzb("Could not access SystemProperties.get()", illegalAccessException);
            return string2;
        }
        catch (InvocationTargetException invocationTargetException) {
            this.zzu.zzaV().zzb().zzb("SystemProperties.get() threw an exception", invocationTargetException);
            return string2;
        }
    }

    public final boolean zzC(String string) {
        String string2 = "gaia_collection_enabled";
        String string3 = ((zzal)((Object)string3)).zzc.zza(string, string2);
        return "1".equals(string3);
    }

    public final boolean zzD(String string) {
        String string2 = "measurement.event_sampling_enabled";
        String string3 = ((zzal)((Object)string3)).zzc.zza(string, string2);
        return "1".equals(string3);
    }

    @WorkerThread
    final boolean zzE() {
        if (this.zza == null) {
            this.zza = this.zzr("app_measurement_lite");
            if (this.zza == null) {
                this.zza = false;
            }
        }
        return this.zza != false || !this.zzu.zzp();
    }

    public static final long zzF() {
        return (Long)zzfx.zzd.zzb(null);
    }

    public static final int zzG() {
        return Math.max(0, (Integer)zzfx.zzi.zzb(null));
    }

    public static final long zzH() {
        return ((Integer)zzfx.zzk.zzb(null)).intValue();
    }

    public static final long zzI() {
        return (Long)zzfx.zzR.zzb(null);
    }

    public static final long zzJ() {
        return (Long)zzfx.zzM.zzb(null);
    }
}

