/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.GuardedBy;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.measurement.internal.zzal;
import com.google.android.gms.measurement.internal.zzgq;
import com.google.android.gms.measurement.internal.zzgr;
import com.google.android.gms.measurement.internal.zzgs;
import com.google.android.gms.measurement.internal.zzhy;
import com.google.android.gms.measurement.internal.zzib;
import com.google.android.gms.measurement.internal.zzje;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;

public final class zzgt
extends zzje {
    private char zza = '\u0000';
    private long zzb = -1L;
    @GuardedBy(value="this")
    private String zzc;
    private final zzgr zzd = new zzgr(this, 6, false, false);
    private final zzgr zze = new zzgr(this, 6, true, false);
    private final zzgr zzf = new zzgr(this, 6, false, true);
    private final zzgr zzg = new zzgr(this, 5, false, false);
    private final zzgr zzh = new zzgr(this, 5, true, false);
    private final zzgr zzi = new zzgr(this, 5, false, true);
    private final zzgr zzj = new zzgr(this, 4, false, false);
    private final zzgr zzk = new zzgr(this, 3, false, false);
    private final zzgr zzl = new zzgr(this, 2, false, false);

    zzgt(zzib zzib2) {
        super(zzib2);
    }

    public final zzgr zzb() {
        return this.zzd;
    }

    public final zzgr zzc() {
        return this.zze;
    }

    public final zzgr zzd() {
        return this.zzf;
    }

    public final zzgr zze() {
        return this.zzg;
    }

    public final zzgr zzf() {
        return this.zzh;
    }

    public final zzgr zzh() {
        return this.zzi;
    }

    public final zzgr zzi() {
        return this.zzj;
    }

    public final zzgr zzj() {
        return this.zzk;
    }

    public final zzgr zzk() {
        return this.zzl;
    }

    @Override
    protected final boolean zza() {
        return false;
    }

    protected static Object zzl(String string) {
        if (string == null) {
            return null;
        }
        return new zzgs(string);
    }

    protected final void zzm(int n, boolean bl, boolean bl2, String string, Object object, Object object2, Object object3) {
        if (!bl && Log.isLoggable((String)this.zzn(), (int)n)) {
            String string2 = zzgt.zzo(false, string, object, object2, object3);
            Log.println((int)n, (String)this.zzn(), (String)string2);
        }
        if (!bl2 && n >= 5) {
            Preconditions.checkNotNull((Object)string);
            zzhy zzhy2 = this.zzu.zzi();
            if (zzhy2 == null) {
                Log.println((int)6, (String)this.zzn(), (String)"Scheduler not set. Not logging error/warn");
                return;
            }
            if (!zzhy2.zzv()) {
                Log.println((int)6, (String)this.zzn(), (String)"Scheduler not initialized. Not logging error/warn");
                return;
            }
            if (n >= 9) {
                n = 8;
            }
            zzhy2.zzj(new zzgq(this, n, string, object, object2, object3));
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @EnsuresNonNull(value={"logTagDoNotUseDirectly"})
    @VisibleForTesting
    protected final String zzn() {
        synchronized (this) {
            Object object = this.zzc;
            if (object == null) {
                object = this.zzu.zzc();
                this.zzc = ((zzal)object).zzb();
            }
            Preconditions.checkNotNull((Object)this.zzc);
            return this.zzc;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    static String zzo(boolean bl, String string, Object object, Object object2, Object object3) {
        String string2;
        object = zzgt.zzp(bl, object);
        object2 = zzgt.zzp(bl, object2);
        object3 = zzgt.zzp(bl, object3);
        StringBuilder stringBuilder = new StringBuilder();
        if (string == null) {
            string = "";
        }
        if (!TextUtils.isEmpty((CharSequence)string)) {
            stringBuilder.append(string);
            string2 = ": ";
        } else {
            string2 = "";
        }
        if (!TextUtils.isEmpty((CharSequence)object)) {
            stringBuilder.append(string2);
            stringBuilder.append((String)object);
            string2 = ", ";
        }
        if (!TextUtils.isEmpty((CharSequence)object2)) {
            stringBuilder.append(string2);
            stringBuilder.append((String)object2);
            string2 = ", ";
        }
        if (!TextUtils.isEmpty((CharSequence)object3)) {
            stringBuilder.append(string2);
            stringBuilder.append((String)object3);
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    @VisibleForTesting
    static String zzp(boolean bl, Object object) {
        int n;
        String string;
        StringBuilder stringBuilder;
        if (object == null) {
            return "";
        }
        if (object instanceof Integer) {
            object = (long)((Integer)object).intValue();
        }
        if (object instanceof Long) {
            if (!bl) {
                return object.toString();
            }
            Object object2 = (Long)object;
            if (Math.abs((Long)object2) < 100L) {
                return object.toString();
            }
            object2 = String.valueOf(Math.abs((Long)object2));
            long l = Math.round(Math.pow(10.0, ((String)object2).length() + -1));
            long l2 = Math.round(Math.pow(10.0, ((String)object2).length()) + -1.0);
            int n2 = String.valueOf(l).length();
            object2 = object.toString().charAt(0) == '-' ? "-" : "";
            n2 = ((String)object2).length() + n2;
            int n3 = String.valueOf(l2).length();
            StringBuilder stringBuilder2 = new StringBuilder(n2 + 3 + ((String)object2).length() + n3);
            stringBuilder2.append((String)object2);
            stringBuilder2.append(l);
            stringBuilder2.append("...");
            stringBuilder2.append((String)object2);
            stringBuilder2.append(l2);
            return stringBuilder2.toString();
        }
        if (object instanceof Boolean) {
            return object.toString();
        }
        if (object instanceof Throwable) {
            object = (Throwable)object;
            String string2 = bl ? object.getClass().getName() : ((Throwable)object).toString();
            stringBuilder = new StringBuilder(string2);
            string = zzgt.zzq(zzib.class.getCanonicalName());
            object = ((Throwable)object).getStackTrace();
            n = ((Object)object).length;
        } else {
            if (object instanceof zzgs) {
                return ((zzgs)object).zza();
            }
            if (!bl) return object.toString();
            return "-";
        }
        for (int i = 0; i < n; ++i) {
            String string3;
            Object object3 = object[i];
            if (((StackTraceElement)object3).isNativeMethod() || (string3 = ((StackTraceElement)object3).getClassName()) == null || !zzgt.zzq(string3).equals(string)) continue;
            stringBuilder.append(": ");
            stringBuilder.append(object3);
            return stringBuilder.toString();
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    static String zzq(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return "";
        }
        int n = string.lastIndexOf(46);
        if (n != -1) return string.substring(0, n);
        return "";
    }

    final /* synthetic */ char zzr() {
        return this.zza;
    }

    final /* synthetic */ void zzs(char c) {
        this.zza = c;
    }

    final /* synthetic */ long zzt() {
        return this.zzb;
    }

    final /* synthetic */ void zzu(long l) {
        this.zzb = 130000L;
    }
}

