/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.content.Context;
import android.database.ContentObserver;
import android.util.Log;
import androidx.annotation.GuardedBy;
import androidx.core.content.PermissionChecker;
import com.google.android.gms.internal.measurement.zzjf;
import com.google.android.gms.internal.measurement.zzjg;
import com.google.android.gms.internal.measurement.zzjm;
import com.google.android.gms.internal.measurement.zzjv;
import com.google.android.gms.internal.measurement.zzjw;
import com.google.android.gms.internal.measurement.zzjx;
import com.google.common.base.Preconditions;

final class zzjy
implements zzjv {
    @GuardedBy(value="GservicesLoader.class")
    private static zzjy zza;
    private final Context zzb;
    private final ContentObserver zzc;
    @GuardedBy(value="GservicesLoader.class")
    private boolean zzd = false;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static zzjy zza(Context object) {
        Class<zzjy> clazz = zzjy.class;
        synchronized (clazz) {
            zzjy zzjy2 = zza;
            if (zzjy2 == null) {
                int n = PermissionChecker.checkSelfPermission((Context)object, (String)"com.google.android.providers.gsf.permission.READ_GSERVICES");
                zzjy2 = n == 0 ? new zzjy((Context)object) : new zzjy();
                zza = zzjy2;
            }
            if ((zzjy2 = zza) == null) return (zzjy)Preconditions.checkNotNull((Object)zza);
            ContentObserver contentObserver = zzjy2.zzc;
            if (contentObserver == null) return (zzjy)Preconditions.checkNotNull((Object)zza);
            boolean bl = zzjy2.zzd;
            if (bl) return (zzjy)Preconditions.checkNotNull((Object)zza);
            try {
                object.getContentResolver().registerContentObserver(zzjg.zza, true, zzjy.zza.zzc);
                ((zzjy)Preconditions.checkNotNull((Object)zzjy.zza)).zzd = true;
                return (zzjy)Preconditions.checkNotNull((Object)zza);
            }
            catch (SecurityException securityException) {
                Log.e((String)"GservicesLoader", (String)"Unable to register Gservices content observer", (Throwable)securityException);
            }
            return (zzjy)Preconditions.checkNotNull((Object)zza);
        }
    }

    private zzjy(Context context) {
        this.zzb = context;
        this.zzc = new zzjw(this, null);
    }

    private zzjy() {
        this.zzb = null;
        this.zzc = null;
    }

    public final String zzb(String string) {
        Context context = ((zzjy)((Object)string2)).zzb;
        if (context == null || zzjm.zzb(context)) {
            return null;
        }
        try {
            String string2 = (String)zzjv.zzh(new zzjx((zzjy)((Object)string2), string));
            return string2;
        }
        catch (IllegalStateException | NullPointerException | SecurityException runtimeException) {
            string = "Unable to read GServices for: ".concat(string);
            Log.e((String)"GservicesLoader", (String)string, (Throwable)runtimeException);
            return null;
        }
    }

    static synchronized void zzc() {
        Context context;
        zzjy zzjy2 = zza;
        if (zzjy2 != null && (context = zzjy2.zzb) != null && zzjy2.zzc != null && zzjy2.zzd) {
            context.getContentResolver().unregisterContentObserver(zzjy.zza.zzc);
        }
        zza = null;
    }

    final /* synthetic */ String zzd(String string) {
        return zzjf.zza(((Context)Preconditions.checkNotNull((Object)this.zzb)).getContentResolver(), string, null);
    }
}

