/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.util.Pair;
import android.util.SparseArray;
import androidx.annotation.WorkerThread;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.measurement.internal.zzaz;
import com.google.android.gms.measurement.internal.zzfy;
import com.google.android.gms.measurement.internal.zzhc;
import com.google.android.gms.measurement.internal.zzhd;
import com.google.android.gms.measurement.internal.zzhe;
import com.google.android.gms.measurement.internal.zzhf;
import com.google.android.gms.measurement.internal.zzhg;
import com.google.android.gms.measurement.internal.zzic;
import com.google.android.gms.measurement.internal.zzje;
import com.google.android.gms.measurement.internal.zzjf;
import com.google.android.gms.measurement.internal.zzjk;
import com.google.android.gms.measurement.internal.zzjl;
import com.google.android.gms.measurement.internal.zzod;
import com.google.common.annotations.VisibleForTesting;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;

final class zzhh
extends zzjf {
    static final Pair zza = new Pair((Object)"", (Object)0L);
    private SharedPreferences zzv;
    private SharedPreferences zzw;
    public zzhf zzb;
    public final zzhe zzc;
    public final zzhe zzd;
    public final zzhg zze;
    private String zzx;
    private boolean zzy;
    private long zzz;
    public final zzhe zzf;
    public final zzhc zzg;
    public final zzhg zzh;
    public final zzhd zzi;
    public final zzhc zzj;
    public final zzhe zzk;
    public final zzhe zzl;
    public boolean zzm;
    public final zzhc zzn;
    public final zzhc zzo;
    public final zzhe zzp;
    public final zzhg zzq;
    public final zzhg zzr;
    public final zzhe zzs;
    public final zzhd zzt;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    final Pair zzb(String string) {
        ((zzje)((Object)bl)).zzg();
        if (!((zzhh)((Object)bl)).zzl().zzo(zzjk.zza)) {
            Boolean bl = false;
            return new Pair((Object)"", (Object)bl);
        }
        Object object = ((zzje)((Object)bl)).zzu;
        long l = ((zzic)object).zzaZ().elapsedRealtime();
        String string2 = ((zzhh)((Object)bl)).zzx;
        if (string2 != null && l < ((zzhh)((Object)bl)).zzz) {
            return new Pair((Object)string2, (Object)((zzhh)((Object)bl)).zzy);
        }
        ((zzhh)((Object)bl)).zzz = l + ((zzic)object).zzc().zzl(string, zzfy.zza);
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)true);
        try {
            string = ((zzic)object).zzaY();
            string = AdvertisingIdClient.getAdvertisingIdInfo((Context)string);
            ((zzhh)((Object)bl)).zzx = "";
            object = string.getId();
            if (object != null) {
                ((zzhh)((Object)bl)).zzx = object;
            }
            ((zzhh)((Object)bl)).zzy = string.isLimitAdTrackingEnabled();
        }
        catch (Exception exception) {
            ((zzje)((Object)bl)).zzu.zzaV().zzj().zzb("Unable to get advertising id", exception);
            ((zzhh)((Object)bl)).zzx = "";
        }
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)false);
        return new Pair((Object)((zzhh)((Object)bl)).zzx, (Object)((zzhh)((Object)bl)).zzy);
    }

    zzhh(zzic object) {
        super((zzic)object);
        object = "session_timeout";
        this.zzf = new zzhe(this, (String)object, 1800000L);
        object = "start_new_session";
        this.zzg = new zzhc(this, (String)object, true);
        object = "last_pause_time";
        this.zzk = new zzhe(this, (String)object, 0L);
        object = "session_id";
        this.zzl = new zzhe(this, (String)object, 0L);
        object = "non_personalized_ads";
        this.zzh = new zzhg(this, (String)object, null);
        object = "last_received_uri_timestamps_by_source";
        this.zzi = new zzhd(this, (String)object, null);
        object = "allow_remote_dynamite";
        this.zzj = new zzhc(this, (String)object, false);
        object = "first_open_time";
        this.zzc = new zzhe(this, (String)object, 0L);
        object = "app_install_time";
        this.zzd = new zzhe(this, (String)object, 0L);
        object = "app_instance_id";
        this.zze = new zzhg(this, (String)object, null);
        object = "app_backgrounded";
        this.zzn = new zzhc(this, (String)object, false);
        object = "deep_link_retrieval_complete";
        this.zzo = new zzhc(this, (String)object, false);
        object = "deep_link_retrieval_attempts";
        this.zzp = new zzhe(this, (String)object, 0L);
        object = "firebase_feature_rollouts";
        this.zzq = new zzhg(this, (String)object, null);
        object = "deferred_attribution_cache";
        this.zzr = new zzhg(this, (String)object, null);
        object = "deferred_attribution_cache_timestamp";
        this.zzs = new zzhe(this, (String)object, 0L);
        object = "default_event_parameters";
        this.zzt = new zzhd(this, (String)object, null);
    }

    @Override
    protected final boolean zza() {
        return true;
    }

    @Override
    @EnsuresNonNull.List(value={@EnsuresNonNull(value={"this.preferences"}), @EnsuresNonNull(value={"this.monitoringSample"})})
    @WorkerThread
    protected final void zzba() {
        zzic zzic2 = this.zzu;
        this.zzv = zzic2.zzaY().getSharedPreferences("com.google.android.gms.measurement.prefs", 0);
        this.zzm = this.zzv.getBoolean("has_been_opened", false);
        if (!this.zzm) {
            SharedPreferences.Editor editor = this.zzv.edit();
            editor.putBoolean("has_been_opened", true);
            editor.apply();
        }
        zzic2.zzc();
        long l = Math.max(0L, (Long)zzfy.zzc.zzb(null));
        this.zzb = new zzhf(this, "health_monitor", l, null);
    }

    @WorkerThread
    @VisibleForTesting
    protected final SharedPreferences zzd() {
        this.zzg();
        this.zzw();
        Preconditions.checkNotNull((Object)this.zzv);
        return this.zzv;
    }

    @WorkerThread
    protected final SharedPreferences zze() {
        this.zzg();
        this.zzw();
        if (this.zzw == null) {
            zzic zzic2 = this.zzu;
            String string = zzic2.zzaY().getPackageName();
            String.valueOf(string);
            String string2 = String.valueOf(string);
            string2 = string2.concat("_preferences");
            zzic2.zzaV().zzk().zzb("Default prefs file", string2);
            this.zzw = zzic2.zzaY().getSharedPreferences(string2, 0);
        }
        return this.zzw;
    }

    final SparseArray zzf() {
        Bundle bundle = this.zzi.zza();
        int[] nArray = bundle.getIntArray("uriSources");
        long[] lArray = bundle.getLongArray("uriTimestamps");
        if (nArray == null || lArray == null) {
            return new SparseArray();
        }
        int n = lArray.length;
        if (nArray.length != n) {
            this.zzu.zzaV().zzb().zza("Trigger URI source and timestamp array lengths do not match");
            return new SparseArray();
        }
        SparseArray sparseArray = new SparseArray();
        for (int i = 0; i < nArray.length; ++i) {
            sparseArray.put(nArray[i], (Object)lArray[i]);
        }
        return sparseArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    final void zzh(Boolean bl) {
        zzhh2.zzg();
        zzhh zzhh2 = zzhh2.zzd().edit();
        if (bl != null) {
            zzhh2.putBoolean("measurement_enabled", bl);
        } else {
            zzhh2.remove("measurement_enabled");
        }
        zzhh2.apply();
    }

    @WorkerThread
    final Boolean zzi() {
        this.zzg();
        if (this.zzd().contains("measurement_enabled")) {
            return this.zzd().getBoolean("measurement_enabled", true);
        }
        return null;
    }

    @WorkerThread
    final zzaz zzj() {
        this.zzg();
        return zzaz.zzg(this.zzd().getString("dma_consent_settings", null));
    }

    @WorkerThread
    final boolean zzk(int n) {
        return zzjl.zzu(n, this.zzd().getInt("consent_source", 100));
    }

    @WorkerThread
    final zzjl zzl() {
        this.zzg();
        return zzjl.zzf(this.zzd().getString("consent_settings", "G1"), this.zzd().getInt("consent_source", 100));
    }

    @WorkerThread
    protected final boolean zzm(zzod object) {
        this.zzg();
        String string = this.zzd().getString("stored_tcf_param", "");
        object = ((zzod)object).zza();
        if (!((String)object).equals(string)) {
            SharedPreferences.Editor editor = this.zzd().edit();
            editor.putString("stored_tcf_param", (String)object);
            editor.apply();
            return true;
        }
        return false;
    }

    @WorkerThread
    final void zzn(boolean bl) {
        this.zzg();
        this.zzu.zzaV().zzk().zzb("App measurement setting deferred collection", bl);
        SharedPreferences.Editor editor = this.zzd().edit();
        editor.putBoolean("deferred_analytics_collection", bl);
        editor.apply();
    }

    @WorkerThread
    final boolean zzo() {
        zzhh zzhh2 = zzhh2.zzv;
        if (zzhh2 == null) {
            return false;
        }
        return zzhh2.contains("deferred_analytics_collection");
    }

    final boolean zzp(long l) {
        return l - this.zzf.zza() > this.zzk.zza();
    }
}

